/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gaming.v1alpha.AllocationPoliciesServiceClient;
import com.google.cloud.gaming.v1alpha.AllocationPolicy;
import com.google.cloud.gaming.v1alpha.CreateAllocationPolicyRequest;
import com.google.cloud.gaming.v1alpha.DeleteAllocationPolicyRequest;
import com.google.cloud.gaming.v1alpha.GetAllocationPolicyRequest;
import com.google.cloud.gaming.v1alpha.ListAllocationPoliciesRequest;
import com.google.cloud.gaming.v1alpha.ListAllocationPoliciesResponse;
import com.google.cloud.gaming.v1alpha.UpdateAllocationPolicyRequest;
import com.google.cloud.gaming.v1alpha.stub.AllocationPoliciesServiceStub;
import com.google.cloud.gaming.v1alpha.stub.GrpcAllocationPoliciesServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class AllocationPoliciesServiceStubSettings
extends StubSettings<AllocationPoliciesServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse, AllocationPoliciesServiceClient.ListAllocationPoliciesPagedResponse> listAllocationPoliciesSettings;
    private final UnaryCallSettings<GetAllocationPolicyRequest, AllocationPolicy> getAllocationPolicySettings;
    private final UnaryCallSettings<CreateAllocationPolicyRequest, Operation> createAllocationPolicySettings;
    private final OperationCallSettings<CreateAllocationPolicyRequest, AllocationPolicy, Empty> createAllocationPolicyOperationSettings;
    private final UnaryCallSettings<DeleteAllocationPolicyRequest, Operation> deleteAllocationPolicySettings;
    private final OperationCallSettings<DeleteAllocationPolicyRequest, Empty, Empty> deleteAllocationPolicyOperationSettings;
    private final UnaryCallSettings<UpdateAllocationPolicyRequest, Operation> updateAllocationPolicySettings;
    private final OperationCallSettings<UpdateAllocationPolicyRequest, AllocationPolicy, Empty> updateAllocationPolicyOperationSettings;
    private static final PagedListDescriptor<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse, AllocationPolicy> LIST_ALLOCATION_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse, AllocationPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListAllocationPoliciesRequest injectToken(ListAllocationPoliciesRequest payload, String token) {
            return ListAllocationPoliciesRequest.newBuilder((ListAllocationPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListAllocationPoliciesRequest injectPageSize(ListAllocationPoliciesRequest payload, int pageSize) {
            return ListAllocationPoliciesRequest.newBuilder((ListAllocationPoliciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAllocationPoliciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAllocationPoliciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AllocationPolicy> extractResources(ListAllocationPoliciesResponse payload) {
            return payload.getAllocationPoliciesList() != null ? payload.getAllocationPoliciesList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse, AllocationPoliciesServiceClient.ListAllocationPoliciesPagedResponse> LIST_ALLOCATION_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse, AllocationPoliciesServiceClient.ListAllocationPoliciesPagedResponse>(){

        public ApiFuture<AllocationPoliciesServiceClient.ListAllocationPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse> callable, ListAllocationPoliciesRequest request, ApiCallContext context, ApiFuture<ListAllocationPoliciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ALLOCATION_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AllocationPoliciesServiceClient.ListAllocationPoliciesPagedResponse.createAsync((PageContext<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse, AllocationPolicy>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse, AllocationPoliciesServiceClient.ListAllocationPoliciesPagedResponse> listAllocationPoliciesSettings() {
        return this.listAllocationPoliciesSettings;
    }

    public UnaryCallSettings<GetAllocationPolicyRequest, AllocationPolicy> getAllocationPolicySettings() {
        return this.getAllocationPolicySettings;
    }

    public UnaryCallSettings<CreateAllocationPolicyRequest, Operation> createAllocationPolicySettings() {
        return this.createAllocationPolicySettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<CreateAllocationPolicyRequest, AllocationPolicy, Empty> createAllocationPolicyOperationSettings() {
        return this.createAllocationPolicyOperationSettings;
    }

    public UnaryCallSettings<DeleteAllocationPolicyRequest, Operation> deleteAllocationPolicySettings() {
        return this.deleteAllocationPolicySettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<DeleteAllocationPolicyRequest, Empty, Empty> deleteAllocationPolicyOperationSettings() {
        return this.deleteAllocationPolicyOperationSettings;
    }

    public UnaryCallSettings<UpdateAllocationPolicyRequest, Operation> updateAllocationPolicySettings() {
        return this.updateAllocationPolicySettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<UpdateAllocationPolicyRequest, AllocationPolicy, Empty> updateAllocationPolicyOperationSettings() {
        return this.updateAllocationPolicyOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AllocationPoliciesServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAllocationPoliciesServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "gameservices.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AllocationPoliciesServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AllocationPoliciesServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AllocationPoliciesServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listAllocationPoliciesSettings = settingsBuilder.listAllocationPoliciesSettings().build();
        this.getAllocationPolicySettings = settingsBuilder.getAllocationPolicySettings().build();
        this.createAllocationPolicySettings = settingsBuilder.createAllocationPolicySettings().build();
        this.createAllocationPolicyOperationSettings = settingsBuilder.createAllocationPolicyOperationSettings().build();
        this.deleteAllocationPolicySettings = settingsBuilder.deleteAllocationPolicySettings().build();
        this.deleteAllocationPolicyOperationSettings = settingsBuilder.deleteAllocationPolicyOperationSettings().build();
        this.updateAllocationPolicySettings = settingsBuilder.updateAllocationPolicySettings().build();
        this.updateAllocationPolicyOperationSettings = settingsBuilder.updateAllocationPolicyOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AllocationPoliciesServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse, AllocationPoliciesServiceClient.ListAllocationPoliciesPagedResponse> listAllocationPoliciesSettings;
        private final UnaryCallSettings.Builder<GetAllocationPolicyRequest, AllocationPolicy> getAllocationPolicySettings;
        private final UnaryCallSettings.Builder<CreateAllocationPolicyRequest, Operation> createAllocationPolicySettings;
        private final OperationCallSettings.Builder<CreateAllocationPolicyRequest, AllocationPolicy, Empty> createAllocationPolicyOperationSettings;
        private final UnaryCallSettings.Builder<DeleteAllocationPolicyRequest, Operation> deleteAllocationPolicySettings;
        private final OperationCallSettings.Builder<DeleteAllocationPolicyRequest, Empty, Empty> deleteAllocationPolicyOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAllocationPolicyRequest, Operation> updateAllocationPolicySettings;
        private final OperationCallSettings.Builder<UpdateAllocationPolicyRequest, AllocationPolicy, Empty> updateAllocationPolicyOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listAllocationPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ALLOCATION_POLICIES_PAGE_STR_FACT);
            this.getAllocationPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAllocationPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAllocationPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.deleteAllocationPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAllocationPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.updateAllocationPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAllocationPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAllocationPoliciesSettings, this.getAllocationPolicySettings, this.createAllocationPolicySettings, this.deleteAllocationPolicySettings, this.updateAllocationPolicySettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AllocationPoliciesServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AllocationPoliciesServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AllocationPoliciesServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AllocationPoliciesServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listAllocationPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getAllocationPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createAllocationPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteAllocationPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateAllocationPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createAllocationPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AllocationPolicy.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteAllocationPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateAllocationPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AllocationPolicy.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        protected Builder(AllocationPoliciesServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listAllocationPoliciesSettings = settings.listAllocationPoliciesSettings.toBuilder();
            this.getAllocationPolicySettings = settings.getAllocationPolicySettings.toBuilder();
            this.createAllocationPolicySettings = settings.createAllocationPolicySettings.toBuilder();
            this.createAllocationPolicyOperationSettings = settings.createAllocationPolicyOperationSettings.toBuilder();
            this.deleteAllocationPolicySettings = settings.deleteAllocationPolicySettings.toBuilder();
            this.deleteAllocationPolicyOperationSettings = settings.deleteAllocationPolicyOperationSettings.toBuilder();
            this.updateAllocationPolicySettings = settings.updateAllocationPolicySettings.toBuilder();
            this.updateAllocationPolicyOperationSettings = settings.updateAllocationPolicyOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAllocationPoliciesSettings, this.getAllocationPolicySettings, this.createAllocationPolicySettings, this.deleteAllocationPolicySettings, this.updateAllocationPolicySettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse, AllocationPoliciesServiceClient.ListAllocationPoliciesPagedResponse> listAllocationPoliciesSettings() {
            return this.listAllocationPoliciesSettings;
        }

        public UnaryCallSettings.Builder<GetAllocationPolicyRequest, AllocationPolicy> getAllocationPolicySettings() {
            return this.getAllocationPolicySettings;
        }

        public UnaryCallSettings.Builder<CreateAllocationPolicyRequest, Operation> createAllocationPolicySettings() {
            return this.createAllocationPolicySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateAllocationPolicyRequest, AllocationPolicy, Empty> createAllocationPolicyOperationSettings() {
            return this.createAllocationPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteAllocationPolicyRequest, Operation> deleteAllocationPolicySettings() {
            return this.deleteAllocationPolicySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteAllocationPolicyRequest, Empty, Empty> deleteAllocationPolicyOperationSettings() {
            return this.deleteAllocationPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAllocationPolicyRequest, Operation> updateAllocationPolicySettings() {
            return this.updateAllocationPolicySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateAllocationPolicyRequest, AllocationPolicy, Empty> updateAllocationPolicyOperationSettings() {
            return this.updateAllocationPolicyOperationSettings;
        }

        public AllocationPoliciesServiceStubSettings build() throws IOException {
            return new AllocationPoliciesServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

