/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gaming.v1alpha.CreateScalingPolicyRequest;
import com.google.cloud.gaming.v1alpha.DeleteScalingPolicyRequest;
import com.google.cloud.gaming.v1alpha.GetScalingPolicyRequest;
import com.google.cloud.gaming.v1alpha.ListScalingPoliciesRequest;
import com.google.cloud.gaming.v1alpha.ListScalingPoliciesResponse;
import com.google.cloud.gaming.v1alpha.ScalingPoliciesServiceClient;
import com.google.cloud.gaming.v1alpha.ScalingPolicy;
import com.google.cloud.gaming.v1alpha.UpdateScalingPolicyRequest;
import com.google.cloud.gaming.v1alpha.stub.GrpcScalingPoliciesServiceStub;
import com.google.cloud.gaming.v1alpha.stub.ScalingPoliciesServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ScalingPoliciesServiceStubSettings
extends StubSettings<ScalingPoliciesServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListScalingPoliciesRequest, ListScalingPoliciesResponse, ScalingPoliciesServiceClient.ListScalingPoliciesPagedResponse> listScalingPoliciesSettings;
    private final UnaryCallSettings<GetScalingPolicyRequest, ScalingPolicy> getScalingPolicySettings;
    private final UnaryCallSettings<CreateScalingPolicyRequest, Operation> createScalingPolicySettings;
    private final OperationCallSettings<CreateScalingPolicyRequest, ScalingPolicy, Empty> createScalingPolicyOperationSettings;
    private final UnaryCallSettings<DeleteScalingPolicyRequest, Operation> deleteScalingPolicySettings;
    private final OperationCallSettings<DeleteScalingPolicyRequest, Empty, Empty> deleteScalingPolicyOperationSettings;
    private final UnaryCallSettings<UpdateScalingPolicyRequest, Operation> updateScalingPolicySettings;
    private final OperationCallSettings<UpdateScalingPolicyRequest, ScalingPolicy, Empty> updateScalingPolicyOperationSettings;
    private static final PagedListDescriptor<ListScalingPoliciesRequest, ListScalingPoliciesResponse, ScalingPolicy> LIST_SCALING_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<ListScalingPoliciesRequest, ListScalingPoliciesResponse, ScalingPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListScalingPoliciesRequest injectToken(ListScalingPoliciesRequest payload, String token) {
            return ListScalingPoliciesRequest.newBuilder((ListScalingPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListScalingPoliciesRequest injectPageSize(ListScalingPoliciesRequest payload, int pageSize) {
            return ListScalingPoliciesRequest.newBuilder((ListScalingPoliciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListScalingPoliciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListScalingPoliciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ScalingPolicy> extractResources(ListScalingPoliciesResponse payload) {
            return payload.getScalingPoliciesList() != null ? payload.getScalingPoliciesList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListScalingPoliciesRequest, ListScalingPoliciesResponse, ScalingPoliciesServiceClient.ListScalingPoliciesPagedResponse> LIST_SCALING_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<ListScalingPoliciesRequest, ListScalingPoliciesResponse, ScalingPoliciesServiceClient.ListScalingPoliciesPagedResponse>(){

        public ApiFuture<ScalingPoliciesServiceClient.ListScalingPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListScalingPoliciesRequest, ListScalingPoliciesResponse> callable, ListScalingPoliciesRequest request, ApiCallContext context, ApiFuture<ListScalingPoliciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SCALING_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ScalingPoliciesServiceClient.ListScalingPoliciesPagedResponse.createAsync((PageContext<ListScalingPoliciesRequest, ListScalingPoliciesResponse, ScalingPolicy>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListScalingPoliciesRequest, ListScalingPoliciesResponse, ScalingPoliciesServiceClient.ListScalingPoliciesPagedResponse> listScalingPoliciesSettings() {
        return this.listScalingPoliciesSettings;
    }

    public UnaryCallSettings<GetScalingPolicyRequest, ScalingPolicy> getScalingPolicySettings() {
        return this.getScalingPolicySettings;
    }

    public UnaryCallSettings<CreateScalingPolicyRequest, Operation> createScalingPolicySettings() {
        return this.createScalingPolicySettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<CreateScalingPolicyRequest, ScalingPolicy, Empty> createScalingPolicyOperationSettings() {
        return this.createScalingPolicyOperationSettings;
    }

    public UnaryCallSettings<DeleteScalingPolicyRequest, Operation> deleteScalingPolicySettings() {
        return this.deleteScalingPolicySettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<DeleteScalingPolicyRequest, Empty, Empty> deleteScalingPolicyOperationSettings() {
        return this.deleteScalingPolicyOperationSettings;
    }

    public UnaryCallSettings<UpdateScalingPolicyRequest, Operation> updateScalingPolicySettings() {
        return this.updateScalingPolicySettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<UpdateScalingPolicyRequest, ScalingPolicy, Empty> updateScalingPolicyOperationSettings() {
        return this.updateScalingPolicyOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ScalingPoliciesServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcScalingPoliciesServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "gameservices.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ScalingPoliciesServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ScalingPoliciesServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ScalingPoliciesServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listScalingPoliciesSettings = settingsBuilder.listScalingPoliciesSettings().build();
        this.getScalingPolicySettings = settingsBuilder.getScalingPolicySettings().build();
        this.createScalingPolicySettings = settingsBuilder.createScalingPolicySettings().build();
        this.createScalingPolicyOperationSettings = settingsBuilder.createScalingPolicyOperationSettings().build();
        this.deleteScalingPolicySettings = settingsBuilder.deleteScalingPolicySettings().build();
        this.deleteScalingPolicyOperationSettings = settingsBuilder.deleteScalingPolicyOperationSettings().build();
        this.updateScalingPolicySettings = settingsBuilder.updateScalingPolicySettings().build();
        this.updateScalingPolicyOperationSettings = settingsBuilder.updateScalingPolicyOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ScalingPoliciesServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListScalingPoliciesRequest, ListScalingPoliciesResponse, ScalingPoliciesServiceClient.ListScalingPoliciesPagedResponse> listScalingPoliciesSettings;
        private final UnaryCallSettings.Builder<GetScalingPolicyRequest, ScalingPolicy> getScalingPolicySettings;
        private final UnaryCallSettings.Builder<CreateScalingPolicyRequest, Operation> createScalingPolicySettings;
        private final OperationCallSettings.Builder<CreateScalingPolicyRequest, ScalingPolicy, Empty> createScalingPolicyOperationSettings;
        private final UnaryCallSettings.Builder<DeleteScalingPolicyRequest, Operation> deleteScalingPolicySettings;
        private final OperationCallSettings.Builder<DeleteScalingPolicyRequest, Empty, Empty> deleteScalingPolicyOperationSettings;
        private final UnaryCallSettings.Builder<UpdateScalingPolicyRequest, Operation> updateScalingPolicySettings;
        private final OperationCallSettings.Builder<UpdateScalingPolicyRequest, ScalingPolicy, Empty> updateScalingPolicyOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listScalingPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SCALING_POLICIES_PAGE_STR_FACT);
            this.getScalingPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createScalingPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createScalingPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.deleteScalingPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteScalingPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.updateScalingPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateScalingPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listScalingPoliciesSettings, this.getScalingPolicySettings, this.createScalingPolicySettings, this.deleteScalingPolicySettings, this.updateScalingPolicySettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ScalingPoliciesServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ScalingPoliciesServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ScalingPoliciesServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ScalingPoliciesServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listScalingPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getScalingPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createScalingPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteScalingPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateScalingPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createScalingPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ScalingPolicy.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteScalingPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateScalingPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ScalingPolicy.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        protected Builder(ScalingPoliciesServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listScalingPoliciesSettings = settings.listScalingPoliciesSettings.toBuilder();
            this.getScalingPolicySettings = settings.getScalingPolicySettings.toBuilder();
            this.createScalingPolicySettings = settings.createScalingPolicySettings.toBuilder();
            this.createScalingPolicyOperationSettings = settings.createScalingPolicyOperationSettings.toBuilder();
            this.deleteScalingPolicySettings = settings.deleteScalingPolicySettings.toBuilder();
            this.deleteScalingPolicyOperationSettings = settings.deleteScalingPolicyOperationSettings.toBuilder();
            this.updateScalingPolicySettings = settings.updateScalingPolicySettings.toBuilder();
            this.updateScalingPolicyOperationSettings = settings.updateScalingPolicyOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listScalingPoliciesSettings, this.getScalingPolicySettings, this.createScalingPolicySettings, this.deleteScalingPolicySettings, this.updateScalingPolicySettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListScalingPoliciesRequest, ListScalingPoliciesResponse, ScalingPoliciesServiceClient.ListScalingPoliciesPagedResponse> listScalingPoliciesSettings() {
            return this.listScalingPoliciesSettings;
        }

        public UnaryCallSettings.Builder<GetScalingPolicyRequest, ScalingPolicy> getScalingPolicySettings() {
            return this.getScalingPolicySettings;
        }

        public UnaryCallSettings.Builder<CreateScalingPolicyRequest, Operation> createScalingPolicySettings() {
            return this.createScalingPolicySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateScalingPolicyRequest, ScalingPolicy, Empty> createScalingPolicyOperationSettings() {
            return this.createScalingPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteScalingPolicyRequest, Operation> deleteScalingPolicySettings() {
            return this.deleteScalingPolicySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteScalingPolicyRequest, Empty, Empty> deleteScalingPolicyOperationSettings() {
            return this.deleteScalingPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateScalingPolicyRequest, Operation> updateScalingPolicySettings() {
            return this.updateScalingPolicySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateScalingPolicyRequest, ScalingPolicy, Empty> updateScalingPolicyOperationSettings() {
            return this.updateScalingPolicyOperationSettings;
        }

        public ScalingPoliciesServiceStubSettings build() throws IOException {
            return new ScalingPoliciesServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

