/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.config.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.config.v1.ApplyResults;
import com.google.cloud.config.v1.ConfigClient;
import com.google.cloud.config.v1.ConfigSettings;
import com.google.cloud.config.v1.Deployment;
import com.google.cloud.config.v1.DeploymentName;
import com.google.cloud.config.v1.ExportDeploymentStatefileRequest;
import com.google.cloud.config.v1.ExportPreviewResultRequest;
import com.google.cloud.config.v1.ExportPreviewResultResponse;
import com.google.cloud.config.v1.ExportRevisionStatefileRequest;
import com.google.cloud.config.v1.ListDeploymentsResponse;
import com.google.cloud.config.v1.ListPreviewsResponse;
import com.google.cloud.config.v1.ListResourcesResponse;
import com.google.cloud.config.v1.ListRevisionsResponse;
import com.google.cloud.config.v1.ListTerraformVersionsResponse;
import com.google.cloud.config.v1.LocationName;
import com.google.cloud.config.v1.LockInfo;
import com.google.cloud.config.v1.Preview;
import com.google.cloud.config.v1.PreviewArtifacts;
import com.google.cloud.config.v1.PreviewName;
import com.google.cloud.config.v1.PreviewResult;
import com.google.cloud.config.v1.QuotaValidation;
import com.google.cloud.config.v1.Resource;
import com.google.cloud.config.v1.ResourceName;
import com.google.cloud.config.v1.ResourceTerraformInfo;
import com.google.cloud.config.v1.Revision;
import com.google.cloud.config.v1.RevisionName;
import com.google.cloud.config.v1.Statefile;
import com.google.cloud.config.v1.TerraformVersion;
import com.google.cloud.config.v1.TerraformVersionName;
import com.google.cloud.config.v1.stub.HttpJsonConfigStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.GetPolicyOptions;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.rpc.Status;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ConfigClientHttpJsonTest {
    private static MockHttpService mockService;
    private static ConfigClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonConfigStub.getMethodDescriptors(), ConfigSettings.getDefaultEndpoint());
        ConfigSettings settings = ((ConfigSettings.Builder)((ConfigSettings.Builder)ConfigSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)ConfigSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = ConfigClient.create((ConfigSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void listDeploymentsTest() throws Exception {
        Deployment responsesElement = Deployment.newBuilder().build();
        ListDeploymentsResponse expectedResponse = ListDeploymentsResponse.newBuilder().setNextPageToken("").addAllDeployments(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ConfigClient.ListDeploymentsPagedResponse pagedListResponse = client.listDeployments(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDeploymentsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDeploymentsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listDeployments(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDeploymentsTest2() throws Exception {
        Deployment responsesElement = Deployment.newBuilder().build();
        ListDeploymentsResponse expectedResponse = ListDeploymentsResponse.newBuilder().setNextPageToken("").addAllDeployments(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        ConfigClient.ListDeploymentsPagedResponse pagedListResponse = client.listDeployments(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDeploymentsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDeploymentsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listDeployments(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDeploymentTest() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        Deployment actualResponse = client.getDeployment(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getDeploymentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            client.getDeployment(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDeploymentTest2() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4348/locations/location-4348/deployments/deployment-4348";
        Deployment actualResponse = client.getDeployment(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getDeploymentExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4348/locations/location-4348/deployments/deployment-4348";
            client.getDeployment(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDeploymentTest() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("createDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Deployment deployment = Deployment.newBuilder().build();
        String deploymentId = "deploymentId-136894784";
        Deployment actualResponse = (Deployment)client.createDeploymentAsync(parent, deployment, deploymentId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createDeploymentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Deployment deployment = Deployment.newBuilder().build();
            String deploymentId = "deploymentId-136894784";
            client.createDeploymentAsync(parent, deployment, deploymentId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createDeploymentTest2() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("createDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        Deployment deployment = Deployment.newBuilder().build();
        String deploymentId = "deploymentId-136894784";
        Deployment actualResponse = (Deployment)client.createDeploymentAsync(parent, deployment, deploymentId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createDeploymentExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Deployment deployment = Deployment.newBuilder().build();
            String deploymentId = "deploymentId-136894784";
            client.createDeploymentAsync(parent, deployment, deploymentId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateDeploymentTest() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Deployment deployment = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Deployment actualResponse = (Deployment)client.updateDeploymentAsync(deployment, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateDeploymentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Deployment deployment = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateDeploymentAsync(deployment, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDeploymentTest() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        Deployment actualResponse = (Deployment)client.deleteDeploymentAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteDeploymentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            client.deleteDeploymentAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDeploymentTest2() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-4348/locations/location-4348/deployments/deployment-4348";
        Deployment actualResponse = (Deployment)client.deleteDeploymentAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteDeploymentExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4348/locations/location-4348/deployments/deployment-4348";
            client.deleteDeploymentAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listRevisionsTest() throws Exception {
        Revision responsesElement = Revision.newBuilder().build();
        ListRevisionsResponse expectedResponse = ListRevisionsResponse.newBuilder().setNextPageToken("").addAllRevisions(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        DeploymentName parent = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        ConfigClient.ListRevisionsPagedResponse pagedListResponse = client.listRevisions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRevisionsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listRevisionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DeploymentName parent = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            client.listRevisions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listRevisionsTest2() throws Exception {
        Revision responsesElement = Revision.newBuilder().build();
        ListRevisionsResponse expectedResponse = ListRevisionsResponse.newBuilder().setNextPageToken("").addAllRevisions(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-2099/locations/location-2099/deployments/deployment-2099";
        ConfigClient.ListRevisionsPagedResponse pagedListResponse = client.listRevisions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRevisionsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listRevisionsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-2099/locations/location-2099/deployments/deployment-2099";
            client.listRevisions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRevisionTest() throws Exception {
        Revision expectedResponse = Revision.newBuilder().setName(RevisionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setApplyResults(ApplyResults.newBuilder().build()).setStateDetail("stateDetail748574786").setBuild("build94094958").setLogs("logs3327407").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidationResults("quotaValidationResults-1396407899").setQuotaValidation(QuotaValidation.forNumber((int)0)).build();
        mockService.addResponse((Object)expectedResponse);
        RevisionName name = RevisionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]");
        Revision actualResponse = client.getRevision(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getRevisionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RevisionName name = RevisionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]");
            client.getRevision(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRevisionTest2() throws Exception {
        Revision expectedResponse = Revision.newBuilder().setName(RevisionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setApplyResults(ApplyResults.newBuilder().build()).setStateDetail("stateDetail748574786").setBuild("build94094958").setLogs("logs3327407").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidationResults("quotaValidationResults-1396407899").setQuotaValidation(QuotaValidation.forNumber((int)0)).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-6392/locations/location-6392/deployments/deployment-6392/revisions/revision-6392";
        Revision actualResponse = client.getRevision(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getRevisionExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-6392/locations/location-6392/deployments/deployment-6392/revisions/revision-6392";
            client.getRevision(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getResourceTest() throws Exception {
        Resource expectedResponse = Resource.newBuilder().setName(ResourceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]", (String)"[RESOURCE]").toString()).setTerraformInfo(ResourceTerraformInfo.newBuilder().build()).putAllCaiAssets(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        ResourceName name = ResourceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]", (String)"[RESOURCE]");
        Resource actualResponse = client.getResource(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getResourceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ResourceName name = ResourceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]", (String)"[RESOURCE]");
            client.getResource(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getResourceTest2() throws Exception {
        Resource expectedResponse = Resource.newBuilder().setName(ResourceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]", (String)"[RESOURCE]").toString()).setTerraformInfo(ResourceTerraformInfo.newBuilder().build()).putAllCaiAssets(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3735/locations/location-3735/deployments/deployment-3735/revisions/revision-3735/resources/resource-3735";
        Resource actualResponse = client.getResource(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getResourceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3735/locations/location-3735/deployments/deployment-3735/revisions/revision-3735/resources/resource-3735";
            client.getResource(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listResourcesTest() throws Exception {
        Resource responsesElement = Resource.newBuilder().build();
        ListResourcesResponse expectedResponse = ListResourcesResponse.newBuilder().setNextPageToken("").addAllResources(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        RevisionName parent = RevisionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]");
        ConfigClient.ListResourcesPagedResponse pagedListResponse = client.listResources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getResourcesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listResourcesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RevisionName parent = RevisionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]");
            client.listResources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listResourcesTest2() throws Exception {
        Resource responsesElement = Resource.newBuilder().build();
        ListResourcesResponse expectedResponse = ListResourcesResponse.newBuilder().setNextPageToken("").addAllResources(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-9641/locations/location-9641/deployments/deployment-9641/revisions/revision-9641";
        ConfigClient.ListResourcesPagedResponse pagedListResponse = client.listResources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getResourcesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listResourcesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9641/locations/location-9641/deployments/deployment-9641/revisions/revision-9641";
            client.listResources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void exportDeploymentStatefileTest() throws Exception {
        Statefile expectedResponse = Statefile.newBuilder().setSignedUri("signedUri1076770992").build();
        mockService.addResponse((Object)expectedResponse);
        ExportDeploymentStatefileRequest request = ExportDeploymentStatefileRequest.newBuilder().setParent(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setDraft(true).build();
        Statefile actualResponse = client.exportDeploymentStatefile(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void exportDeploymentStatefileExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ExportDeploymentStatefileRequest request = ExportDeploymentStatefileRequest.newBuilder().setParent(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setDraft(true).build();
            client.exportDeploymentStatefile(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void exportRevisionStatefileTest() throws Exception {
        Statefile expectedResponse = Statefile.newBuilder().setSignedUri("signedUri1076770992").build();
        mockService.addResponse((Object)expectedResponse);
        ExportRevisionStatefileRequest request = ExportRevisionStatefileRequest.newBuilder().setParent(RevisionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]").toString()).build();
        Statefile actualResponse = client.exportRevisionStatefile(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void exportRevisionStatefileExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ExportRevisionStatefileRequest request = ExportRevisionStatefileRequest.newBuilder().setParent(RevisionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]").toString()).build();
            client.exportRevisionStatefile(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void importStatefileTest() throws Exception {
        Statefile expectedResponse = Statefile.newBuilder().setSignedUri("signedUri1076770992").build();
        mockService.addResponse((Object)expectedResponse);
        DeploymentName parent = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        long lockId = 338696367L;
        Statefile actualResponse = client.importStatefile(parent, lockId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void importStatefileExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DeploymentName parent = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            long lockId = 338696367L;
            client.importStatefile(parent, lockId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void importStatefileTest2() throws Exception {
        Statefile expectedResponse = Statefile.newBuilder().setSignedUri("signedUri1076770992").build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-2099/locations/location-2099/deployments/deployment-2099";
        long lockId = 338696367L;
        Statefile actualResponse = client.importStatefile(parent, lockId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void importStatefileExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-2099/locations/location-2099/deployments/deployment-2099";
            long lockId = 338696367L;
            client.importStatefile(parent, lockId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteStatefileTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        client.deleteStatefile(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteStatefileExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            client.deleteStatefile(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteStatefileTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4348/locations/location-4348/deployments/deployment-4348";
        client.deleteStatefile(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteStatefileExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4348/locations/location-4348/deployments/deployment-4348";
            client.deleteStatefile(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void lockDeploymentTest() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("lockDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        Deployment actualResponse = (Deployment)client.lockDeploymentAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void lockDeploymentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            client.lockDeploymentAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void lockDeploymentTest2() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("lockDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-4348/locations/location-4348/deployments/deployment-4348";
        Deployment actualResponse = (Deployment)client.lockDeploymentAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void lockDeploymentExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4348/locations/location-4348/deployments/deployment-4348";
            client.lockDeploymentAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void unlockDeploymentTest() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("unlockDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        long lockId = 338696367L;
        Deployment actualResponse = (Deployment)client.unlockDeploymentAsync(name, lockId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void unlockDeploymentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            long lockId = 338696367L;
            client.unlockDeploymentAsync(name, lockId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void unlockDeploymentTest2() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("unlockDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-4348/locations/location-4348/deployments/deployment-4348";
        long lockId = 338696367L;
        Deployment actualResponse = (Deployment)client.unlockDeploymentAsync(name, lockId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void unlockDeploymentExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4348/locations/location-4348/deployments/deployment-4348";
            long lockId = 338696367L;
            client.unlockDeploymentAsync(name, lockId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void exportLockInfoTest() throws Exception {
        LockInfo expectedResponse = LockInfo.newBuilder().setLockId(338696367L).setOperation("operation1662702951").setInfo("info3237038").setWho("who117694").setVersion("version351608024").setCreateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        LockInfo actualResponse = client.exportLockInfo(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void exportLockInfoExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            client.exportLockInfo(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void exportLockInfoTest2() throws Exception {
        LockInfo expectedResponse = LockInfo.newBuilder().setLockId(338696367L).setOperation("operation1662702951").setInfo("info3237038").setWho("who117694").setVersion("version351608024").setCreateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4348/locations/location-4348/deployments/deployment-4348";
        LockInfo actualResponse = client.exportLockInfo(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void exportLockInfoExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4348/locations/location-4348/deployments/deployment-4348";
            client.exportLockInfo(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createPreviewTest() throws Exception {
        Preview expectedResponse = Preview.newBuilder().setName(PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]").toString()).setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDeployment(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setServiceAccount("serviceAccount1079137720").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setWorkerPool("workerPool-384405318").setErrorStatus(Status.newBuilder().build()).setBuild("build94094958").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setPreviewArtifacts(PreviewArtifacts.newBuilder().build()).setLogs("logs3327407").setTfVersion("tfVersion182968838").setTfVersionConstraint("tfVersionConstraint-1530231677").putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPreviewTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Preview preview = Preview.newBuilder().build();
        Preview actualResponse = (Preview)client.createPreviewAsync(parent, preview).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createPreviewExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Preview preview = Preview.newBuilder().build();
            client.createPreviewAsync(parent, preview).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createPreviewTest2() throws Exception {
        Preview expectedResponse = Preview.newBuilder().setName(PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]").toString()).setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDeployment(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setServiceAccount("serviceAccount1079137720").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setWorkerPool("workerPool-384405318").setErrorStatus(Status.newBuilder().build()).setBuild("build94094958").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setPreviewArtifacts(PreviewArtifacts.newBuilder().build()).setLogs("logs3327407").setTfVersion("tfVersion182968838").setTfVersionConstraint("tfVersionConstraint-1530231677").putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPreviewTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        Preview preview = Preview.newBuilder().build();
        Preview actualResponse = (Preview)client.createPreviewAsync(parent, preview).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createPreviewExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Preview preview = Preview.newBuilder().build();
            client.createPreviewAsync(parent, preview).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void getPreviewTest() throws Exception {
        Preview expectedResponse = Preview.newBuilder().setName(PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]").toString()).setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDeployment(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setServiceAccount("serviceAccount1079137720").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setWorkerPool("workerPool-384405318").setErrorStatus(Status.newBuilder().build()).setBuild("build94094958").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setPreviewArtifacts(PreviewArtifacts.newBuilder().build()).setLogs("logs3327407").setTfVersion("tfVersion182968838").setTfVersionConstraint("tfVersionConstraint-1530231677").putAllAnnotations(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        PreviewName name = PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]");
        Preview actualResponse = client.getPreview(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getPreviewExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            PreviewName name = PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]");
            client.getPreview(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getPreviewTest2() throws Exception {
        Preview expectedResponse = Preview.newBuilder().setName(PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]").toString()).setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDeployment(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setServiceAccount("serviceAccount1079137720").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setWorkerPool("workerPool-384405318").setErrorStatus(Status.newBuilder().build()).setBuild("build94094958").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setPreviewArtifacts(PreviewArtifacts.newBuilder().build()).setLogs("logs3327407").setTfVersion("tfVersion182968838").setTfVersionConstraint("tfVersionConstraint-1530231677").putAllAnnotations(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3835/locations/location-3835/previews/preview-3835";
        Preview actualResponse = client.getPreview(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getPreviewExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3835/locations/location-3835/previews/preview-3835";
            client.getPreview(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPreviewsTest() throws Exception {
        Preview responsesElement = Preview.newBuilder().build();
        ListPreviewsResponse expectedResponse = ListPreviewsResponse.newBuilder().setNextPageToken("").addAllPreviews(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ConfigClient.ListPreviewsPagedResponse pagedListResponse = client.listPreviews(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPreviewsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listPreviewsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listPreviews(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPreviewsTest2() throws Exception {
        Preview responsesElement = Preview.newBuilder().build();
        ListPreviewsResponse expectedResponse = ListPreviewsResponse.newBuilder().setNextPageToken("").addAllPreviews(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        ConfigClient.ListPreviewsPagedResponse pagedListResponse = client.listPreviews(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPreviewsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listPreviewsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listPreviews(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deletePreviewTest() throws Exception {
        Preview expectedResponse = Preview.newBuilder().setName(PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]").toString()).setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDeployment(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setServiceAccount("serviceAccount1079137720").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setWorkerPool("workerPool-384405318").setErrorStatus(Status.newBuilder().build()).setBuild("build94094958").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setPreviewArtifacts(PreviewArtifacts.newBuilder().build()).setLogs("logs3327407").setTfVersion("tfVersion182968838").setTfVersionConstraint("tfVersionConstraint-1530231677").putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("deletePreviewTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        PreviewName name = PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]");
        Preview actualResponse = (Preview)client.deletePreviewAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deletePreviewExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            PreviewName name = PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]");
            client.deletePreviewAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deletePreviewTest2() throws Exception {
        Preview expectedResponse = Preview.newBuilder().setName(PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]").toString()).setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDeployment(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setServiceAccount("serviceAccount1079137720").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setWorkerPool("workerPool-384405318").setErrorStatus(Status.newBuilder().build()).setBuild("build94094958").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setPreviewArtifacts(PreviewArtifacts.newBuilder().build()).setLogs("logs3327407").setTfVersion("tfVersion182968838").setTfVersionConstraint("tfVersionConstraint-1530231677").putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("deletePreviewTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-3835/locations/location-3835/previews/preview-3835";
        Preview actualResponse = (Preview)client.deletePreviewAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deletePreviewExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3835/locations/location-3835/previews/preview-3835";
            client.deletePreviewAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void exportPreviewResultTest() throws Exception {
        ExportPreviewResultResponse expectedResponse = ExportPreviewResultResponse.newBuilder().setResult(PreviewResult.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        ExportPreviewResultRequest request = ExportPreviewResultRequest.newBuilder().setParent(PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]").toString()).build();
        ExportPreviewResultResponse actualResponse = client.exportPreviewResult(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void exportPreviewResultExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ExportPreviewResultRequest request = ExportPreviewResultRequest.newBuilder().setParent(PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]").toString()).build();
            client.exportPreviewResult(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTerraformVersionsTest() throws Exception {
        TerraformVersion responsesElement = TerraformVersion.newBuilder().build();
        ListTerraformVersionsResponse expectedResponse = ListTerraformVersionsResponse.newBuilder().setNextPageToken("").addAllTerraformVersions(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ConfigClient.ListTerraformVersionsPagedResponse pagedListResponse = client.listTerraformVersions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTerraformVersionsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listTerraformVersionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listTerraformVersions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTerraformVersionsTest2() throws Exception {
        TerraformVersion responsesElement = TerraformVersion.newBuilder().build();
        ListTerraformVersionsResponse expectedResponse = ListTerraformVersionsResponse.newBuilder().setNextPageToken("").addAllTerraformVersions(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        ConfigClient.ListTerraformVersionsPagedResponse pagedListResponse = client.listTerraformVersions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTerraformVersionsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listTerraformVersionsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listTerraformVersions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTerraformVersionTest() throws Exception {
        TerraformVersion expectedResponse = TerraformVersion.newBuilder().setName(TerraformVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TERRAFORM_VERSION]").toString()).setSupportTime(Timestamp.newBuilder().build()).setDeprecateTime(Timestamp.newBuilder().build()).setObsoleteTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        TerraformVersionName name = TerraformVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TERRAFORM_VERSION]");
        TerraformVersion actualResponse = client.getTerraformVersion(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getTerraformVersionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TerraformVersionName name = TerraformVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TERRAFORM_VERSION]");
            client.getTerraformVersion(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTerraformVersionTest2() throws Exception {
        TerraformVersion expectedResponse = TerraformVersion.newBuilder().setName(TerraformVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TERRAFORM_VERSION]").toString()).setSupportTime(Timestamp.newBuilder().build()).setDeprecateTime(Timestamp.newBuilder().build()).setObsoleteTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-7557/locations/location-7557/terraformVersions/terraformVersion-7557";
        TerraformVersion actualResponse = client.getTerraformVersion(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getTerraformVersionExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7557/locations/location-7557/terraformVersions/terraformVersion-7557";
            client.getTerraformVersion(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listLocationsTest() throws Exception {
        Location responsesElement = Location.newBuilder().build();
        ListLocationsResponse expectedResponse = ListLocationsResponse.newBuilder().setNextPageToken("").addAllLocations(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("projects/project-3664").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
        ConfigClient.ListLocationsPagedResponse pagedListResponse = client.listLocations(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLocationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listLocationsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("projects/project-3664").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
            client.listLocations(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getLocationTest() throws Exception {
        Location expectedResponse = Location.newBuilder().setName("name3373707").setLocationId("locationId1541836720").setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setMetadata(Any.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        GetLocationRequest request = GetLocationRequest.newBuilder().setName("projects/project-9062/locations/location-9062").build();
        Location actualResponse = client.getLocation(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getLocationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GetLocationRequest request = GetLocationRequest.newBuilder().setName("projects/project-9062/locations/location-9062").build();
            client.getLocation(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
        Policy actualResponse = client.setIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
            client.setIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
        Policy actualResponse = client.getIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
            client.getIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).addAllPermissions(new ArrayList()).build();
        TestIamPermissionsResponse actualResponse = client.testIamPermissions(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).addAllPermissions(new ArrayList()).build();
            client.testIamPermissions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

