/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.config.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.config.v1.ApplyResults;
import com.google.cloud.config.v1.ConfigClient;
import com.google.cloud.config.v1.ConfigSettings;
import com.google.cloud.config.v1.CreateDeploymentRequest;
import com.google.cloud.config.v1.CreatePreviewRequest;
import com.google.cloud.config.v1.DeleteDeploymentRequest;
import com.google.cloud.config.v1.DeletePreviewRequest;
import com.google.cloud.config.v1.DeleteStatefileRequest;
import com.google.cloud.config.v1.Deployment;
import com.google.cloud.config.v1.DeploymentName;
import com.google.cloud.config.v1.ExportDeploymentStatefileRequest;
import com.google.cloud.config.v1.ExportLockInfoRequest;
import com.google.cloud.config.v1.ExportPreviewResultRequest;
import com.google.cloud.config.v1.ExportPreviewResultResponse;
import com.google.cloud.config.v1.ExportRevisionStatefileRequest;
import com.google.cloud.config.v1.GetDeploymentRequest;
import com.google.cloud.config.v1.GetPreviewRequest;
import com.google.cloud.config.v1.GetResourceRequest;
import com.google.cloud.config.v1.GetRevisionRequest;
import com.google.cloud.config.v1.GetTerraformVersionRequest;
import com.google.cloud.config.v1.ImportStatefileRequest;
import com.google.cloud.config.v1.ListDeploymentsRequest;
import com.google.cloud.config.v1.ListDeploymentsResponse;
import com.google.cloud.config.v1.ListPreviewsRequest;
import com.google.cloud.config.v1.ListPreviewsResponse;
import com.google.cloud.config.v1.ListResourcesRequest;
import com.google.cloud.config.v1.ListResourcesResponse;
import com.google.cloud.config.v1.ListRevisionsRequest;
import com.google.cloud.config.v1.ListRevisionsResponse;
import com.google.cloud.config.v1.ListTerraformVersionsRequest;
import com.google.cloud.config.v1.ListTerraformVersionsResponse;
import com.google.cloud.config.v1.LocationName;
import com.google.cloud.config.v1.LockDeploymentRequest;
import com.google.cloud.config.v1.LockInfo;
import com.google.cloud.config.v1.MockConfig;
import com.google.cloud.config.v1.MockIAMPolicy;
import com.google.cloud.config.v1.MockLocations;
import com.google.cloud.config.v1.Preview;
import com.google.cloud.config.v1.PreviewArtifacts;
import com.google.cloud.config.v1.PreviewName;
import com.google.cloud.config.v1.PreviewResult;
import com.google.cloud.config.v1.QuotaValidation;
import com.google.cloud.config.v1.Resource;
import com.google.cloud.config.v1.ResourceName;
import com.google.cloud.config.v1.ResourceTerraformInfo;
import com.google.cloud.config.v1.Revision;
import com.google.cloud.config.v1.RevisionName;
import com.google.cloud.config.v1.Statefile;
import com.google.cloud.config.v1.TerraformVersion;
import com.google.cloud.config.v1.TerraformVersionName;
import com.google.cloud.config.v1.UnlockDeploymentRequest;
import com.google.cloud.config.v1.UpdateDeploymentRequest;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.GetPolicyOptions;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ConfigClientTest {
    private static MockConfig mockConfig;
    private static MockIAMPolicy mockIAMPolicy;
    private static MockLocations mockLocations;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private ConfigClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockConfig = new MockConfig();
        mockLocations = new MockLocations();
        mockIAMPolicy = new MockIAMPolicy();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockConfig, mockLocations, mockIAMPolicy));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        ConfigSettings settings = ((ConfigSettings.Builder)((ConfigSettings.Builder)ConfigSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = ConfigClient.create((ConfigSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listDeploymentsTest() throws Exception {
        Deployment responsesElement = Deployment.newBuilder().build();
        ListDeploymentsResponse expectedResponse = ListDeploymentsResponse.newBuilder().setNextPageToken("").addAllDeployments(Arrays.asList(responsesElement)).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ConfigClient.ListDeploymentsPagedResponse pagedListResponse = this.client.listDeployments(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDeploymentsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDeploymentsRequest actualRequest = (ListDeploymentsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDeploymentsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listDeployments(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDeploymentsTest2() throws Exception {
        Deployment responsesElement = Deployment.newBuilder().build();
        ListDeploymentsResponse expectedResponse = ListDeploymentsResponse.newBuilder().setNextPageToken("").addAllDeployments(Arrays.asList(responsesElement)).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ConfigClient.ListDeploymentsPagedResponse pagedListResponse = this.client.listDeployments(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDeploymentsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDeploymentsRequest actualRequest = (ListDeploymentsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDeploymentsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listDeployments(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDeploymentTest() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        Deployment actualResponse = this.client.getDeployment(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDeploymentRequest actualRequest = (GetDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDeploymentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            this.client.getDeployment(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDeploymentTest2() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Deployment actualResponse = this.client.getDeployment(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDeploymentRequest actualRequest = (GetDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDeploymentExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getDeployment(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDeploymentTest() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("createDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockConfig.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Deployment deployment = Deployment.newBuilder().build();
        String deploymentId = "deploymentId-136894784";
        Deployment actualResponse = (Deployment)this.client.createDeploymentAsync(parent, deployment, deploymentId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDeploymentRequest actualRequest = (CreateDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)deployment, (Object)actualRequest.getDeployment());
        Assert.assertEquals((Object)deploymentId, (Object)actualRequest.getDeploymentId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDeploymentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Deployment deployment = Deployment.newBuilder().build();
            String deploymentId = "deploymentId-136894784";
            this.client.createDeploymentAsync(parent, deployment, deploymentId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createDeploymentTest2() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("createDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockConfig.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Deployment deployment = Deployment.newBuilder().build();
        String deploymentId = "deploymentId-136894784";
        Deployment actualResponse = (Deployment)this.client.createDeploymentAsync(parent, deployment, deploymentId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDeploymentRequest actualRequest = (CreateDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)deployment, (Object)actualRequest.getDeployment());
        Assert.assertEquals((Object)deploymentId, (Object)actualRequest.getDeploymentId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDeploymentExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Deployment deployment = Deployment.newBuilder().build();
            String deploymentId = "deploymentId-136894784";
            this.client.createDeploymentAsync(parent, deployment, deploymentId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateDeploymentTest() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockConfig.addResponse((AbstractMessage)resultOperation);
        Deployment deployment = Deployment.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Deployment actualResponse = (Deployment)this.client.updateDeploymentAsync(deployment, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateDeploymentRequest actualRequest = (UpdateDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)deployment, (Object)actualRequest.getDeployment());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateDeploymentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            Deployment deployment = Deployment.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateDeploymentAsync(deployment, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteDeploymentTest() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockConfig.addResponse((AbstractMessage)resultOperation);
        DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        Deployment actualResponse = (Deployment)this.client.deleteDeploymentAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDeploymentRequest actualRequest = (DeleteDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDeploymentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            this.client.deleteDeploymentAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteDeploymentTest2() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockConfig.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        Deployment actualResponse = (Deployment)this.client.deleteDeploymentAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDeploymentRequest actualRequest = (DeleteDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDeploymentExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteDeploymentAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listRevisionsTest() throws Exception {
        Revision responsesElement = Revision.newBuilder().build();
        ListRevisionsResponse expectedResponse = ListRevisionsResponse.newBuilder().setNextPageToken("").addAllRevisions(Arrays.asList(responsesElement)).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        DeploymentName parent = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        ConfigClient.ListRevisionsPagedResponse pagedListResponse = this.client.listRevisions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRevisionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListRevisionsRequest actualRequest = (ListRevisionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listRevisionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            DeploymentName parent = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            this.client.listRevisions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listRevisionsTest2() throws Exception {
        Revision responsesElement = Revision.newBuilder().build();
        ListRevisionsResponse expectedResponse = ListRevisionsResponse.newBuilder().setNextPageToken("").addAllRevisions(Arrays.asList(responsesElement)).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ConfigClient.ListRevisionsPagedResponse pagedListResponse = this.client.listRevisions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRevisionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListRevisionsRequest actualRequest = (ListRevisionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listRevisionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listRevisions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRevisionTest() throws Exception {
        Revision expectedResponse = Revision.newBuilder().setName(RevisionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setApplyResults(ApplyResults.newBuilder().build()).setStateDetail("stateDetail748574786").setBuild("build94094958").setLogs("logs3327407").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidationResults("quotaValidationResults-1396407899").setQuotaValidation(QuotaValidation.forNumber((int)0)).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        RevisionName name = RevisionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]");
        Revision actualResponse = this.client.getRevision(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetRevisionRequest actualRequest = (GetRevisionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getRevisionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            RevisionName name = RevisionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]");
            this.client.getRevision(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRevisionTest2() throws Exception {
        Revision expectedResponse = Revision.newBuilder().setName(RevisionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setApplyResults(ApplyResults.newBuilder().build()).setStateDetail("stateDetail748574786").setBuild("build94094958").setLogs("logs3327407").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidationResults("quotaValidationResults-1396407899").setQuotaValidation(QuotaValidation.forNumber((int)0)).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Revision actualResponse = this.client.getRevision(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetRevisionRequest actualRequest = (GetRevisionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getRevisionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getRevision(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getResourceTest() throws Exception {
        Resource expectedResponse = Resource.newBuilder().setName(ResourceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]", (String)"[RESOURCE]").toString()).setTerraformInfo(ResourceTerraformInfo.newBuilder().build()).putAllCaiAssets(new HashMap()).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        ResourceName name = ResourceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]", (String)"[RESOURCE]");
        Resource actualResponse = this.client.getResource(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetResourceRequest actualRequest = (GetResourceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getResourceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            ResourceName name = ResourceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]", (String)"[RESOURCE]");
            this.client.getResource(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getResourceTest2() throws Exception {
        Resource expectedResponse = Resource.newBuilder().setName(ResourceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]", (String)"[RESOURCE]").toString()).setTerraformInfo(ResourceTerraformInfo.newBuilder().build()).putAllCaiAssets(new HashMap()).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Resource actualResponse = this.client.getResource(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetResourceRequest actualRequest = (GetResourceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getResourceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getResource(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listResourcesTest() throws Exception {
        Resource responsesElement = Resource.newBuilder().build();
        ListResourcesResponse expectedResponse = ListResourcesResponse.newBuilder().setNextPageToken("").addAllResources(Arrays.asList(responsesElement)).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        RevisionName parent = RevisionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]");
        ConfigClient.ListResourcesPagedResponse pagedListResponse = this.client.listResources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getResourcesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListResourcesRequest actualRequest = (ListResourcesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listResourcesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            RevisionName parent = RevisionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]");
            this.client.listResources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listResourcesTest2() throws Exception {
        Resource responsesElement = Resource.newBuilder().build();
        ListResourcesResponse expectedResponse = ListResourcesResponse.newBuilder().setNextPageToken("").addAllResources(Arrays.asList(responsesElement)).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ConfigClient.ListResourcesPagedResponse pagedListResponse = this.client.listResources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getResourcesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListResourcesRequest actualRequest = (ListResourcesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listResourcesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listResources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void exportDeploymentStatefileTest() throws Exception {
        Statefile expectedResponse = Statefile.newBuilder().setSignedUri("signedUri1076770992").build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        ExportDeploymentStatefileRequest request = ExportDeploymentStatefileRequest.newBuilder().setParent(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setDraft(true).build();
        Statefile actualResponse = this.client.exportDeploymentStatefile(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ExportDeploymentStatefileRequest actualRequest = (ExportDeploymentStatefileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getDraft(), (Object)actualRequest.getDraft());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void exportDeploymentStatefileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            ExportDeploymentStatefileRequest request = ExportDeploymentStatefileRequest.newBuilder().setParent(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setDraft(true).build();
            this.client.exportDeploymentStatefile(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void exportRevisionStatefileTest() throws Exception {
        Statefile expectedResponse = Statefile.newBuilder().setSignedUri("signedUri1076770992").build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        ExportRevisionStatefileRequest request = ExportRevisionStatefileRequest.newBuilder().setParent(RevisionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]").toString()).build();
        Statefile actualResponse = this.client.exportRevisionStatefile(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ExportRevisionStatefileRequest actualRequest = (ExportRevisionStatefileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void exportRevisionStatefileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            ExportRevisionStatefileRequest request = ExportRevisionStatefileRequest.newBuilder().setParent(RevisionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[REVISION]").toString()).build();
            this.client.exportRevisionStatefile(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void importStatefileTest() throws Exception {
        Statefile expectedResponse = Statefile.newBuilder().setSignedUri("signedUri1076770992").build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        DeploymentName parent = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        long lockId = 338696367L;
        Statefile actualResponse = this.client.importStatefile(parent, lockId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ImportStatefileRequest actualRequest = (ImportStatefileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((long)lockId, (long)actualRequest.getLockId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void importStatefileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            DeploymentName parent = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            long lockId = 338696367L;
            this.client.importStatefile(parent, lockId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void importStatefileTest2() throws Exception {
        Statefile expectedResponse = Statefile.newBuilder().setSignedUri("signedUri1076770992").build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        long lockId = 338696367L;
        Statefile actualResponse = this.client.importStatefile(parent, lockId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ImportStatefileRequest actualRequest = (ImportStatefileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((long)lockId, (long)actualRequest.getLockId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void importStatefileExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            long lockId = 338696367L;
            this.client.importStatefile(parent, lockId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteStatefileTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        this.client.deleteStatefile(name);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteStatefileRequest actualRequest = (DeleteStatefileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteStatefileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            this.client.deleteStatefile(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteStatefileTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteStatefile(name);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteStatefileRequest actualRequest = (DeleteStatefileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteStatefileExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteStatefile(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void lockDeploymentTest() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("lockDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockConfig.addResponse((AbstractMessage)resultOperation);
        DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        Deployment actualResponse = (Deployment)this.client.lockDeploymentAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        LockDeploymentRequest actualRequest = (LockDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void lockDeploymentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            this.client.lockDeploymentAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void lockDeploymentTest2() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("lockDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockConfig.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        Deployment actualResponse = (Deployment)this.client.lockDeploymentAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        LockDeploymentRequest actualRequest = (LockDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void lockDeploymentExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.lockDeploymentAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void unlockDeploymentTest() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("unlockDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockConfig.addResponse((AbstractMessage)resultOperation);
        DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        long lockId = 338696367L;
        Deployment actualResponse = (Deployment)this.client.unlockDeploymentAsync(name, lockId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UnlockDeploymentRequest actualRequest = (UnlockDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((long)lockId, (long)actualRequest.getLockId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void unlockDeploymentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            long lockId = 338696367L;
            this.client.unlockDeploymentAsync(name, lockId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void unlockDeploymentTest2() throws Exception {
        Deployment expectedResponse = Deployment.newBuilder().setName(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLatestRevision("latestRevision-1002490750").setStateDetail("stateDetail748574786").setDeleteResults(ApplyResults.newBuilder().build()).setDeleteBuild("deleteBuild-1148574845").setDeleteLogs("deleteLogs1764356602").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setServiceAccount("serviceAccount1079137720").setImportExistingResources(true).setWorkerPool("workerPool-384405318").setTfVersionConstraint("tfVersionConstraint-1530231677").setTfVersion("tfVersion182968838").setQuotaValidation(QuotaValidation.forNumber((int)0)).putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("unlockDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockConfig.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        long lockId = 338696367L;
        Deployment actualResponse = (Deployment)this.client.unlockDeploymentAsync(name, lockId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UnlockDeploymentRequest actualRequest = (UnlockDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((long)lockId, (long)actualRequest.getLockId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void unlockDeploymentExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String name = "name3373707";
            long lockId = 338696367L;
            this.client.unlockDeploymentAsync(name, lockId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void exportLockInfoTest() throws Exception {
        LockInfo expectedResponse = LockInfo.newBuilder().setLockId(338696367L).setOperation("operation1662702951").setInfo("info3237038").setWho("who117694").setVersion("version351608024").setCreateTime(Timestamp.newBuilder().build()).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        LockInfo actualResponse = this.client.exportLockInfo(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ExportLockInfoRequest actualRequest = (ExportLockInfoRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void exportLockInfoExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            DeploymentName name = DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            this.client.exportLockInfo(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void exportLockInfoTest2() throws Exception {
        LockInfo expectedResponse = LockInfo.newBuilder().setLockId(338696367L).setOperation("operation1662702951").setInfo("info3237038").setWho("who117694").setVersion("version351608024").setCreateTime(Timestamp.newBuilder().build()).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        LockInfo actualResponse = this.client.exportLockInfo(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ExportLockInfoRequest actualRequest = (ExportLockInfoRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void exportLockInfoExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.exportLockInfo(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createPreviewTest() throws Exception {
        Preview expectedResponse = Preview.newBuilder().setName(PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]").toString()).setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDeployment(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setServiceAccount("serviceAccount1079137720").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setWorkerPool("workerPool-384405318").setErrorStatus(com.google.rpc.Status.newBuilder().build()).setBuild("build94094958").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setPreviewArtifacts(PreviewArtifacts.newBuilder().build()).setLogs("logs3327407").setTfVersion("tfVersion182968838").setTfVersionConstraint("tfVersionConstraint-1530231677").putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPreviewTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockConfig.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Preview preview = Preview.newBuilder().build();
        Preview actualResponse = (Preview)this.client.createPreviewAsync(parent, preview).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreatePreviewRequest actualRequest = (CreatePreviewRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)preview, (Object)actualRequest.getPreview());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createPreviewExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Preview preview = Preview.newBuilder().build();
            this.client.createPreviewAsync(parent, preview).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createPreviewTest2() throws Exception {
        Preview expectedResponse = Preview.newBuilder().setName(PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]").toString()).setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDeployment(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setServiceAccount("serviceAccount1079137720").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setWorkerPool("workerPool-384405318").setErrorStatus(com.google.rpc.Status.newBuilder().build()).setBuild("build94094958").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setPreviewArtifacts(PreviewArtifacts.newBuilder().build()).setLogs("logs3327407").setTfVersion("tfVersion182968838").setTfVersionConstraint("tfVersionConstraint-1530231677").putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPreviewTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockConfig.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Preview preview = Preview.newBuilder().build();
        Preview actualResponse = (Preview)this.client.createPreviewAsync(parent, preview).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreatePreviewRequest actualRequest = (CreatePreviewRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)preview, (Object)actualRequest.getPreview());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createPreviewExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Preview preview = Preview.newBuilder().build();
            this.client.createPreviewAsync(parent, preview).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getPreviewTest() throws Exception {
        Preview expectedResponse = Preview.newBuilder().setName(PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]").toString()).setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDeployment(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setServiceAccount("serviceAccount1079137720").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setWorkerPool("workerPool-384405318").setErrorStatus(com.google.rpc.Status.newBuilder().build()).setBuild("build94094958").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setPreviewArtifacts(PreviewArtifacts.newBuilder().build()).setLogs("logs3327407").setTfVersion("tfVersion182968838").setTfVersionConstraint("tfVersionConstraint-1530231677").putAllAnnotations(new HashMap()).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        PreviewName name = PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]");
        Preview actualResponse = this.client.getPreview(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetPreviewRequest actualRequest = (GetPreviewRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getPreviewExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            PreviewName name = PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]");
            this.client.getPreview(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getPreviewTest2() throws Exception {
        Preview expectedResponse = Preview.newBuilder().setName(PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]").toString()).setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDeployment(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setServiceAccount("serviceAccount1079137720").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setWorkerPool("workerPool-384405318").setErrorStatus(com.google.rpc.Status.newBuilder().build()).setBuild("build94094958").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setPreviewArtifacts(PreviewArtifacts.newBuilder().build()).setLogs("logs3327407").setTfVersion("tfVersion182968838").setTfVersionConstraint("tfVersionConstraint-1530231677").putAllAnnotations(new HashMap()).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Preview actualResponse = this.client.getPreview(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetPreviewRequest actualRequest = (GetPreviewRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getPreviewExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getPreview(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPreviewsTest() throws Exception {
        Preview responsesElement = Preview.newBuilder().build();
        ListPreviewsResponse expectedResponse = ListPreviewsResponse.newBuilder().setNextPageToken("").addAllPreviews(Arrays.asList(responsesElement)).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ConfigClient.ListPreviewsPagedResponse pagedListResponse = this.client.listPreviews(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPreviewsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPreviewsRequest actualRequest = (ListPreviewsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPreviewsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listPreviews(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPreviewsTest2() throws Exception {
        Preview responsesElement = Preview.newBuilder().build();
        ListPreviewsResponse expectedResponse = ListPreviewsResponse.newBuilder().setNextPageToken("").addAllPreviews(Arrays.asList(responsesElement)).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ConfigClient.ListPreviewsPagedResponse pagedListResponse = this.client.listPreviews(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPreviewsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPreviewsRequest actualRequest = (ListPreviewsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPreviewsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listPreviews(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deletePreviewTest() throws Exception {
        Preview expectedResponse = Preview.newBuilder().setName(PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]").toString()).setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDeployment(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setServiceAccount("serviceAccount1079137720").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setWorkerPool("workerPool-384405318").setErrorStatus(com.google.rpc.Status.newBuilder().build()).setBuild("build94094958").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setPreviewArtifacts(PreviewArtifacts.newBuilder().build()).setLogs("logs3327407").setTfVersion("tfVersion182968838").setTfVersionConstraint("tfVersionConstraint-1530231677").putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("deletePreviewTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockConfig.addResponse((AbstractMessage)resultOperation);
        PreviewName name = PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]");
        Preview actualResponse = (Preview)this.client.deletePreviewAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeletePreviewRequest actualRequest = (DeletePreviewRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deletePreviewExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            PreviewName name = PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]");
            this.client.deletePreviewAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deletePreviewTest2() throws Exception {
        Preview expectedResponse = Preview.newBuilder().setName(PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]").toString()).setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDeployment(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setServiceAccount("serviceAccount1079137720").setArtifactsGcsBucket("artifactsGcsBucket-1978454016").setWorkerPool("workerPool-384405318").setErrorStatus(com.google.rpc.Status.newBuilder().build()).setBuild("build94094958").addAllTfErrors(new ArrayList()).setErrorLogs("errorLogs329304023").setPreviewArtifacts(PreviewArtifacts.newBuilder().build()).setLogs("logs3327407").setTfVersion("tfVersion182968838").setTfVersionConstraint("tfVersionConstraint-1530231677").putAllAnnotations(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("deletePreviewTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockConfig.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        Preview actualResponse = (Preview)this.client.deletePreviewAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeletePreviewRequest actualRequest = (DeletePreviewRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deletePreviewExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deletePreviewAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void exportPreviewResultTest() throws Exception {
        ExportPreviewResultResponse expectedResponse = ExportPreviewResultResponse.newBuilder().setResult(PreviewResult.newBuilder().build()).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        ExportPreviewResultRequest request = ExportPreviewResultRequest.newBuilder().setParent(PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]").toString()).build();
        ExportPreviewResultResponse actualResponse = this.client.exportPreviewResult(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ExportPreviewResultRequest actualRequest = (ExportPreviewResultRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void exportPreviewResultExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            ExportPreviewResultRequest request = ExportPreviewResultRequest.newBuilder().setParent(PreviewName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PREVIEW]").toString()).build();
            this.client.exportPreviewResult(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTerraformVersionsTest() throws Exception {
        TerraformVersion responsesElement = TerraformVersion.newBuilder().build();
        ListTerraformVersionsResponse expectedResponse = ListTerraformVersionsResponse.newBuilder().setNextPageToken("").addAllTerraformVersions(Arrays.asList(responsesElement)).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ConfigClient.ListTerraformVersionsPagedResponse pagedListResponse = this.client.listTerraformVersions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTerraformVersionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTerraformVersionsRequest actualRequest = (ListTerraformVersionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTerraformVersionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listTerraformVersions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTerraformVersionsTest2() throws Exception {
        TerraformVersion responsesElement = TerraformVersion.newBuilder().build();
        ListTerraformVersionsResponse expectedResponse = ListTerraformVersionsResponse.newBuilder().setNextPageToken("").addAllTerraformVersions(Arrays.asList(responsesElement)).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ConfigClient.ListTerraformVersionsPagedResponse pagedListResponse = this.client.listTerraformVersions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTerraformVersionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTerraformVersionsRequest actualRequest = (ListTerraformVersionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTerraformVersionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listTerraformVersions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTerraformVersionTest() throws Exception {
        TerraformVersion expectedResponse = TerraformVersion.newBuilder().setName(TerraformVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TERRAFORM_VERSION]").toString()).setSupportTime(Timestamp.newBuilder().build()).setDeprecateTime(Timestamp.newBuilder().build()).setObsoleteTime(Timestamp.newBuilder().build()).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        TerraformVersionName name = TerraformVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TERRAFORM_VERSION]");
        TerraformVersion actualResponse = this.client.getTerraformVersion(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTerraformVersionRequest actualRequest = (GetTerraformVersionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTerraformVersionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            TerraformVersionName name = TerraformVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TERRAFORM_VERSION]");
            this.client.getTerraformVersion(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTerraformVersionTest2() throws Exception {
        TerraformVersion expectedResponse = TerraformVersion.newBuilder().setName(TerraformVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TERRAFORM_VERSION]").toString()).setSupportTime(Timestamp.newBuilder().build()).setDeprecateTime(Timestamp.newBuilder().build()).setObsoleteTime(Timestamp.newBuilder().build()).build();
        mockConfig.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        TerraformVersion actualResponse = this.client.getTerraformVersion(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockConfig.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTerraformVersionRequest actualRequest = (GetTerraformVersionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTerraformVersionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockConfig.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getTerraformVersion(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listLocationsTest() throws Exception {
        Location responsesElement = Location.newBuilder().build();
        ListLocationsResponse expectedResponse = ListLocationsResponse.newBuilder().setNextPageToken("").addAllLocations(Arrays.asList(responsesElement)).build();
        mockLocations.addResponse((AbstractMessage)expectedResponse);
        ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("name3373707").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
        ConfigClient.ListLocationsPagedResponse pagedListResponse = this.client.listLocations(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLocationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLocations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListLocationsRequest actualRequest = (ListLocationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getFilter(), (Object)actualRequest.getFilter());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listLocationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLocations.addException((Exception)exception);
        try {
            ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("name3373707").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
            this.client.listLocations(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getLocationTest() throws Exception {
        Location expectedResponse = Location.newBuilder().setName("name3373707").setLocationId("locationId1541836720").setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setMetadata(Any.newBuilder().build()).build();
        mockLocations.addResponse((AbstractMessage)expectedResponse);
        GetLocationRequest request = GetLocationRequest.newBuilder().setName("name3373707").build();
        Location actualResponse = this.client.getLocation(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLocations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetLocationRequest actualRequest = (GetLocationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getLocationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLocations.addException((Exception)exception);
        try {
            GetLocationRequest request = GetLocationRequest.newBuilder().setName("name3373707").build();
            this.client.getLocation(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
        Policy actualResponse = this.client.setIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getPolicy(), (Object)actualRequest.getPolicy());
        Assert.assertEquals((Object)request.getUpdateMask(), (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
            this.client.setIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
        Policy actualResponse = this.client.getIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getOptions(), (Object)actualRequest.getOptions());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
            this.client.getIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).addAllPermissions(new ArrayList()).build();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getPermissionsList(), (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(DeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]").toString()).addAllPermissions(new ArrayList()).build();
            this.client.testIamPermissions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

