/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.lifesciences.v2beta;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.lifesciences.v2beta.MockLocations;
import com.google.cloud.lifesciences.v2beta.MockWorkflowsServiceV2Beta;
import com.google.cloud.lifesciences.v2beta.Pipeline;
import com.google.cloud.lifesciences.v2beta.RunPipelineRequest;
import com.google.cloud.lifesciences.v2beta.RunPipelineResponse;
import com.google.cloud.lifesciences.v2beta.WorkflowsServiceV2BetaClient;
import com.google.cloud.lifesciences.v2beta.WorkflowsServiceV2BetaSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class WorkflowsServiceV2BetaClientTest {
    private static MockLocations mockLocations;
    private static MockServiceHelper mockServiceHelper;
    private static MockWorkflowsServiceV2Beta mockWorkflowsServiceV2Beta;
    private LocalChannelProvider channelProvider;
    private WorkflowsServiceV2BetaClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockWorkflowsServiceV2Beta = new MockWorkflowsServiceV2Beta();
        mockLocations = new MockLocations();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockWorkflowsServiceV2Beta, mockLocations));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        WorkflowsServiceV2BetaSettings settings = ((WorkflowsServiceV2BetaSettings.Builder)((WorkflowsServiceV2BetaSettings.Builder)WorkflowsServiceV2BetaSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = WorkflowsServiceV2BetaClient.create((WorkflowsServiceV2BetaSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void runPipelineTest() throws Exception {
        RunPipelineResponse expectedResponse = RunPipelineResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("runPipelineTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockWorkflowsServiceV2Beta.addResponse((AbstractMessage)resultOperation);
        RunPipelineRequest request = RunPipelineRequest.newBuilder().setParent("parent-995424086").setPipeline(Pipeline.newBuilder().build()).putAllLabels(new HashMap()).setPubSubTopic("pubSubTopic320524524").build();
        RunPipelineResponse actualResponse = (RunPipelineResponse)this.client.runPipelineAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockWorkflowsServiceV2Beta.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RunPipelineRequest actualRequest = (RunPipelineRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getPipeline(), (Object)actualRequest.getPipeline());
        Assert.assertEquals((Object)request.getLabelsMap(), (Object)actualRequest.getLabelsMap());
        Assert.assertEquals((Object)request.getPubSubTopic(), (Object)actualRequest.getPubSubTopic());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void runPipelineExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockWorkflowsServiceV2Beta.addException((Exception)exception);
        try {
            RunPipelineRequest request = RunPipelineRequest.newBuilder().setParent("parent-995424086").setPipeline(Pipeline.newBuilder().build()).putAllLabels(new HashMap()).setPubSubTopic("pubSubTopic320524524").build();
            this.client.runPipelineAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listLocationsTest() throws Exception {
        Location responsesElement = Location.newBuilder().build();
        ListLocationsResponse expectedResponse = ListLocationsResponse.newBuilder().setNextPageToken("").addAllLocations(Arrays.asList(responsesElement)).build();
        mockLocations.addResponse((AbstractMessage)expectedResponse);
        ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("name3373707").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
        WorkflowsServiceV2BetaClient.ListLocationsPagedResponse pagedListResponse = this.client.listLocations(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLocationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLocations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListLocationsRequest actualRequest = (ListLocationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getFilter(), (Object)actualRequest.getFilter());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listLocationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLocations.addException((Exception)exception);
        try {
            ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("name3373707").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
            this.client.listLocations(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getLocationTest() throws Exception {
        Location expectedResponse = Location.newBuilder().setName("name3373707").setLocationId("locationId1541836720").setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setMetadata(Any.newBuilder().build()).build();
        mockLocations.addResponse((AbstractMessage)expectedResponse);
        GetLocationRequest request = GetLocationRequest.newBuilder().setName("name3373707").build();
        Location actualResponse = this.client.getLocation(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLocations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetLocationRequest actualRequest = (GetLocationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getLocationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLocations.addException((Exception)exception);
        try {
            GetLocationRequest request = GetLocationRequest.newBuilder().setName("name3373707").build();
            this.client.getLocation(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

