/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.maintenance.api.v1beta;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.maintenance.api.v1beta.ListResourceMaintenancesResponse;
import com.google.cloud.maintenance.api.v1beta.LocationName;
import com.google.cloud.maintenance.api.v1beta.MaintenanceClient;
import com.google.cloud.maintenance.api.v1beta.MaintenanceSettings;
import com.google.cloud.maintenance.api.v1beta.MaintenanceSummary;
import com.google.cloud.maintenance.api.v1beta.ResourceMaintenance;
import com.google.cloud.maintenance.api.v1beta.ResourceMaintenanceName;
import com.google.cloud.maintenance.api.v1beta.SummarizeMaintenancesResponse;
import com.google.cloud.maintenance.api.v1beta.stub.HttpJsonMaintenanceStub;
import com.google.common.collect.Lists;
import com.google.protobuf.Any;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MaintenanceClientHttpJsonTest {
    private static MockHttpService mockService;
    private static MaintenanceClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonMaintenanceStub.getMethodDescriptors(), MaintenanceSettings.getDefaultEndpoint());
        MaintenanceSettings settings = ((MaintenanceSettings.Builder)((MaintenanceSettings.Builder)MaintenanceSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)MaintenanceSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = MaintenanceClient.create((MaintenanceSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void summarizeMaintenancesTest() throws Exception {
        MaintenanceSummary responsesElement = MaintenanceSummary.newBuilder().build();
        SummarizeMaintenancesResponse expectedResponse = SummarizeMaintenancesResponse.newBuilder().setNextPageToken("").addAllMaintenances(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        MaintenanceClient.SummarizeMaintenancesPagedResponse pagedListResponse = client.summarizeMaintenances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMaintenancesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void summarizeMaintenancesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.summarizeMaintenances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void summarizeMaintenancesTest2() throws Exception {
        MaintenanceSummary responsesElement = MaintenanceSummary.newBuilder().build();
        SummarizeMaintenancesResponse expectedResponse = SummarizeMaintenancesResponse.newBuilder().setNextPageToken("").addAllMaintenances(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        MaintenanceClient.SummarizeMaintenancesPagedResponse pagedListResponse = client.summarizeMaintenances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMaintenancesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void summarizeMaintenancesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.summarizeMaintenances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listResourceMaintenancesTest() throws Exception {
        ResourceMaintenance responsesElement = ResourceMaintenance.newBuilder().build();
        ListResourceMaintenancesResponse expectedResponse = ListResourceMaintenancesResponse.newBuilder().setNextPageToken("").addAllResourceMaintenances(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        MaintenanceClient.ListResourceMaintenancesPagedResponse pagedListResponse = client.listResourceMaintenances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getResourceMaintenancesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listResourceMaintenancesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listResourceMaintenances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listResourceMaintenancesTest2() throws Exception {
        ResourceMaintenance responsesElement = ResourceMaintenance.newBuilder().build();
        ListResourceMaintenancesResponse expectedResponse = ListResourceMaintenancesResponse.newBuilder().setNextPageToken("").addAllResourceMaintenances(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        MaintenanceClient.ListResourceMaintenancesPagedResponse pagedListResponse = client.listResourceMaintenances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getResourceMaintenancesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listResourceMaintenancesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listResourceMaintenances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getResourceMaintenanceTest() throws Exception {
        ResourceMaintenance expectedResponse = ResourceMaintenance.newBuilder().setName(ResourceMaintenanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESOURCE_MAINTENANCE]").toString()).setResource(ResourceMaintenance.Resource.newBuilder().build()).setMaintenance(ResourceMaintenance.Maintenance.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMaintenanceStartTime(Timestamp.newBuilder().build()).setMaintenanceEndTime(Timestamp.newBuilder().build()).setMaintenanceCancelTime(Timestamp.newBuilder().build()).setMaintenanceScheduledStartTime(Timestamp.newBuilder().build()).setMaintenanceScheduledEndTime(Timestamp.newBuilder().build()).setUserControllable(true).addAllControls(new ArrayList()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setUid("uid115792").setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        ResourceMaintenanceName name = ResourceMaintenanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESOURCE_MAINTENANCE]");
        ResourceMaintenance actualResponse = client.getResourceMaintenance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getResourceMaintenanceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ResourceMaintenanceName name = ResourceMaintenanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESOURCE_MAINTENANCE]");
            client.getResourceMaintenance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getResourceMaintenanceTest2() throws Exception {
        ResourceMaintenance expectedResponse = ResourceMaintenance.newBuilder().setName(ResourceMaintenanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESOURCE_MAINTENANCE]").toString()).setResource(ResourceMaintenance.Resource.newBuilder().build()).setMaintenance(ResourceMaintenance.Maintenance.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMaintenanceStartTime(Timestamp.newBuilder().build()).setMaintenanceEndTime(Timestamp.newBuilder().build()).setMaintenanceCancelTime(Timestamp.newBuilder().build()).setMaintenanceScheduledStartTime(Timestamp.newBuilder().build()).setMaintenanceScheduledEndTime(Timestamp.newBuilder().build()).setUserControllable(true).addAllControls(new ArrayList()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setUid("uid115792").setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-6286/locations/location-6286/resourceMaintenances/resourceMaintenance-6286";
        ResourceMaintenance actualResponse = client.getResourceMaintenance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getResourceMaintenanceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-6286/locations/location-6286/resourceMaintenances/resourceMaintenance-6286";
            client.getResourceMaintenance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listLocationsTest() throws Exception {
        Location responsesElement = Location.newBuilder().build();
        ListLocationsResponse expectedResponse = ListLocationsResponse.newBuilder().setNextPageToken("").addAllLocations(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("projects/project-3664").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
        MaintenanceClient.ListLocationsPagedResponse pagedListResponse = client.listLocations(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLocationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listLocationsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("projects/project-3664").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
            client.listLocations(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getLocationTest() throws Exception {
        Location expectedResponse = Location.newBuilder().setName("name3373707").setLocationId("locationId1541836720").setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setMetadata(Any.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        GetLocationRequest request = GetLocationRequest.newBuilder().setName("projects/project-9062/locations/location-9062").build();
        Location actualResponse = client.getLocation(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getLocationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GetLocationRequest request = GetLocationRequest.newBuilder().setName("projects/project-9062/locations/location-9062").build();
            client.getLocation(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

