/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.maintenance.api.v1beta;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.maintenance.api.v1beta.GetResourceMaintenanceRequest;
import com.google.cloud.maintenance.api.v1beta.ListResourceMaintenancesRequest;
import com.google.cloud.maintenance.api.v1beta.ListResourceMaintenancesResponse;
import com.google.cloud.maintenance.api.v1beta.LocationName;
import com.google.cloud.maintenance.api.v1beta.MaintenanceClient;
import com.google.cloud.maintenance.api.v1beta.MaintenanceSettings;
import com.google.cloud.maintenance.api.v1beta.MaintenanceSummary;
import com.google.cloud.maintenance.api.v1beta.MockLocations;
import com.google.cloud.maintenance.api.v1beta.MockMaintenance;
import com.google.cloud.maintenance.api.v1beta.ResourceMaintenance;
import com.google.cloud.maintenance.api.v1beta.ResourceMaintenanceName;
import com.google.cloud.maintenance.api.v1beta.SummarizeMaintenancesRequest;
import com.google.cloud.maintenance.api.v1beta.SummarizeMaintenancesResponse;
import com.google.common.collect.Lists;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MaintenanceClientTest {
    private static MockLocations mockLocations;
    private static MockMaintenance mockMaintenance;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private MaintenanceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockMaintenance = new MockMaintenance();
        mockLocations = new MockLocations();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockMaintenance, mockLocations));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        MaintenanceSettings settings = ((MaintenanceSettings.Builder)((MaintenanceSettings.Builder)MaintenanceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = MaintenanceClient.create((MaintenanceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void summarizeMaintenancesTest() throws Exception {
        MaintenanceSummary responsesElement = MaintenanceSummary.newBuilder().build();
        SummarizeMaintenancesResponse expectedResponse = SummarizeMaintenancesResponse.newBuilder().setNextPageToken("").addAllMaintenances(Arrays.asList(responsesElement)).build();
        mockMaintenance.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        MaintenanceClient.SummarizeMaintenancesPagedResponse pagedListResponse = this.client.summarizeMaintenances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMaintenancesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMaintenance.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SummarizeMaintenancesRequest actualRequest = (SummarizeMaintenancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void summarizeMaintenancesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMaintenance.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.summarizeMaintenances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void summarizeMaintenancesTest2() throws Exception {
        MaintenanceSummary responsesElement = MaintenanceSummary.newBuilder().build();
        SummarizeMaintenancesResponse expectedResponse = SummarizeMaintenancesResponse.newBuilder().setNextPageToken("").addAllMaintenances(Arrays.asList(responsesElement)).build();
        mockMaintenance.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        MaintenanceClient.SummarizeMaintenancesPagedResponse pagedListResponse = this.client.summarizeMaintenances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMaintenancesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMaintenance.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SummarizeMaintenancesRequest actualRequest = (SummarizeMaintenancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void summarizeMaintenancesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMaintenance.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.summarizeMaintenances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listResourceMaintenancesTest() throws Exception {
        ResourceMaintenance responsesElement = ResourceMaintenance.newBuilder().build();
        ListResourceMaintenancesResponse expectedResponse = ListResourceMaintenancesResponse.newBuilder().setNextPageToken("").addAllResourceMaintenances(Arrays.asList(responsesElement)).build();
        mockMaintenance.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        MaintenanceClient.ListResourceMaintenancesPagedResponse pagedListResponse = this.client.listResourceMaintenances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getResourceMaintenancesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMaintenance.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListResourceMaintenancesRequest actualRequest = (ListResourceMaintenancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listResourceMaintenancesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMaintenance.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listResourceMaintenances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listResourceMaintenancesTest2() throws Exception {
        ResourceMaintenance responsesElement = ResourceMaintenance.newBuilder().build();
        ListResourceMaintenancesResponse expectedResponse = ListResourceMaintenancesResponse.newBuilder().setNextPageToken("").addAllResourceMaintenances(Arrays.asList(responsesElement)).build();
        mockMaintenance.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        MaintenanceClient.ListResourceMaintenancesPagedResponse pagedListResponse = this.client.listResourceMaintenances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getResourceMaintenancesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMaintenance.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListResourceMaintenancesRequest actualRequest = (ListResourceMaintenancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listResourceMaintenancesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMaintenance.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listResourceMaintenances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getResourceMaintenanceTest() throws Exception {
        ResourceMaintenance expectedResponse = ResourceMaintenance.newBuilder().setName(ResourceMaintenanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESOURCE_MAINTENANCE]").toString()).setResource(ResourceMaintenance.Resource.newBuilder().build()).setMaintenance(ResourceMaintenance.Maintenance.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMaintenanceStartTime(Timestamp.newBuilder().build()).setMaintenanceEndTime(Timestamp.newBuilder().build()).setMaintenanceCancelTime(Timestamp.newBuilder().build()).setMaintenanceScheduledStartTime(Timestamp.newBuilder().build()).setMaintenanceScheduledEndTime(Timestamp.newBuilder().build()).setUserControllable(true).addAllControls(new ArrayList()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setUid("uid115792").setEtag("etag3123477").build();
        mockMaintenance.addResponse((AbstractMessage)expectedResponse);
        ResourceMaintenanceName name = ResourceMaintenanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESOURCE_MAINTENANCE]");
        ResourceMaintenance actualResponse = this.client.getResourceMaintenance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMaintenance.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetResourceMaintenanceRequest actualRequest = (GetResourceMaintenanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getResourceMaintenanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMaintenance.addException((Exception)exception);
        try {
            ResourceMaintenanceName name = ResourceMaintenanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESOURCE_MAINTENANCE]");
            this.client.getResourceMaintenance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getResourceMaintenanceTest2() throws Exception {
        ResourceMaintenance expectedResponse = ResourceMaintenance.newBuilder().setName(ResourceMaintenanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RESOURCE_MAINTENANCE]").toString()).setResource(ResourceMaintenance.Resource.newBuilder().build()).setMaintenance(ResourceMaintenance.Maintenance.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMaintenanceStartTime(Timestamp.newBuilder().build()).setMaintenanceEndTime(Timestamp.newBuilder().build()).setMaintenanceCancelTime(Timestamp.newBuilder().build()).setMaintenanceScheduledStartTime(Timestamp.newBuilder().build()).setMaintenanceScheduledEndTime(Timestamp.newBuilder().build()).setUserControllable(true).addAllControls(new ArrayList()).putAllLabels(new HashMap()).putAllAnnotations(new HashMap()).setUid("uid115792").setEtag("etag3123477").build();
        mockMaintenance.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        ResourceMaintenance actualResponse = this.client.getResourceMaintenance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMaintenance.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetResourceMaintenanceRequest actualRequest = (GetResourceMaintenanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getResourceMaintenanceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMaintenance.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getResourceMaintenance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listLocationsTest() throws Exception {
        Location responsesElement = Location.newBuilder().build();
        ListLocationsResponse expectedResponse = ListLocationsResponse.newBuilder().setNextPageToken("").addAllLocations(Arrays.asList(responsesElement)).build();
        mockLocations.addResponse((AbstractMessage)expectedResponse);
        ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("name3373707").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
        MaintenanceClient.ListLocationsPagedResponse pagedListResponse = this.client.listLocations(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLocationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLocations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListLocationsRequest actualRequest = (ListLocationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getFilter(), (Object)actualRequest.getFilter());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listLocationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLocations.addException((Exception)exception);
        try {
            ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("name3373707").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
            this.client.listLocations(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getLocationTest() throws Exception {
        Location expectedResponse = Location.newBuilder().setName("name3373707").setLocationId("locationId1541836720").setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setMetadata(Any.newBuilder().build()).build();
        mockLocations.addResponse((AbstractMessage)expectedResponse);
        GetLocationRequest request = GetLocationRequest.newBuilder().setName("name3373707").build();
        Location actualResponse = this.client.getLocation(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLocations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetLocationRequest actualRequest = (GetLocationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getLocationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLocations.addException((Exception)exception);
        try {
            GetLocationRequest request = GetLocationRequest.newBuilder().setName("name3373707").build();
            this.client.getLocation(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

