/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.policysimulator.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.policysimulator.v1.CreateReplayRequest;
import com.google.cloud.policysimulator.v1.GetReplayRequest;
import com.google.cloud.policysimulator.v1.ListReplayResultsRequest;
import com.google.cloud.policysimulator.v1.ListReplayResultsResponse;
import com.google.cloud.policysimulator.v1.Replay;
import com.google.cloud.policysimulator.v1.ReplayName;
import com.google.cloud.policysimulator.v1.ReplayOperationMetadata;
import com.google.cloud.policysimulator.v1.ReplayResult;
import com.google.cloud.policysimulator.v1.SimulatorSettings;
import com.google.cloud.policysimulator.v1.stub.SimulatorStub;
import com.google.cloud.policysimulator.v1.stub.SimulatorStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SimulatorClient
implements BackgroundResource {
    private final SimulatorSettings settings;
    private final SimulatorStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final SimulatorClient create() throws IOException {
        return SimulatorClient.create(SimulatorSettings.newBuilder().build());
    }

    public static final SimulatorClient create(SimulatorSettings settings) throws IOException {
        return new SimulatorClient(settings);
    }

    public static final SimulatorClient create(SimulatorStub stub) {
        return new SimulatorClient(stub);
    }

    protected SimulatorClient(SimulatorSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SimulatorStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected SimulatorClient(SimulatorStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final SimulatorSettings getSettings() {
        return this.settings;
    }

    public SimulatorStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Replay getReplay(ReplayName name) {
        GetReplayRequest request = GetReplayRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getReplay(request);
    }

    public final Replay getReplay(String name) {
        GetReplayRequest request = GetReplayRequest.newBuilder().setName(name).build();
        return this.getReplay(request);
    }

    public final Replay getReplay(GetReplayRequest request) {
        return (Replay)this.getReplayCallable().call((Object)request);
    }

    public final UnaryCallable<GetReplayRequest, Replay> getReplayCallable() {
        return this.stub.getReplayCallable();
    }

    public final OperationFuture<Replay, ReplayOperationMetadata> createReplayAsync(String parent, Replay replay) {
        CreateReplayRequest request = CreateReplayRequest.newBuilder().setParent(parent).setReplay(replay).build();
        return this.createReplayAsync(request);
    }

    public final OperationFuture<Replay, ReplayOperationMetadata> createReplayAsync(CreateReplayRequest request) {
        return this.createReplayOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateReplayRequest, Replay, ReplayOperationMetadata> createReplayOperationCallable() {
        return this.stub.createReplayOperationCallable();
    }

    public final UnaryCallable<CreateReplayRequest, Operation> createReplayCallable() {
        return this.stub.createReplayCallable();
    }

    public final ListReplayResultsPagedResponse listReplayResults(ReplayName parent) {
        ListReplayResultsRequest request = ListReplayResultsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReplayResults(request);
    }

    public final ListReplayResultsPagedResponse listReplayResults(String parent) {
        ListReplayResultsRequest request = ListReplayResultsRequest.newBuilder().setParent(parent).build();
        return this.listReplayResults(request);
    }

    public final ListReplayResultsPagedResponse listReplayResults(ListReplayResultsRequest request) {
        return (ListReplayResultsPagedResponse)((Object)this.listReplayResultsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReplayResultsRequest, ListReplayResultsPagedResponse> listReplayResultsPagedCallable() {
        return this.stub.listReplayResultsPagedCallable();
    }

    public final UnaryCallable<ListReplayResultsRequest, ListReplayResultsResponse> listReplayResultsCallable() {
        return this.stub.listReplayResultsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListReplayResultsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReplayResultsRequest, ListReplayResultsResponse, ReplayResult, ListReplayResultsPage, ListReplayResultsFixedSizeCollection> {
        private ListReplayResultsFixedSizeCollection(List<ListReplayResultsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReplayResultsFixedSizeCollection createEmptyCollection() {
            return new ListReplayResultsFixedSizeCollection(null, 0);
        }

        protected ListReplayResultsFixedSizeCollection createCollection(List<ListReplayResultsPage> pages, int collectionSize) {
            return new ListReplayResultsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReplayResultsPage
    extends AbstractPage<ListReplayResultsRequest, ListReplayResultsResponse, ReplayResult, ListReplayResultsPage> {
        private ListReplayResultsPage(PageContext<ListReplayResultsRequest, ListReplayResultsResponse, ReplayResult> context, ListReplayResultsResponse response) {
            super(context, (Object)response);
        }

        private static ListReplayResultsPage createEmptyPage() {
            return new ListReplayResultsPage(null, null);
        }

        protected ListReplayResultsPage createPage(PageContext<ListReplayResultsRequest, ListReplayResultsResponse, ReplayResult> context, ListReplayResultsResponse response) {
            return new ListReplayResultsPage(context, response);
        }

        public ApiFuture<ListReplayResultsPage> createPageAsync(PageContext<ListReplayResultsRequest, ListReplayResultsResponse, ReplayResult> context, ApiFuture<ListReplayResultsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReplayResultsPagedResponse
    extends AbstractPagedListResponse<ListReplayResultsRequest, ListReplayResultsResponse, ReplayResult, ListReplayResultsPage, ListReplayResultsFixedSizeCollection> {
        public static ApiFuture<ListReplayResultsPagedResponse> createAsync(PageContext<ListReplayResultsRequest, ListReplayResultsResponse, ReplayResult> context, ApiFuture<ListReplayResultsResponse> futureResponse) {
            ApiFuture<ListReplayResultsPage> futurePage = ListReplayResultsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListReplayResultsPagedResponse((ListReplayResultsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListReplayResultsPagedResponse(ListReplayResultsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReplayResultsFixedSizeCollection.createEmptyCollection());
        }
    }
}

