/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.privatecatalog.v1beta1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.privatecatalog.v1beta1.Catalog;
import com.google.cloud.privatecatalog.v1beta1.PrivateCatalogClient;
import com.google.cloud.privatecatalog.v1beta1.PrivateCatalogSettings;
import com.google.cloud.privatecatalog.v1beta1.Product;
import com.google.cloud.privatecatalog.v1beta1.SearchCatalogsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchCatalogsResponse;
import com.google.cloud.privatecatalog.v1beta1.SearchProductsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchProductsResponse;
import com.google.cloud.privatecatalog.v1beta1.SearchVersionsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchVersionsResponse;
import com.google.cloud.privatecatalog.v1beta1.Version;
import com.google.cloud.privatecatalog.v1beta1.stub.HttpJsonPrivateCatalogStub;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PrivateCatalogClientHttpJsonTest {
    private static MockHttpService mockService;
    private static PrivateCatalogClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonPrivateCatalogStub.getMethodDescriptors(), PrivateCatalogSettings.getDefaultEndpoint());
        PrivateCatalogSettings settings = ((PrivateCatalogSettings.Builder)((PrivateCatalogSettings.Builder)PrivateCatalogSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)PrivateCatalogSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = PrivateCatalogClient.create((PrivateCatalogSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void searchCatalogsTest() throws Exception {
        Catalog responsesElement = Catalog.newBuilder().build();
        SearchCatalogsResponse expectedResponse = SearchCatalogsResponse.newBuilder().setNextPageToken("").addAllCatalogs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        SearchCatalogsRequest request = SearchCatalogsRequest.newBuilder().setResource("projects/project-4963").setQuery("query107944136").setPageSize(883849137).setPageToken("pageToken873572522").build();
        PrivateCatalogClient.SearchCatalogsPagedResponse pagedListResponse = client.searchCatalogs(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCatalogsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void searchCatalogsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SearchCatalogsRequest request = SearchCatalogsRequest.newBuilder().setResource("projects/project-4963").setQuery("query107944136").setPageSize(883849137).setPageToken("pageToken873572522").build();
            client.searchCatalogs(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchProductsTest() throws Exception {
        Product responsesElement = Product.newBuilder().build();
        SearchProductsResponse expectedResponse = SearchProductsResponse.newBuilder().setNextPageToken("").addAllProducts(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        SearchProductsRequest request = SearchProductsRequest.newBuilder().setResource("projects/project-4963").setQuery("query107944136").setPageSize(883849137).setPageToken("pageToken873572522").build();
        PrivateCatalogClient.SearchProductsPagedResponse pagedListResponse = client.searchProducts(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void searchProductsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SearchProductsRequest request = SearchProductsRequest.newBuilder().setResource("projects/project-4963").setQuery("query107944136").setPageSize(883849137).setPageToken("pageToken873572522").build();
            client.searchProducts(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchVersionsTest() throws Exception {
        Version responsesElement = Version.newBuilder().build();
        SearchVersionsResponse expectedResponse = SearchVersionsResponse.newBuilder().setNextPageToken("").addAllVersions(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        SearchVersionsRequest request = SearchVersionsRequest.newBuilder().setResource("projects/project-4963").setQuery("query107944136").setPageSize(883849137).setPageToken("pageToken873572522").build();
        PrivateCatalogClient.SearchVersionsPagedResponse pagedListResponse = client.searchVersions(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getVersionsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void searchVersionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SearchVersionsRequest request = SearchVersionsRequest.newBuilder().setResource("projects/project-4963").setQuery("query107944136").setPageSize(883849137).setPageToken("pageToken873572522").build();
            client.searchVersions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

