/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.privatecatalog.v1beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.privatecatalog.v1beta1.Catalog;
import com.google.cloud.privatecatalog.v1beta1.MockPrivateCatalog;
import com.google.cloud.privatecatalog.v1beta1.PrivateCatalogClient;
import com.google.cloud.privatecatalog.v1beta1.PrivateCatalogSettings;
import com.google.cloud.privatecatalog.v1beta1.Product;
import com.google.cloud.privatecatalog.v1beta1.SearchCatalogsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchCatalogsResponse;
import com.google.cloud.privatecatalog.v1beta1.SearchProductsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchProductsResponse;
import com.google.cloud.privatecatalog.v1beta1.SearchVersionsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchVersionsResponse;
import com.google.cloud.privatecatalog.v1beta1.Version;
import com.google.common.collect.Lists;
import com.google.protobuf.AbstractMessage;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PrivateCatalogClientTest {
    private static MockPrivateCatalog mockPrivateCatalog;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private PrivateCatalogClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockPrivateCatalog = new MockPrivateCatalog();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockPrivateCatalog));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        PrivateCatalogSettings settings = ((PrivateCatalogSettings.Builder)((PrivateCatalogSettings.Builder)PrivateCatalogSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = PrivateCatalogClient.create((PrivateCatalogSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void searchCatalogsTest() throws Exception {
        Catalog responsesElement = Catalog.newBuilder().build();
        SearchCatalogsResponse expectedResponse = SearchCatalogsResponse.newBuilder().setNextPageToken("").addAllCatalogs(Arrays.asList(responsesElement)).build();
        mockPrivateCatalog.addResponse((AbstractMessage)expectedResponse);
        SearchCatalogsRequest request = SearchCatalogsRequest.newBuilder().setResource("resource-341064690").setQuery("query107944136").setPageSize(883849137).setPageToken("pageToken873572522").build();
        PrivateCatalogClient.SearchCatalogsPagedResponse pagedListResponse = this.client.searchCatalogs(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCatalogsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPrivateCatalog.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchCatalogsRequest actualRequest = (SearchCatalogsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getQuery(), (Object)actualRequest.getQuery());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchCatalogsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPrivateCatalog.addException((Exception)exception);
        try {
            SearchCatalogsRequest request = SearchCatalogsRequest.newBuilder().setResource("resource-341064690").setQuery("query107944136").setPageSize(883849137).setPageToken("pageToken873572522").build();
            this.client.searchCatalogs(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchProductsTest() throws Exception {
        Product responsesElement = Product.newBuilder().build();
        SearchProductsResponse expectedResponse = SearchProductsResponse.newBuilder().setNextPageToken("").addAllProducts(Arrays.asList(responsesElement)).build();
        mockPrivateCatalog.addResponse((AbstractMessage)expectedResponse);
        SearchProductsRequest request = SearchProductsRequest.newBuilder().setResource("resource-341064690").setQuery("query107944136").setPageSize(883849137).setPageToken("pageToken873572522").build();
        PrivateCatalogClient.SearchProductsPagedResponse pagedListResponse = this.client.searchProducts(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProductsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPrivateCatalog.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchProductsRequest actualRequest = (SearchProductsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getQuery(), (Object)actualRequest.getQuery());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchProductsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPrivateCatalog.addException((Exception)exception);
        try {
            SearchProductsRequest request = SearchProductsRequest.newBuilder().setResource("resource-341064690").setQuery("query107944136").setPageSize(883849137).setPageToken("pageToken873572522").build();
            this.client.searchProducts(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchVersionsTest() throws Exception {
        Version responsesElement = Version.newBuilder().build();
        SearchVersionsResponse expectedResponse = SearchVersionsResponse.newBuilder().setNextPageToken("").addAllVersions(Arrays.asList(responsesElement)).build();
        mockPrivateCatalog.addResponse((AbstractMessage)expectedResponse);
        SearchVersionsRequest request = SearchVersionsRequest.newBuilder().setResource("resource-341064690").setQuery("query107944136").setPageSize(883849137).setPageToken("pageToken873572522").build();
        PrivateCatalogClient.SearchVersionsPagedResponse pagedListResponse = this.client.searchVersions(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getVersionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPrivateCatalog.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchVersionsRequest actualRequest = (SearchVersionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getQuery(), (Object)actualRequest.getQuery());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchVersionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPrivateCatalog.addException((Exception)exception);
        try {
            SearchVersionsRequest request = SearchVersionsRequest.newBuilder().setResource("resource-341064690").setQuery("query107944136").setPageSize(883849137).setPageToken("pageToken873572522").build();
            this.client.searchVersions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

