/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.privatecatalog.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.privatecatalog.v1beta1.Catalog;
import com.google.cloud.privatecatalog.v1beta1.PrivateCatalogClient;
import com.google.cloud.privatecatalog.v1beta1.Product;
import com.google.cloud.privatecatalog.v1beta1.SearchCatalogsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchCatalogsResponse;
import com.google.cloud.privatecatalog.v1beta1.SearchProductsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchProductsResponse;
import com.google.cloud.privatecatalog.v1beta1.SearchVersionsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchVersionsResponse;
import com.google.cloud.privatecatalog.v1beta1.Version;
import com.google.cloud.privatecatalog.v1beta1.stub.GrpcPrivateCatalogStub;
import com.google.cloud.privatecatalog.v1beta1.stub.HttpJsonPrivateCatalogStub;
import com.google.cloud.privatecatalog.v1beta1.stub.PrivateCatalogStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class PrivateCatalogStubSettings
extends StubSettings<PrivateCatalogStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<SearchCatalogsRequest, SearchCatalogsResponse, PrivateCatalogClient.SearchCatalogsPagedResponse> searchCatalogsSettings;
    private final PagedCallSettings<SearchProductsRequest, SearchProductsResponse, PrivateCatalogClient.SearchProductsPagedResponse> searchProductsSettings;
    private final PagedCallSettings<SearchVersionsRequest, SearchVersionsResponse, PrivateCatalogClient.SearchVersionsPagedResponse> searchVersionsSettings;
    private static final PagedListDescriptor<SearchCatalogsRequest, SearchCatalogsResponse, Catalog> SEARCH_CATALOGS_PAGE_STR_DESC = new PagedListDescriptor<SearchCatalogsRequest, SearchCatalogsResponse, Catalog>(){

        public String emptyToken() {
            return "";
        }

        public SearchCatalogsRequest injectToken(SearchCatalogsRequest payload, String token) {
            return SearchCatalogsRequest.newBuilder((SearchCatalogsRequest)payload).setPageToken(token).build();
        }

        public SearchCatalogsRequest injectPageSize(SearchCatalogsRequest payload, int pageSize) {
            return SearchCatalogsRequest.newBuilder((SearchCatalogsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchCatalogsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchCatalogsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Catalog> extractResources(SearchCatalogsResponse payload) {
            return payload.getCatalogsList() == null ? ImmutableList.of() : payload.getCatalogsList();
        }
    };
    private static final PagedListDescriptor<SearchProductsRequest, SearchProductsResponse, Product> SEARCH_PRODUCTS_PAGE_STR_DESC = new PagedListDescriptor<SearchProductsRequest, SearchProductsResponse, Product>(){

        public String emptyToken() {
            return "";
        }

        public SearchProductsRequest injectToken(SearchProductsRequest payload, String token) {
            return SearchProductsRequest.newBuilder((SearchProductsRequest)payload).setPageToken(token).build();
        }

        public SearchProductsRequest injectPageSize(SearchProductsRequest payload, int pageSize) {
            return SearchProductsRequest.newBuilder((SearchProductsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchProductsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchProductsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Product> extractResources(SearchProductsResponse payload) {
            return payload.getProductsList() == null ? ImmutableList.of() : payload.getProductsList();
        }
    };
    private static final PagedListDescriptor<SearchVersionsRequest, SearchVersionsResponse, Version> SEARCH_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<SearchVersionsRequest, SearchVersionsResponse, Version>(){

        public String emptyToken() {
            return "";
        }

        public SearchVersionsRequest injectToken(SearchVersionsRequest payload, String token) {
            return SearchVersionsRequest.newBuilder((SearchVersionsRequest)payload).setPageToken(token).build();
        }

        public SearchVersionsRequest injectPageSize(SearchVersionsRequest payload, int pageSize) {
            return SearchVersionsRequest.newBuilder((SearchVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Version> extractResources(SearchVersionsResponse payload) {
            return payload.getVersionsList() == null ? ImmutableList.of() : payload.getVersionsList();
        }
    };
    private static final PagedListResponseFactory<SearchCatalogsRequest, SearchCatalogsResponse, PrivateCatalogClient.SearchCatalogsPagedResponse> SEARCH_CATALOGS_PAGE_STR_FACT = new PagedListResponseFactory<SearchCatalogsRequest, SearchCatalogsResponse, PrivateCatalogClient.SearchCatalogsPagedResponse>(){

        public ApiFuture<PrivateCatalogClient.SearchCatalogsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchCatalogsRequest, SearchCatalogsResponse> callable, SearchCatalogsRequest request, ApiCallContext context, ApiFuture<SearchCatalogsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_CATALOGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PrivateCatalogClient.SearchCatalogsPagedResponse.createAsync((PageContext<SearchCatalogsRequest, SearchCatalogsResponse, Catalog>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchProductsRequest, SearchProductsResponse, PrivateCatalogClient.SearchProductsPagedResponse> SEARCH_PRODUCTS_PAGE_STR_FACT = new PagedListResponseFactory<SearchProductsRequest, SearchProductsResponse, PrivateCatalogClient.SearchProductsPagedResponse>(){

        public ApiFuture<PrivateCatalogClient.SearchProductsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchProductsRequest, SearchProductsResponse> callable, SearchProductsRequest request, ApiCallContext context, ApiFuture<SearchProductsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_PRODUCTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PrivateCatalogClient.SearchProductsPagedResponse.createAsync((PageContext<SearchProductsRequest, SearchProductsResponse, Product>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchVersionsRequest, SearchVersionsResponse, PrivateCatalogClient.SearchVersionsPagedResponse> SEARCH_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<SearchVersionsRequest, SearchVersionsResponse, PrivateCatalogClient.SearchVersionsPagedResponse>(){

        public ApiFuture<PrivateCatalogClient.SearchVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchVersionsRequest, SearchVersionsResponse> callable, SearchVersionsRequest request, ApiCallContext context, ApiFuture<SearchVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PrivateCatalogClient.SearchVersionsPagedResponse.createAsync((PageContext<SearchVersionsRequest, SearchVersionsResponse, Version>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<SearchCatalogsRequest, SearchCatalogsResponse, PrivateCatalogClient.SearchCatalogsPagedResponse> searchCatalogsSettings() {
        return this.searchCatalogsSettings;
    }

    public PagedCallSettings<SearchProductsRequest, SearchProductsResponse, PrivateCatalogClient.SearchProductsPagedResponse> searchProductsSettings() {
        return this.searchProductsSettings;
    }

    public PagedCallSettings<SearchVersionsRequest, SearchVersionsResponse, PrivateCatalogClient.SearchVersionsPagedResponse> searchVersionsSettings() {
        return this.searchVersionsSettings;
    }

    public PrivateCatalogStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcPrivateCatalogStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPrivateCatalogStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudprivatecatalog.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudprivatecatalog.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PrivateCatalogStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PrivateCatalogStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PrivateCatalogStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return PrivateCatalogStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PrivateCatalogStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.searchCatalogsSettings = settingsBuilder.searchCatalogsSettings().build();
        this.searchProductsSettings = settingsBuilder.searchProductsSettings().build();
        this.searchVersionsSettings = settingsBuilder.searchVersionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PrivateCatalogStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<SearchCatalogsRequest, SearchCatalogsResponse, PrivateCatalogClient.SearchCatalogsPagedResponse> searchCatalogsSettings;
        private final PagedCallSettings.Builder<SearchProductsRequest, SearchProductsResponse, PrivateCatalogClient.SearchProductsPagedResponse> searchProductsSettings;
        private final PagedCallSettings.Builder<SearchVersionsRequest, SearchVersionsResponse, PrivateCatalogClient.SearchVersionsPagedResponse> searchVersionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.searchCatalogsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_CATALOGS_PAGE_STR_FACT);
            this.searchProductsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_PRODUCTS_PAGE_STR_FACT);
            this.searchVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_VERSIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.searchCatalogsSettings, this.searchProductsSettings, this.searchVersionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(PrivateCatalogStubSettings settings) {
            super((StubSettings)settings);
            this.searchCatalogsSettings = settings.searchCatalogsSettings.toBuilder();
            this.searchProductsSettings = settings.searchProductsSettings.toBuilder();
            this.searchVersionsSettings = settings.searchVersionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.searchCatalogsSettings, this.searchProductsSettings, this.searchVersionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PrivateCatalogStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PrivateCatalogStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PrivateCatalogStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(PrivateCatalogStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(PrivateCatalogStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)PrivateCatalogStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)PrivateCatalogStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PrivateCatalogStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(PrivateCatalogStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(PrivateCatalogStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.searchCatalogsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.searchProductsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.searchVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<SearchCatalogsRequest, SearchCatalogsResponse, PrivateCatalogClient.SearchCatalogsPagedResponse> searchCatalogsSettings() {
            return this.searchCatalogsSettings;
        }

        public PagedCallSettings.Builder<SearchProductsRequest, SearchProductsResponse, PrivateCatalogClient.SearchProductsPagedResponse> searchProductsSettings() {
            return this.searchProductsSettings;
        }

        public PagedCallSettings.Builder<SearchVersionsRequest, SearchVersionsResponse, PrivateCatalogClient.SearchVersionsPagedResponse> searchVersionsSettings() {
            return this.searchVersionsSettings;
        }

        public PrivateCatalogStubSettings build() throws IOException {
            return new PrivateCatalogStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

