/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.privatecatalog.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.privatecatalog.v1beta1.Catalog;
import com.google.cloud.privatecatalog.v1beta1.PrivateCatalogSettings;
import com.google.cloud.privatecatalog.v1beta1.Product;
import com.google.cloud.privatecatalog.v1beta1.SearchCatalogsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchCatalogsResponse;
import com.google.cloud.privatecatalog.v1beta1.SearchProductsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchProductsResponse;
import com.google.cloud.privatecatalog.v1beta1.SearchVersionsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchVersionsResponse;
import com.google.cloud.privatecatalog.v1beta1.Version;
import com.google.cloud.privatecatalog.v1beta1.stub.PrivateCatalogStub;
import com.google.cloud.privatecatalog.v1beta1.stub.PrivateCatalogStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PrivateCatalogClient
implements BackgroundResource {
    private final PrivateCatalogSettings settings;
    private final PrivateCatalogStub stub;

    public static final PrivateCatalogClient create() throws IOException {
        return PrivateCatalogClient.create(PrivateCatalogSettings.newBuilder().build());
    }

    public static final PrivateCatalogClient create(PrivateCatalogSettings settings) throws IOException {
        return new PrivateCatalogClient(settings);
    }

    public static final PrivateCatalogClient create(PrivateCatalogStub stub) {
        return new PrivateCatalogClient(stub);
    }

    protected PrivateCatalogClient(PrivateCatalogSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PrivateCatalogStubSettings)settings.getStubSettings()).createStub();
    }

    protected PrivateCatalogClient(PrivateCatalogStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PrivateCatalogSettings getSettings() {
        return this.settings;
    }

    public PrivateCatalogStub getStub() {
        return this.stub;
    }

    public final SearchCatalogsPagedResponse searchCatalogs(SearchCatalogsRequest request) {
        return (SearchCatalogsPagedResponse)((Object)this.searchCatalogsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchCatalogsRequest, SearchCatalogsPagedResponse> searchCatalogsPagedCallable() {
        return this.stub.searchCatalogsPagedCallable();
    }

    public final UnaryCallable<SearchCatalogsRequest, SearchCatalogsResponse> searchCatalogsCallable() {
        return this.stub.searchCatalogsCallable();
    }

    public final SearchProductsPagedResponse searchProducts(SearchProductsRequest request) {
        return (SearchProductsPagedResponse)((Object)this.searchProductsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchProductsRequest, SearchProductsPagedResponse> searchProductsPagedCallable() {
        return this.stub.searchProductsPagedCallable();
    }

    public final UnaryCallable<SearchProductsRequest, SearchProductsResponse> searchProductsCallable() {
        return this.stub.searchProductsCallable();
    }

    public final SearchVersionsPagedResponse searchVersions(SearchVersionsRequest request) {
        return (SearchVersionsPagedResponse)((Object)this.searchVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchVersionsRequest, SearchVersionsPagedResponse> searchVersionsPagedCallable() {
        return this.stub.searchVersionsPagedCallable();
    }

    public final UnaryCallable<SearchVersionsRequest, SearchVersionsResponse> searchVersionsCallable() {
        return this.stub.searchVersionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchVersionsRequest, SearchVersionsResponse, Version, SearchVersionsPage, SearchVersionsFixedSizeCollection> {
        private SearchVersionsFixedSizeCollection(List<SearchVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchVersionsFixedSizeCollection createEmptyCollection() {
            return new SearchVersionsFixedSizeCollection(null, 0);
        }

        protected SearchVersionsFixedSizeCollection createCollection(List<SearchVersionsPage> pages, int collectionSize) {
            return new SearchVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchVersionsPage
    extends AbstractPage<SearchVersionsRequest, SearchVersionsResponse, Version, SearchVersionsPage> {
        private SearchVersionsPage(PageContext<SearchVersionsRequest, SearchVersionsResponse, Version> context, SearchVersionsResponse response) {
            super(context, (Object)response);
        }

        private static SearchVersionsPage createEmptyPage() {
            return new SearchVersionsPage(null, null);
        }

        protected SearchVersionsPage createPage(PageContext<SearchVersionsRequest, SearchVersionsResponse, Version> context, SearchVersionsResponse response) {
            return new SearchVersionsPage(context, response);
        }

        public ApiFuture<SearchVersionsPage> createPageAsync(PageContext<SearchVersionsRequest, SearchVersionsResponse, Version> context, ApiFuture<SearchVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchVersionsPagedResponse
    extends AbstractPagedListResponse<SearchVersionsRequest, SearchVersionsResponse, Version, SearchVersionsPage, SearchVersionsFixedSizeCollection> {
        public static ApiFuture<SearchVersionsPagedResponse> createAsync(PageContext<SearchVersionsRequest, SearchVersionsResponse, Version> context, ApiFuture<SearchVersionsResponse> futureResponse) {
            ApiFuture<SearchVersionsPage> futurePage = SearchVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchVersionsPagedResponse((SearchVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchVersionsPagedResponse(SearchVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchProductsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchProductsRequest, SearchProductsResponse, Product, SearchProductsPage, SearchProductsFixedSizeCollection> {
        private SearchProductsFixedSizeCollection(List<SearchProductsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchProductsFixedSizeCollection createEmptyCollection() {
            return new SearchProductsFixedSizeCollection(null, 0);
        }

        protected SearchProductsFixedSizeCollection createCollection(List<SearchProductsPage> pages, int collectionSize) {
            return new SearchProductsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchProductsPage
    extends AbstractPage<SearchProductsRequest, SearchProductsResponse, Product, SearchProductsPage> {
        private SearchProductsPage(PageContext<SearchProductsRequest, SearchProductsResponse, Product> context, SearchProductsResponse response) {
            super(context, (Object)response);
        }

        private static SearchProductsPage createEmptyPage() {
            return new SearchProductsPage(null, null);
        }

        protected SearchProductsPage createPage(PageContext<SearchProductsRequest, SearchProductsResponse, Product> context, SearchProductsResponse response) {
            return new SearchProductsPage(context, response);
        }

        public ApiFuture<SearchProductsPage> createPageAsync(PageContext<SearchProductsRequest, SearchProductsResponse, Product> context, ApiFuture<SearchProductsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchProductsPagedResponse
    extends AbstractPagedListResponse<SearchProductsRequest, SearchProductsResponse, Product, SearchProductsPage, SearchProductsFixedSizeCollection> {
        public static ApiFuture<SearchProductsPagedResponse> createAsync(PageContext<SearchProductsRequest, SearchProductsResponse, Product> context, ApiFuture<SearchProductsResponse> futureResponse) {
            ApiFuture<SearchProductsPage> futurePage = SearchProductsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchProductsPagedResponse((SearchProductsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchProductsPagedResponse(SearchProductsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchProductsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchCatalogsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchCatalogsRequest, SearchCatalogsResponse, Catalog, SearchCatalogsPage, SearchCatalogsFixedSizeCollection> {
        private SearchCatalogsFixedSizeCollection(List<SearchCatalogsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchCatalogsFixedSizeCollection createEmptyCollection() {
            return new SearchCatalogsFixedSizeCollection(null, 0);
        }

        protected SearchCatalogsFixedSizeCollection createCollection(List<SearchCatalogsPage> pages, int collectionSize) {
            return new SearchCatalogsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchCatalogsPage
    extends AbstractPage<SearchCatalogsRequest, SearchCatalogsResponse, Catalog, SearchCatalogsPage> {
        private SearchCatalogsPage(PageContext<SearchCatalogsRequest, SearchCatalogsResponse, Catalog> context, SearchCatalogsResponse response) {
            super(context, (Object)response);
        }

        private static SearchCatalogsPage createEmptyPage() {
            return new SearchCatalogsPage(null, null);
        }

        protected SearchCatalogsPage createPage(PageContext<SearchCatalogsRequest, SearchCatalogsResponse, Catalog> context, SearchCatalogsResponse response) {
            return new SearchCatalogsPage(context, response);
        }

        public ApiFuture<SearchCatalogsPage> createPageAsync(PageContext<SearchCatalogsRequest, SearchCatalogsResponse, Catalog> context, ApiFuture<SearchCatalogsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchCatalogsPagedResponse
    extends AbstractPagedListResponse<SearchCatalogsRequest, SearchCatalogsResponse, Catalog, SearchCatalogsPage, SearchCatalogsFixedSizeCollection> {
        public static ApiFuture<SearchCatalogsPagedResponse> createAsync(PageContext<SearchCatalogsRequest, SearchCatalogsResponse, Catalog> context, ApiFuture<SearchCatalogsResponse> futureResponse) {
            ApiFuture<SearchCatalogsPage> futurePage = SearchCatalogsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchCatalogsPagedResponse((SearchCatalogsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchCatalogsPagedResponse(SearchCatalogsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchCatalogsFixedSizeCollection.createEmptyCollection());
        }
    }
}

