/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.security.publicca.v1beta1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.security.publicca.v1beta1.ExternalAccountKey;
import com.google.cloud.security.publicca.v1beta1.ExternalAccountKeyName;
import com.google.cloud.security.publicca.v1beta1.LocationName;
import com.google.cloud.security.publicca.v1beta1.PublicCertificateAuthorityServiceClient;
import com.google.cloud.security.publicca.v1beta1.PublicCertificateAuthorityServiceSettings;
import com.google.cloud.security.publicca.v1beta1.stub.HttpJsonPublicCertificateAuthorityServiceStub;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PublicCertificateAuthorityServiceClientHttpJsonTest {
    private static MockHttpService mockService;
    private static PublicCertificateAuthorityServiceClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonPublicCertificateAuthorityServiceStub.getMethodDescriptors(), PublicCertificateAuthorityServiceSettings.getDefaultEndpoint());
        PublicCertificateAuthorityServiceSettings settings = ((PublicCertificateAuthorityServiceSettings.Builder)((PublicCertificateAuthorityServiceSettings.Builder)PublicCertificateAuthorityServiceSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)PublicCertificateAuthorityServiceSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = PublicCertificateAuthorityServiceClient.create((PublicCertificateAuthorityServiceSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void createExternalAccountKeyTest() throws Exception {
        ExternalAccountKey expectedResponse = ExternalAccountKey.newBuilder().setName(ExternalAccountKeyName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[EXTERNAL_ACCOUNT_KEY]").toString()).setKeyId("keyId101944282").setB64MacKey(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ExternalAccountKey externalAccountKey = ExternalAccountKey.newBuilder().build();
        ExternalAccountKey actualResponse = client.createExternalAccountKey(parent, externalAccountKey);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createExternalAccountKeyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            ExternalAccountKey externalAccountKey = ExternalAccountKey.newBuilder().build();
            client.createExternalAccountKey(parent, externalAccountKey);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createExternalAccountKeyTest2() throws Exception {
        ExternalAccountKey expectedResponse = ExternalAccountKey.newBuilder().setName(ExternalAccountKeyName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[EXTERNAL_ACCOUNT_KEY]").toString()).setKeyId("keyId101944282").setB64MacKey(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        ExternalAccountKey externalAccountKey = ExternalAccountKey.newBuilder().build();
        ExternalAccountKey actualResponse = client.createExternalAccountKey(parent, externalAccountKey);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createExternalAccountKeyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            ExternalAccountKey externalAccountKey = ExternalAccountKey.newBuilder().build();
            client.createExternalAccountKey(parent, externalAccountKey);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

