/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.security.publicca.v1beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.security.publicca.v1beta1.CreateExternalAccountKeyRequest;
import com.google.cloud.security.publicca.v1beta1.ExternalAccountKey;
import com.google.cloud.security.publicca.v1beta1.ExternalAccountKeyName;
import com.google.cloud.security.publicca.v1beta1.LocationName;
import com.google.cloud.security.publicca.v1beta1.MockPublicCertificateAuthorityService;
import com.google.cloud.security.publicca.v1beta1.PublicCertificateAuthorityServiceClient;
import com.google.cloud.security.publicca.v1beta1.PublicCertificateAuthorityServiceSettings;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PublicCertificateAuthorityServiceClientTest {
    private static MockPublicCertificateAuthorityService mockPublicCertificateAuthorityService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private PublicCertificateAuthorityServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockPublicCertificateAuthorityService = new MockPublicCertificateAuthorityService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockPublicCertificateAuthorityService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        PublicCertificateAuthorityServiceSettings settings = ((PublicCertificateAuthorityServiceSettings.Builder)((PublicCertificateAuthorityServiceSettings.Builder)PublicCertificateAuthorityServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = PublicCertificateAuthorityServiceClient.create((PublicCertificateAuthorityServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createExternalAccountKeyTest() throws Exception {
        ExternalAccountKey expectedResponse = ExternalAccountKey.newBuilder().setName(ExternalAccountKeyName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[EXTERNAL_ACCOUNT_KEY]").toString()).setKeyId("keyId101944282").setB64MacKey(ByteString.EMPTY).build();
        mockPublicCertificateAuthorityService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ExternalAccountKey externalAccountKey = ExternalAccountKey.newBuilder().build();
        ExternalAccountKey actualResponse = this.client.createExternalAccountKey(parent, externalAccountKey);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPublicCertificateAuthorityService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateExternalAccountKeyRequest actualRequest = (CreateExternalAccountKeyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)externalAccountKey, (Object)actualRequest.getExternalAccountKey());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createExternalAccountKeyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublicCertificateAuthorityService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            ExternalAccountKey externalAccountKey = ExternalAccountKey.newBuilder().build();
            this.client.createExternalAccountKey(parent, externalAccountKey);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createExternalAccountKeyTest2() throws Exception {
        ExternalAccountKey expectedResponse = ExternalAccountKey.newBuilder().setName(ExternalAccountKeyName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[EXTERNAL_ACCOUNT_KEY]").toString()).setKeyId("keyId101944282").setB64MacKey(ByteString.EMPTY).build();
        mockPublicCertificateAuthorityService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ExternalAccountKey externalAccountKey = ExternalAccountKey.newBuilder().build();
        ExternalAccountKey actualResponse = this.client.createExternalAccountKey(parent, externalAccountKey);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPublicCertificateAuthorityService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateExternalAccountKeyRequest actualRequest = (CreateExternalAccountKeyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)externalAccountKey, (Object)actualRequest.getExternalAccountKey());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createExternalAccountKeyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublicCertificateAuthorityService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ExternalAccountKey externalAccountKey = ExternalAccountKey.newBuilder().build();
            this.client.createExternalAccountKey(parent, externalAccountKey);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

