/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.stub.HttpJsonSubscriberCallableFactory;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.CreateSnapshotRequest;
import com.google.pubsub.v1.DeleteSnapshotRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.GetSnapshotRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ListSnapshotsRequest;
import com.google.pubsub.v1.ListSnapshotsResponse;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.SeekRequest;
import com.google.pubsub.v1.SeekResponse;
import com.google.pubsub.v1.Snapshot;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.UpdateSnapshotRequest;
import com.google.pubsub.v1.UpdateSubscriptionRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonSubscriberStub
extends SubscriberStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<Subscription, Subscription> createSubscriptionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Subscriber/CreateSubscription").setHttpMethod("PUT").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/subscriptions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Subscription.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetSubscriptionRequest, Subscription> getSubscriptionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Subscriber/GetSubscription").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{subscription=projects/*/subscriptions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "subscription", (Object)request.getSubscription());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Subscription.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateSubscriptionRequest, Subscription> updateSubscriptionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Subscriber/UpdateSubscription").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{subscription.name=projects/*/subscriptions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "subscription.name", (Object)request.getSubscription().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Subscription.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Subscriber/ListSubscriptions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{project=projects/*}/subscriptions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListSubscriptionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteSubscriptionRequest, Empty> deleteSubscriptionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Subscriber/DeleteSubscription").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{subscription=projects/*/subscriptions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "subscription", (Object)request.getSubscription());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Subscriber/ModifyAckDeadline").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{subscription=projects/*/subscriptions/*}:modifyAckDeadline", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "subscription", (Object)request.getSubscription());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearSubscription().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<AcknowledgeRequest, Empty> acknowledgeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Subscriber/Acknowledge").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{subscription=projects/*/subscriptions/*}:acknowledge", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "subscription", (Object)request.getSubscription());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearSubscription().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<PullRequest, PullResponse> pullMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Subscriber/Pull").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{subscription=projects/*/subscriptions/*}:pull", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "subscription", (Object)request.getSubscription());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearSubscription().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)PullResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ModifyPushConfigRequest, Empty> modifyPushConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Subscriber/ModifyPushConfig").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{subscription=projects/*/subscriptions/*}:modifyPushConfig", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "subscription", (Object)request.getSubscription());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearSubscription().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetSnapshotRequest, Snapshot> getSnapshotMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Subscriber/GetSnapshot").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{snapshot=projects/*/snapshots/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "snapshot", (Object)request.getSnapshot());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Snapshot.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Subscriber/ListSnapshots").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{project=projects/*}/snapshots", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListSnapshotsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateSnapshotRequest, Snapshot> createSnapshotMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Subscriber/CreateSnapshot").setHttpMethod("PUT").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/snapshots/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Snapshot.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateSnapshotRequest, Snapshot> updateSnapshotMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Subscriber/UpdateSnapshot").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{snapshot.name=projects/*/snapshots/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "snapshot.name", (Object)request.getSnapshot().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Snapshot.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteSnapshotRequest, Empty> deleteSnapshotMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Subscriber/DeleteSnapshot").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{snapshot=projects/*/snapshots/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "snapshot", (Object)request.getSnapshot());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SeekRequest, SeekResponse> seekMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.Subscriber/Seek").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{subscription=projects/*/subscriptions/*}:seek", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "subscription", (Object)request.getSubscription());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearSubscription().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SeekResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/topics/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/subscriptions/*}:setIamPolicy", "/v1/{resource=projects/*/snapshots/*}:setIamPolicy", "/v1/{resource=projects/*/schemas/*}:setIamPolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/topics/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/subscriptions/*}:getIamPolicy", "/v1/{resource=projects/*/snapshots/*}:getIamPolicy", "/v1/{resource=projects/*/schemas/*}:getIamPolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/subscriptions/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/topics/*}:testIamPermissions", "/v1/{resource=projects/*/snapshots/*}:testIamPermissions", "/v1/{resource=projects/*/schemas/*}:testIamPermissions"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<Subscription, Subscription> createSubscriptionCallable;
    private final UnaryCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable;
    private final UnaryCallable<UpdateSubscriptionRequest, Subscription> updateSubscriptionCallable;
    private final UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable;
    private final UnaryCallable<ListSubscriptionsRequest, SubscriptionAdminClient.ListSubscriptionsPagedResponse> listSubscriptionsPagedCallable;
    private final UnaryCallable<DeleteSubscriptionRequest, Empty> deleteSubscriptionCallable;
    private final UnaryCallable<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineCallable;
    private final UnaryCallable<AcknowledgeRequest, Empty> acknowledgeCallable;
    private final UnaryCallable<PullRequest, PullResponse> pullCallable;
    private final UnaryCallable<ModifyPushConfigRequest, Empty> modifyPushConfigCallable;
    private final UnaryCallable<GetSnapshotRequest, Snapshot> getSnapshotCallable;
    private final UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsCallable;
    private final UnaryCallable<ListSnapshotsRequest, SubscriptionAdminClient.ListSnapshotsPagedResponse> listSnapshotsPagedCallable;
    private final UnaryCallable<CreateSnapshotRequest, Snapshot> createSnapshotCallable;
    private final UnaryCallable<UpdateSnapshotRequest, Snapshot> updateSnapshotCallable;
    private final UnaryCallable<DeleteSnapshotRequest, Empty> deleteSnapshotCallable;
    private final UnaryCallable<SeekRequest, SeekResponse> seekCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonSubscriberStub create(SubscriberStubSettings settings) throws IOException {
        return new HttpJsonSubscriberStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonSubscriberStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonSubscriberStub(SubscriberStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonSubscriberStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonSubscriberStub(SubscriberStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonSubscriberStub(SubscriberStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonSubscriberCallableFactory());
    }

    protected HttpJsonSubscriberStub(SubscriberStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createSubscriptionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createSubscriptionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getSubscriptionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSubscriptionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateSubscriptionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateSubscriptionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listSubscriptionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listSubscriptionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteSubscriptionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteSubscriptionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings modifyAckDeadlineTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(modifyAckDeadlineMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings acknowledgeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(acknowledgeMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings pullTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(pullMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings modifyPushConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(modifyPushConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getSnapshotTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSnapshotMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listSnapshotsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listSnapshotsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createSnapshotTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createSnapshotMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateSnapshotTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateSnapshotMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteSnapshotTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteSnapshotMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings seekTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(seekMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createSubscriptionCallable = callableFactory.createUnaryCallable(createSubscriptionTransportSettings, settings.createSubscriptionSettings(), clientContext);
        this.getSubscriptionCallable = callableFactory.createUnaryCallable(getSubscriptionTransportSettings, settings.getSubscriptionSettings(), clientContext);
        this.updateSubscriptionCallable = callableFactory.createUnaryCallable(updateSubscriptionTransportSettings, settings.updateSubscriptionSettings(), clientContext);
        this.listSubscriptionsCallable = callableFactory.createUnaryCallable(listSubscriptionsTransportSettings, settings.listSubscriptionsSettings(), clientContext);
        this.listSubscriptionsPagedCallable = callableFactory.createPagedCallable(listSubscriptionsTransportSettings, settings.listSubscriptionsSettings(), clientContext);
        this.deleteSubscriptionCallable = callableFactory.createUnaryCallable(deleteSubscriptionTransportSettings, settings.deleteSubscriptionSettings(), clientContext);
        this.modifyAckDeadlineCallable = callableFactory.createUnaryCallable(modifyAckDeadlineTransportSettings, settings.modifyAckDeadlineSettings(), clientContext);
        this.acknowledgeCallable = callableFactory.createUnaryCallable(acknowledgeTransportSettings, settings.acknowledgeSettings(), clientContext);
        this.pullCallable = callableFactory.createUnaryCallable(pullTransportSettings, settings.pullSettings(), clientContext);
        this.modifyPushConfigCallable = callableFactory.createUnaryCallable(modifyPushConfigTransportSettings, settings.modifyPushConfigSettings(), clientContext);
        this.getSnapshotCallable = callableFactory.createUnaryCallable(getSnapshotTransportSettings, settings.getSnapshotSettings(), clientContext);
        this.listSnapshotsCallable = callableFactory.createUnaryCallable(listSnapshotsTransportSettings, settings.listSnapshotsSettings(), clientContext);
        this.listSnapshotsPagedCallable = callableFactory.createPagedCallable(listSnapshotsTransportSettings, settings.listSnapshotsSettings(), clientContext);
        this.createSnapshotCallable = callableFactory.createUnaryCallable(createSnapshotTransportSettings, settings.createSnapshotSettings(), clientContext);
        this.updateSnapshotCallable = callableFactory.createUnaryCallable(updateSnapshotTransportSettings, settings.updateSnapshotSettings(), clientContext);
        this.deleteSnapshotCallable = callableFactory.createUnaryCallable(deleteSnapshotTransportSettings, settings.deleteSnapshotSettings(), clientContext);
        this.seekCallable = callableFactory.createUnaryCallable(seekTransportSettings, settings.seekSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createSubscriptionMethodDescriptor);
        methodDescriptors.add(getSubscriptionMethodDescriptor);
        methodDescriptors.add(updateSubscriptionMethodDescriptor);
        methodDescriptors.add(listSubscriptionsMethodDescriptor);
        methodDescriptors.add(deleteSubscriptionMethodDescriptor);
        methodDescriptors.add(modifyAckDeadlineMethodDescriptor);
        methodDescriptors.add(acknowledgeMethodDescriptor);
        methodDescriptors.add(pullMethodDescriptor);
        methodDescriptors.add(modifyPushConfigMethodDescriptor);
        methodDescriptors.add(getSnapshotMethodDescriptor);
        methodDescriptors.add(listSnapshotsMethodDescriptor);
        methodDescriptors.add(createSnapshotMethodDescriptor);
        methodDescriptors.add(updateSnapshotMethodDescriptor);
        methodDescriptors.add(deleteSnapshotMethodDescriptor);
        methodDescriptors.add(seekMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<Subscription, Subscription> createSubscriptionCallable() {
        return this.createSubscriptionCallable;
    }

    @Override
    public UnaryCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable() {
        return this.getSubscriptionCallable;
    }

    @Override
    public UnaryCallable<UpdateSubscriptionRequest, Subscription> updateSubscriptionCallable() {
        return this.updateSubscriptionCallable;
    }

    @Override
    public UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable() {
        return this.listSubscriptionsCallable;
    }

    @Override
    public UnaryCallable<ListSubscriptionsRequest, SubscriptionAdminClient.ListSubscriptionsPagedResponse> listSubscriptionsPagedCallable() {
        return this.listSubscriptionsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteSubscriptionRequest, Empty> deleteSubscriptionCallable() {
        return this.deleteSubscriptionCallable;
    }

    @Override
    public UnaryCallable<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineCallable() {
        return this.modifyAckDeadlineCallable;
    }

    @Override
    public UnaryCallable<AcknowledgeRequest, Empty> acknowledgeCallable() {
        return this.acknowledgeCallable;
    }

    @Override
    public UnaryCallable<PullRequest, PullResponse> pullCallable() {
        return this.pullCallable;
    }

    @Override
    public UnaryCallable<ModifyPushConfigRequest, Empty> modifyPushConfigCallable() {
        return this.modifyPushConfigCallable;
    }

    @Override
    public UnaryCallable<GetSnapshotRequest, Snapshot> getSnapshotCallable() {
        return this.getSnapshotCallable;
    }

    @Override
    public UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsCallable() {
        return this.listSnapshotsCallable;
    }

    @Override
    public UnaryCallable<ListSnapshotsRequest, SubscriptionAdminClient.ListSnapshotsPagedResponse> listSnapshotsPagedCallable() {
        return this.listSnapshotsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateSnapshotRequest, Snapshot> createSnapshotCallable() {
        return this.createSnapshotCallable;
    }

    @Override
    public UnaryCallable<UpdateSnapshotRequest, Snapshot> updateSnapshotCallable() {
        return this.updateSnapshotCallable;
    }

    @Override
    public UnaryCallable<DeleteSnapshotRequest, Empty> deleteSnapshotCallable() {
        return this.deleteSnapshotCallable;
    }

    @Override
    public UnaryCallable<SeekRequest, SeekResponse> seekCallable() {
        return this.seekCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

