/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.common.base.Preconditions;
import com.google.pubsub.v1.ProjectName;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Test;

public class TopicAdminSmokeTest {
    private static final String PROJECT_ENV_NAME = "GOOGLE_CLOUD_PROJECT";
    private static final String LEGACY_PROJECT_ENV_NAME = "GCLOUD_PROJECT";

    @Test
    public void run() {
        TopicAdminSmokeTest.main(null);
    }

    public static void main(String[] args) {
        Logger.getLogger("").setLevel(Level.WARNING);
        try {
            TopicAdminSmokeTest.executeNoCatch(TopicAdminSmokeTest.getProjectId());
            System.out.println("OK");
        }
        catch (Exception e) {
            System.err.println("Failed with exception:");
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public static void executeNoCatch(String projectId) throws Exception {
        try (TopicAdminClient client = TopicAdminClient.create();){
            ProjectName project = ProjectName.of((String)projectId);
            TopicAdminClient.ListTopicsPagedResponse listTopicsPagedResponse = client.listTopics(project);
        }
    }

    private static String getProjectId() {
        String projectId = System.getProperty(PROJECT_ENV_NAME, System.getenv(PROJECT_ENV_NAME));
        if (projectId == null) {
            projectId = System.getProperty(LEGACY_PROJECT_ENV_NAME, System.getenv(LEGACY_PROJECT_ENV_NAME));
        }
        Preconditions.checkArgument((projectId != null ? 1 : 0) != 0, (Object)"A project ID is required.");
        return projectId;
    }
}

