/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.client.util.Preconditions;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.StreamingPullRequest;
import com.google.pubsub.v1.StreamingPullResponse;
import com.google.pubsub.v1.SubscriberGrpc;
import com.google.pubsub.v1.Subscription;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class FakeSubscriberServiceImpl
extends SubscriberGrpc.SubscriberImplBase {
    private final AtomicBoolean subscriptionInitialized = new AtomicBoolean(false);
    private String subscription = "";
    private final AtomicInteger messageAckDeadline = new AtomicInteger(Math.toIntExact(Subscriber.STREAM_ACK_DEADLINE_DEFAULT.getSeconds()));
    private final AtomicInteger getSubscriptionCalled = new AtomicInteger();
    private StreamingPullRequest lastSeenRequest;
    private final List<Stream> openedStreams = new ArrayList<Stream>();
    private final List<Stream> closedStreams = new ArrayList<Stream>();
    private final List<String> acks = new ArrayList<String>();
    private final List<ModifyAckDeadline> modAckDeadlines = new ArrayList<ModifyAckDeadline>();
    private final List<PullRequest> receivedPullRequest = new ArrayList<PullRequest>();
    private final BlockingQueue<PullResponse> pullResponses = new LinkedBlockingDeque<PullResponse>();
    private int currentStream;

    FakeSubscriberServiceImpl() {
    }

    public StreamObserver<StreamingPullRequest> streamingPull(StreamObserver<StreamingPullResponse> responseObserver) {
        Stream stream = new Stream();
        stream.requestObserver = new StreamingPullRequestObserver(stream, responseObserver);
        stream.responseObserver = responseObserver;
        return stream.requestObserver;
    }

    public void getSubscription(GetSubscriptionRequest request, StreamObserver<Subscription> responseObserver) {
        this.getSubscriptionCalled.incrementAndGet();
        responseObserver.onNext((Object)Subscription.newBuilder().setName(request.getSubscription()).setAckDeadlineSeconds(this.messageAckDeadline.get()).setTopic("fake-topic").build());
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pull(PullRequest request, StreamObserver<PullResponse> responseObserver) {
        List<PullRequest> list = this.receivedPullRequest;
        synchronized (list) {
            this.receivedPullRequest.add(request);
        }
        try {
            responseObserver.onNext((Object)this.pullResponses.take());
            responseObserver.onCompleted();
        }
        catch (InterruptedException e) {
            responseObserver.onError((Throwable)e);
        }
    }

    public void acknowledge(AcknowledgeRequest request, StreamObserver<Empty> responseObserver) {
        this.addReceivedAcks((Collection<String>)request.getAckIdsList());
        responseObserver.onNext((Object)Empty.getDefaultInstance());
        responseObserver.onCompleted();
    }

    public void modifyAckDeadline(ModifyAckDeadlineRequest request, StreamObserver<Empty> responseObserver) {
        for (String ackId : request.getAckIdsList()) {
            this.addReceivedModifyAckDeadline(new ModifyAckDeadline(ackId, request.getAckDeadlineSeconds()));
        }
        responseObserver.onNext((Object)Empty.getDefaultInstance());
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendError(Throwable error) throws InterruptedException {
        this.waitForRegistedSubscription();
        List<Stream> list = this.openedStreams;
        synchronized (list) {
            this.waitForOpenedStreams(1);
            Stream stream = this.openedStreams.get(this.getAndAdvanceCurrentStream());
            stream.responseObserver.onError(error);
            this.closeStream(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String waitForRegistedSubscription() throws InterruptedException {
        AtomicBoolean atomicBoolean = this.subscriptionInitialized;
        synchronized (atomicBoolean) {
            while (!this.subscriptionInitialized.get()) {
                this.subscriptionInitialized.wait();
            }
        }
        return this.subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForClosedStreams(int expectedCount) throws InterruptedException {
        List<Stream> list = this.closedStreams;
        synchronized (list) {
            FakeSubscriberServiceImpl.waitAtLeast(this.closedStreams, expectedCount);
            return this.closedStreams.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForOpenedStreams(int expectedCount) throws InterruptedException {
        List<Stream> list = this.openedStreams;
        synchronized (list) {
            FakeSubscriberServiceImpl.waitAtLeast(this.openedStreams, expectedCount);
            return this.openedStreams.size();
        }
    }

    private static void waitAtLeast(Collection<?> collection, int target) throws InterruptedException {
        long untilMillis = System.currentTimeMillis() + 20000L;
        while (collection.size() < target) {
            long now = System.currentTimeMillis();
            if (now >= untilMillis) {
                throw new IllegalStateException("timed out, last state: " + collection);
            }
            collection.wait(untilMillis - now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamingPullRequest getLastSeenRequest() {
        StreamingPullRequest streamingPullRequest = this.lastSeenRequest;
        synchronized (streamingPullRequest) {
            return this.lastSeenRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastSeenRequest(StreamingPullRequest lastSeenRequest) {
        StreamingPullRequest streamingPullRequest = lastSeenRequest;
        synchronized (streamingPullRequest) {
            this.lastSeenRequest = lastSeenRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOpenedStream(Stream stream) {
        List<Stream> list = this.openedStreams;
        synchronized (list) {
            this.openedStreams.add(stream);
            this.openedStreams.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStream(Stream stream) {
        List<Stream> list = this.openedStreams;
        synchronized (list) {
            this.openedStreams.remove(stream);
            this.closedStreams.add(stream);
        }
        list = this.closedStreams;
        synchronized (list) {
            this.closedStreams.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAndAdvanceCurrentStream() {
        int current = this.currentStream;
        List<Stream> list = this.openedStreams;
        synchronized (list) {
            this.currentStream = (this.currentStream + 1) % this.openedStreams.size();
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReceivedAcks(Collection<String> newAckIds) {
        List<String> list = this.acks;
        synchronized (list) {
            this.acks.addAll(newAckIds);
            this.acks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReceivedModifyAckDeadline(ModifyAckDeadline newAckDeadline) {
        List<ModifyAckDeadline> list = this.modAckDeadlines;
        synchronized (list) {
            this.modAckDeadlines.add(newAckDeadline);
            this.modAckDeadlines.notifyAll();
        }
    }

    private class StreamingPullRequestObserver
    implements StreamObserver<StreamingPullRequest> {
        private final Stream stream;
        private final StreamObserver<StreamingPullResponse> responseObserver;

        StreamingPullRequestObserver(Stream stream, StreamObserver<StreamingPullResponse> responseObserver) {
            this.stream = stream;
            this.responseObserver = responseObserver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(StreamingPullRequest request) {
            Stream stream = this.stream;
            synchronized (stream) {
                Serializable serializable;
                if (!request.getSubscription().isEmpty()) {
                    if (!FakeSubscriberServiceImpl.this.subscription.isEmpty() && !FakeSubscriberServiceImpl.this.subscription.equals(request.getSubscription())) {
                        this.responseObserver.onError((Throwable)new StatusException(Status.fromCode((Status.Code)Status.Code.ABORTED).withDescription("Can only set one subscription.")));
                        return;
                    }
                    serializable = FakeSubscriberServiceImpl.this.subscriptionInitialized;
                    synchronized (serializable) {
                        if (FakeSubscriberServiceImpl.this.subscription.isEmpty()) {
                            if (request.getStreamAckDeadlineSeconds() == 0) {
                                this.responseObserver.onError((Throwable)new StatusException(Status.fromCode((Status.Code)Status.Code.INVALID_ARGUMENT).withDescription("A stream must be initialized with a ack deadline.")));
                            }
                            FakeSubscriberServiceImpl.this.subscription = request.getSubscription();
                            FakeSubscriberServiceImpl.this.subscriptionInitialized.set(true);
                            FakeSubscriberServiceImpl.this.subscriptionInitialized.notifyAll();
                        }
                    }
                    FakeSubscriberServiceImpl.this.setLastSeenRequest(request);
                    FakeSubscriberServiceImpl.this.addOpenedStream(this.stream);
                    this.stream.notifyAll();
                }
                if (request.getStreamAckDeadlineSeconds() > 0) {
                    serializable = FakeSubscriberServiceImpl.this.messageAckDeadline;
                    synchronized (serializable) {
                        FakeSubscriberServiceImpl.this.messageAckDeadline.set(request.getStreamAckDeadlineSeconds());
                        FakeSubscriberServiceImpl.this.messageAckDeadline.notifyAll();
                    }
                }
                if (FakeSubscriberServiceImpl.this.subscription.isEmpty()) {
                    FakeSubscriberServiceImpl.this.closeStream(this.stream);
                    this.responseObserver.onError((Throwable)new StatusException(Status.fromCode((Status.Code)Status.Code.ABORTED).withDescription("The stream has not been properly initialized with a subscription.")));
                    return;
                }
                if (request.getAckIdsCount() > 0) {
                    FakeSubscriberServiceImpl.this.addReceivedAcks((Collection)request.getAckIdsList());
                }
                if (request.getModifyDeadlineAckIdsCount() > 0) {
                    if (request.getModifyDeadlineAckIdsCount() != request.getModifyDeadlineSecondsCount()) {
                        FakeSubscriberServiceImpl.this.closeStream(this.stream);
                        this.responseObserver.onError((Throwable)new StatusException(Status.fromCode((Status.Code)Status.Code.ABORTED).withDescription("Invalid modify ack deadline request.")));
                        return;
                    }
                    Iterator ackIds = request.getModifyDeadlineAckIdsList().iterator();
                    Iterator seconds = request.getModifyDeadlineSecondsList().iterator();
                    while (ackIds.hasNext() && seconds.hasNext()) {
                        FakeSubscriberServiceImpl.this.addReceivedModifyAckDeadline(new ModifyAckDeadline((String)ackIds.next(), ((Integer)seconds.next()).intValue()));
                    }
                }
            }
        }

        public void onError(Throwable error) {
            FakeSubscriberServiceImpl.this.closeStream(this.stream);
        }

        public void onCompleted() {
            FakeSubscriberServiceImpl.this.closeStream(this.stream);
            this.stream.responseObserver.onCompleted();
        }
    }

    private static class Stream {
        private StreamObserver<StreamingPullRequest> requestObserver;
        private StreamObserver<StreamingPullResponse> responseObserver;

        private Stream() {
        }
    }

    public static final class ModifyAckDeadline {
        private final String ackId;
        private final long seconds;

        public ModifyAckDeadline(String ackId, long seconds) {
            Preconditions.checkNotNull((Object)ackId);
            this.ackId = ackId;
            this.seconds = seconds;
        }

        public long getSeconds() {
            return this.seconds;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ModifyAckDeadline)) {
                return false;
            }
            ModifyAckDeadline other = (ModifyAckDeadline)obj;
            return other.ackId.equals(this.ackId) && other.seconds == this.seconds;
        }

        public int hashCode() {
            return this.ackId.hashCode();
        }

        public String toString() {
            return "Ack ID: " + this.ackId + ", deadline seconds: " + this.seconds;
        }
    }

    public static enum CloseSide {
        SERVER,
        CLIENT;

    }
}

