/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiClock;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.Distribution;
import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.AckReplyConsumerWithResponse;
import com.google.cloud.pubsub.v1.AckRequestData;
import com.google.cloud.pubsub.v1.CustomArgumentMatchers;
import com.google.cloud.pubsub.v1.FakeClock;
import com.google.cloud.pubsub.v1.FakeScheduledExecutorService;
import com.google.cloud.pubsub.v1.MessageDispatcher;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.MessageReceiverWithAckResponse;
import com.google.cloud.pubsub.v1.ModackRequestData;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.ReceivedMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.threeten.bp.Duration;

public class MessageDispatcherTest {
    private static final ByteString MESSAGE_DATA = ByteString.copyFromUtf8((String)"message-data");
    private static final int DELIVERY_INFO_COUNT = 3;
    private static final String ACK_ID = "ACK-ID";
    private static final ReceivedMessage TEST_MESSAGE = ReceivedMessage.newBuilder().setAckId("ACK-ID").setMessage(PubsubMessage.newBuilder().setData(MESSAGE_DATA).build()).setDeliveryAttempt(3).build();
    private static final int MAX_SECONDS_PER_ACK_EXTENSION = 60;
    private static final int MIN_ACK_DEADLINE_SECONDS = 10;
    private static final Duration MAX_ACK_EXTENSION_PERIOD = Duration.ofMinutes((long)60L);
    private static final Duration ACK_EXPIRATION_PADDING_DEFAULT = Subscriber.ACK_EXPIRATION_PADDING_DEFAULT;
    private Distribution mockAckLatencyDistribution;
    private MessageDispatcher.AckProcessor mockAckProcessor;
    private FakeClock clock;
    private boolean messageContainsDeliveryAttempt;
    private FakeScheduledExecutorService systemExecutor;
    private static MessageReceiver messageReceiver;
    private static MessageReceiverWithAckResponse messageReceiverWithAckResponse;
    private LinkedBlockingQueue<AckReplyConsumer> consumers;
    private LinkedBlockingQueue<AckReplyConsumerWithResponse> consumersWithResponse;

    @Before
    public void setUp() {
        this.systemExecutor = new FakeScheduledExecutorService();
        this.clock = new FakeClock();
        this.mockAckLatencyDistribution = (Distribution)Mockito.mock(Distribution.class);
        this.mockAckProcessor = (MessageDispatcher.AckProcessor)Mockito.mock(MessageDispatcher.AckProcessor.class);
        this.messageContainsDeliveryAttempt = true;
        this.consumers = new LinkedBlockingQueue();
        this.consumersWithResponse = new LinkedBlockingQueue();
        messageReceiver = new MessageReceiver(){

            public void receiveMessage(PubsubMessage message, AckReplyConsumer ackReplyConsumer) {
                Truth.assertThat((Iterable)message.getData()).isEqualTo((Object)MESSAGE_DATA);
                if (MessageDispatcherTest.this.messageContainsDeliveryAttempt) {
                    Assert.assertTrue((boolean)message.containsAttributes("googclient_deliveryattempt"));
                    Truth.assertThat((String)message.getAttributesOrThrow("googclient_deliveryattempt")).isEqualTo((Object)Integer.toString(3));
                } else {
                    Assert.assertFalse((boolean)message.containsAttributes("googclient_deliveryattempt"));
                }
                MessageDispatcherTest.this.consumers.add(ackReplyConsumer);
            }
        };
        messageReceiverWithAckResponse = new MessageReceiverWithAckResponse(){

            public void receiveMessage(PubsubMessage message, AckReplyConsumerWithResponse ackReplyConsumerWithResponse) {
                Truth.assertThat((Iterable)message.getData()).isEqualTo((Object)MESSAGE_DATA);
                if (MessageDispatcherTest.this.messageContainsDeliveryAttempt) {
                    Assert.assertTrue((boolean)message.containsAttributes("googclient_deliveryattempt"));
                    Truth.assertThat((String)message.getAttributesOrThrow("googclient_deliveryattempt")).isEqualTo((Object)Integer.toString(3));
                } else {
                    Assert.assertFalse((boolean)message.containsAttributes("googclient_deliveryattempt"));
                }
                MessageDispatcherTest.this.consumersWithResponse.add(ackReplyConsumerWithResponse);
            }
        };
    }

    @Test
    public void testSetupAndTeardown() {
        MessageDispatcher messageDispatcher = this.getMessageDispatcher();
        messageDispatcher.start();
        messageDispatcher.stop();
    }

    @Test
    public void testReceiptMessageReceiver() {
        MessageReceiver mockMessageReceiver = (MessageReceiver)Mockito.mock(MessageReceiver.class);
        MessageDispatcher messageDispatcher = this.getMessageDispatcher(mockMessageReceiver);
        messageDispatcher.processReceivedMessages(Collections.singletonList(TEST_MESSAGE));
        messageDispatcher.processOutstandingOperations();
        ArrayList<ModackRequestData> modackRequestDataList = new ArrayList<ModackRequestData>();
        modackRequestDataList.add(new ModackRequestData(10, new AckRequestData[]{AckRequestData.newBuilder((String)TEST_MESSAGE.getAckId()).build()}));
        ((MessageDispatcher.AckProcessor)Mockito.verify((Object)this.mockAckProcessor, (VerificationMode)Mockito.times((int)1))).sendModackOperations((List)Mockito.argThat((ArgumentMatcher)new CustomArgumentMatchers.ModackRequestDataListMatcher(modackRequestDataList)));
        ((MessageReceiver)Mockito.verify((Object)mockMessageReceiver, (VerificationMode)Mockito.never())).receiveMessage((PubsubMessage)Mockito.eq((Object)TEST_MESSAGE.getMessage()), (AckReplyConsumer)Mockito.any(AckReplyConsumer.class));
    }

    @Test
    public void testReceiptMessageReceiverWithAckResponse() {
        MessageReceiverWithAckResponse mockMessageReceiverWithAckResponse = (MessageReceiverWithAckResponse)Mockito.mock(MessageReceiverWithAckResponse.class);
        MessageDispatcher messageDispatcher = this.getMessageDispatcher(mockMessageReceiverWithAckResponse);
        messageDispatcher.processReceivedMessages(Collections.singletonList(TEST_MESSAGE));
        messageDispatcher.processOutstandingOperations();
        ArrayList<ModackRequestData> modackRequestDataList = new ArrayList<ModackRequestData>();
        modackRequestDataList.add(new ModackRequestData(10, new AckRequestData[]{AckRequestData.newBuilder((String)TEST_MESSAGE.getAckId()).build()}));
        ((MessageDispatcher.AckProcessor)Mockito.verify((Object)this.mockAckProcessor, (VerificationMode)Mockito.times((int)1))).sendModackOperations((List)Mockito.argThat((ArgumentMatcher)new CustomArgumentMatchers.ModackRequestDataListMatcher(modackRequestDataList)));
        ((MessageReceiverWithAckResponse)Mockito.verify((Object)mockMessageReceiverWithAckResponse, (VerificationMode)Mockito.never())).receiveMessage((PubsubMessage)Mockito.eq((Object)TEST_MESSAGE.getMessage()), (AckReplyConsumerWithResponse)Mockito.any(AckReplyConsumerWithResponse.class));
    }

    @Test
    public void testConsumerAckMessageReceiver() {
        MessageDispatcher messageDispatcher = this.getMessageDispatcher(messageReceiver);
        messageDispatcher.processReceivedMessages(Collections.singletonList(TEST_MESSAGE));
        try {
            this.consumers.take().ack();
        }
        catch (Throwable t) {
            throw new AssertionError();
        }
        messageDispatcher.processOutstandingOperations();
        ArrayList<AckRequestData> ackRequestDataList = new ArrayList<AckRequestData>();
        AckRequestData ackRequestData = AckRequestData.newBuilder((String)TEST_MESSAGE.getAckId()).build();
        ackRequestDataList.add(ackRequestData);
        ArrayList<ModackRequestData> modackRequestDataList = new ArrayList<ModackRequestData>();
        modackRequestDataList.add(new ModackRequestData(10, new AckRequestData[]{ackRequestData}));
        ((MessageDispatcher.AckProcessor)Mockito.verify((Object)this.mockAckProcessor, (VerificationMode)Mockito.times((int)1))).sendModackOperations((List)Mockito.argThat((ArgumentMatcher)new CustomArgumentMatchers.ModackRequestDataListMatcher(modackRequestDataList)));
        ((MessageDispatcher.AckProcessor)Mockito.verify((Object)this.mockAckProcessor, (VerificationMode)Mockito.times((int)1))).sendAckOperations((List)Mockito.argThat((ArgumentMatcher)new CustomArgumentMatchers.AckRequestDataListMatcher(ackRequestDataList)));
    }

    @Test
    public void testConsumerAckMessageReceiverWithAckResponse() {
        MessageDispatcher messageDispatcher = this.getMessageDispatcher(messageReceiverWithAckResponse);
        messageDispatcher.processReceivedMessages(Collections.singletonList(TEST_MESSAGE));
        try {
            this.consumersWithResponse.take().ack();
        }
        catch (Throwable t) {
            throw new AssertionError();
        }
        messageDispatcher.processOutstandingOperations();
        ArrayList<AckRequestData> ackRequestDataList = new ArrayList<AckRequestData>();
        AckRequestData ackRequestData = AckRequestData.newBuilder((String)TEST_MESSAGE.getAckId()).build();
        ackRequestDataList.add(ackRequestData);
        ArrayList<ModackRequestData> modackRequestDataList = new ArrayList<ModackRequestData>();
        modackRequestDataList.add(new ModackRequestData(10, new AckRequestData[]{ackRequestData}));
        ((MessageDispatcher.AckProcessor)Mockito.verify((Object)this.mockAckProcessor, (VerificationMode)Mockito.times((int)1))).sendModackOperations((List)Mockito.argThat((ArgumentMatcher)new CustomArgumentMatchers.ModackRequestDataListMatcher(modackRequestDataList)));
        ((MessageDispatcher.AckProcessor)Mockito.verify((Object)this.mockAckProcessor, (VerificationMode)Mockito.times((int)1))).sendAckOperations((List)Mockito.argThat((ArgumentMatcher)new CustomArgumentMatchers.AckRequestDataListMatcher(ackRequestDataList)));
    }

    @Test
    public void testConsumerNackMessageReceiver() {
        MessageDispatcher messageDispatcher = this.getMessageDispatcher(messageReceiver);
        messageDispatcher.processReceivedMessages(Collections.singletonList(TEST_MESSAGE));
        try {
            this.consumers.take().nack();
        }
        catch (Throwable t) {
            throw new AssertionError();
        }
        messageDispatcher.processOutstandingOperations();
        AckRequestData ackRequestData = AckRequestData.newBuilder((String)TEST_MESSAGE.getAckId()).build();
        ArrayList<ModackRequestData> modackRequestDataList = new ArrayList<ModackRequestData>();
        modackRequestDataList.add(new ModackRequestData(0, new AckRequestData[]{ackRequestData}));
        modackRequestDataList.add(new ModackRequestData(10, new AckRequestData[]{ackRequestData}));
        ((MessageDispatcher.AckProcessor)Mockito.verify((Object)this.mockAckProcessor, (VerificationMode)Mockito.times((int)1))).sendModackOperations((List)Mockito.argThat((ArgumentMatcher)new CustomArgumentMatchers.ModackRequestDataListMatcher(modackRequestDataList)));
    }

    @Test
    public void testConsumerNackMessageReceiverWithAckResponse() {
        MessageDispatcher messageDispatcher = this.getMessageDispatcher(messageReceiverWithAckResponse);
        messageDispatcher.processReceivedMessages(Collections.singletonList(TEST_MESSAGE));
        try {
            this.consumersWithResponse.take().nack();
        }
        catch (Throwable t) {
            throw new AssertionError();
        }
        messageDispatcher.processOutstandingOperations();
        AckRequestData ackRequestData = AckRequestData.newBuilder((String)TEST_MESSAGE.getAckId()).build();
        ArrayList<ModackRequestData> modackRequestDataList = new ArrayList<ModackRequestData>();
        modackRequestDataList.add(new ModackRequestData(0, new AckRequestData[]{ackRequestData}));
        modackRequestDataList.add(new ModackRequestData(10, new AckRequestData[]{ackRequestData}));
        ((MessageDispatcher.AckProcessor)Mockito.verify((Object)this.mockAckProcessor, (VerificationMode)Mockito.times((int)1))).sendModackOperations((List)Mockito.argThat((ArgumentMatcher)new CustomArgumentMatchers.ModackRequestDataListMatcher(modackRequestDataList)));
    }

    @Test
    public void testExtension() {
        MessageDispatcher messageDispatcher = this.getMessageDispatcher();
        messageDispatcher.processReceivedMessages(Collections.singletonList(TEST_MESSAGE));
        messageDispatcher.extendDeadlines();
        ArrayList<AckRequestData> ackRequestDataList = new ArrayList<AckRequestData>();
        AckRequestData ackRequestData = AckRequestData.newBuilder((String)TEST_MESSAGE.getAckId()).build();
        ackRequestDataList.add(ackRequestData);
        ArrayList<ModackRequestData> modackRequestDataList = new ArrayList<ModackRequestData>();
        modackRequestDataList.add(new ModackRequestData(10, new AckRequestData[]{ackRequestData}));
        ((MessageDispatcher.AckProcessor)Mockito.verify((Object)this.mockAckProcessor, (VerificationMode)Mockito.times((int)1))).sendModackOperations((List)Mockito.argThat((ArgumentMatcher)new CustomArgumentMatchers.ModackRequestDataListMatcher(modackRequestDataList)));
    }

    @Test
    public void testExtension_ExpirationExtension() {
        MessageDispatcher messageDispatcher = this.getMessageDispatcher();
        messageDispatcher.processReceivedMessages(Collections.singletonList(TEST_MESSAGE));
        int secondsLeft = 5;
        this.clock.advance(MAX_ACK_EXTENSION_PERIOD.getSeconds() - (long)secondsLeft, TimeUnit.SECONDS);
        messageDispatcher.extendDeadlines();
        ArrayList<AckRequestData> ackRequestDataList = new ArrayList<AckRequestData>();
        AckRequestData ackRequestData = AckRequestData.newBuilder((String)TEST_MESSAGE.getAckId()).build();
        ackRequestDataList.add(ackRequestData);
        ArrayList<ModackRequestData> modackRequestDataList = new ArrayList<ModackRequestData>();
        modackRequestDataList.add(new ModackRequestData(secondsLeft, new AckRequestData[]{ackRequestData}));
        ((MessageDispatcher.AckProcessor)Mockito.verify((Object)this.mockAckProcessor, (VerificationMode)Mockito.times((int)1))).sendModackOperations((List)Mockito.argThat((ArgumentMatcher)new CustomArgumentMatchers.ModackRequestDataListMatcher(modackRequestDataList)));
    }

    @Test
    public void testExtension_GiveUp() throws Exception {
        MessageDispatcher messageDispatcher = this.getMessageDispatcher();
        messageDispatcher.processReceivedMessages(Collections.singletonList(TEST_MESSAGE));
        this.clock.advance(1L, TimeUnit.DAYS);
        messageDispatcher.extendDeadlines();
        ((MessageDispatcher.AckProcessor)Mockito.verify((Object)this.mockAckProcessor, (VerificationMode)Mockito.times((int)0))).sendAckOperations((List)Mockito.eq(Collections.emptyList()));
        ((MessageDispatcher.AckProcessor)Mockito.verify((Object)this.mockAckProcessor, (VerificationMode)Mockito.times((int)0))).sendModackOperations((List)Mockito.eq(Collections.emptyList()));
    }

    @Test
    public void testAckExtensionDefaultsExactlyOnceDeliveryDisabledThenEnabled() {
        MessageDispatcher messageDispatcher = MessageDispatcher.newBuilder((MessageReceiver)((MessageReceiver)Mockito.mock(MessageReceiver.class))).setAckLatencyDistribution(this.mockAckLatencyDistribution).setMinDurationPerAckExtension(Subscriber.DEFAULT_MIN_ACK_DEADLINE_EXTENSION).setMinDurationPerAckExtensionDefaultUsed(true).setMaxDurationPerAckExtension(Subscriber.DEFAULT_MAX_ACK_DEADLINE_EXTENSION).setMaxDurationPerAckExtensionDefaultUsed(true).build();
        this.assertMinAndMaxAckDeadlines(messageDispatcher, Math.toIntExact(Subscriber.MIN_STREAM_ACK_DEADLINE.getSeconds()), Math.toIntExact(Subscriber.MAX_STREAM_ACK_DEADLINE.getSeconds()));
        messageDispatcher.setExactlyOnceDeliveryEnabled(true);
        this.assertMinAndMaxAckDeadlines(messageDispatcher, Math.toIntExact(Subscriber.DEFAULT_MIN_ACK_DEADLINE_EXTENSION_EXACTLY_ONCE_DELIVERY.getSeconds()), Math.toIntExact(Subscriber.MAX_STREAM_ACK_DEADLINE.getSeconds()));
    }

    @Test
    public void testAckExtensionDefaultsExactlyOnceDeliveryEnabledThenDisabled() {
        MessageDispatcher messageDispatcher = MessageDispatcher.newBuilder((MessageReceiver)((MessageReceiver)Mockito.mock(MessageReceiver.class))).setAckLatencyDistribution(this.mockAckLatencyDistribution).setMinDurationPerAckExtension(Subscriber.DEFAULT_MIN_ACK_DEADLINE_EXTENSION_EXACTLY_ONCE_DELIVERY).setMinDurationPerAckExtensionDefaultUsed(true).setMaxDurationPerAckExtension(Subscriber.DEFAULT_MIN_ACK_DEADLINE_EXTENSION).setMaxDurationPerAckExtensionDefaultUsed(true).build();
        messageDispatcher.setExactlyOnceDeliveryEnabled(true);
        this.assertMinAndMaxAckDeadlines(messageDispatcher, Math.toIntExact(Subscriber.DEFAULT_MIN_ACK_DEADLINE_EXTENSION_EXACTLY_ONCE_DELIVERY.getSeconds()), Math.toIntExact(Subscriber.MAX_STREAM_ACK_DEADLINE.getSeconds()));
        messageDispatcher.setExactlyOnceDeliveryEnabled(false);
        this.assertMinAndMaxAckDeadlines(messageDispatcher, Math.toIntExact(Subscriber.MIN_STREAM_ACK_DEADLINE.getSeconds()), Math.toIntExact(Subscriber.MAX_STREAM_ACK_DEADLINE.getSeconds()));
    }

    @Test
    public void testAckExtensionCustomMinExactlyOnceDeliveryDisabledThenEnabled() {
        int customMinSeconds = 30;
        MessageDispatcher messageDispatcher = MessageDispatcher.newBuilder((MessageReceiver)((MessageReceiver)Mockito.mock(MessageReceiver.class))).setAckLatencyDistribution(this.mockAckLatencyDistribution).setMinDurationPerAckExtension(Duration.ofSeconds((long)customMinSeconds)).setMinDurationPerAckExtensionDefaultUsed(false).setMaxDurationPerAckExtension(Subscriber.DEFAULT_MIN_ACK_DEADLINE_EXTENSION).setMaxDurationPerAckExtensionDefaultUsed(true).build();
        this.assertMinAndMaxAckDeadlines(messageDispatcher, customMinSeconds, Math.toIntExact(Subscriber.MAX_STREAM_ACK_DEADLINE.getSeconds()));
        messageDispatcher.setExactlyOnceDeliveryEnabled(true);
        this.assertMinAndMaxAckDeadlines(messageDispatcher, customMinSeconds, Math.toIntExact(Subscriber.MAX_STREAM_ACK_DEADLINE.getSeconds()));
    }

    @Test
    public void testAckExtensionCustomMaxExactlyOnceDeliveryDisabledThenEnabled() {
        int customMaxSeconds = 30;
        MessageDispatcher messageDispatcher = MessageDispatcher.newBuilder((MessageReceiver)((MessageReceiver)Mockito.mock(MessageReceiver.class))).setAckLatencyDistribution(this.mockAckLatencyDistribution).setMinDurationPerAckExtension(Subscriber.DEFAULT_MIN_ACK_DEADLINE_EXTENSION).setMinDurationPerAckExtensionDefaultUsed(true).setMaxDurationPerAckExtension(Duration.ofSeconds((long)customMaxSeconds)).setMaxDurationPerAckExtensionDefaultUsed(false).build();
        this.assertMinAndMaxAckDeadlines(messageDispatcher, Math.toIntExact(Subscriber.MIN_STREAM_ACK_DEADLINE.getSeconds()), customMaxSeconds);
        messageDispatcher.setExactlyOnceDeliveryEnabled(true);
        this.assertMinAndMaxAckDeadlines(messageDispatcher, customMaxSeconds, customMaxSeconds);
    }

    private void assertMinAndMaxAckDeadlines(MessageDispatcher messageDispatcher, int minAckDeadline, int maxAckDeadline) {
        Mockito.when((Object)this.mockAckLatencyDistribution.getPercentile(99.9)).thenReturn((Object)0);
        Assert.assertEquals((long)minAckDeadline, (long)messageDispatcher.computeDeadlineSeconds());
        Mockito.when((Object)this.mockAckLatencyDistribution.getPercentile(99.9)).thenReturn((Object)3600);
        Assert.assertEquals((long)maxAckDeadline, (long)messageDispatcher.computeDeadlineSeconds());
    }

    private MessageDispatcher getMessageDispatcher() {
        return this.getMessageDispatcher((MessageReceiver)Mockito.mock(MessageReceiver.class));
    }

    private MessageDispatcher getMessageDispatcher(MessageReceiver messageReceiver) {
        return this.getMessageDispatcherFromBuilder(MessageDispatcher.newBuilder((MessageReceiver)messageReceiver));
    }

    private MessageDispatcher getMessageDispatcher(MessageReceiverWithAckResponse messageReceiverWithAckResponse) {
        return this.getMessageDispatcherFromBuilder(MessageDispatcher.newBuilder((MessageReceiverWithAckResponse)messageReceiverWithAckResponse));
    }

    private MessageDispatcher getMessageDispatcherFromBuilder(MessageDispatcher.Builder builder) {
        MessageDispatcher messageDispatcher = builder.setAckProcessor(this.mockAckProcessor).setAckExpirationPadding(ACK_EXPIRATION_PADDING_DEFAULT).setMaxAckExtensionPeriod(MAX_ACK_EXTENSION_PERIOD).setMinDurationPerAckExtension(Subscriber.DEFAULT_MIN_ACK_DEADLINE_EXTENSION).setMinDurationPerAckExtensionDefaultUsed(true).setMaxDurationPerAckExtension(Subscriber.DEFAULT_MAX_ACK_DEADLINE_EXTENSION).setMaxDurationPerAckExtensionDefaultUsed(true).setAckLatencyDistribution((Distribution)Mockito.mock(Distribution.class)).setFlowController((FlowController)Mockito.mock(FlowController.class)).setExecutor(MoreExecutors.directExecutor()).setSystemExecutor((ScheduledExecutorService)this.systemExecutor).setApiClock((ApiClock)this.clock).build();
        messageDispatcher.setMessageDeadlineSeconds(10);
        return messageDispatcher;
    }
}

