/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.DataLossException;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.FakePublisherServiceImpl;
import com.google.cloud.pubsub.v1.FakeScheduledExecutorService;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.cloud.pubsub.v1.SequentialExecutorService;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.TopicName;
import io.grpc.BindableService;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class PublisherImplTest {
    private static final ProjectTopicName TEST_TOPIC = ProjectTopicName.of((String)"test-project", (String)"test-topic");
    private static final ExecutorProvider SINGLE_THREAD_EXECUTOR = InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(1).build();
    private static final TransportChannelProvider TEST_CHANNEL_PROVIDER = LocalChannelProvider.create((String)"test-server");
    private FakeScheduledExecutorService fakeExecutor;
    private FakePublisherServiceImpl testPublisherServiceImpl;
    private ManagedChannel testChannel;
    private Server testServer;

    @Before
    public void setUp() throws Exception {
        this.testPublisherServiceImpl = new FakePublisherServiceImpl();
        InProcessServerBuilder serverBuilder = InProcessServerBuilder.forName((String)"test-server");
        serverBuilder.addService((BindableService)this.testPublisherServiceImpl);
        this.testServer = serverBuilder.build();
        this.testChannel = InProcessChannelBuilder.forName((String)"test-server").build();
        this.testServer.start();
        this.fakeExecutor = new FakeScheduledExecutorService();
    }

    @After
    public void tearDown() throws Exception {
        this.testServer.shutdownNow().awaitTermination();
        this.testChannel.shutdown();
    }

    @Test
    public void testPublishByDuration() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setDelayThreshold(Duration.ofSeconds((long)5L)).setElementCountThreshold(Long.valueOf(10L)).build()).build();
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1").addMessageIds("2"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        ApiFuture<String> publishFuture2 = this.sendTestMessage(publisher, "B");
        Assert.assertFalse((boolean)publishFuture1.isDone());
        Assert.assertFalse((boolean)publishFuture2.isDone());
        this.fakeExecutor.advanceTime(Duration.ofSeconds((long)10L));
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((Object)"2", (Object)publishFuture2.get());
        Assert.assertEquals((long)2L, (long)this.testPublisherServiceImpl.getCapturedRequests().get(0).getMessagesCount());
        this.shutdownTestPublisher(publisher);
    }

    @Test
    public void testPublishByNumBatchedMessages() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(2L)).setDelayThreshold(Duration.ofSeconds((long)100L)).build()).build();
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1").addMessageIds("2")).addPublishResponse(PublishResponse.newBuilder().addMessageIds("3").addMessageIds("4"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        ApiFuture<String> publishFuture2 = this.sendTestMessage(publisher, "B");
        ApiFuture<String> publishFuture3 = this.sendTestMessage(publisher, "C");
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((Object)"2", (Object)publishFuture2.get());
        Assert.assertFalse((boolean)publishFuture3.isDone());
        ApiFuture<String> publishFuture4 = this.sendTestMessage(publisher, "D");
        Assert.assertEquals((Object)"3", (Object)publishFuture3.get());
        Assert.assertEquals((Object)"4", (Object)publishFuture4.get());
        Assert.assertEquals((long)2L, (long)this.testPublisherServiceImpl.getCapturedRequests().get(0).getMessagesCount());
        Assert.assertEquals((long)2L, (long)this.testPublisherServiceImpl.getCapturedRequests().get(1).getMessagesCount());
        this.fakeExecutor.advanceTime(Duration.ofSeconds((long)100L));
        this.shutdownTestPublisher(publisher);
    }

    @Test
    public void testSinglePublishByNumBytes() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(2L)).setDelayThreshold(Duration.ofSeconds((long)100L)).build()).build();
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1").addMessageIds("2")).addPublishResponse(PublishResponse.newBuilder().addMessageIds("3").addMessageIds("4"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        ApiFuture<String> publishFuture2 = this.sendTestMessage(publisher, "B");
        ApiFuture<String> publishFuture3 = this.sendTestMessage(publisher, "C");
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((Object)"2", (Object)publishFuture2.get());
        Assert.assertFalse((boolean)publishFuture3.isDone());
        ApiFuture<String> publishFuture4 = this.sendTestMessage(publisher, "D");
        Assert.assertEquals((Object)"3", (Object)publishFuture3.get());
        Assert.assertEquals((Object)"4", (Object)publishFuture4.get());
        Assert.assertEquals((long)2L, (long)this.testPublisherServiceImpl.getCapturedRequests().size());
        this.fakeExecutor.advanceTime(Duration.ofSeconds((long)100L));
        this.shutdownTestPublisher(publisher);
    }

    @Test
    public void testPublishByShutdown() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setDelayThreshold(Duration.ofSeconds((long)100L)).setElementCountThreshold(Long.valueOf(10L)).build()).build();
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1").addMessageIds("2"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        ApiFuture<String> publishFuture2 = this.sendTestMessage(publisher, "B");
        publisher.shutdown();
        Assert.assertTrue((boolean)publishFuture1.isDone());
        Assert.assertTrue((boolean)publishFuture2.isDone());
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((Object)"2", (Object)publishFuture2.get());
        this.fakeExecutor.advanceTime(Duration.ofSeconds((long)100L));
        publisher.awaitTermination(1L, TimeUnit.MINUTES);
    }

    @Test
    public void testPublishMixedSizeAndDuration() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(2L)).setDelayThreshold(Duration.ofSeconds((long)5L)).build()).build();
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1").addMessageIds("2"));
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("3"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        this.fakeExecutor.advanceTime(Duration.ofSeconds((long)2L));
        Assert.assertFalse((boolean)publishFuture1.isDone());
        ApiFuture<String> publishFuture2 = this.sendTestMessage(publisher, "B");
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((Object)"2", (Object)publishFuture2.get());
        ApiFuture<String> publishFuture3 = this.sendTestMessage(publisher, "C");
        Assert.assertFalse((boolean)publishFuture3.isDone());
        this.fakeExecutor.advanceTime(Duration.ofSeconds((long)5L));
        Assert.assertEquals((Object)"3", (Object)publishFuture3.get());
        Assert.assertEquals((long)2L, (long)this.testPublisherServiceImpl.getCapturedRequests().get(0).getMessagesCount());
        Assert.assertEquals((long)1L, (long)this.testPublisherServiceImpl.getCapturedRequests().get(1).getMessagesCount());
        this.shutdownTestPublisher(publisher);
    }

    @Test
    public void testPublishWithCompression() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(2L)).setDelayThreshold(Duration.ofSeconds((long)100L)).build()).setEnableCompression(true).setCompressionBytesThreshold(100L).build();
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1").addMessageIds("2"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        ApiFuture<String> publishFuture2 = this.sendTestMessage(publisher, "B");
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((Object)"2", (Object)publishFuture2.get());
        this.fakeExecutor.advanceTime(Duration.ofSeconds((long)100L));
        this.shutdownTestPublisher(publisher);
    }

    private ApiFuture<String> sendTestMessage(Publisher publisher, String data) {
        return publisher.publish(PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)data)).build());
    }

    @Test
    public void testBatchedMessagesWithOrderingKeyByNum() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(3L)).setDelayThreshold(Duration.ofSeconds((long)100L)).build()).setEnableMessageOrdering(true).build();
        this.testPublisherServiceImpl.setAutoPublishResponse(true);
        ApiFuture<String> publishFuture1 = this.sendTestMessageWithOrderingKey(publisher, "m1", "OrderA");
        ApiFuture<String> publishFuture2 = this.sendTestMessageWithOrderingKey(publisher, "m2", "OrderB");
        ApiFuture<String> publishFuture3 = this.sendTestMessageWithOrderingKey(publisher, "m3", "OrderA");
        ApiFuture<String> publishFuture4 = this.sendTestMessageWithOrderingKey(publisher, "m4", "OrderB");
        Assert.assertFalse((boolean)publishFuture1.isDone());
        Assert.assertFalse((boolean)publishFuture2.isDone());
        Assert.assertFalse((boolean)publishFuture3.isDone());
        Assert.assertFalse((boolean)publishFuture4.isDone());
        ApiFuture<String> publishFuture5 = this.sendTestMessageWithOrderingKey(publisher, "m5", "OrderA");
        Assert.assertTrue((Integer.parseInt((String)publishFuture1.get()) < Integer.parseInt((String)publishFuture3.get()) ? 1 : 0) != 0);
        Assert.assertTrue((Integer.parseInt((String)publishFuture3.get()) < Integer.parseInt((String)publishFuture5.get()) ? 1 : 0) != 0);
        ApiFuture<String> publishFuture6 = this.sendTestMessageWithOrderingKey(publisher, "m6", "OrderB");
        Assert.assertTrue((Integer.parseInt((String)publishFuture2.get()) < Integer.parseInt((String)publishFuture4.get()) ? 1 : 0) != 0);
        Assert.assertTrue((Integer.parseInt((String)publishFuture4.get()) < Integer.parseInt((String)publishFuture6.get()) ? 1 : 0) != 0);
        List<PublishRequest> requests = this.testPublisherServiceImpl.getCapturedRequests();
        for (PublishRequest request : requests) {
            if (request.getMessagesCount() <= 1) continue;
            String orderingKey = request.getMessages(0).getOrderingKey();
            for (PubsubMessage message : request.getMessagesList()) {
                Assert.assertEquals((Object)message.getOrderingKey(), (Object)orderingKey);
            }
        }
        this.fakeExecutor.advanceTime(Duration.ofSeconds((long)100L));
        this.shutdownTestPublisher(publisher);
    }

    @Test
    public void testBatchedMessagesWithOrderingKeyByDuration() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(10L)).setDelayThreshold(Duration.ofSeconds((long)100L)).build()).setEnableMessageOrdering(true).build();
        this.testPublisherServiceImpl.setAutoPublishResponse(true);
        this.testPublisherServiceImpl.setExecutor(this.fakeExecutor);
        this.testPublisherServiceImpl.setPublishResponseDelay(Duration.ofSeconds((long)300L));
        ApiFuture<String> publishFuture1 = this.sendTestMessageWithOrderingKey(publisher, "m1", "OrderA");
        ApiFuture<String> publishFuture2 = this.sendTestMessageWithOrderingKey(publisher, "m2", "OrderB");
        ApiFuture<String> publishFuture3 = this.sendTestMessageWithOrderingKey(publisher, "m3", "OrderA");
        ApiFuture<String> publishFuture4 = this.sendTestMessageWithOrderingKey(publisher, "m4", "OrderB");
        Assert.assertFalse((boolean)publishFuture1.isDone());
        Assert.assertFalse((boolean)publishFuture2.isDone());
        Assert.assertFalse((boolean)publishFuture3.isDone());
        Assert.assertFalse((boolean)publishFuture4.isDone());
        this.fakeExecutor.advanceTime(Duration.ofSeconds((long)100L));
        this.testPublisherServiceImpl.setPublishResponseDelay(Duration.ZERO);
        ApiFuture<String> publishFuture5 = this.sendTestMessageWithOrderingKey(publisher, "m5", "OrderA");
        this.fakeExecutor.advanceTime(Duration.ofSeconds((long)100L));
        this.fakeExecutor.advanceTime(Duration.ofSeconds((long)200L));
        Assert.assertTrue((Integer.parseInt((String)publishFuture1.get()) < Integer.parseInt((String)publishFuture3.get()) ? 1 : 0) != 0);
        Assert.assertTrue((Integer.parseInt((String)publishFuture2.get()) < Integer.parseInt((String)publishFuture4.get()) ? 1 : 0) != 0);
        Assert.assertTrue((Integer.parseInt((String)publishFuture3.get()) < Integer.parseInt((String)publishFuture5.get()) ? 1 : 0) != 0);
        List<PublishRequest> requests = this.testPublisherServiceImpl.getCapturedRequests();
        for (PublishRequest request : requests) {
            if (request.getMessagesCount() <= 1) continue;
            String orderingKey = request.getMessages(0).getOrderingKey();
            for (PubsubMessage message : request.getMessagesList()) {
                Assert.assertEquals((Object)message.getOrderingKey(), (Object)orderingKey);
            }
        }
        this.shutdownTestPublisher(publisher);
    }

    @Test
    public void testLargeMessagesDoNotReorderBatches() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(10L)).setRequestByteThreshold(Long.valueOf(20L)).setDelayThreshold(Duration.ofSeconds((long)100L)).build()).setEnableMessageOrdering(true).build();
        this.testPublisherServiceImpl.setAutoPublishResponse(true);
        ApiFuture<String> publishFuture1 = this.sendTestMessageWithOrderingKey(publisher, "m1", "OrderA");
        ApiFuture<String> publishFuture2 = this.sendTestMessageWithOrderingKey(publisher, "m2", "OrderB");
        Assert.assertFalse((boolean)publishFuture1.isDone());
        Assert.assertFalse((boolean)publishFuture2.isDone());
        ApiFuture<String> publishFuture3 = this.sendTestMessageWithOrderingKey(publisher, "VeryLargeMessage", "OrderB");
        Assert.assertTrue((Integer.parseInt((String)publishFuture2.get()) < Integer.parseInt((String)publishFuture3.get()) ? 1 : 0) != 0);
        this.fakeExecutor.advanceTime(Duration.ofSeconds((long)100L));
        this.shutdownTestPublisher(publisher);
    }

    @Test
    public void testOrderingKeyWhenDisabled_throwsException() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().build();
        try {
            ApiFuture<String> publishFuture = this.sendTestMessageWithOrderingKey(publisher, "m1", "orderA");
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.shutdownTestPublisher(publisher);
    }

    @Test
    public void testEnableMessageOrdering_overwritesMaxAttempts() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setTotalTimeout(Duration.ofSeconds((long)10L)).setMaxAttempts(1).build()).setEnableMessageOrdering(true).build();
        this.testPublisherServiceImpl.addPublishError(new Throwable("Transiently failing"));
        this.testPublisherServiceImpl.addPublishError(new Throwable("Transiently failing"));
        this.testPublisherServiceImpl.addPublishError(new Throwable("Transiently failing"));
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1"));
        ApiFuture<String> publishFuture1 = this.sendTestMessageWithOrderingKey(publisher, "m1", "orderA");
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((long)4L, (long)this.testPublisherServiceImpl.getCapturedRequests().size());
        publisher.shutdown();
        Assert.assertTrue((boolean)publisher.awaitTermination(1L, TimeUnit.MINUTES));
    }

    @Test
    public void testResumePublish() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(2L)).build()).setEnableMessageOrdering(true).build();
        ApiFuture<String> future1 = this.sendTestMessageWithOrderingKey(publisher, "m1", "orderA");
        ApiFuture<String> future2 = this.sendTestMessageWithOrderingKey(publisher, "m2", "orderA");
        this.fakeExecutor.advanceTime(Duration.ZERO);
        Assert.assertFalse((boolean)future1.isDone());
        Assert.assertFalse((boolean)future2.isDone());
        this.testPublisherServiceImpl.addPublishError((Throwable)new StatusException(Status.INVALID_ARGUMENT));
        this.fakeExecutor.advanceTime(Duration.ZERO);
        try {
            future1.get();
            Assert.fail((String)"This should fail.");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        try {
            future2.get();
            Assert.fail((String)"This should fail.");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        ApiFuture<String> future3 = this.sendTestMessageWithOrderingKey(publisher, "m3", "orderA");
        ApiFuture<String> future4 = this.sendTestMessageWithOrderingKey(publisher, "m4", "orderA");
        try {
            future3.get();
            Assert.fail((String)"This should fail.");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((Object)SequentialExecutorService.CallbackExecutor.CANCELLATION_EXCEPTION, (Object)e.getCause());
        }
        try {
            future4.get();
            Assert.fail((String)"This should fail.");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((Object)SequentialExecutorService.CallbackExecutor.CANCELLATION_EXCEPTION, (Object)e.getCause());
        }
        ApiFuture<String> future5 = this.sendTestMessageWithOrderingKey(publisher, "m5", "orderB");
        ApiFuture<String> future6 = this.sendTestMessageWithOrderingKey(publisher, "m6", "orderB");
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("5").addMessageIds("6"));
        Assert.assertEquals((Object)"5", (Object)future5.get());
        Assert.assertEquals((Object)"6", (Object)future6.get());
        publisher.resumePublish("orderA");
        ApiFuture<String> future7 = this.sendTestMessageWithOrderingKey(publisher, "m7", "orderA");
        ApiFuture<String> future8 = this.sendTestMessageWithOrderingKey(publisher, "m8", "orderA");
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("7").addMessageIds("8"));
        Assert.assertEquals((Object)"7", (Object)future7.get());
        Assert.assertEquals((Object)"8", (Object)future8.get());
        this.shutdownTestPublisher(publisher);
    }

    @Test
    public void testPublishThrowExceptionForUnsubmittedOrderingKeyMessage() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(2L)).setDelayThreshold(Duration.ofSeconds((long)500L)).build()).setEnableMessageOrdering(true).build();
        this.testPublisherServiceImpl.addPublishError((Throwable)new StatusException(Status.INVALID_ARGUMENT));
        ApiFuture<String> publishFuture1 = this.sendTestMessageWithOrderingKey(publisher, "A", "a");
        ApiFuture<String> publishFuture2 = this.sendTestMessageWithOrderingKey(publisher, "B", "a");
        ApiFuture<String> publishFuture3 = this.sendTestMessageWithOrderingKey(publisher, "C", "a");
        try {
            publishFuture1.get();
            Assert.fail((String)"Should have failed.");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        try {
            publishFuture2.get();
            Assert.fail((String)"Should have failed.");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        try {
            publishFuture3.get();
            Assert.fail((String)"Should have failed.");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((Object)SequentialExecutorService.CallbackExecutor.CANCELLATION_EXCEPTION, (Object)e.getCause());
        }
        ApiFuture<String> publishFuture4 = this.sendTestMessageWithOrderingKey(publisher, "D", "a");
        try {
            publishFuture4.get();
            Assert.fail((String)"Should have failed.");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((Object)SequentialExecutorService.CallbackExecutor.CANCELLATION_EXCEPTION, (Object)e.getCause());
        }
    }

    private ApiFuture<String> sendTestMessageWithOrderingKey(Publisher publisher, String data, String orderingKey) {
        return publisher.publish(PubsubMessage.newBuilder().setOrderingKey(orderingKey).setData(ByteString.copyFromUtf8((String)data)).build());
    }

    @Test
    public void testErrorPropagation() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(1L)).setDelayThreshold(Duration.ofSeconds((long)5L)).build()).build();
        this.testPublisherServiceImpl.addPublishError((Throwable)Status.DATA_LOSS.asException());
        try {
            this.sendTestMessage(publisher, "A").get();
            Assert.fail((String)"should throw exception");
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(DataLossException.class);
        }
    }

    @Test
    public void testPublishFailureRetries() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(1L)).setDelayThreshold(Duration.ofSeconds((long)5L)).build()).build();
        this.testPublisherServiceImpl.addPublishError(new Throwable("Transiently failing"));
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((long)2L, (long)this.testPublisherServiceImpl.getCapturedRequests().size());
        this.shutdownTestPublisher(publisher);
    }

    @Test(expected=ExecutionException.class)
    public void testPublishFailureRetries_retriesDisabled() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setTotalTimeout(Duration.ofSeconds((long)10L)).setMaxAttempts(1).build()).build();
        this.testPublisherServiceImpl.addPublishError(new Throwable("Transiently failing"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        try {
            publishFuture1.get();
        }
        finally {
            Assert.assertSame((Object)this.testPublisherServiceImpl.getCapturedRequests().size(), (Object)1);
            this.shutdownTestPublisher(publisher);
        }
    }

    @Test
    public void testPublishFailureRetries_maxRetriesSetup() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setTotalTimeout(Duration.ofSeconds((long)10L)).setMaxAttempts(3).build()).build();
        this.testPublisherServiceImpl.addPublishError(new Throwable("Transiently failing"));
        this.testPublisherServiceImpl.addPublishError(new Throwable("Transiently failing"));
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((long)3L, (long)this.testPublisherServiceImpl.getCapturedRequests().size());
        this.shutdownTestPublisher(publisher);
    }

    @Test
    public void testPublishFailureRetries_maxRetriesSetUnlimited() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setTotalTimeout(Duration.ofSeconds((long)10L)).setMaxAttempts(0).build()).build();
        this.testPublisherServiceImpl.addPublishError(new Throwable("Transiently failing"));
        this.testPublisherServiceImpl.addPublishError(new Throwable("Transiently failing"));
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((long)3L, (long)this.testPublisherServiceImpl.getCapturedRequests().size());
        publisher.shutdown();
        Assert.assertTrue((boolean)publisher.awaitTermination(1L, TimeUnit.MINUTES));
    }

    @Test(expected=ExecutionException.class)
    public void testPublishFailureRetries_nonRetryableFailsImmediately() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setTotalTimeout(Duration.ofSeconds((long)10L)).build()).setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(1L)).setDelayThreshold(Duration.ofSeconds((long)5L)).build()).build();
        this.testPublisherServiceImpl.addPublishError((Throwable)new StatusException(Status.INVALID_ARGUMENT));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        try {
            publishFuture1.get();
            Assert.assertTrue((this.testPublisherServiceImpl.getCapturedRequests().size() >= 1 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Assert.assertTrue((this.testPublisherServiceImpl.getCapturedRequests().size() >= 1 ? 1 : 0) != 0);
            publisher.shutdown();
            Assert.assertTrue((boolean)publisher.awaitTermination(1L, TimeUnit.MINUTES));
            throw throwable;
        }
        publisher.shutdown();
        Assert.assertTrue((boolean)publisher.awaitTermination(1L, TimeUnit.MINUTES));
    }

    @Test
    public void testPublisherGetters() throws Exception {
        Publisher.Builder builder = Publisher.newBuilder((TopicName)TEST_TOPIC);
        builder.setChannelProvider((TransportChannelProvider)FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)this.testChannel)));
        builder.setExecutorProvider(SINGLE_THREAD_EXECUTOR);
        builder.setBatchingSettings(BatchingSettings.newBuilder().setRequestByteThreshold(Long.valueOf(10L)).setDelayThreshold(Duration.ofMillis((long)11L)).setElementCountThreshold(Long.valueOf(12L)).build());
        builder.setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create());
        Publisher publisher = builder.build();
        Assert.assertEquals((Object)TEST_TOPIC, (Object)publisher.getTopicName());
        Assert.assertEquals((long)10L, (long)publisher.getBatchingSettings().getRequestByteThreshold());
        Assert.assertEquals((Object)Duration.ofMillis((long)11L), (Object)publisher.getBatchingSettings().getDelayThreshold());
        Assert.assertEquals((long)12L, (long)publisher.getBatchingSettings().getElementCountThreshold());
        publisher.shutdown();
        Assert.assertTrue((boolean)publisher.awaitTermination(1L, TimeUnit.MINUTES));
    }

    @Test
    public void testBuilderParametersAndDefaults() {
        Publisher.Builder builder = Publisher.newBuilder((TopicName)TEST_TOPIC);
        Assert.assertEquals((Object)TEST_TOPIC.toString(), (Object)builder.topicName);
        Assert.assertEquals((Object)Publisher.Builder.DEFAULT_EXECUTOR_PROVIDER, (Object)builder.executorProvider);
        Assert.assertEquals((long)1000L, (long)builder.batchingSettings.getRequestByteThreshold());
        Assert.assertEquals((Object)Publisher.Builder.DEFAULT_DELAY_THRESHOLD, (Object)builder.batchingSettings.getDelayThreshold());
        Assert.assertEquals((long)100L, (long)builder.batchingSettings.getElementCountThreshold());
        Assert.assertEquals((Object)Publisher.Builder.DEFAULT_RETRY_SETTINGS, (Object)builder.retrySettings);
    }

    @Test
    public void testBuilderInvalidArguments() {
        Publisher.Builder builder = Publisher.newBuilder((TopicName)TEST_TOPIC);
        try {
            builder.setChannelProvider(null);
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.setExecutorProvider(null);
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setRequestByteThreshold(null).build());
            Assert.fail((String)"Should have thrown an NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setRequestByteThreshold(Long.valueOf(0L)).build());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setRequestByteThreshold(Long.valueOf(-1L)).build());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setDelayThreshold(Duration.ofMillis((long)1L)).build());
        try {
            builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setDelayThreshold(null).build());
            Assert.fail((String)"Should have thrown an NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setDelayThreshold(Duration.ofMillis((long)-1L)).build());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(1L)).build());
        try {
            builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(null).build());
            Assert.fail((String)"Should have thrown an NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(0L)).build());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(-1L)).build());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        builder.setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setInitialRpcTimeout(Publisher.Builder.MIN_RPC_TIMEOUT).build());
        try {
            builder.setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setInitialRpcTimeout(Publisher.Builder.MIN_RPC_TIMEOUT.minusMillis(1L)).build());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        builder.setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setTotalTimeout(Publisher.Builder.MIN_TOTAL_TIMEOUT).build());
        try {
            builder.setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setTotalTimeout(Publisher.Builder.MIN_TOTAL_TIMEOUT.minusMillis(1L)).build());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPartialBatchingSettings() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.getDefaultBatchingSettings().toBuilder().setRequestByteThreshold(Long.valueOf(5000L)).build()).build();
        Assert.assertEquals((long)publisher.getBatchingSettings().getRequestByteThreshold(), (long)5000L);
        Assert.assertEquals((Object)publisher.getBatchingSettings().getElementCountThreshold(), (Object)Publisher.Builder.DEFAULT_BATCHING_SETTINGS.getElementCountThreshold());
        publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.getDefaultBatchingSettings().toBuilder().setElementCountThreshold(Long.valueOf(500L)).build()).build();
        Assert.assertEquals((long)publisher.getBatchingSettings().getElementCountThreshold(), (long)500L);
        Assert.assertEquals((Object)publisher.getBatchingSettings().getRequestByteThreshold(), (Object)Publisher.Builder.DEFAULT_BATCHING_SETTINGS.getRequestByteThreshold());
    }

    @Test
    public void testAwaitTermination() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setTotalTimeout(Duration.ofSeconds((long)10L)).setMaxAttempts(0).build()).build();
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        publisher.shutdown();
        Assert.assertTrue((boolean)publisher.awaitTermination(1L, TimeUnit.MINUTES));
    }

    @Test
    public void testShutDown() throws Exception {
        ApiFuture apiFuture = (ApiFuture)EasyMock.mock(ApiFuture.class);
        Publisher publisher = (Publisher)EasyMock.mock(Publisher.class);
        EasyMock.expect((Object)publisher.publish(PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"A")).build())).andReturn((Object)apiFuture);
        EasyMock.expect((Object)publisher.awaitTermination(1L, TimeUnit.MINUTES)).andReturn((Object)true);
        publisher.shutdown();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{publisher});
        this.sendTestMessage(publisher, "A");
        publisher.shutdown();
        Assert.assertTrue((boolean)publisher.awaitTermination(1L, TimeUnit.MINUTES));
    }

    @Test
    public void invalidFlowControlBytes_throwException() throws Exception {
        try {
            Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(1L)).setDelayThreshold(Duration.ofSeconds((long)5L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).setMaxOutstandingElementCount(Long.valueOf(1L)).setMaxOutstandingRequestBytes(Long.valueOf(0L)).build()).build()).build();
            Assert.fail((String)"Expected an IllegalArgumentException");
        }
        catch (Exception e) {
            Truth.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void invalidFlowControlElementCount_throwException() throws Exception {
        try {
            Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(1L)).setDelayThreshold(Duration.ofSeconds((long)5L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).setMaxOutstandingElementCount(Long.valueOf(0L)).setMaxOutstandingRequestBytes(Long.valueOf(1000L)).build()).build()).build();
            Assert.fail((String)"Expected an IllegalArgumentException");
        }
        catch (Exception e) {
            Truth.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void testMessageExceedsFlowControlLimits_throwException() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(1L)).setDelayThreshold(Duration.ofSeconds((long)5L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).setMaxOutstandingElementCount(Long.valueOf(1L)).setMaxOutstandingRequestBytes(Long.valueOf(1L)).build()).build()).build();
        try {
            this.sendTestMessage(publisher, "AAAAAAAAAAAAAAAAAAAAA").get();
            Assert.fail((String)"Should have thrown a FlowController.MaxOutstandingRequestBytesReachedException");
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(FlowController.MaxOutstandingRequestBytesReachedException.class);
        }
    }

    @Test
    public void testPublishFlowControl_throwException() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(1L)).setDelayThreshold(Duration.ofSeconds((long)5L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).setMaxOutstandingElementCount(Long.valueOf(1L)).setMaxOutstandingRequestBytes(Long.valueOf(10L)).build()).build()).build();
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "AAAA");
        ApiFuture<String> publishFuture2 = this.sendTestMessage(publisher, "AA");
        try {
            publishFuture2.get();
            Assert.fail((String)"Should have thrown an FlowController.MaxOutstandingElementCountReachedException");
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(FlowController.MaxOutstandingElementCountReachedException.class);
        }
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1"));
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        ApiFuture<String> publishFuture4 = this.sendTestMessage(publisher, "AAAA");
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("2"));
        Assert.assertEquals((Object)"2", (Object)publishFuture4.get());
    }

    @Test
    public void testPublishFlowControl_throwExceptionWithOrderingKey() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(1L)).setDelayThreshold(Duration.ofSeconds((long)5L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).setMaxOutstandingElementCount(Long.valueOf(1L)).setMaxOutstandingRequestBytes(Long.valueOf(10L)).build()).build()).setEnableMessageOrdering(true).build();
        ApiFuture<String> publishFuture1 = this.sendTestMessageWithOrderingKey(publisher, "AAAA", "a");
        ApiFuture<String> publishFuture2 = this.sendTestMessageWithOrderingKey(publisher, "AA", "a");
        try {
            publishFuture2.get();
            Assert.fail((String)"Should have thrown an FlowController.MaxOutstandingElementCountReachedException");
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(FlowController.MaxOutstandingElementCountReachedException.class);
        }
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1"));
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        ApiFuture<String> publishFuture3 = this.sendTestMessageWithOrderingKey(publisher, "AAAA", "a");
        try {
            publishFuture3.get();
            Assert.fail((String)"This should fail.");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((Object)SequentialExecutorService.CallbackExecutor.CANCELLATION_EXCEPTION, (Object)e.getCause());
        }
    }

    @Test
    public void testPublishFlowControl_block() throws Exception {
        final Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(1L)).setDelayThreshold(Duration.ofSeconds((long)5L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).setMaxOutstandingElementCount(Long.valueOf(2L)).setMaxOutstandingRequestBytes(Long.valueOf(10L)).build()).build()).build();
        ScheduledExecutorService responseExecutor = Executors.newScheduledThreadPool(10);
        final CountDownLatch sendResponse1 = new CountDownLatch(1);
        final CountDownLatch response1Sent = new CountDownLatch(1);
        final CountDownLatch sendResponse2 = new CountDownLatch(1);
        responseExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    sendResponse1.await();
                    PublisherImplTest.this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1"));
                    response1Sent.countDown();
                    sendResponse2.await();
                    PublisherImplTest.this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("2"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "AA");
        ApiFuture<String> publishFuture2 = this.sendTestMessage(publisher, "AA");
        final CountDownLatch publish3Completed = new CountDownLatch(1);
        CountDownLatch response3Sent = new CountDownLatch(1);
        responseExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ApiFuture publishFuture3 = PublisherImplTest.this.sendTestMessage(publisher, "AAAAAA");
                publish3Completed.countDown();
            }
        });
        responseExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    sendResponse1.countDown();
                    response1Sent.await();
                    sendResponse2.countDown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final CountDownLatch publish4Completed = new CountDownLatch(1);
        responseExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    publish3Completed.await();
                    ApiFuture publishFuture4 = PublisherImplTest.this.sendTestMessage(publisher, "A");
                    publish4Completed.countDown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        publish3Completed.await();
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("3"));
        response3Sent.countDown();
        publish4Completed.await();
    }

    private Publisher.Builder getTestPublisherBuilder() {
        return Publisher.newBuilder((TopicName)TEST_TOPIC).setExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)this.fakeExecutor)).setChannelProvider((TransportChannelProvider)FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)this.testChannel))).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create());
    }

    private void shutdownTestPublisher(Publisher publisher) throws InterruptedException {
        publisher.shutdown();
        this.fakeExecutor.advanceTime(Duration.ofSeconds((long)10L));
        Assert.assertTrue((boolean)publisher.awaitTermination(1L, TimeUnit.MINUTES));
    }
}

