/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.cloud.pubsub.v1.SequentialExecutorService;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class SequentialExecutorServiceTest {
    private final ExecutorProvider executorProvider = InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(5 * Runtime.getRuntime().availableProcessors()).build();

    @Test
    public void testExecutorRunsNextTaskWhenPrevResponseReceived() throws Exception {
        SequentialExecutorService.CallbackExecutor sequentialExecutorService = new SequentialExecutorService.CallbackExecutor((Executor)this.executorProvider.getExecutor());
        AsyncTaskCallable callable1 = new AsyncTaskCallable();
        AsyncTaskCallable callable2 = new AsyncTaskCallable();
        AsyncTaskCallable callable3 = new AsyncTaskCallable();
        ApiFuture result1 = sequentialExecutorService.submit("key", (Callable)callable1);
        ApiFuture result2 = sequentialExecutorService.submit("key", (Callable)callable2);
        ApiFuture result3 = sequentialExecutorService.submit("key", (Callable)callable3);
        Thread.sleep(1000L);
        Assert.assertFalse((boolean)callable2.isCalled());
        Assert.assertFalse((boolean)callable3.isCalled());
        callable1.finish();
        Assert.assertEquals((Object)"ok", (Object)result1.get());
        Assert.assertFalse((boolean)callable3.isCalled());
        callable2.finish();
        Assert.assertEquals((Object)"ok", (Object)result2.get());
        callable3.finish();
        Assert.assertEquals((Object)"ok", (Object)result3.get());
    }

    @Test
    public void testExecutorRunsDifferentKeySimultaneously() throws Exception {
        SequentialExecutorService.CallbackExecutor sequentialExecutorService = new SequentialExecutorService.CallbackExecutor((Executor)this.executorProvider.getExecutor());
        AsyncTaskCallable callable1 = new AsyncTaskCallable();
        AsyncTaskCallable callable2 = new AsyncTaskCallable();
        AsyncTaskCallable callable3 = new AsyncTaskCallable();
        ApiFuture result1 = sequentialExecutorService.submit("key", (Callable)callable1);
        ApiFuture result2 = sequentialExecutorService.submit("key", (Callable)callable2);
        ApiFuture result3 = sequentialExecutorService.submit("key2", (Callable)callable3);
        callable3.finish();
        Assert.assertEquals((Object)"ok", (Object)result3.get());
        Thread.sleep(100L);
        Assert.assertFalse((boolean)callable2.isCalled());
        callable1.finish();
        Assert.assertEquals((Object)"ok", (Object)result1.get());
        callable2.finish();
        Assert.assertEquals((Object)"ok", (Object)result2.get());
    }

    @Test
    public void testExecutorCancelsAllTasksWhenOneFailed() throws Exception {
        SequentialExecutorService.CallbackExecutor sequentialExecutorService = new SequentialExecutorService.CallbackExecutor((Executor)this.executorProvider.getExecutor());
        AsyncTaskCallable callable1 = new AsyncTaskCallable();
        AsyncTaskCallable callable2 = new AsyncTaskCallable();
        AsyncTaskCallable callable3 = new AsyncTaskCallable();
        ApiFuture result1 = sequentialExecutorService.submit("key", (Callable)callable1);
        ApiFuture result2 = sequentialExecutorService.submit("key", (Callable)callable2);
        ApiFuture result3 = sequentialExecutorService.submit("key", (Callable)callable3);
        Exception failure = new Exception("failure");
        callable1.finishWithError(failure);
        try {
            result1.get();
            Assert.fail((String)"Should have thrown an ExecutionException");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((Object)failure, (Object)e.getCause());
        }
        for (ApiFuture result : ImmutableList.of((Object)result2, (Object)result3)) {
            try {
                result.get();
                Assert.fail((String)"Should have thrown an ExecutionException");
            }
            catch (ExecutionException e) {
                Truth.assertThat((Throwable)e.getCause()).isInstanceOf(CancellationException.class);
            }
        }
    }

    @Test
    public void SequentialExecutorRunsTasksAutomatically() throws Exception {
        int i;
        int numKeys = 50;
        int numTasks = 50;
        SequentialExecutorService.AutoExecutor sequentialExecutor = new SequentialExecutorService.AutoExecutor((Executor)this.executorProvider.getExecutor());
        CountDownLatch remainingTasksCount = new CountDownLatch(numKeys * numTasks);
        HashMap<String, LinkedHashSet<Integer>> startedTasks = new HashMap<String, LinkedHashSet<Integer>>();
        HashMap<String, LinkedHashSet<Integer>> completedTasks = new HashMap<String, LinkedHashSet<Integer>>();
        for (i = 0; i < numKeys; ++i) {
            String key = "key" + i;
            LinkedHashSet<Integer> startedTasksSequence = new LinkedHashSet<Integer>();
            LinkedHashSet<Integer> completedTasksSequence = new LinkedHashSet<Integer>();
            startedTasks.put(key, completedTasksSequence);
            completedTasks.put(key, completedTasksSequence);
            for (int taskId = 0; taskId < numTasks; ++taskId) {
                SleepingSyncTask task = new SleepingSyncTask(taskId, 5L, startedTasksSequence, completedTasksSequence, remainingTasksCount);
                sequentialExecutor.submit(key, (Runnable)task);
            }
        }
        remainingTasksCount.await();
        for (i = 0; i < numKeys; ++i) {
            LinkedHashSet startedTasksSequence = (LinkedHashSet)startedTasks.get("key" + i);
            LinkedHashSet completedTasksSequence = (LinkedHashSet)completedTasks.get("key" + i);
            int expectedTaskId = 0;
            Iterator it1 = startedTasksSequence.iterator();
            Iterator it2 = completedTasksSequence.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                Assert.assertEquals((long)expectedTaskId, (long)((Integer)it1.next()).intValue());
                Assert.assertEquals((long)expectedTaskId, (long)((Integer)it2.next()).intValue());
                ++expectedTaskId;
            }
        }
    }

    static class SleepingSyncTask
    implements Runnable {
        private final int taskId;
        private final long taskDurationMillis;
        private final LinkedHashSet<Integer> startedTasksSequence;
        private final LinkedHashSet<Integer> completedTasksSequence;
        private final CountDownLatch remainingTasksCount;

        public SleepingSyncTask(int taskId, long taskDurationMillis, LinkedHashSet<Integer> startedTasksSequence, LinkedHashSet<Integer> completedTasksSequence, CountDownLatch remainingTasksCount) {
            this.taskId = taskId;
            this.taskDurationMillis = taskDurationMillis;
            this.startedTasksSequence = startedTasksSequence;
            this.completedTasksSequence = completedTasksSequence;
            this.remainingTasksCount = remainingTasksCount;
        }

        @Override
        public void run() {
            if (this.taskId > 0) {
                Assert.assertTrue((boolean)this.startedTasksSequence.contains(this.taskId - 1));
                Assert.assertTrue((boolean)this.completedTasksSequence.contains(this.taskId - 1));
            }
            this.startedTasksSequence.add(this.taskId);
            try {
                Thread.sleep(this.taskDurationMillis);
            }
            catch (InterruptedException e) {
                return;
            }
            this.completedTasksSequence.add(this.taskId);
            this.remainingTasksCount.countDown();
            Assert.assertFalse((boolean)this.startedTasksSequence.contains(this.taskId + 1));
            Assert.assertFalse((boolean)this.completedTasksSequence.contains(this.taskId + 1));
        }
    }

    static class AsyncTaskCallable
    implements Callable<ApiFuture<String>> {
        boolean isCalled = false;
        SettableApiFuture<String> result = SettableApiFuture.create();

        AsyncTaskCallable() {
        }

        @Override
        public ApiFuture<String> call() {
            this.isCalled = true;
            return this.result;
        }

        public boolean isCalled() {
            return this.isCalled;
        }

        public void finishWithError(Throwable e) {
            this.result.setException(e);
        }

        public void finish() {
            this.result.set((Object)"ok");
        }
    }
}

