/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.OpenCensusUtil;
import com.google.common.base.Stopwatch;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import io.opencensus.common.Scope;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.Tags;
import io.opencensus.trace.Link;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.RunningSpanStore;
import io.opencensus.trace.export.SpanData;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class OpenCensusUtilTest {
    private static final Tagger tagger = Tags.getTagger();
    private static final Tracer tracer = Tracing.getTracer();
    private static final TagKey TEST_TAG_KEY = TagKey.create((String)"TEST_TAG_KEY");
    private static final TagValue TEST_TAG_VAL = TagValue.create((String)"TEST_TAG_VAL");
    private static final String TEST_PARENT_LINK_NAME = "TEST_PARENT_LINK";

    @BeforeClass
    public static void configureOpenCensus() {
        Tracing.getExportComponent().getRunningSpanStore().setMaxNumberOfSpans(5);
    }

    @Test
    public void testOpenCensusMessageReceiver() {
        SpanContext publisherContext;
        PubsubMessage message;
        try (Scope traceScope = OpenCensusUtil.createScopedSpan((String)TEST_PARENT_LINK_NAME);
             Scope tagScope = OpenCensusUtilTest.createScopeTags();){
            message = (PubsubMessage)OpenCensusUtil.OPEN_CENSUS_MESSAGE_TRANSFORM.apply((Object)OpenCensusUtilTest.generatePubsubMessage(500));
            publisherContext = tracer.getCurrentSpan().getContext();
        }
        OpenCensusUtil.OpenCensusMessageReceiver receiver = new OpenCensusUtil.OpenCensusMessageReceiver((MessageReceiver)new TestMessageReceiver(publisherContext, tagger.getCurrentTagContext()));
        receiver.receiveMessage(message, (AckReplyConsumer)new NoOpAckReplyConsumer());
    }

    @Test
    public void testOpenCensusMessageTransformer() {
        try (Scope traceScope = OpenCensusUtil.createScopedSpan((String)"PublisherTestRoot");
             Scope tagScope = OpenCensusUtilTest.createScopeTags();){
            PubsubMessage originalMessage = OpenCensusUtilTest.generatePubsubMessage(500);
            Assert.assertEquals((Object)"", (Object)originalMessage.getAttributesOrDefault("googclient_OpenCensusTraceContextKey", ""));
            Assert.assertEquals((Object)"", (Object)originalMessage.getAttributesOrDefault("googclient_OpenCensusTagContextKey", ""));
            PubsubMessage attributedMessage = (PubsubMessage)OpenCensusUtil.OPEN_CENSUS_MESSAGE_TRANSFORM.apply((Object)originalMessage);
            String encodedSpanContext = OpenCensusUtil.encodeSpanContext((SpanContext)tracer.getCurrentSpan().getContext());
            Assert.assertNotEquals((Object)"", (Object)encodedSpanContext);
            Assert.assertEquals((Object)encodedSpanContext, (Object)attributedMessage.getAttributesOrDefault("googclient_OpenCensusTraceContextKey", ""));
            Assert.assertEquals((Object)"", (Object)attributedMessage.getAttributesOrDefault("googclient_OpenCensusTagContextKey", ""));
        }
    }

    private static PubsubMessage generatePubsubMessage(int size) {
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = (byte)(120 + i % 20);
        }
        return PubsubMessage.newBuilder().setData(ByteString.copyFrom((byte[])bytes)).build();
    }

    private static Scope createScopeTags() {
        return tagger.currentBuilder().put(TEST_TAG_KEY, TEST_TAG_VAL).buildScoped();
    }

    private static final class TestMessageReceiver
    implements MessageReceiver {
        private static final RunningSpanStore runningSpanStore = Tracing.getExportComponent().getRunningSpanStore();
        private static final RunningSpanStore.Filter RECEIVER_FILTER = RunningSpanStore.Filter.create((String)"OpenCensusMessageReceiver", (int)0);
        SpanContext parentLinkedSpan;
        TagContext originalTagContext;

        private TestMessageReceiver(SpanContext parentLinkedSpan, TagContext originalTagContext) {
            this.parentLinkedSpan = parentLinkedSpan;
            this.originalTagContext = originalTagContext;
        }

        public void receiveMessage(PubsubMessage message, AckReplyConsumer consumer) {
            Assert.assertEquals((Object)this.originalTagContext, (Object)tagger.getCurrentTagContext());
            this.assertSpanCount(1);
            Collection spanDatas = runningSpanStore.getRunningSpans(RECEIVER_FILTER);
            for (SpanData spanData : spanDatas) {
                List links = spanData.getLinks().getLinks();
                Assert.assertEquals((long)links.size(), (long)1L);
                Link link = (Link)links.get(0);
                Assert.assertEquals((Object)Link.Type.PARENT_LINKED_SPAN, (Object)link.getType());
                Assert.assertEquals((Object)this.parentLinkedSpan.getTraceId(), (Object)link.getTraceId());
                Assert.assertEquals((Object)this.parentLinkedSpan.getSpanId(), (Object)link.getSpanId());
            }
            consumer.ack();
        }

        private void assertSpanCount(int expected) {
            Collection spanDatas;
            Stopwatch watch = Stopwatch.createStarted();
            while ((spanDatas = runningSpanStore.getRunningSpans(RECEIVER_FILTER)).size() != expected) {
                Thread.yield();
                if (watch.elapsed(TimeUnit.SECONDS) < 5L) continue;
                Assert.fail((String)"failed to get spans in 5 seconds");
            }
        }
    }

    private static final class NoOpAckReplyConsumer
    implements AckReplyConsumer {
        private NoOpAckReplyConsumer() {
        }

        public void ack() {
        }

        public void nack() {
        }
    }
}

