/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.cloud.pubsub.v1.OpenTelemetryPubsubTracer;
import com.google.cloud.pubsub.v1.PubsubMessageWrapper;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.SubscriptionName;
import com.google.pubsub.v1.TopicName;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.testing.assertj.AttributesAssert;
import io.opentelemetry.sdk.testing.assertj.EventDataAssert;
import io.opentelemetry.sdk.testing.assertj.OpenTelemetryAssertions;
import io.opentelemetry.sdk.testing.assertj.SpanDataAssert;
import io.opentelemetry.sdk.testing.junit4.OpenTelemetryRule;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class OpenTelemetryTest {
    private static final TopicName FULL_TOPIC_NAME = TopicName.parse((String)"projects/test-project/topics/test-topic");
    private static final SubscriptionName FULL_SUBSCRIPTION_NAME = SubscriptionName.parse((String)"projects/test-project/subscriptions/test-sub");
    private static final String PROJECT_NAME = "test-project";
    private static final String ORDERING_KEY = "abc";
    private static final String MESSAGE_ID = "m0";
    private static final String ACK_ID = "def";
    private static final int DELIVERY_ATTEMPT = 1;
    private static final int ACK_DEADLINE = 10;
    private static final boolean EXACTLY_ONCE_ENABLED = true;
    private static final String PUBLISHER_SPAN_NAME = FULL_TOPIC_NAME.getTopic() + " create";
    private static final String PUBLISH_FLOW_CONTROL_SPAN_NAME = "publisher flow control";
    private static final String PUBLISH_BATCHING_SPAN_NAME = "publisher batching";
    private static final String PUBLISH_RPC_SPAN_NAME = FULL_TOPIC_NAME.getTopic() + " publish";
    private static final String PUBLISH_START_EVENT = "publish start";
    private static final String PUBLISH_END_EVENT = "publish end";
    private static final String SUBSCRIBER_SPAN_NAME = FULL_SUBSCRIPTION_NAME.getSubscription() + " subscribe";
    private static final String SUBSCRIBE_CONCURRENCY_CONTROL_SPAN_NAME = "subscriber concurrency control";
    private static final String SUBSCRIBE_SCHEDULER_SPAN_NAME = "subscriber scheduler";
    private static final String SUBSCRIBE_PROCESS_SPAN_NAME = FULL_SUBSCRIPTION_NAME.getSubscription() + " process";
    private static final String SUBSCRIBE_MODACK_RPC_SPAN_NAME = FULL_SUBSCRIPTION_NAME.getSubscription() + " modack";
    private static final String SUBSCRIBE_ACK_RPC_SPAN_NAME = FULL_SUBSCRIPTION_NAME.getSubscription() + " ack";
    private static final String SUBSCRIBE_NACK_RPC_SPAN_NAME = FULL_SUBSCRIPTION_NAME.getSubscription() + " nack";
    private static final String PROCESS_ACTION = "ack";
    private static final String MODACK_START_EVENT = "modack start";
    private static final String MODACK_END_EVENT = "modack end";
    private static final String NACK_START_EVENT = "nack start";
    private static final String NACK_END_EVENT = "nack end";
    private static final String ACK_START_EVENT = "ack start";
    private static final String ACK_END_EVENT = "ack end";
    private static final String MESSAGING_SYSTEM_VALUE = "gcp_pubsub";
    private static final String PROJECT_ATTR_KEY = "gcp.project_id";
    private static final String MESSAGE_SIZE_ATTR_KEY = "messaging.message.body.size";
    private static final String ORDERING_KEY_ATTR_KEY = "messaging.gcp_pubsub.message.ordering_key";
    private static final String ACK_DEADLINE_ATTR_KEY = "messaging.gcp_pubsub.message.ack_deadline";
    private static final String RECEIPT_MODACK_ATTR_KEY = "messaging.gcp_pubsub.is_receipt_modack";
    private static final String MESSAGE_ACK_ID_ATTR_KEY = "messaging.gcp_pubsub.message.ack_id";
    private static final String MESSAGE_EXACTLY_ONCE_ATTR_KEY = "messaging.gcp_pubsub.message.exactly_once_delivery";
    private static final String MESSAGE_RESULT_ATTR_KEY = "messaging.gcp_pubsub.result";
    private static final String MESSAGE_DELIVERY_ATTEMPT_ATTR_KEY = "messaging.gcp_pubsub.message.delivery_attempt";
    private static final String TRACEPARENT_ATTRIBUTE = "googclient_traceparent";
    private static final OpenTelemetryRule openTelemetryTesting = OpenTelemetryRule.create();

    @Test
    public void testPublishSpansSuccess() {
        openTelemetryTesting.clearSpans();
        PubsubMessageWrapper messageWrapper = PubsubMessageWrapper.newBuilder((PubsubMessage)this.getPubsubMessage(), (TopicName)FULL_TOPIC_NAME).build();
        List<PubsubMessageWrapper> messageWrappers = Arrays.asList(messageWrapper);
        long messageSize = messageWrapper.getPubsubMessage().getData().size();
        Tracer openTelemetryTracer = openTelemetryTesting.getOpenTelemetry().getTracer("test");
        OpenTelemetryPubsubTracer tracer = new OpenTelemetryPubsubTracer(openTelemetryTracer, true);
        tracer.startPublisherSpan(messageWrapper);
        tracer.startPublishFlowControlSpan(messageWrapper);
        tracer.endPublishFlowControlSpan(messageWrapper);
        tracer.startPublishBatchingSpan(messageWrapper);
        tracer.endPublishBatchingSpan(messageWrapper);
        Span publishRpcSpan = tracer.startPublishRpcSpan(FULL_TOPIC_NAME, messageWrappers);
        tracer.endPublishRpcSpan(publishRpcSpan);
        tracer.setPublisherMessageIdSpanAttribute(messageWrapper, MESSAGE_ID);
        tracer.endPublisherSpan(messageWrapper);
        List allSpans = openTelemetryTesting.getSpans();
        Assert.assertEquals((long)4L, (long)allSpans.size());
        SpanData flowControlSpanData = (SpanData)allSpans.get(0);
        SpanData batchingSpanData = (SpanData)allSpans.get(1);
        SpanData publishRpcSpanData = (SpanData)allSpans.get(2);
        SpanData publisherSpanData = (SpanData)allSpans.get(3);
        SpanDataAssert flowControlSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)flowControlSpanData);
        flowControlSpanDataAssert.hasName(PUBLISH_FLOW_CONTROL_SPAN_NAME).hasParent(publisherSpanData).hasEnded();
        SpanDataAssert batchingSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)batchingSpanData);
        batchingSpanDataAssert.hasName(PUBLISH_BATCHING_SPAN_NAME).hasParent(publisherSpanData).hasEnded();
        SpanDataAssert publishRpcSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)publishRpcSpanData);
        publishRpcSpanDataAssert.hasName(PUBLISH_RPC_SPAN_NAME).hasKind(SpanKind.CLIENT).hasNoParent().hasEnded();
        List publishRpcLinks = publishRpcSpanData.getLinks();
        Assert.assertEquals((long)messageWrappers.size(), (long)publishRpcLinks.size());
        Assert.assertEquals((Object)publisherSpanData.getSpanContext(), (Object)((LinkData)publishRpcLinks.get(0)).getSpanContext());
        Assert.assertEquals((long)6L, (long)publishRpcSpanData.getAttributes().size());
        AttributesAssert publishRpcSpanAttributesAssert = OpenTelemetryAssertions.assertThat((Attributes)publishRpcSpanData.getAttributes());
        publishRpcSpanAttributesAssert.containsEntry(SemanticAttributes.MESSAGING_SYSTEM, (Object)MESSAGING_SYSTEM_VALUE).containsEntry(SemanticAttributes.MESSAGING_DESTINATION_NAME, (Object)FULL_TOPIC_NAME.getTopic()).containsEntry(PROJECT_ATTR_KEY, FULL_TOPIC_NAME.getProject()).containsEntry(SemanticAttributes.CODE_FUNCTION, (Object)"publishCall").containsEntry(SemanticAttributes.MESSAGING_OPERATION, (Object)"publish").containsEntry(SemanticAttributes.MESSAGING_BATCH_MESSAGE_COUNT, messageWrappers.size());
        SpanDataAssert publisherSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)publisherSpanData);
        publisherSpanDataAssert.hasName(PUBLISHER_SPAN_NAME).hasKind(SpanKind.PRODUCER).hasNoParent().hasEnded();
        Assert.assertEquals((long)2L, (long)publisherSpanData.getEvents().size());
        EventDataAssert startEventAssert = OpenTelemetryAssertions.assertThat((EventData)((EventData)publisherSpanData.getEvents().get(0)));
        startEventAssert.hasName(PUBLISH_START_EVENT);
        EventDataAssert endEventAssert = OpenTelemetryAssertions.assertThat((EventData)((EventData)publisherSpanData.getEvents().get(1)));
        endEventAssert.hasName(PUBLISH_END_EVENT);
        List publisherLinks = publisherSpanData.getLinks();
        Assert.assertEquals((long)1L, (long)publisherLinks.size());
        Assert.assertEquals((Object)publishRpcSpanData.getSpanContext(), (Object)((LinkData)publisherLinks.get(0)).getSpanContext());
        Assert.assertEquals((long)8L, (long)publisherSpanData.getAttributes().size());
        AttributesAssert publisherSpanAttributesAssert = OpenTelemetryAssertions.assertThat((Attributes)publisherSpanData.getAttributes());
        publisherSpanAttributesAssert.containsEntry(SemanticAttributes.MESSAGING_SYSTEM, (Object)MESSAGING_SYSTEM_VALUE).containsEntry(SemanticAttributes.MESSAGING_DESTINATION_NAME, (Object)FULL_TOPIC_NAME.getTopic()).containsEntry(PROJECT_ATTR_KEY, PROJECT_NAME).containsEntry(SemanticAttributes.CODE_FUNCTION, (Object)"publish").containsEntry(SemanticAttributes.MESSAGING_OPERATION, (Object)"create").containsEntry(ORDERING_KEY_ATTR_KEY, ORDERING_KEY).containsEntry(MESSAGE_SIZE_ATTR_KEY, messageSize).containsEntry(SemanticAttributes.MESSAGING_MESSAGE_ID, (Object)MESSAGE_ID);
        PubsubMessage message = messageWrapper.getPubsubMessage();
        Assert.assertEquals((long)1L, (long)message.getAttributesMap().size());
        Assert.assertTrue((boolean)message.containsAttributes(TRACEPARENT_ATTRIBUTE));
        Assert.assertTrue((boolean)message.getAttributesOrDefault(TRACEPARENT_ATTRIBUTE, "").contains(publisherSpanData.getTraceId()));
        Assert.assertTrue((boolean)message.getAttributesOrDefault(TRACEPARENT_ATTRIBUTE, "").contains(publisherSpanData.getSpanId()));
    }

    @Test
    public void testPublishFlowControlSpanFailure() {
        openTelemetryTesting.clearSpans();
        PubsubMessageWrapper messageWrapper = PubsubMessageWrapper.newBuilder((PubsubMessage)this.getPubsubMessage(), (TopicName)FULL_TOPIC_NAME).build();
        Tracer openTelemetryTracer = openTelemetryTesting.getOpenTelemetry().getTracer("test");
        OpenTelemetryPubsubTracer tracer = new OpenTelemetryPubsubTracer(openTelemetryTracer, true);
        tracer.startPublisherSpan(messageWrapper);
        tracer.startPublishFlowControlSpan(messageWrapper);
        Exception e = new Exception("test-exception");
        tracer.setPublishFlowControlSpanException(messageWrapper, (Throwable)e);
        List allSpans = openTelemetryTesting.getSpans();
        Assert.assertEquals((long)2L, (long)allSpans.size());
        SpanData flowControlSpanData = (SpanData)allSpans.get(0);
        SpanData publisherSpanData = (SpanData)allSpans.get(1);
        SpanDataAssert flowControlSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)flowControlSpanData);
        StatusData expectedStatus = StatusData.create((StatusCode)StatusCode.ERROR, (String)"Exception thrown during publish flow control.");
        flowControlSpanDataAssert.hasName(PUBLISH_FLOW_CONTROL_SPAN_NAME).hasParent(publisherSpanData).hasStatus(expectedStatus).hasException((Throwable)e).hasEnded();
        SpanDataAssert publisherSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)publisherSpanData);
        publisherSpanDataAssert.hasName(PUBLISHER_SPAN_NAME).hasKind(SpanKind.PRODUCER).hasNoParent().hasEnded();
    }

    @Test
    public void testPublishRpcSpanFailure() {
        openTelemetryTesting.clearSpans();
        PubsubMessageWrapper messageWrapper = PubsubMessageWrapper.newBuilder((PubsubMessage)this.getPubsubMessage(), (TopicName)FULL_TOPIC_NAME).build();
        List<PubsubMessageWrapper> messageWrappers = Arrays.asList(messageWrapper);
        Tracer openTelemetryTracer = openTelemetryTesting.getOpenTelemetry().getTracer("test");
        OpenTelemetryPubsubTracer tracer = new OpenTelemetryPubsubTracer(openTelemetryTracer, true);
        tracer.startPublisherSpan(messageWrapper);
        Span publishRpcSpan = tracer.startPublishRpcSpan(FULL_TOPIC_NAME, messageWrappers);
        Exception e = new Exception("test-exception");
        tracer.setPublishRpcSpanException(publishRpcSpan, (Throwable)e);
        tracer.endPublisherSpan(messageWrapper);
        List allSpans = openTelemetryTesting.getSpans();
        Assert.assertEquals((long)2L, (long)allSpans.size());
        SpanData rpcSpanData = (SpanData)allSpans.get(0);
        SpanData publisherSpanData = (SpanData)allSpans.get(1);
        SpanDataAssert rpcSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)rpcSpanData);
        StatusData expectedStatus = StatusData.create((StatusCode)StatusCode.ERROR, (String)"Exception thrown on publish RPC.");
        rpcSpanDataAssert.hasName(PUBLISH_RPC_SPAN_NAME).hasKind(SpanKind.CLIENT).hasStatus(expectedStatus).hasException((Throwable)e).hasEnded();
        SpanDataAssert publisherSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)publisherSpanData);
        publisherSpanDataAssert.hasName(PUBLISHER_SPAN_NAME).hasKind(SpanKind.PRODUCER).hasNoParent().hasEnded();
    }

    @Test
    public void testSubscribeSpansSuccess() {
        openTelemetryTesting.clearSpans();
        Tracer openTelemetryTracer = openTelemetryTesting.getOpenTelemetry().getTracer("test");
        OpenTelemetryPubsubTracer tracer = new OpenTelemetryPubsubTracer(openTelemetryTracer, true);
        PubsubMessageWrapper publishMessageWrapper = PubsubMessageWrapper.newBuilder((PubsubMessage)this.getPubsubMessage(), (TopicName)FULL_TOPIC_NAME).build();
        tracer.startPublisherSpan(publishMessageWrapper);
        tracer.endPublisherSpan(publishMessageWrapper);
        PubsubMessage publishedMessage = publishMessageWrapper.getPubsubMessage().toBuilder().setMessageId(MESSAGE_ID).build();
        PubsubMessageWrapper subscribeMessageWrapper = PubsubMessageWrapper.newBuilder((PubsubMessage)publishedMessage, (SubscriptionName)FULL_SUBSCRIPTION_NAME, (String)ACK_ID, (int)1).build();
        List<PubsubMessageWrapper> subscribeMessageWrappers = Arrays.asList(subscribeMessageWrapper);
        long messageSize = subscribeMessageWrapper.getPubsubMessage().getData().size();
        tracer.startSubscriberSpan(subscribeMessageWrapper, true);
        tracer.startSubscribeConcurrencyControlSpan(subscribeMessageWrapper);
        tracer.endSubscribeConcurrencyControlSpan(subscribeMessageWrapper);
        tracer.startSubscribeSchedulerSpan(subscribeMessageWrapper);
        tracer.endSubscribeSchedulerSpan(subscribeMessageWrapper);
        tracer.startSubscribeProcessSpan(subscribeMessageWrapper);
        tracer.endSubscribeProcessSpan(subscribeMessageWrapper, PROCESS_ACTION);
        Span subscribeModackRpcSpan = tracer.startSubscribeRpcSpan(FULL_SUBSCRIPTION_NAME, "modack", subscribeMessageWrappers, 10, true);
        tracer.endSubscribeRpcSpan(subscribeModackRpcSpan);
        tracer.addEndRpcEvent(subscribeMessageWrapper, true, true, 10);
        Span subscribeAckRpcSpan = tracer.startSubscribeRpcSpan(FULL_SUBSCRIPTION_NAME, PROCESS_ACTION, subscribeMessageWrappers, 0, false);
        tracer.endSubscribeRpcSpan(subscribeAckRpcSpan);
        tracer.addEndRpcEvent(subscribeMessageWrapper, true, false, 0);
        Span subscribeNackRpcSpan = tracer.startSubscribeRpcSpan(FULL_SUBSCRIPTION_NAME, "nack", subscribeMessageWrappers, 0, false);
        tracer.endSubscribeRpcSpan(subscribeNackRpcSpan);
        tracer.addEndRpcEvent(subscribeMessageWrapper, true, true, 0);
        tracer.endSubscriberSpan(subscribeMessageWrapper);
        List allSpans = openTelemetryTesting.getSpans();
        Assert.assertEquals((long)8L, (long)allSpans.size());
        SpanData publisherSpanData = (SpanData)allSpans.get(0);
        SpanData concurrencyControlSpanData = (SpanData)allSpans.get(1);
        SpanData schedulerSpanData = (SpanData)allSpans.get(2);
        SpanData processSpanData = (SpanData)allSpans.get(3);
        SpanData modackRpcSpanData = (SpanData)allSpans.get(4);
        SpanData ackRpcSpanData = (SpanData)allSpans.get(5);
        SpanData nackRpcSpanData = (SpanData)allSpans.get(6);
        SpanData subscriberSpanData = (SpanData)allSpans.get(7);
        SpanDataAssert concurrencyControlSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)concurrencyControlSpanData);
        concurrencyControlSpanDataAssert.hasName(SUBSCRIBE_CONCURRENCY_CONTROL_SPAN_NAME).hasParent(subscriberSpanData).hasEnded();
        SpanDataAssert schedulerSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)schedulerSpanData);
        schedulerSpanDataAssert.hasName(SUBSCRIBE_SCHEDULER_SPAN_NAME).hasParent(subscriberSpanData).hasEnded();
        SpanDataAssert processSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)processSpanData);
        processSpanDataAssert.hasName(SUBSCRIBE_PROCESS_SPAN_NAME).hasParent(subscriberSpanData).hasEnded();
        Assert.assertEquals((long)1L, (long)processSpanData.getEvents().size());
        EventDataAssert actionCalledEventAssert = OpenTelemetryAssertions.assertThat((EventData)((EventData)processSpanData.getEvents().get(0)));
        actionCalledEventAssert.hasName("ack called");
        SpanDataAssert modackRpcSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)modackRpcSpanData);
        modackRpcSpanDataAssert.hasName(SUBSCRIBE_MODACK_RPC_SPAN_NAME).hasKind(SpanKind.CLIENT).hasNoParent().hasEnded();
        List modackRpcLinks = modackRpcSpanData.getLinks();
        Assert.assertEquals((long)subscribeMessageWrappers.size(), (long)modackRpcLinks.size());
        Assert.assertEquals((Object)subscriberSpanData.getSpanContext(), (Object)((LinkData)modackRpcLinks.get(0)).getSpanContext());
        Assert.assertEquals((long)8L, (long)modackRpcSpanData.getAttributes().size());
        AttributesAssert modackRpcSpanAttributesAssert = OpenTelemetryAssertions.assertThat((Attributes)modackRpcSpanData.getAttributes());
        modackRpcSpanAttributesAssert.containsEntry(SemanticAttributes.MESSAGING_SYSTEM, (Object)MESSAGING_SYSTEM_VALUE).containsEntry(SemanticAttributes.MESSAGING_DESTINATION_NAME, (Object)FULL_SUBSCRIPTION_NAME.getSubscription()).containsEntry(PROJECT_ATTR_KEY, FULL_TOPIC_NAME.getProject()).containsEntry(SemanticAttributes.CODE_FUNCTION, (Object)"sendModAckOperations").containsEntry(SemanticAttributes.MESSAGING_OPERATION, (Object)"modack").containsEntry(SemanticAttributes.MESSAGING_BATCH_MESSAGE_COUNT, subscribeMessageWrappers.size()).containsEntry(ACK_DEADLINE_ATTR_KEY, 10L).containsEntry(RECEIPT_MODACK_ATTR_KEY, true);
        SpanDataAssert ackRpcSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)ackRpcSpanData);
        ackRpcSpanDataAssert.hasName(SUBSCRIBE_ACK_RPC_SPAN_NAME).hasKind(SpanKind.CLIENT).hasNoParent().hasEnded();
        List ackRpcLinks = ackRpcSpanData.getLinks();
        Assert.assertEquals((long)subscribeMessageWrappers.size(), (long)ackRpcLinks.size());
        Assert.assertEquals((Object)subscriberSpanData.getSpanContext(), (Object)((LinkData)ackRpcLinks.get(0)).getSpanContext());
        Assert.assertEquals((long)6L, (long)ackRpcSpanData.getAttributes().size());
        AttributesAssert ackRpcSpanAttributesAssert = OpenTelemetryAssertions.assertThat((Attributes)ackRpcSpanData.getAttributes());
        ackRpcSpanAttributesAssert.containsEntry(SemanticAttributes.MESSAGING_SYSTEM, (Object)MESSAGING_SYSTEM_VALUE).containsEntry(SemanticAttributes.MESSAGING_DESTINATION_NAME, (Object)FULL_SUBSCRIPTION_NAME.getSubscription()).containsEntry(PROJECT_ATTR_KEY, FULL_TOPIC_NAME.getProject()).containsEntry(SemanticAttributes.CODE_FUNCTION, (Object)"sendAckOperations").containsEntry(SemanticAttributes.MESSAGING_OPERATION, (Object)PROCESS_ACTION).containsEntry(SemanticAttributes.MESSAGING_BATCH_MESSAGE_COUNT, subscribeMessageWrappers.size());
        SpanDataAssert nackRpcSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)nackRpcSpanData);
        nackRpcSpanDataAssert.hasName(SUBSCRIBE_NACK_RPC_SPAN_NAME).hasKind(SpanKind.CLIENT).hasNoParent().hasEnded();
        List nackRpcLinks = nackRpcSpanData.getLinks();
        Assert.assertEquals((long)subscribeMessageWrappers.size(), (long)nackRpcLinks.size());
        Assert.assertEquals((Object)subscriberSpanData.getSpanContext(), (Object)((LinkData)nackRpcLinks.get(0)).getSpanContext());
        Assert.assertEquals((long)6L, (long)nackRpcSpanData.getAttributes().size());
        AttributesAssert nackRpcSpanAttributesAssert = OpenTelemetryAssertions.assertThat((Attributes)nackRpcSpanData.getAttributes());
        nackRpcSpanAttributesAssert.containsEntry(SemanticAttributes.MESSAGING_SYSTEM, (Object)MESSAGING_SYSTEM_VALUE).containsEntry(SemanticAttributes.MESSAGING_DESTINATION_NAME, (Object)FULL_SUBSCRIPTION_NAME.getSubscription()).containsEntry(PROJECT_ATTR_KEY, FULL_TOPIC_NAME.getProject()).containsEntry(SemanticAttributes.CODE_FUNCTION, (Object)"sendModAckOperations").containsEntry(SemanticAttributes.MESSAGING_OPERATION, (Object)"nack").containsEntry(SemanticAttributes.MESSAGING_BATCH_MESSAGE_COUNT, subscribeMessageWrappers.size());
        SpanDataAssert subscriberSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)subscriberSpanData);
        subscriberSpanDataAssert.hasName(SUBSCRIBER_SPAN_NAME).hasKind(SpanKind.CONSUMER).hasParent(publisherSpanData).hasEnded();
        Assert.assertEquals((long)6L, (long)subscriberSpanData.getEvents().size());
        EventDataAssert startModackEventAssert = OpenTelemetryAssertions.assertThat((EventData)((EventData)subscriberSpanData.getEvents().get(0)));
        startModackEventAssert.hasName(MODACK_START_EVENT);
        EventDataAssert endModackEventAssert = OpenTelemetryAssertions.assertThat((EventData)((EventData)subscriberSpanData.getEvents().get(1)));
        endModackEventAssert.hasName(MODACK_END_EVENT);
        EventDataAssert startAckEventAssert = OpenTelemetryAssertions.assertThat((EventData)((EventData)subscriberSpanData.getEvents().get(2)));
        startAckEventAssert.hasName(ACK_START_EVENT);
        EventDataAssert endAckEventAssert = OpenTelemetryAssertions.assertThat((EventData)((EventData)subscriberSpanData.getEvents().get(3)));
        endAckEventAssert.hasName(ACK_END_EVENT);
        EventDataAssert startNackEventAssert = OpenTelemetryAssertions.assertThat((EventData)((EventData)subscriberSpanData.getEvents().get(4)));
        startNackEventAssert.hasName(NACK_START_EVENT);
        EventDataAssert endNackEventAssert = OpenTelemetryAssertions.assertThat((EventData)((EventData)subscriberSpanData.getEvents().get(5)));
        endNackEventAssert.hasName(NACK_END_EVENT);
        List subscriberLinks = subscriberSpanData.getLinks();
        Assert.assertEquals((long)3L, (long)subscriberLinks.size());
        Assert.assertEquals((Object)modackRpcSpanData.getSpanContext(), (Object)((LinkData)subscriberLinks.get(0)).getSpanContext());
        Assert.assertEquals((Object)ackRpcSpanData.getSpanContext(), (Object)((LinkData)subscriberLinks.get(1)).getSpanContext());
        Assert.assertEquals((Object)nackRpcSpanData.getSpanContext(), (Object)((LinkData)subscriberLinks.get(2)).getSpanContext());
        Assert.assertEquals((long)11L, (long)subscriberSpanData.getAttributes().size());
        AttributesAssert subscriberSpanAttributesAssert = OpenTelemetryAssertions.assertThat((Attributes)subscriberSpanData.getAttributes());
        subscriberSpanAttributesAssert.containsEntry(SemanticAttributes.MESSAGING_SYSTEM, (Object)MESSAGING_SYSTEM_VALUE).containsEntry(SemanticAttributes.MESSAGING_DESTINATION_NAME, (Object)FULL_SUBSCRIPTION_NAME.getSubscription()).containsEntry(PROJECT_ATTR_KEY, PROJECT_NAME).containsEntry(SemanticAttributes.CODE_FUNCTION, (Object)"onResponse").containsEntry(MESSAGE_SIZE_ATTR_KEY, messageSize).containsEntry(ORDERING_KEY_ATTR_KEY, ORDERING_KEY).containsEntry(MESSAGE_ACK_ID_ATTR_KEY, ACK_ID).containsEntry(MESSAGE_DELIVERY_ATTEMPT_ATTR_KEY, 1L).containsEntry(MESSAGE_EXACTLY_ONCE_ATTR_KEY, true).containsEntry(MESSAGE_RESULT_ATTR_KEY, PROCESS_ACTION).containsEntry(SemanticAttributes.MESSAGING_MESSAGE_ID, (Object)MESSAGE_ID);
    }

    @Test
    public void testSubscribeConcurrencyControlSpanFailure() {
        openTelemetryTesting.clearSpans();
        PubsubMessageWrapper messageWrapper = PubsubMessageWrapper.newBuilder((PubsubMessage)this.getPubsubMessage(), (SubscriptionName)FULL_SUBSCRIPTION_NAME, (String)ACK_ID, (int)1).build();
        Tracer openTelemetryTracer = openTelemetryTesting.getOpenTelemetry().getTracer("test");
        OpenTelemetryPubsubTracer tracer = new OpenTelemetryPubsubTracer(openTelemetryTracer, true);
        tracer.startSubscriberSpan(messageWrapper, true);
        tracer.startSubscribeConcurrencyControlSpan(messageWrapper);
        Exception e = new Exception("test-exception");
        tracer.setSubscribeConcurrencyControlSpanException(messageWrapper, (Throwable)e);
        List allSpans = openTelemetryTesting.getSpans();
        Assert.assertEquals((long)2L, (long)allSpans.size());
        SpanData concurrencyControlSpanData = (SpanData)allSpans.get(0);
        SpanData subscriberSpanData = (SpanData)allSpans.get(1);
        SpanDataAssert concurrencyControlSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)concurrencyControlSpanData);
        StatusData expectedStatus = StatusData.create((StatusCode)StatusCode.ERROR, (String)"Exception thrown during subscribe concurrency control.");
        concurrencyControlSpanDataAssert.hasName(SUBSCRIBE_CONCURRENCY_CONTROL_SPAN_NAME).hasParent(subscriberSpanData).hasStatus(expectedStatus).hasException((Throwable)e).hasEnded();
        SpanDataAssert subscriberSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)subscriberSpanData);
        subscriberSpanDataAssert.hasName(SUBSCRIBER_SPAN_NAME).hasKind(SpanKind.CONSUMER).hasNoParent().hasEnded();
    }

    @Test
    public void testSubscriberSpanFailure() {
        openTelemetryTesting.clearSpans();
        PubsubMessageWrapper messageWrapper = PubsubMessageWrapper.newBuilder((PubsubMessage)this.getPubsubMessage(), (SubscriptionName)FULL_SUBSCRIPTION_NAME, (String)ACK_ID, (int)1).build();
        Tracer openTelemetryTracer = openTelemetryTesting.getOpenTelemetry().getTracer("test");
        OpenTelemetryPubsubTracer tracer = new OpenTelemetryPubsubTracer(openTelemetryTracer, true);
        tracer.startSubscriberSpan(messageWrapper, true);
        Exception e = new Exception("test-exception");
        tracer.setSubscriberSpanException(messageWrapper, (Throwable)e, "Test exception");
        List allSpans = openTelemetryTesting.getSpans();
        Assert.assertEquals((long)1L, (long)allSpans.size());
        SpanData subscriberSpanData = (SpanData)allSpans.get(0);
        StatusData expectedStatus = StatusData.create((StatusCode)StatusCode.ERROR, (String)"Test exception");
        SpanDataAssert subscriberSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)subscriberSpanData);
        subscriberSpanDataAssert.hasName(SUBSCRIBER_SPAN_NAME).hasKind(SpanKind.CONSUMER).hasNoParent().hasStatus(expectedStatus).hasException((Throwable)e).hasEnded();
    }

    @Test
    public void testSubscribeRpcSpanFailures() {
        openTelemetryTesting.clearSpans();
        PubsubMessageWrapper messageWrapper = PubsubMessageWrapper.newBuilder((PubsubMessage)this.getPubsubMessage(), (SubscriptionName)FULL_SUBSCRIPTION_NAME, (String)ACK_ID, (int)1).build();
        List<PubsubMessageWrapper> messageWrappers = Arrays.asList(messageWrapper);
        Tracer openTelemetryTracer = openTelemetryTesting.getOpenTelemetry().getTracer("test");
        OpenTelemetryPubsubTracer tracer = new OpenTelemetryPubsubTracer(openTelemetryTracer, true);
        tracer.startSubscriberSpan(messageWrapper, true);
        Span subscribeModackRpcSpan = tracer.startSubscribeRpcSpan(FULL_SUBSCRIPTION_NAME, "modack", messageWrappers, 10, true);
        Span subscribeAckRpcSpan = tracer.startSubscribeRpcSpan(FULL_SUBSCRIPTION_NAME, PROCESS_ACTION, messageWrappers, 0, false);
        Span subscribeNackRpcSpan = tracer.startSubscribeRpcSpan(FULL_SUBSCRIPTION_NAME, "nack", messageWrappers, 0, false);
        Exception e = new Exception("test-exception");
        tracer.setSubscribeRpcSpanException(subscribeModackRpcSpan, true, 10, (Throwable)e);
        tracer.setSubscribeRpcSpanException(subscribeAckRpcSpan, false, 0, (Throwable)e);
        tracer.setSubscribeRpcSpanException(subscribeNackRpcSpan, true, 0, (Throwable)e);
        tracer.endSubscriberSpan(messageWrapper);
        List allSpans = openTelemetryTesting.getSpans();
        Assert.assertEquals((long)4L, (long)allSpans.size());
        SpanData modackSpanData = (SpanData)allSpans.get(0);
        SpanData ackSpanData = (SpanData)allSpans.get(1);
        SpanData nackSpanData = (SpanData)allSpans.get(2);
        SpanData subscriberSpanData = (SpanData)allSpans.get(3);
        StatusData expectedModackStatus = StatusData.create((StatusCode)StatusCode.ERROR, (String)"Exception thrown on modack RPC.");
        SpanDataAssert modackSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)modackSpanData);
        modackSpanDataAssert.hasName(SUBSCRIBE_MODACK_RPC_SPAN_NAME).hasKind(SpanKind.CLIENT).hasNoParent().hasStatus(expectedModackStatus).hasException((Throwable)e).hasEnded();
        StatusData expectedAckStatus = StatusData.create((StatusCode)StatusCode.ERROR, (String)"Exception thrown on ack RPC.");
        SpanDataAssert ackSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)ackSpanData);
        ackSpanDataAssert.hasName(SUBSCRIBE_ACK_RPC_SPAN_NAME).hasKind(SpanKind.CLIENT).hasNoParent().hasStatus(expectedAckStatus).hasException((Throwable)e).hasEnded();
        StatusData expectedNackStatus = StatusData.create((StatusCode)StatusCode.ERROR, (String)"Exception thrown on nack RPC.");
        SpanDataAssert nackSpanDataAssert = OpenTelemetryAssertions.assertThat((SpanData)nackSpanData);
        nackSpanDataAssert.hasName(SUBSCRIBE_NACK_RPC_SPAN_NAME).hasKind(SpanKind.CLIENT).hasNoParent().hasStatus(expectedNackStatus).hasException((Throwable)e).hasEnded();
    }

    private PubsubMessage getPubsubMessage() {
        return PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"test-data")).setOrderingKey(ORDERING_KEY).build();
    }
}

