/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.pubsub.v1.SchemaServiceClient;
import com.google.cloud.pubsub.v1.SchemaServiceSettings;
import com.google.cloud.pubsub.v1.stub.HttpJsonSchemaServiceStub;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.GetPolicyOptions;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import com.google.pubsub.v1.Encoding;
import com.google.pubsub.v1.ListSchemaRevisionsResponse;
import com.google.pubsub.v1.ListSchemasResponse;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.Schema;
import com.google.pubsub.v1.SchemaName;
import com.google.pubsub.v1.ValidateMessageRequest;
import com.google.pubsub.v1.ValidateMessageResponse;
import com.google.pubsub.v1.ValidateSchemaResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SchemaServiceClientHttpJsonTest {
    private static MockHttpService mockService;
    private static SchemaServiceClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonSchemaServiceStub.getMethodDescriptors(), SchemaServiceSettings.getDefaultEndpoint());
        SchemaServiceSettings settings = ((SchemaServiceSettings.Builder)((SchemaServiceSettings.Builder)SchemaServiceSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)SchemaServiceSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = SchemaServiceClient.create((SchemaServiceSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void createSchemaTest() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        Schema schema = Schema.newBuilder().build();
        String schemaId = "schemaId-697673060";
        Schema actualResponse = client.createSchema(parent, schema, schemaId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSchemaExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            Schema schema = Schema.newBuilder().build();
            String schemaId = "schemaId-697673060";
            client.createSchema(parent, schema, schemaId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSchemaTest2() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-2353";
        Schema schema = Schema.newBuilder().build();
        String schemaId = "schemaId-697673060";
        Schema actualResponse = client.createSchema(parent, schema, schemaId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSchemaExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-2353";
            Schema schema = Schema.newBuilder().build();
            String schemaId = "schemaId-697673060";
            client.createSchema(parent, schema, schemaId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSchemaTest() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
        Schema actualResponse = client.getSchema(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSchemaExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
            client.getSchema(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSchemaTest2() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-5662/schemas/schema-5662";
        Schema actualResponse = client.getSchema(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSchemaExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-5662/schemas/schema-5662";
            client.getSchema(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSchemasTest() throws Exception {
        Schema responsesElement = Schema.newBuilder().build();
        ListSchemasResponse expectedResponse = ListSchemasResponse.newBuilder().setNextPageToken("").addAllSchemas(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        SchemaServiceClient.ListSchemasPagedResponse pagedListResponse = client.listSchemas(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSchemasList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSchemasExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            client.listSchemas(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSchemasTest2() throws Exception {
        Schema responsesElement = Schema.newBuilder().build();
        ListSchemasResponse expectedResponse = ListSchemasResponse.newBuilder().setNextPageToken("").addAllSchemas(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-2353";
        SchemaServiceClient.ListSchemasPagedResponse pagedListResponse = client.listSchemas(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSchemasList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSchemasExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-2353";
            client.listSchemas(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSchemaRevisionsTest() throws Exception {
        Schema responsesElement = Schema.newBuilder().build();
        ListSchemaRevisionsResponse expectedResponse = ListSchemaRevisionsResponse.newBuilder().setNextPageToken("").addAllSchemas(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
        SchemaServiceClient.ListSchemaRevisionsPagedResponse pagedListResponse = client.listSchemaRevisions(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSchemasList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSchemaRevisionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
            client.listSchemaRevisions(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSchemaRevisionsTest2() throws Exception {
        Schema responsesElement = Schema.newBuilder().build();
        ListSchemaRevisionsResponse expectedResponse = ListSchemaRevisionsResponse.newBuilder().setNextPageToken("").addAllSchemas(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-5662/schemas/schema-5662";
        SchemaServiceClient.ListSchemaRevisionsPagedResponse pagedListResponse = client.listSchemaRevisions(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSchemasList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSchemaRevisionsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-5662/schemas/schema-5662";
            client.listSchemaRevisions(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void commitSchemaTest() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
        Schema schema = Schema.newBuilder().build();
        Schema actualResponse = client.commitSchema(name, schema);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void commitSchemaExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
            Schema schema = Schema.newBuilder().build();
            client.commitSchema(name, schema);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void commitSchemaTest2() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-5662/schemas/schema-5662";
        Schema schema = Schema.newBuilder().build();
        Schema actualResponse = client.commitSchema(name, schema);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void commitSchemaExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-5662/schemas/schema-5662";
            Schema schema = Schema.newBuilder().build();
            client.commitSchema(name, schema);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void rollbackSchemaTest() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
        String revisionId = "revisionId-1507445162";
        Schema actualResponse = client.rollbackSchema(name, revisionId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void rollbackSchemaExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
            String revisionId = "revisionId-1507445162";
            client.rollbackSchema(name, revisionId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void rollbackSchemaTest2() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-5662/schemas/schema-5662";
        String revisionId = "revisionId-1507445162";
        Schema actualResponse = client.rollbackSchema(name, revisionId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void rollbackSchemaExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-5662/schemas/schema-5662";
            String revisionId = "revisionId-1507445162";
            client.rollbackSchema(name, revisionId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSchemaRevisionTest() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
        String revisionId = "revisionId-1507445162";
        Schema actualResponse = client.deleteSchemaRevision(name, revisionId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSchemaRevisionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
            String revisionId = "revisionId-1507445162";
            client.deleteSchemaRevision(name, revisionId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSchemaRevisionTest2() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-5662/schemas/schema-5662";
        String revisionId = "revisionId-1507445162";
        Schema actualResponse = client.deleteSchemaRevision(name, revisionId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSchemaRevisionExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-5662/schemas/schema-5662";
            String revisionId = "revisionId-1507445162";
            client.deleteSchemaRevision(name, revisionId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSchemaTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
        client.deleteSchema(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSchemaExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
            client.deleteSchema(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSchemaTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-5662/schemas/schema-5662";
        client.deleteSchema(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSchemaExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-5662/schemas/schema-5662";
            client.deleteSchema(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void validateSchemaTest() throws Exception {
        ValidateSchemaResponse expectedResponse = ValidateSchemaResponse.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        Schema schema = Schema.newBuilder().build();
        ValidateSchemaResponse actualResponse = client.validateSchema(parent, schema);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void validateSchemaExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            Schema schema = Schema.newBuilder().build();
            client.validateSchema(parent, schema);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void validateSchemaTest2() throws Exception {
        ValidateSchemaResponse expectedResponse = ValidateSchemaResponse.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-2353";
        Schema schema = Schema.newBuilder().build();
        ValidateSchemaResponse actualResponse = client.validateSchema(parent, schema);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void validateSchemaExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-2353";
            Schema schema = Schema.newBuilder().build();
            client.validateSchema(parent, schema);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void validateMessageTest() throws Exception {
        ValidateMessageResponse expectedResponse = ValidateMessageResponse.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        ValidateMessageRequest request = ValidateMessageRequest.newBuilder().setParent(ProjectName.of((String)"[PROJECT]").toString()).setMessage(ByteString.EMPTY).setEncoding(Encoding.forNumber((int)0)).build();
        ValidateMessageResponse actualResponse = client.validateMessage(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void validateMessageExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ValidateMessageRequest request = ValidateMessageRequest.newBuilder().setParent(ProjectName.of((String)"[PROJECT]").toString()).setMessage(ByteString.EMPTY).setEncoding(Encoding.forNumber((int)0)).build();
            client.validateMessage(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
        Policy actualResponse = client.setIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
            client.setIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
        Policy actualResponse = client.getIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
            client.getIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).addAllPermissions(new ArrayList()).build();
        TestIamPermissionsResponse actualResponse = client.testIamPermissions(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).addAllPermissions(new ArrayList()).build();
            client.testIamPermissions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

