/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.Distribution;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.AckRequestData;
import com.google.cloud.pubsub.v1.AckResponse;
import com.google.cloud.pubsub.v1.CustomArgumentMatchers;
import com.google.cloud.pubsub.v1.FakeClock;
import com.google.cloud.pubsub.v1.FakeScheduledExecutorService;
import com.google.cloud.pubsub.v1.MessageReceiverWithAckResponse;
import com.google.cloud.pubsub.v1.ModackRequestData;
import com.google.cloud.pubsub.v1.StreamingSubscriberConnection;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.common.collect.Lists;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.rpc.ErrorInfo;
import com.google.rpc.Status;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.protobuf.StatusProto;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class StreamingSubscriberConnectionTest {
    @Rule
    public TestName testName = new TestName();
    private FakeScheduledExecutorService systemExecutor;
    private FakeScheduledExecutorService executor;
    private FakeClock clock;
    private SubscriberStub mockSubscriberStub;
    private static final String MOCK_SUBSCRIPTION_NAME = "projects/MOCK-PROJECT/subscriptions/MOCK-SUBSCRIPTION";
    private static final String MOCK_ACK_ID_SUCCESS = "MOCK-ACK-ID-SUCCESS";
    private static final String MOCK_ACK_ID_SUCCESS_2 = "MOCK-ACK-ID-SUCCESS-2";
    private static final String MOCK_ACK_ID_NACK_SUCCESS = "MOCK-ACK-ID-NACK-SUCCESS";
    private static final String MOCK_ACK_ID_SUCCESS_NO_MESSAGE = "MOCK-ACK-ID-SUCCESS-NO-MESSAGE";
    private static final String MOCK_ACK_ID_TRANSIENT_FAILURE_UNORDERED_ACK_ID_THEN_SUCCESS = "MOCK-ACK-ID-TRANSIENT-FAILURE-UNORDERED-ACK-ID-THEN-SUCCESS";
    private static final String MOCK_ACK_ID_TRANSIENT_FAILURE_SERVICE_UNAVAILABLE_THEN_SUCCESS = "MOCK-ACK-ID-TRANSIENT-FAILURE-SERVICE-UNAVAILABLE-THEN-SUCCESS";
    private static final String MOCK_ACK_ID_INVALID = "MOCK-ACK-ID-INVALID";
    private static final String MOCK_ACK_ID_OTHER = "MOCK-ACK-ID-OTHER";
    private static final String MOCK_ACK_ID_NO_METADATA_MAP_INTERNAL_ERROR_THEN_PERMISSION_DENIED = "MOCK-ACK-ID-NO-METADATA-MAP-INTERNAL-ERROR";
    private static final String PERMANENT_FAILURE_INVALID_ACK_ID = "PERMANENT_FAILURE_INVALID_ACK_ID";
    private static final String TRANSIENT_FAILURE_UNORDERED_ACK_ID = "TRANSIENT_FAILURE_UNORDERED_ACK_ID";
    private static final String TRANSIENT_FAILURE_SERVICE_UNAVAILABLE = "TRANSIENT_FAILURE_SERVICE_UNAVAILABLE";
    private static final String PERMANENT_FAILURE_OTHER = "I_DO_NOT_MATCH_ANY_KNOWN_ERRORS";
    private static int MOCK_ACK_EXTENSION_DEFAULT_SECONDS = 10;
    private static Duration ACK_EXPIRATION_PADDING_DEFAULT_DURATION = Duration.ofSeconds(10L);
    private static int MAX_DURATION_PER_ACK_EXTENSION_DEFAULT_SECONDS = 10;

    @Before
    public void setUp() {
        this.systemExecutor = new FakeScheduledExecutorService();
        this.clock = this.systemExecutor.getClock();
        this.mockSubscriberStub = (SubscriberStub)Mockito.mock(SubscriberStub.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    }

    @After
    public void tearDown() {
        this.systemExecutor.shutdown();
    }

    @Test
    public void testSetupAndTeardown() {
        StreamingSubscriberConnection streamingSubscriberConnection = this.getStreamingSubscriberConnection(false);
        streamingSubscriberConnection.startAsync();
        streamingSubscriberConnection.awaitRunning();
        streamingSubscriberConnection.stopAsync();
        streamingSubscriberConnection.awaitTerminated();
    }

    @Test
    public void testSendAckOperationsExactlyOnceDisabledNoMessageFutures() {
        ArrayList<ModackRequestData> modackRequestDataList = new ArrayList<ModackRequestData>();
        ModackRequestData modackRequestDataSuccess = new ModackRequestData(MOCK_ACK_EXTENSION_DEFAULT_SECONDS, new AckRequestData[]{AckRequestData.newBuilder((String)MOCK_ACK_ID_SUCCESS).build()});
        modackRequestDataList.add(modackRequestDataSuccess);
        ModackRequestData modackRequestDataNack = new ModackRequestData(0, new AckRequestData[]{AckRequestData.newBuilder((String)MOCK_ACK_ID_SUCCESS).build()});
        modackRequestDataList.add(modackRequestDataNack);
        ArrayList<AckRequestData> ackRequestDataList = new ArrayList<AckRequestData>();
        AckRequestData ackRequestDataSuccess = AckRequestData.newBuilder((String)MOCK_ACK_ID_SUCCESS).build();
        ackRequestDataList.add(ackRequestDataSuccess);
        StreamingSubscriberConnection streamingSubscriberConnection = this.getStreamingSubscriberConnection(false);
        streamingSubscriberConnection.sendAckOperations(ackRequestDataList);
        streamingSubscriberConnection.sendModackOperations(modackRequestDataList);
        ((SubscriberStub)Mockito.verify((Object)this.mockSubscriberStub, (VerificationMode)Mockito.times((int)2))).modifyAckDeadlineCallable();
        ((SubscriberStub)Mockito.verify((Object)this.mockSubscriberStub, (VerificationMode)Mockito.times((int)1))).acknowledgeCallable();
    }

    @Test
    public void testSendAckOperationsExactlyOnceEnabledMessageFuturesModacks() {
        ArrayList<String> ackIdsInitialRequest = new ArrayList<String>();
        ArrayList<String> ackIdsRetryRequest = new ArrayList<String>();
        HashMap<String, String> errorInfoMetadataMapInitialRequest = new HashMap<String, String>();
        ArrayList<ModackRequestData> modackRequestDataList = new ArrayList<ModackRequestData>();
        ModackRequestData modackRequestDataDefault = new ModackRequestData(MOCK_ACK_EXTENSION_DEFAULT_SECONDS);
        SettableApiFuture messageFutureSuccessExpected = SettableApiFuture.create();
        ModackRequestData modackRequestDataSuccess = new ModackRequestData(0, new AckRequestData[]{AckRequestData.newBuilder((String)MOCK_ACK_ID_NACK_SUCCESS).setMessageFuture(messageFutureSuccessExpected).build()});
        modackRequestDataList.add(modackRequestDataSuccess);
        SettableApiFuture messageFutureNotDoneExpected = SettableApiFuture.create();
        modackRequestDataDefault.addAckRequestData(AckRequestData.newBuilder((String)MOCK_ACK_ID_SUCCESS_NO_MESSAGE).setMessageFuture(messageFutureNotDoneExpected).build());
        ackIdsInitialRequest.add(MOCK_ACK_ID_SUCCESS_NO_MESSAGE);
        SettableApiFuture messageFutureInvalidExpected = SettableApiFuture.create();
        modackRequestDataDefault.addAckRequestData(AckRequestData.newBuilder((String)MOCK_ACK_ID_INVALID).setMessageFuture(messageFutureInvalidExpected).build());
        errorInfoMetadataMapInitialRequest.put(MOCK_ACK_ID_INVALID, PERMANENT_FAILURE_INVALID_ACK_ID);
        ackIdsInitialRequest.add(MOCK_ACK_ID_INVALID);
        SettableApiFuture messageFutureOtherExpected = SettableApiFuture.create();
        modackRequestDataDefault.addAckRequestData(AckRequestData.newBuilder((String)MOCK_ACK_ID_OTHER).setMessageFuture(messageFutureOtherExpected).build());
        errorInfoMetadataMapInitialRequest.put(MOCK_ACK_ID_OTHER, PERMANENT_FAILURE_OTHER);
        ackIdsInitialRequest.add(MOCK_ACK_ID_OTHER);
        SettableApiFuture messageFutureTransientFailureServiceUnavailableThenSuccess = SettableApiFuture.create();
        modackRequestDataDefault.addAckRequestData(AckRequestData.newBuilder((String)MOCK_ACK_ID_TRANSIENT_FAILURE_SERVICE_UNAVAILABLE_THEN_SUCCESS).setMessageFuture(messageFutureTransientFailureServiceUnavailableThenSuccess).build());
        errorInfoMetadataMapInitialRequest.put(MOCK_ACK_ID_TRANSIENT_FAILURE_SERVICE_UNAVAILABLE_THEN_SUCCESS, TRANSIENT_FAILURE_SERVICE_UNAVAILABLE);
        ackIdsInitialRequest.add(MOCK_ACK_ID_TRANSIENT_FAILURE_SERVICE_UNAVAILABLE_THEN_SUCCESS);
        ackIdsRetryRequest.add(MOCK_ACK_ID_TRANSIENT_FAILURE_SERVICE_UNAVAILABLE_THEN_SUCCESS);
        SettableApiFuture messageFutureTransientFailureUnorderedAckIdThenSuccess = SettableApiFuture.create();
        modackRequestDataDefault.addAckRequestData(AckRequestData.newBuilder((String)MOCK_ACK_ID_TRANSIENT_FAILURE_UNORDERED_ACK_ID_THEN_SUCCESS).setMessageFuture(messageFutureTransientFailureUnorderedAckIdThenSuccess).build());
        errorInfoMetadataMapInitialRequest.put(MOCK_ACK_ID_TRANSIENT_FAILURE_UNORDERED_ACK_ID_THEN_SUCCESS, TRANSIENT_FAILURE_UNORDERED_ACK_ID);
        ackIdsInitialRequest.add(MOCK_ACK_ID_TRANSIENT_FAILURE_UNORDERED_ACK_ID_THEN_SUCCESS);
        ackIdsRetryRequest.add(MOCK_ACK_ID_TRANSIENT_FAILURE_UNORDERED_ACK_ID_THEN_SUCCESS);
        modackRequestDataList.add(modackRequestDataDefault);
        ModifyAckDeadlineRequest modifyAckDeadlineRequestNack = ModifyAckDeadlineRequest.newBuilder().setSubscription(MOCK_SUBSCRIPTION_NAME).addAckIds(MOCK_ACK_ID_NACK_SUCCESS).setAckDeadlineSeconds(0).build();
        ModifyAckDeadlineRequest modifyAckDeadlineRequestInitial = ModifyAckDeadlineRequest.newBuilder().setSubscription(MOCK_SUBSCRIPTION_NAME).addAllAckIds(ackIdsInitialRequest).setAckDeadlineSeconds(MOCK_ACK_EXTENSION_DEFAULT_SECONDS).build();
        ModifyAckDeadlineRequest modifyAckDeadlineRequestRetry = ModifyAckDeadlineRequest.newBuilder().setSubscription(MOCK_SUBSCRIPTION_NAME).addAllAckIds(ackIdsRetryRequest).setAckDeadlineSeconds(MOCK_ACK_EXTENSION_DEFAULT_SECONDS).build();
        Mockito.when((Object)this.mockSubscriberStub.modifyAckDeadlineCallable().futureCall((Object)modifyAckDeadlineRequestNack)).thenReturn((Object)ApiFutures.immediateFuture(null));
        Mockito.when((Object)this.mockSubscriberStub.modifyAckDeadlineCallable().futureCall((Object)modifyAckDeadlineRequestInitial)).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)this.getMockStatusException(errorInfoMetadataMapInitialRequest)));
        Mockito.when((Object)this.mockSubscriberStub.modifyAckDeadlineCallable().futureCall((Object)((ModifyAckDeadlineRequest)ArgumentMatchers.argThat((ArgumentMatcher)new CustomArgumentMatchers.ModifyAckDeadlineRequestMatcher(modifyAckDeadlineRequestRetry))))).thenReturn((Object)ApiFutures.immediateFuture(null));
        StreamingSubscriberConnection streamingSubscriberConnection = this.getStreamingSubscriberConnection(true);
        streamingSubscriberConnection.sendModackOperations(modackRequestDataList);
        this.systemExecutor.advanceTime(Duration.ofSeconds(200L));
        ((UnaryCallable)Mockito.verify((Object)this.mockSubscriberStub.modifyAckDeadlineCallable(), (VerificationMode)Mockito.times((int)1))).futureCall((Object)modifyAckDeadlineRequestNack);
        ((UnaryCallable)Mockito.verify((Object)this.mockSubscriberStub.modifyAckDeadlineCallable(), (VerificationMode)Mockito.times((int)1))).futureCall((Object)modifyAckDeadlineRequestInitial);
        ((UnaryCallable)Mockito.verify((Object)this.mockSubscriberStub.modifyAckDeadlineCallable(), (VerificationMode)Mockito.times((int)1))).futureCall((Object)modifyAckDeadlineRequestRetry);
        ((SubscriberStub)Mockito.verify((Object)this.mockSubscriberStub, (VerificationMode)Mockito.never())).acknowledgeCallable();
        try {
            Assert.assertEquals((Object)AckResponse.SUCCESSFUL, (Object)messageFutureSuccessExpected.get());
            Assert.assertEquals((Object)AckResponse.INVALID, (Object)messageFutureInvalidExpected.get());
            Assert.assertEquals((Object)AckResponse.OTHER, (Object)messageFutureOtherExpected.get());
            Assert.assertFalse((boolean)messageFutureTransientFailureServiceUnavailableThenSuccess.isDone());
            Assert.assertFalse((boolean)messageFutureTransientFailureUnorderedAckIdThenSuccess.isDone());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AssertionError();
        }
    }

    @Test
    public void testSendAckOperationsExactlyOnceEnabledMessageFuturesAcks() {
        ArrayList<String> ackIdsInitialRequest = new ArrayList<String>();
        ArrayList<String> ackIdsRetryRequest = new ArrayList<String>();
        HashMap<String, String> errorInfoMetadataMapInitialRequest = new HashMap<String, String>();
        ArrayList<AckRequestData> ackRequestDataList = new ArrayList<AckRequestData>();
        SettableApiFuture messageFutureSuccessExpected = SettableApiFuture.create();
        ackRequestDataList.add(AckRequestData.newBuilder((String)MOCK_ACK_ID_SUCCESS).setMessageFuture(messageFutureSuccessExpected).build());
        ackIdsInitialRequest.add(MOCK_ACK_ID_SUCCESS);
        SettableApiFuture messageFutureInvalidExpected = SettableApiFuture.create();
        ackRequestDataList.add(AckRequestData.newBuilder((String)MOCK_ACK_ID_INVALID).setMessageFuture(messageFutureInvalidExpected).build());
        errorInfoMetadataMapInitialRequest.put(MOCK_ACK_ID_INVALID, PERMANENT_FAILURE_INVALID_ACK_ID);
        ackIdsInitialRequest.add(MOCK_ACK_ID_INVALID);
        SettableApiFuture messageFutureOtherExpected = SettableApiFuture.create();
        ackRequestDataList.add(AckRequestData.newBuilder((String)MOCK_ACK_ID_OTHER).setMessageFuture(messageFutureOtherExpected).build());
        errorInfoMetadataMapInitialRequest.put(MOCK_ACK_ID_OTHER, PERMANENT_FAILURE_OTHER);
        ackIdsInitialRequest.add(MOCK_ACK_ID_OTHER);
        SettableApiFuture messageFutureTransientFailureServiceUnavailableThenSuccess = SettableApiFuture.create();
        ackRequestDataList.add(AckRequestData.newBuilder((String)MOCK_ACK_ID_TRANSIENT_FAILURE_SERVICE_UNAVAILABLE_THEN_SUCCESS).setMessageFuture(messageFutureTransientFailureServiceUnavailableThenSuccess).build());
        errorInfoMetadataMapInitialRequest.put(MOCK_ACK_ID_TRANSIENT_FAILURE_SERVICE_UNAVAILABLE_THEN_SUCCESS, TRANSIENT_FAILURE_SERVICE_UNAVAILABLE);
        ackIdsInitialRequest.add(MOCK_ACK_ID_TRANSIENT_FAILURE_SERVICE_UNAVAILABLE_THEN_SUCCESS);
        ackIdsRetryRequest.add(MOCK_ACK_ID_TRANSIENT_FAILURE_SERVICE_UNAVAILABLE_THEN_SUCCESS);
        SettableApiFuture messageFutureTransientFailureUnorderedAckIdThenSuccess = SettableApiFuture.create();
        ackRequestDataList.add(AckRequestData.newBuilder((String)MOCK_ACK_ID_TRANSIENT_FAILURE_UNORDERED_ACK_ID_THEN_SUCCESS).setMessageFuture(messageFutureTransientFailureUnorderedAckIdThenSuccess).build());
        errorInfoMetadataMapInitialRequest.put(MOCK_ACK_ID_TRANSIENT_FAILURE_UNORDERED_ACK_ID_THEN_SUCCESS, TRANSIENT_FAILURE_UNORDERED_ACK_ID);
        ackIdsInitialRequest.add(MOCK_ACK_ID_TRANSIENT_FAILURE_UNORDERED_ACK_ID_THEN_SUCCESS);
        ackIdsRetryRequest.add(MOCK_ACK_ID_TRANSIENT_FAILURE_UNORDERED_ACK_ID_THEN_SUCCESS);
        AcknowledgeRequest acknowledgeRequestInitial = AcknowledgeRequest.newBuilder().setSubscription(MOCK_SUBSCRIPTION_NAME).addAllAckIds(ackIdsInitialRequest).build();
        AcknowledgeRequest acknowledgeRequestRetry = AcknowledgeRequest.newBuilder().setSubscription(MOCK_SUBSCRIPTION_NAME).addAllAckIds(ackIdsRetryRequest).build();
        Mockito.when((Object)this.mockSubscriberStub.acknowledgeCallable().futureCall((Object)acknowledgeRequestInitial)).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)this.getMockStatusException(errorInfoMetadataMapInitialRequest)));
        Mockito.when((Object)this.mockSubscriberStub.acknowledgeCallable().futureCall((Object)((AcknowledgeRequest)ArgumentMatchers.argThat((ArgumentMatcher)new CustomArgumentMatchers.AcknowledgeRequestMatcher(acknowledgeRequestRetry))))).thenReturn((Object)ApiFutures.immediateFuture(null));
        StreamingSubscriberConnection streamingSubscriberConnection = this.getStreamingSubscriberConnection(true);
        streamingSubscriberConnection.sendAckOperations(ackRequestDataList);
        this.systemExecutor.advanceTime(Duration.ofMillis(200L));
        ((UnaryCallable)Mockito.verify((Object)this.mockSubscriberStub.acknowledgeCallable(), (VerificationMode)Mockito.times((int)1))).futureCall((Object)acknowledgeRequestInitial);
        ((UnaryCallable)Mockito.verify((Object)this.mockSubscriberStub.acknowledgeCallable(), (VerificationMode)Mockito.times((int)1))).futureCall((Object)((AcknowledgeRequest)ArgumentMatchers.argThat((ArgumentMatcher)new CustomArgumentMatchers.AcknowledgeRequestMatcher(acknowledgeRequestRetry))));
        ((SubscriberStub)Mockito.verify((Object)this.mockSubscriberStub, (VerificationMode)Mockito.never())).modifyAckDeadlineCallable();
        try {
            Assert.assertEquals((Object)AckResponse.SUCCESSFUL, (Object)messageFutureSuccessExpected.get());
            Assert.assertEquals((Object)AckResponse.INVALID, (Object)messageFutureInvalidExpected.get());
            Assert.assertEquals((Object)AckResponse.OTHER, (Object)messageFutureOtherExpected.get());
            Assert.assertEquals((Object)AckResponse.SUCCESSFUL, (Object)messageFutureTransientFailureServiceUnavailableThenSuccess.get());
            Assert.assertEquals((Object)AckResponse.SUCCESSFUL, (Object)messageFutureTransientFailureUnorderedAckIdThenSuccess.get());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AssertionError();
        }
    }

    @Test
    public void testSendAckOperationsExactlyOnceEnabledErrorWithEmptyMetadataMap() {
        ArrayList<String> ackIdsRequest = new ArrayList<String>();
        ArrayList<AckRequestData> ackRequestDataList = new ArrayList<AckRequestData>();
        SettableApiFuture messageInternalErrorThenPermissionDenied = SettableApiFuture.create();
        ackRequestDataList.add(AckRequestData.newBuilder((String)MOCK_ACK_ID_NO_METADATA_MAP_INTERNAL_ERROR_THEN_PERMISSION_DENIED).setMessageFuture(messageInternalErrorThenPermissionDenied).build());
        ackIdsRequest.add(MOCK_ACK_ID_NO_METADATA_MAP_INTERNAL_ERROR_THEN_PERMISSION_DENIED);
        AcknowledgeRequest acknowledgeRequest = AcknowledgeRequest.newBuilder().setSubscription(MOCK_SUBSCRIPTION_NAME).addAllAckIds(ackIdsRequest).build();
        ApiException internalError = new ApiException("internal", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), true);
        ApiException permissionDeniedError = new ApiException("permission_denied", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.PERMISSION_DENIED), false);
        Mockito.when((Object)this.mockSubscriberStub.acknowledgeCallable().futureCall((Object)acknowledgeRequest)).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)internalError)).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)permissionDeniedError));
        StreamingSubscriberConnection streamingSubscriberConnection = this.getStreamingSubscriberConnection(true);
        streamingSubscriberConnection.sendAckOperations(ackRequestDataList);
        this.systemExecutor.advanceTime(Duration.ofMillis(200L));
        ((UnaryCallable)Mockito.verify((Object)this.mockSubscriberStub.acknowledgeCallable(), (VerificationMode)Mockito.times((int)2))).futureCall((Object)acknowledgeRequest);
        ((SubscriberStub)Mockito.verify((Object)this.mockSubscriberStub, (VerificationMode)Mockito.never())).modifyAckDeadlineCallable();
        try {
            Assert.assertEquals((Object)AckResponse.PERMISSION_DENIED, (Object)messageInternalErrorThenPermissionDenied.get());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AssertionError();
        }
    }

    @Test
    public void testSetFailureResponseOutstandingMessages() {
        SettableApiFuture future;
        int i;
        ArrayList<AckRequestData> ackRequestDataList = new ArrayList<AckRequestData>();
        ArrayList<AckRequestData> nackRequestDataList = new ArrayList<AckRequestData>();
        ArrayList<SettableApiFuture> futureList = new ArrayList<SettableApiFuture>();
        for (i = 0; i < 5; ++i) {
            future = SettableApiFuture.create();
            futureList.add(future);
            ackRequestDataList.add(AckRequestData.newBuilder((String)("ACK-ID-" + i)).setMessageFuture(future).build());
        }
        for (i = 5; i < 10; ++i) {
            future = SettableApiFuture.create();
            futureList.add(future);
            nackRequestDataList.add(AckRequestData.newBuilder((String)("ACK-ID-" + i)).setMessageFuture(future).build());
        }
        ModackRequestData modackRequestData = new ModackRequestData(0, nackRequestDataList);
        StreamingSubscriberConnection streamingSubscriberConnection = this.getStreamingSubscriberConnection(true);
        streamingSubscriberConnection.sendAckOperations(ackRequestDataList);
        streamingSubscriberConnection.sendModackOperations(Collections.singletonList(modackRequestData));
        futureList.forEach(ackResponseSettableApiFuture -> Assert.assertFalse((boolean)ackResponseSettableApiFuture.isDone()));
        streamingSubscriberConnection.setResponseOutstandingMessages(AckResponse.PERMISSION_DENIED);
        futureList.forEach(ackResponseSettableApiFuture -> {
            try {
                Assert.assertEquals((Object)ackResponseSettableApiFuture.get(), (Object)AckResponse.PERMISSION_DENIED);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new AssertionError();
            }
        });
    }

    @Test
    public void testMaxPerRequestChanges() {
        ArrayList<ModackRequestData> modackRequestDataList = new ArrayList<ModackRequestData>();
        ArrayList<AckRequestData> ackRequestDataList = new ArrayList<AckRequestData>();
        int numAckIds = 3000;
        int numMaxPerRequestChanges = 1000;
        ArrayList<String> mockAckIds = new ArrayList<String>();
        for (int i = 0; i < numAckIds; ++i) {
            String mockAckId = "MOCK-ACK-ID-" + i;
            mockAckIds.add(mockAckId);
            ackRequestDataList.add(AckRequestData.newBuilder((String)mockAckId).build());
        }
        modackRequestDataList.add(new ModackRequestData(MOCK_ACK_EXTENSION_DEFAULT_SECONDS, ackRequestDataList));
        StreamingSubscriberConnection streamingSubscriberConnection = this.getStreamingSubscriberConnection(false);
        streamingSubscriberConnection.sendAckOperations(ackRequestDataList);
        streamingSubscriberConnection.sendModackOperations(modackRequestDataList);
        for (List mockAckIdsInRequest : Lists.partition(mockAckIds, (int)numMaxPerRequestChanges)) {
            AcknowledgeRequest expectedAcknowledgeRequest = AcknowledgeRequest.newBuilder().setSubscription(MOCK_SUBSCRIPTION_NAME).addAllAckIds((Iterable)mockAckIdsInRequest).build();
            ((UnaryCallable)Mockito.verify((Object)this.mockSubscriberStub.acknowledgeCallable(), (VerificationMode)Mockito.times((int)1))).futureCall((Object)expectedAcknowledgeRequest);
            ModifyAckDeadlineRequest expectedModifyAckDeadlineRequest = ModifyAckDeadlineRequest.newBuilder().setSubscription(MOCK_SUBSCRIPTION_NAME).addAllAckIds((Iterable)mockAckIdsInRequest).setAckDeadlineSeconds(MOCK_ACK_EXTENSION_DEFAULT_SECONDS).build();
            ((UnaryCallable)Mockito.verify((Object)this.mockSubscriberStub.modifyAckDeadlineCallable(), (VerificationMode)Mockito.times((int)1))).futureCall((Object)expectedModifyAckDeadlineRequest);
        }
    }

    private StreamingSubscriberConnection getStreamingSubscriberConnection(boolean exactlyOnceDeliveryEnabled) {
        StreamingSubscriberConnection streamingSubscriberConnection = this.getStreamingSubscriberConnectionFromBuilder(StreamingSubscriberConnection.newBuilder((MessageReceiverWithAckResponse)((MessageReceiverWithAckResponse)Mockito.mock(MessageReceiverWithAckResponse.class))));
        streamingSubscriberConnection.setExactlyOnceDeliveryEnabled(exactlyOnceDeliveryEnabled);
        return streamingSubscriberConnection;
    }

    private StreamingSubscriberConnection getStreamingSubscriberConnectionFromBuilder(StreamingSubscriberConnection.Builder builder) {
        return builder.setSubscription(MOCK_SUBSCRIPTION_NAME).setAckExpirationPadding(ACK_EXPIRATION_PADDING_DEFAULT_DURATION).setAckLatencyDistribution((Distribution)Mockito.mock(Distribution.class)).setSubscriberStub(this.mockSubscriberStub).setChannelAffinity(0).setFlowControlSettings((FlowControlSettings)Mockito.mock(FlowControlSettings.class)).setFlowController((FlowController)Mockito.mock(FlowController.class)).setExecutor((ScheduledExecutorService)this.executor).setSystemExecutor((ScheduledExecutorService)this.systemExecutor).setClock((ApiClock)this.clock).setMinDurationPerAckExtension(Subscriber.DEFAULT_MIN_ACK_DEADLINE_EXTENSION).setMinDurationPerAckExtensionDefaultUsed(true).setMaxDurationPerAckExtension(Subscriber.DEFAULT_MAX_ACK_DEADLINE_EXTENSION).setMaxDurationPerAckExtensionDefaultUsed(true).build();
    }

    private StatusException getMockStatusException(Map<String, String> metadata) {
        ErrorInfo errorInfo = ErrorInfo.newBuilder().putAllMetadata(metadata).build();
        Status status = Status.newBuilder().setCode(StatusCode.Code.OK.ordinal()).addDetails(Any.pack((Message)errorInfo)).build();
        return StatusProto.toStatusException((Status)status);
    }
}

