/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.stub.HttpJsonSubscriberStub;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.GetPolicyOptions;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import com.google.pubsub.v1.BigQueryConfig;
import com.google.pubsub.v1.CloudStorageConfig;
import com.google.pubsub.v1.DeadLetterPolicy;
import com.google.pubsub.v1.ExpirationPolicy;
import com.google.pubsub.v1.ListSnapshotsResponse;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.RetryPolicy;
import com.google.pubsub.v1.SchemaName;
import com.google.pubsub.v1.SeekRequest;
import com.google.pubsub.v1.SeekResponse;
import com.google.pubsub.v1.Snapshot;
import com.google.pubsub.v1.SnapshotName;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.SubscriptionName;
import com.google.pubsub.v1.TopicName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SubscriptionAdminClientHttpJsonTest {
    private static MockHttpService mockService;
    private static SubscriptionAdminClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonSubscriberStub.getMethodDescriptors(), SubscriptionAdminSettings.getDefaultEndpoint());
        SubscriptionAdminSettings settings = ((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)SubscriptionAdminSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = SubscriptionAdminClient.create((SubscriptionAdminSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void createSubscriptionTest() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setPushConfig(PushConfig.newBuilder().build()).setBigqueryConfig(BigQueryConfig.newBuilder().build()).setCloudStorageConfig(CloudStorageConfig.newBuilder().build()).setAckDeadlineSeconds(2135351438).setRetainAckedMessages(true).setMessageRetentionDuration(Duration.newBuilder().build()).putAllLabels(new HashMap()).setEnableMessageOrdering(true).setExpirationPolicy(ExpirationPolicy.newBuilder().build()).setFilter("filter-1274492040").setDeadLetterPolicy(DeadLetterPolicy.newBuilder().build()).setRetryPolicy(RetryPolicy.newBuilder().build()).setDetached(true).setEnableExactlyOnceDelivery(true).setTopicMessageRetentionDuration(Duration.newBuilder().build()).setAnalyticsHubSubscriptionInfo(Subscription.AnalyticsHubSubscriptionInfo.newBuilder().build()).addAllMessageTransforms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        SubscriptionName name = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
        PushConfig pushConfig = PushConfig.newBuilder().build();
        int ackDeadlineSeconds = 2135351438;
        Subscription actualResponse = client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSubscriptionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SubscriptionName name = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
            PushConfig pushConfig = PushConfig.newBuilder().build();
            int ackDeadlineSeconds = 2135351438;
            client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSubscriptionTest2() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setPushConfig(PushConfig.newBuilder().build()).setBigqueryConfig(BigQueryConfig.newBuilder().build()).setCloudStorageConfig(CloudStorageConfig.newBuilder().build()).setAckDeadlineSeconds(2135351438).setRetainAckedMessages(true).setMessageRetentionDuration(Duration.newBuilder().build()).putAllLabels(new HashMap()).setEnableMessageOrdering(true).setExpirationPolicy(ExpirationPolicy.newBuilder().build()).setFilter("filter-1274492040").setDeadLetterPolicy(DeadLetterPolicy.newBuilder().build()).setRetryPolicy(RetryPolicy.newBuilder().build()).setDetached(true).setEnableExactlyOnceDelivery(true).setTopicMessageRetentionDuration(Duration.newBuilder().build()).setAnalyticsHubSubscriptionInfo(Subscription.AnalyticsHubSubscriptionInfo.newBuilder().build()).addAllMessageTransforms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        SubscriptionName name = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        String topic = "topic110546223";
        PushConfig pushConfig = PushConfig.newBuilder().build();
        int ackDeadlineSeconds = 2135351438;
        Subscription actualResponse = client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSubscriptionExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SubscriptionName name = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            String topic = "topic110546223";
            PushConfig pushConfig = PushConfig.newBuilder().build();
            int ackDeadlineSeconds = 2135351438;
            client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSubscriptionTest3() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setPushConfig(PushConfig.newBuilder().build()).setBigqueryConfig(BigQueryConfig.newBuilder().build()).setCloudStorageConfig(CloudStorageConfig.newBuilder().build()).setAckDeadlineSeconds(2135351438).setRetainAckedMessages(true).setMessageRetentionDuration(Duration.newBuilder().build()).putAllLabels(new HashMap()).setEnableMessageOrdering(true).setExpirationPolicy(ExpirationPolicy.newBuilder().build()).setFilter("filter-1274492040").setDeadLetterPolicy(DeadLetterPolicy.newBuilder().build()).setRetryPolicy(RetryPolicy.newBuilder().build()).setDetached(true).setEnableExactlyOnceDelivery(true).setTopicMessageRetentionDuration(Duration.newBuilder().build()).setAnalyticsHubSubscriptionInfo(Subscription.AnalyticsHubSubscriptionInfo.newBuilder().build()).addAllMessageTransforms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-7298/subscriptions/subscription-7298";
        TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
        PushConfig pushConfig = PushConfig.newBuilder().build();
        int ackDeadlineSeconds = 2135351438;
        Subscription actualResponse = client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSubscriptionExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7298/subscriptions/subscription-7298";
            TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
            PushConfig pushConfig = PushConfig.newBuilder().build();
            int ackDeadlineSeconds = 2135351438;
            client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSubscriptionTest4() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setPushConfig(PushConfig.newBuilder().build()).setBigqueryConfig(BigQueryConfig.newBuilder().build()).setCloudStorageConfig(CloudStorageConfig.newBuilder().build()).setAckDeadlineSeconds(2135351438).setRetainAckedMessages(true).setMessageRetentionDuration(Duration.newBuilder().build()).putAllLabels(new HashMap()).setEnableMessageOrdering(true).setExpirationPolicy(ExpirationPolicy.newBuilder().build()).setFilter("filter-1274492040").setDeadLetterPolicy(DeadLetterPolicy.newBuilder().build()).setRetryPolicy(RetryPolicy.newBuilder().build()).setDetached(true).setEnableExactlyOnceDelivery(true).setTopicMessageRetentionDuration(Duration.newBuilder().build()).setAnalyticsHubSubscriptionInfo(Subscription.AnalyticsHubSubscriptionInfo.newBuilder().build()).addAllMessageTransforms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-7298/subscriptions/subscription-7298";
        String topic = "topic110546223";
        PushConfig pushConfig = PushConfig.newBuilder().build();
        int ackDeadlineSeconds = 2135351438;
        Subscription actualResponse = client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSubscriptionExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7298/subscriptions/subscription-7298";
            String topic = "topic110546223";
            PushConfig pushConfig = PushConfig.newBuilder().build();
            int ackDeadlineSeconds = 2135351438;
            client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSubscriptionTest() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setPushConfig(PushConfig.newBuilder().build()).setBigqueryConfig(BigQueryConfig.newBuilder().build()).setCloudStorageConfig(CloudStorageConfig.newBuilder().build()).setAckDeadlineSeconds(2135351438).setRetainAckedMessages(true).setMessageRetentionDuration(Duration.newBuilder().build()).putAllLabels(new HashMap()).setEnableMessageOrdering(true).setExpirationPolicy(ExpirationPolicy.newBuilder().build()).setFilter("filter-1274492040").setDeadLetterPolicy(DeadLetterPolicy.newBuilder().build()).setRetryPolicy(RetryPolicy.newBuilder().build()).setDetached(true).setEnableExactlyOnceDelivery(true).setTopicMessageRetentionDuration(Duration.newBuilder().build()).setAnalyticsHubSubscriptionInfo(Subscription.AnalyticsHubSubscriptionInfo.newBuilder().build()).addAllMessageTransforms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        Subscription actualResponse = client.getSubscription(subscription);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSubscriptionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            client.getSubscription(subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSubscriptionTest2() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setPushConfig(PushConfig.newBuilder().build()).setBigqueryConfig(BigQueryConfig.newBuilder().build()).setCloudStorageConfig(CloudStorageConfig.newBuilder().build()).setAckDeadlineSeconds(2135351438).setRetainAckedMessages(true).setMessageRetentionDuration(Duration.newBuilder().build()).putAllLabels(new HashMap()).setEnableMessageOrdering(true).setExpirationPolicy(ExpirationPolicy.newBuilder().build()).setFilter("filter-1274492040").setDeadLetterPolicy(DeadLetterPolicy.newBuilder().build()).setRetryPolicy(RetryPolicy.newBuilder().build()).setDetached(true).setEnableExactlyOnceDelivery(true).setTopicMessageRetentionDuration(Duration.newBuilder().build()).setAnalyticsHubSubscriptionInfo(Subscription.AnalyticsHubSubscriptionInfo.newBuilder().build()).addAllMessageTransforms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String subscription = "projects/project-1980/subscriptions/subscription-1980";
        Subscription actualResponse = client.getSubscription(subscription);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSubscriptionExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String subscription = "projects/project-1980/subscriptions/subscription-1980";
            client.getSubscription(subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSubscriptionTest() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setPushConfig(PushConfig.newBuilder().build()).setBigqueryConfig(BigQueryConfig.newBuilder().build()).setCloudStorageConfig(CloudStorageConfig.newBuilder().build()).setAckDeadlineSeconds(2135351438).setRetainAckedMessages(true).setMessageRetentionDuration(Duration.newBuilder().build()).putAllLabels(new HashMap()).setEnableMessageOrdering(true).setExpirationPolicy(ExpirationPolicy.newBuilder().build()).setFilter("filter-1274492040").setDeadLetterPolicy(DeadLetterPolicy.newBuilder().build()).setRetryPolicy(RetryPolicy.newBuilder().build()).setDetached(true).setEnableExactlyOnceDelivery(true).setTopicMessageRetentionDuration(Duration.newBuilder().build()).setAnalyticsHubSubscriptionInfo(Subscription.AnalyticsHubSubscriptionInfo.newBuilder().build()).addAllMessageTransforms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        Subscription subscription = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setPushConfig(PushConfig.newBuilder().build()).setBigqueryConfig(BigQueryConfig.newBuilder().build()).setCloudStorageConfig(CloudStorageConfig.newBuilder().build()).setAckDeadlineSeconds(2135351438).setRetainAckedMessages(true).setMessageRetentionDuration(Duration.newBuilder().build()).putAllLabels(new HashMap()).setEnableMessageOrdering(true).setExpirationPolicy(ExpirationPolicy.newBuilder().build()).setFilter("filter-1274492040").setDeadLetterPolicy(DeadLetterPolicy.newBuilder().build()).setRetryPolicy(RetryPolicy.newBuilder().build()).setDetached(true).setEnableExactlyOnceDelivery(true).setTopicMessageRetentionDuration(Duration.newBuilder().build()).setAnalyticsHubSubscriptionInfo(Subscription.AnalyticsHubSubscriptionInfo.newBuilder().build()).addAllMessageTransforms(new ArrayList()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Subscription actualResponse = client.updateSubscription(subscription, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateSubscriptionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Subscription subscription = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setPushConfig(PushConfig.newBuilder().build()).setBigqueryConfig(BigQueryConfig.newBuilder().build()).setCloudStorageConfig(CloudStorageConfig.newBuilder().build()).setAckDeadlineSeconds(2135351438).setRetainAckedMessages(true).setMessageRetentionDuration(Duration.newBuilder().build()).putAllLabels(new HashMap()).setEnableMessageOrdering(true).setExpirationPolicy(ExpirationPolicy.newBuilder().build()).setFilter("filter-1274492040").setDeadLetterPolicy(DeadLetterPolicy.newBuilder().build()).setRetryPolicy(RetryPolicy.newBuilder().build()).setDetached(true).setEnableExactlyOnceDelivery(true).setTopicMessageRetentionDuration(Duration.newBuilder().build()).setAnalyticsHubSubscriptionInfo(Subscription.AnalyticsHubSubscriptionInfo.newBuilder().build()).addAllMessageTransforms(new ArrayList()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateSubscription(subscription, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSubscriptionsTest() throws Exception {
        Subscription responsesElement = Subscription.newBuilder().build();
        ListSubscriptionsResponse expectedResponse = ListSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName project = ProjectName.of((String)"[PROJECT]");
        SubscriptionAdminClient.ListSubscriptionsPagedResponse pagedListResponse = client.listSubscriptions(project);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSubscriptionsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSubscriptionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName project = ProjectName.of((String)"[PROJECT]");
            client.listSubscriptions(project);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSubscriptionsTest2() throws Exception {
        Subscription responsesElement = Subscription.newBuilder().build();
        ListSubscriptionsResponse expectedResponse = ListSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String project = "projects/project-7934";
        SubscriptionAdminClient.ListSubscriptionsPagedResponse pagedListResponse = client.listSubscriptions(project);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSubscriptionsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSubscriptionsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String project = "projects/project-7934";
            client.listSubscriptions(project);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSubscriptionTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        client.deleteSubscription(subscription);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSubscriptionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            client.deleteSubscription(subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSubscriptionTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String subscription = "projects/project-1980/subscriptions/subscription-1980";
        client.deleteSubscription(subscription);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSubscriptionExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String subscription = "projects/project-1980/subscriptions/subscription-1980";
            client.deleteSubscription(subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void modifyAckDeadlineTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        ArrayList ackIds = new ArrayList();
        int ackDeadlineSeconds = 2135351438;
        client.modifyAckDeadline(subscription, ackIds, ackDeadlineSeconds);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void modifyAckDeadlineExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            ArrayList ackIds = new ArrayList();
            int ackDeadlineSeconds = 2135351438;
            client.modifyAckDeadline(subscription, ackIds, ackDeadlineSeconds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void modifyAckDeadlineTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String subscription = "projects/project-1980/subscriptions/subscription-1980";
        ArrayList ackIds = new ArrayList();
        int ackDeadlineSeconds = 2135351438;
        client.modifyAckDeadline(subscription, ackIds, ackDeadlineSeconds);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void modifyAckDeadlineExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String subscription = "projects/project-1980/subscriptions/subscription-1980";
            ArrayList ackIds = new ArrayList();
            int ackDeadlineSeconds = 2135351438;
            client.modifyAckDeadline(subscription, ackIds, ackDeadlineSeconds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void acknowledgeTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        ArrayList ackIds = new ArrayList();
        client.acknowledge(subscription, ackIds);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void acknowledgeExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            ArrayList ackIds = new ArrayList();
            client.acknowledge(subscription, ackIds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void acknowledgeTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String subscription = "projects/project-1980/subscriptions/subscription-1980";
        ArrayList ackIds = new ArrayList();
        client.acknowledge(subscription, ackIds);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void acknowledgeExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String subscription = "projects/project-1980/subscriptions/subscription-1980";
            ArrayList ackIds = new ArrayList();
            client.acknowledge(subscription, ackIds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void pullTest() throws Exception {
        PullResponse expectedResponse = PullResponse.newBuilder().addAllReceivedMessages(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        int maxMessages = 496131527;
        PullResponse actualResponse = client.pull(subscription, maxMessages);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void pullExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            int maxMessages = 496131527;
            client.pull(subscription, maxMessages);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void pullTest2() throws Exception {
        PullResponse expectedResponse = PullResponse.newBuilder().addAllReceivedMessages(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String subscription = "projects/project-1980/subscriptions/subscription-1980";
        int maxMessages = 496131527;
        PullResponse actualResponse = client.pull(subscription, maxMessages);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void pullExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String subscription = "projects/project-1980/subscriptions/subscription-1980";
            int maxMessages = 496131527;
            client.pull(subscription, maxMessages);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void pullTest3() throws Exception {
        PullResponse expectedResponse = PullResponse.newBuilder().addAllReceivedMessages(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        boolean returnImmediately = true;
        int maxMessages = 496131527;
        PullResponse actualResponse = client.pull(subscription, returnImmediately, maxMessages);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void pullExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            boolean returnImmediately = true;
            int maxMessages = 496131527;
            client.pull(subscription, returnImmediately, maxMessages);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void pullTest4() throws Exception {
        PullResponse expectedResponse = PullResponse.newBuilder().addAllReceivedMessages(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String subscription = "projects/project-1980/subscriptions/subscription-1980";
        boolean returnImmediately = true;
        int maxMessages = 496131527;
        PullResponse actualResponse = client.pull(subscription, returnImmediately, maxMessages);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void pullExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String subscription = "projects/project-1980/subscriptions/subscription-1980";
            boolean returnImmediately = true;
            int maxMessages = 496131527;
            client.pull(subscription, returnImmediately, maxMessages);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void streamingPullUnsupportedMethodTest() throws Exception {
    }

    @Test
    public void modifyPushConfigTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        PushConfig pushConfig = PushConfig.newBuilder().build();
        client.modifyPushConfig(subscription, pushConfig);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void modifyPushConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            PushConfig pushConfig = PushConfig.newBuilder().build();
            client.modifyPushConfig(subscription, pushConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void modifyPushConfigTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String subscription = "projects/project-1980/subscriptions/subscription-1980";
        PushConfig pushConfig = PushConfig.newBuilder().build();
        client.modifyPushConfig(subscription, pushConfig);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void modifyPushConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String subscription = "projects/project-1980/subscriptions/subscription-1980";
            PushConfig pushConfig = PushConfig.newBuilder().build();
            client.modifyPushConfig(subscription, pushConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSnapshotTest() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setExpireTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        SnapshotName snapshot = SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
        Snapshot actualResponse = client.getSnapshot(snapshot);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSnapshotExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SnapshotName snapshot = SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
            client.getSnapshot(snapshot);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSnapshotTest2() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setExpireTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        String snapshot = "projects/project-2020/snapshots/snapshot-2020";
        Snapshot actualResponse = client.getSnapshot(snapshot);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSnapshotExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String snapshot = "projects/project-2020/snapshots/snapshot-2020";
            client.getSnapshot(snapshot);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSnapshotsTest() throws Exception {
        Snapshot responsesElement = Snapshot.newBuilder().build();
        ListSnapshotsResponse expectedResponse = ListSnapshotsResponse.newBuilder().setNextPageToken("").addAllSnapshots(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName project = ProjectName.of((String)"[PROJECT]");
        SubscriptionAdminClient.ListSnapshotsPagedResponse pagedListResponse = client.listSnapshots(project);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSnapshotsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSnapshotsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName project = ProjectName.of((String)"[PROJECT]");
            client.listSnapshots(project);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSnapshotsTest2() throws Exception {
        Snapshot responsesElement = Snapshot.newBuilder().build();
        ListSnapshotsResponse expectedResponse = ListSnapshotsResponse.newBuilder().setNextPageToken("").addAllSnapshots(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String project = "projects/project-7934";
        SubscriptionAdminClient.ListSnapshotsPagedResponse pagedListResponse = client.listSnapshots(project);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSnapshotsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSnapshotsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String project = "projects/project-7934";
            client.listSnapshots(project);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSnapshotTest() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setExpireTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        Snapshot actualResponse = client.createSnapshot(name, subscription);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSnapshotExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            client.createSnapshot(name, subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSnapshotTest2() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setExpireTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
        String subscription = "subscription341203229";
        Snapshot actualResponse = client.createSnapshot(name, subscription);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSnapshotExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
            String subscription = "subscription341203229";
            client.createSnapshot(name, subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSnapshotTest3() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setExpireTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4389/snapshots/snapshot-4389";
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        Snapshot actualResponse = client.createSnapshot(name, subscription);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSnapshotExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4389/snapshots/snapshot-4389";
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            client.createSnapshot(name, subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSnapshotTest4() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setExpireTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4389/snapshots/snapshot-4389";
        String subscription = "subscription341203229";
        Snapshot actualResponse = client.createSnapshot(name, subscription);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSnapshotExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4389/snapshots/snapshot-4389";
            String subscription = "subscription341203229";
            client.createSnapshot(name, subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSnapshotTest() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setExpireTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        Snapshot snapshot = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setExpireTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Snapshot actualResponse = client.updateSnapshot(snapshot, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateSnapshotExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Snapshot snapshot = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setExpireTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateSnapshot(snapshot, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSnapshotTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        SnapshotName snapshot = SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
        client.deleteSnapshot(snapshot);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSnapshotExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SnapshotName snapshot = SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
            client.deleteSnapshot(snapshot);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSnapshotTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String snapshot = "projects/project-2020/snapshots/snapshot-2020";
        client.deleteSnapshot(snapshot);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSnapshotExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String snapshot = "projects/project-2020/snapshots/snapshot-2020";
            client.deleteSnapshot(snapshot);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void seekTest() throws Exception {
        SeekResponse expectedResponse = SeekResponse.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        SeekRequest request = SeekRequest.newBuilder().setSubscription(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).build();
        SeekResponse actualResponse = client.seek(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void seekExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SeekRequest request = SeekRequest.newBuilder().setSubscription(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).build();
            client.seek(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
        Policy actualResponse = client.setIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
            client.setIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
        Policy actualResponse = client.getIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
            client.getIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).addAllPermissions(new ArrayList()).build();
        TestIamPermissionsResponse actualResponse = client.testIamPermissions(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).addAllPermissions(new ArrayList()).build();
            client.testIamPermissions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

