/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.cloud.pubsub.v1.stub.HttpJsonPublisherStub;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.GetPolicyOptions;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.pubsub.v1.DetachSubscriptionRequest;
import com.google.pubsub.v1.DetachSubscriptionResponse;
import com.google.pubsub.v1.IngestionDataSourceSettings;
import com.google.pubsub.v1.ListTopicSnapshotsResponse;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.MessageStoragePolicy;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.SchemaName;
import com.google.pubsub.v1.SchemaSettings;
import com.google.pubsub.v1.SubscriptionName;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TopicAdminClientHttpJsonTest {
    private static MockHttpService mockService;
    private static TopicAdminClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonPublisherStub.getMethodDescriptors(), TopicAdminSettings.getDefaultEndpoint());
        TopicAdminSettings settings = ((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)TopicAdminSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)TopicAdminSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = TopicAdminClient.create((TopicAdminSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void createTopicTest() throws Exception {
        Topic expectedResponse = Topic.newBuilder().setName(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).putAllLabels(new HashMap()).setMessageStoragePolicy(MessageStoragePolicy.newBuilder().build()).setKmsKeyName("kmsKeyName412586233").setSchemaSettings(SchemaSettings.newBuilder().build()).setSatisfiesPzs(true).setMessageRetentionDuration(Duration.newBuilder().build()).setIngestionDataSourceSettings(IngestionDataSourceSettings.newBuilder().build()).addAllMessageTransforms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        TopicName name = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
        Topic actualResponse = client.createTopic(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createTopicExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TopicName name = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
            client.createTopic(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createTopicTest2() throws Exception {
        Topic expectedResponse = Topic.newBuilder().setName(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).putAllLabels(new HashMap()).setMessageStoragePolicy(MessageStoragePolicy.newBuilder().build()).setKmsKeyName("kmsKeyName412586233").setSchemaSettings(SchemaSettings.newBuilder().build()).setSatisfiesPzs(true).setMessageRetentionDuration(Duration.newBuilder().build()).setIngestionDataSourceSettings(IngestionDataSourceSettings.newBuilder().build()).addAllMessageTransforms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-7550/topics/topic-7550";
        Topic actualResponse = client.createTopic(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createTopicExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-7550/topics/topic-7550";
            client.createTopic(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateTopicTest() throws Exception {
        Topic expectedResponse = Topic.newBuilder().setName(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).putAllLabels(new HashMap()).setMessageStoragePolicy(MessageStoragePolicy.newBuilder().build()).setKmsKeyName("kmsKeyName412586233").setSchemaSettings(SchemaSettings.newBuilder().build()).setSatisfiesPzs(true).setMessageRetentionDuration(Duration.newBuilder().build()).setIngestionDataSourceSettings(IngestionDataSourceSettings.newBuilder().build()).addAllMessageTransforms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        Topic topic = Topic.newBuilder().setName(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).putAllLabels(new HashMap()).setMessageStoragePolicy(MessageStoragePolicy.newBuilder().build()).setKmsKeyName("kmsKeyName412586233").setSchemaSettings(SchemaSettings.newBuilder().build()).setSatisfiesPzs(true).setMessageRetentionDuration(Duration.newBuilder().build()).setIngestionDataSourceSettings(IngestionDataSourceSettings.newBuilder().build()).addAllMessageTransforms(new ArrayList()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Topic actualResponse = client.updateTopic(topic, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateTopicExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Topic topic = Topic.newBuilder().setName(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).putAllLabels(new HashMap()).setMessageStoragePolicy(MessageStoragePolicy.newBuilder().build()).setKmsKeyName("kmsKeyName412586233").setSchemaSettings(SchemaSettings.newBuilder().build()).setSatisfiesPzs(true).setMessageRetentionDuration(Duration.newBuilder().build()).setIngestionDataSourceSettings(IngestionDataSourceSettings.newBuilder().build()).addAllMessageTransforms(new ArrayList()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateTopic(topic, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void publishTest() throws Exception {
        PublishResponse expectedResponse = PublishResponse.newBuilder().addAllMessageIds(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
        ArrayList messages = new ArrayList();
        PublishResponse actualResponse = client.publish(topic, messages);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void publishExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
            ArrayList messages = new ArrayList();
            client.publish(topic, messages);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void publishTest2() throws Exception {
        PublishResponse expectedResponse = PublishResponse.newBuilder().addAllMessageIds(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String topic = "projects/project-2486/topics/topic-2486";
        ArrayList messages = new ArrayList();
        PublishResponse actualResponse = client.publish(topic, messages);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void publishExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String topic = "projects/project-2486/topics/topic-2486";
            ArrayList messages = new ArrayList();
            client.publish(topic, messages);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTopicTest() throws Exception {
        Topic expectedResponse = Topic.newBuilder().setName(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).putAllLabels(new HashMap()).setMessageStoragePolicy(MessageStoragePolicy.newBuilder().build()).setKmsKeyName("kmsKeyName412586233").setSchemaSettings(SchemaSettings.newBuilder().build()).setSatisfiesPzs(true).setMessageRetentionDuration(Duration.newBuilder().build()).setIngestionDataSourceSettings(IngestionDataSourceSettings.newBuilder().build()).addAllMessageTransforms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
        Topic actualResponse = client.getTopic(topic);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getTopicExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
            client.getTopic(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTopicTest2() throws Exception {
        Topic expectedResponse = Topic.newBuilder().setName(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).putAllLabels(new HashMap()).setMessageStoragePolicy(MessageStoragePolicy.newBuilder().build()).setKmsKeyName("kmsKeyName412586233").setSchemaSettings(SchemaSettings.newBuilder().build()).setSatisfiesPzs(true).setMessageRetentionDuration(Duration.newBuilder().build()).setIngestionDataSourceSettings(IngestionDataSourceSettings.newBuilder().build()).addAllMessageTransforms(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String topic = "projects/project-2486/topics/topic-2486";
        Topic actualResponse = client.getTopic(topic);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getTopicExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String topic = "projects/project-2486/topics/topic-2486";
            client.getTopic(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicsTest() throws Exception {
        Topic responsesElement = Topic.newBuilder().build();
        ListTopicsResponse expectedResponse = ListTopicsResponse.newBuilder().setNextPageToken("").addAllTopics(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName project = ProjectName.of((String)"[PROJECT]");
        TopicAdminClient.ListTopicsPagedResponse pagedListResponse = client.listTopics(project);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTopicsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listTopicsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName project = ProjectName.of((String)"[PROJECT]");
            client.listTopics(project);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicsTest2() throws Exception {
        Topic responsesElement = Topic.newBuilder().build();
        ListTopicsResponse expectedResponse = ListTopicsResponse.newBuilder().setNextPageToken("").addAllTopics(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String project = "projects/project-7934";
        TopicAdminClient.ListTopicsPagedResponse pagedListResponse = client.listTopics(project);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTopicsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listTopicsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String project = "projects/project-7934";
            client.listTopics(project);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicSubscriptionsTest() throws Exception {
        String responsesElement = "responsesElement-318365110";
        ListTopicSubscriptionsResponse expectedResponse = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
        TopicAdminClient.ListTopicSubscriptionsPagedResponse pagedListResponse = client.listTopicSubscriptions(topic);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getSubscriptionsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listTopicSubscriptionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
            client.listTopicSubscriptions(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicSubscriptionsTest2() throws Exception {
        String responsesElement = "responsesElement-318365110";
        ListTopicSubscriptionsResponse expectedResponse = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String topic = "projects/project-2486/topics/topic-2486";
        TopicAdminClient.ListTopicSubscriptionsPagedResponse pagedListResponse = client.listTopicSubscriptions(topic);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getSubscriptionsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listTopicSubscriptionsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String topic = "projects/project-2486/topics/topic-2486";
            client.listTopicSubscriptions(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicSnapshotsTest() throws Exception {
        String responsesElement = "responsesElement-318365110";
        ListTopicSnapshotsResponse expectedResponse = ListTopicSnapshotsResponse.newBuilder().setNextPageToken("").addAllSnapshots(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
        TopicAdminClient.ListTopicSnapshotsPagedResponse pagedListResponse = client.listTopicSnapshots(topic);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getSnapshotsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listTopicSnapshotsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
            client.listTopicSnapshots(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicSnapshotsTest2() throws Exception {
        String responsesElement = "responsesElement-318365110";
        ListTopicSnapshotsResponse expectedResponse = ListTopicSnapshotsResponse.newBuilder().setNextPageToken("").addAllSnapshots(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String topic = "projects/project-2486/topics/topic-2486";
        TopicAdminClient.ListTopicSnapshotsPagedResponse pagedListResponse = client.listTopicSnapshots(topic);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getSnapshotsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listTopicSnapshotsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String topic = "projects/project-2486/topics/topic-2486";
            client.listTopicSnapshots(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteTopicTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
        client.deleteTopic(topic);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteTopicExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
            client.deleteTopic(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteTopicTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String topic = "projects/project-2486/topics/topic-2486";
        client.deleteTopic(topic);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteTopicExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String topic = "projects/project-2486/topics/topic-2486";
            client.deleteTopic(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void detachSubscriptionTest() throws Exception {
        DetachSubscriptionResponse expectedResponse = DetachSubscriptionResponse.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        DetachSubscriptionRequest request = DetachSubscriptionRequest.newBuilder().setSubscription(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).build();
        DetachSubscriptionResponse actualResponse = client.detachSubscription(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void detachSubscriptionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DetachSubscriptionRequest request = DetachSubscriptionRequest.newBuilder().setSubscription(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).build();
            client.detachSubscription(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
        Policy actualResponse = client.setIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
            client.setIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
        Policy actualResponse = client.getIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
            client.getIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).addAllPermissions(new ArrayList()).build();
        TestIamPermissionsResponse actualResponse = client.testIamPermissions(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).addAllPermissions(new ArrayList()).build();
            client.testIamPermissions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

