/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.it;

import com.google.api.core.ApiService;
import com.google.cloud.ServiceOptions;
import com.google.cloud.pubsub.it.AutoValue_ITPubSubTest_MessageAndConsumer;
import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.Binding;
import com.google.iam.v1.Policy;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.TopicName;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class ITPubSubTest {
    private static final String NAME_SUFFIX = UUID.randomUUID().toString();
    private static TopicAdminClient topicAdminClient;
    private static SubscriptionAdminClient subscriptionAdminClient;
    private static String projectId;
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)300L);

    @BeforeClass
    public static void setupClass() throws Exception {
        topicAdminClient = TopicAdminClient.create();
        subscriptionAdminClient = SubscriptionAdminClient.create();
        projectId = ServiceOptions.getDefaultProjectId();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        topicAdminClient.close();
        subscriptionAdminClient.close();
    }

    private String formatForTest(String resourceName) {
        return resourceName + "-" + NAME_SUFFIX;
    }

    @Test
    public void testTopicPolicy() {
        ProjectTopicName topicName = ProjectTopicName.of((String)projectId, (String)this.formatForTest("testing-topic-policy"));
        topicAdminClient.createTopic(topicName);
        Policy policy = topicAdminClient.getIamPolicy(topicName.toString());
        Binding binding = Binding.newBuilder().setRole("roles/viewer").addMembers("allAuthenticatedUsers").build();
        Policy newPolicy = topicAdminClient.setIamPolicy(topicName.toString(), policy.toBuilder().addBindings(binding).build());
        Truth.assertThat((Iterable)newPolicy.getBindingsList()).contains((Object)binding);
        String permissionName = "pubsub.topics.get";
        ProtocolStringList permissions = topicAdminClient.testIamPermissions(topicName.toString(), Collections.singletonList(permissionName)).getPermissionsList();
        Truth.assertThat((Iterable)permissions).contains((Object)permissionName);
        topicAdminClient.deleteTopic(topicName);
    }

    @Test
    public void testPublishSubscribe() throws Exception {
        ProjectTopicName topicName = ProjectTopicName.of((String)projectId, (String)this.formatForTest("testing-publish-subscribe-topic"));
        ProjectSubscriptionName subscriptionName = ProjectSubscriptionName.of((String)projectId, (String)this.formatForTest("testing-publish-subscribe-subscription"));
        topicAdminClient.createTopic(topicName);
        subscriptionAdminClient.createSubscription(subscriptionName, topicName, PushConfig.newBuilder().build(), 10);
        final LinkedBlockingQueue<Object> receiveQueue = new LinkedBlockingQueue<Object>();
        Subscriber subscriber = Subscriber.newBuilder((ProjectSubscriptionName)subscriptionName, (MessageReceiver)new MessageReceiver(){

            public void receiveMessage(PubsubMessage message, AckReplyConsumer consumer) {
                receiveQueue.offer(MessageAndConsumer.create(message, consumer));
            }
        }).build();
        subscriber.addListener(new ApiService.Listener(){

            public void failed(ApiService.State from, Throwable failure) {
                receiveQueue.offer(failure);
            }
        }, MoreExecutors.directExecutor());
        subscriber.startAsync();
        Publisher publisher = Publisher.newBuilder((TopicName)topicName).build();
        publisher.publish(PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"msg1")).build()).get();
        publisher.publish(PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"msg2")).build()).get();
        publisher.shutdown();
        MessageAndConsumer toAck = this.pollQueue(receiveQueue);
        toAck.consumer().ack();
        MessageAndConsumer toNack = this.pollQueue(receiveQueue);
        Truth.assertThat((Iterable)toNack.message().getData()).isNotEqualTo((Object)toAck.message().getData());
        toNack.consumer().nack();
        MessageAndConsumer redelivered = this.pollQueue(receiveQueue);
        Truth.assertThat((Iterable)redelivered.message().getData()).isEqualTo((Object)toNack.message().getData());
        redelivered.consumer().ack();
        subscriber.stopAsync().awaitTerminated();
        subscriptionAdminClient.deleteSubscription(subscriptionName);
        topicAdminClient.deleteTopic(topicName);
    }

    private MessageAndConsumer pollQueue(BlockingQueue<Object> queue) throws InterruptedException {
        Object obj = queue.poll(10L, TimeUnit.MINUTES);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Throwable) {
            throw new IllegalStateException("unexpected error", (Throwable)obj);
        }
        if (obj instanceof MessageAndConsumer) {
            return (MessageAndConsumer)obj;
        }
        throw new IllegalStateException("expected either MessageAndConsumer or Throwable, found: " + obj);
    }

    static abstract class MessageAndConsumer {
        MessageAndConsumer() {
        }

        abstract PubsubMessage message();

        abstract AckReplyConsumer consumer();

        static MessageAndConsumer create(PubsubMessage message, AckReplyConsumer consumer) {
            return new AutoValue_ITPubSubTest_MessageAndConsumer(message, consumer);
        }
    }
}

