/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiClock;
import com.google.cloud.pubsub.v1.FakeClock;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.TemporalAmount;

public class FakeScheduledExecutorService
extends AbstractExecutorService
implements ScheduledExecutorService {
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final PriorityQueue<PendingCallable<?>> pendingCallables = new PriorityQueue();
    private final FakeClock clock = new FakeClock();
    private final Deque<Duration> expectedWorkQueue = new LinkedList<Duration>();

    public ApiClock getClock() {
        return this.clock;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.schedulePendingCallable(new PendingCallable(Duration.ofMillis((long)unit.toMillis(delay)), command, PendingCallableType.NORMAL));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.schedulePendingCallable(new PendingCallable<V>(Duration.ofMillis((long)unit.toMillis(delay)), callable, PendingCallableType.NORMAL));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.schedulePendingCallable(new PendingCallable(Duration.ofMillis((long)unit.toMillis(initialDelay)), command, PendingCallableType.FIXED_RATE));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.schedulePendingCallable(new PendingCallable(Duration.ofMillis((long)unit.toMillis(initialDelay)), command, PendingCallableType.FIXED_DELAY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupScheduleExpectation(Duration delay) {
        Deque<Duration> deque = this.expectedWorkQueue;
        synchronized (deque) {
            this.expectedWorkQueue.add(delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForExpectedWork() {
        Deque<Duration> deque = this.expectedWorkQueue;
        synchronized (deque) {
            while (!this.expectedWorkQueue.isEmpty()) {
                try {
                    this.expectedWorkQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void advanceTime(Duration toAdvance) {
        this.clock.advance(toAdvance.toMillis(), TimeUnit.MILLISECONDS);
        this.work();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work() {
        Instant cmpTime = Instant.ofEpochMilli((long)this.clock.millisTime());
        while (true) {
            PendingCallable<?> callable = null;
            PriorityQueue<PendingCallable<?>> priorityQueue = this.pendingCallables;
            synchronized (priorityQueue) {
                if (this.pendingCallables.isEmpty() || ((PendingCallable)this.pendingCallables.peek()).getScheduledTime().isAfter(cmpTime)) {
                    break;
                }
                callable = this.pendingCallables.poll();
            }
            if (callable == null) continue;
            try {
                callable.call();
            }
            catch (Exception exception) {}
        }
        PriorityQueue<PendingCallable<?>> priorityQueue = this.pendingCallables;
        synchronized (priorityQueue) {
            if (this.shutdown.get() && this.pendingCallables.isEmpty()) {
                this.pendingCallables.notifyAll();
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            throw new IllegalStateException("This executor has been shutdown already");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        if (this.shutdown.getAndSet(true)) {
            throw new IllegalStateException("This executor has been shutdown already");
        }
        ArrayList<Runnable> pending = new ArrayList<Runnable>();
        for (final PendingCallable<?> pendingCallable : this.pendingCallables) {
            pending.add(new Runnable(){

                @Override
                public void run() {
                    pendingCallable.call();
                }
            });
        }
        PriorityQueue<PendingCallable<?>> priorityQueue = this.pendingCallables;
        synchronized (priorityQueue) {
            this.pendingCallables.notifyAll();
            this.pendingCallables.clear();
        }
        return pending;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.pendingCallables.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        PriorityQueue<PendingCallable<?>> priorityQueue = this.pendingCallables;
        synchronized (priorityQueue) {
            if (this.pendingCallables.isEmpty()) {
                return true;
            }
            this.pendingCallables.wait(unit.toMillis(timeout));
            return this.pendingCallables.isEmpty();
        }
    }

    @Override
    public void execute(Runnable command) {
        if (this.shutdown.get()) {
            throw new IllegalStateException("This executor has been shutdown");
        }
        command.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <V> ScheduledFuture<V> schedulePendingCallable(PendingCallable<V> callable) {
        if (this.shutdown.get()) {
            throw new IllegalStateException("This executor has been shutdown");
        }
        Queue<PendingCallable<Object>> queue = this.pendingCallables;
        synchronized (queue) {
            this.pendingCallables.add(callable);
        }
        this.work();
        queue = this.expectedWorkQueue;
        synchronized (queue) {
            if (!this.expectedWorkQueue.isEmpty() && this.expectedWorkQueue.peek().equals((Object)callable.delay)) {
                this.expectedWorkQueue.poll();
            }
            this.expectedWorkQueue.notifyAll();
        }
        return callable.getScheduledFuture();
    }

    class PendingCallable<T>
    implements Comparable<PendingCallable<T>> {
        Instant creationTime;
        Duration delay;
        Callable<T> pendingCallable;
        SettableFuture<T> future;
        AtomicBoolean cancelled;
        AtomicBoolean done;
        PendingCallableType type;

        PendingCallable(Duration delay, final Runnable runnable, PendingCallableType type) {
            this.creationTime = Instant.ofEpochMilli((long)FakeScheduledExecutorService.this.clock.millisTime());
            this.future = SettableFuture.create();
            this.cancelled = new AtomicBoolean(false);
            this.done = new AtomicBoolean(false);
            this.pendingCallable = new Callable<T>(){

                @Override
                public T call() throws Exception {
                    runnable.run();
                    return null;
                }
            };
            this.type = type;
            this.delay = delay;
        }

        PendingCallable(Duration delay, Callable<T> callable, PendingCallableType type) {
            this.creationTime = Instant.ofEpochMilli((long)FakeScheduledExecutorService.this.clock.millisTime());
            this.future = SettableFuture.create();
            this.cancelled = new AtomicBoolean(false);
            this.done = new AtomicBoolean(false);
            this.pendingCallable = callable;
            this.type = type;
            this.delay = delay;
        }

        private Instant getScheduledTime() {
            return this.creationTime.plus((TemporalAmount)this.delay);
        }

        ScheduledFuture<T> getScheduledFuture() {
            return new ScheduledFuture<T>(){

                @Override
                public long getDelay(TimeUnit unit) {
                    return unit.convert(PendingCallable.this.getScheduledTime().toEpochMilli() - FakeScheduledExecutorService.this.clock.millisTime(), TimeUnit.MILLISECONDS);
                }

                @Override
                public int compareTo(Delayed o) {
                    return Ints.saturatedCast((long)(this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS)));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        PendingCallable.this.cancelled.set(true);
                        return !PendingCallable.this.done.get();
                    }
                }

                @Override
                public boolean isCancelled() {
                    return PendingCallable.this.cancelled.get();
                }

                @Override
                public boolean isDone() {
                    return PendingCallable.this.done.get();
                }

                @Override
                public T get() throws InterruptedException, ExecutionException {
                    return PendingCallable.this.future.get();
                }

                @Override
                public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return PendingCallable.this.future.get(timeout, unit);
                }
            };
        }

        /*
         * Exception decompiling
         */
        T call() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.getBindingFor(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "res" is null
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.getGtbNullFiltered(GenericInferer.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.inferGenericObjectInfoFromCalls(GenericInferer.java:139)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:484)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public int compareTo(PendingCallable<T> other) {
            return this.getScheduledTime().compareTo(super.getScheduledTime());
        }
    }

    static enum PendingCallableType {
        NORMAL,
        FIXED_RATE,
        FIXED_DELAY;

    }
}

