/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.DataLossException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.FakePublisherServiceImpl;
import com.google.cloud.pubsub.v1.FakeScheduledExecutorService;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.TopicName;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.inprocess.InProcessServerBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class PublisherImplTest {
    private static final ProjectTopicName TEST_TOPIC = ProjectTopicName.of((String)"test-project", (String)"test-topic");
    private static final ExecutorProvider SINGLE_THREAD_EXECUTOR = InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(1).build();
    private static final TransportChannelProvider TEST_CHANNEL_PROVIDER = LocalChannelProvider.create((String)"test-server");
    private FakeScheduledExecutorService fakeExecutor;
    private FakePublisherServiceImpl testPublisherServiceImpl;
    private Server testServer;

    @Before
    public void setUp() throws Exception {
        this.testPublisherServiceImpl = new FakePublisherServiceImpl();
        InProcessServerBuilder serverBuilder = InProcessServerBuilder.forName((String)"test-server");
        serverBuilder.addService((BindableService)this.testPublisherServiceImpl);
        this.testServer = serverBuilder.build();
        this.testServer.start();
        this.fakeExecutor = new FakeScheduledExecutorService();
    }

    @After
    public void tearDown() throws Exception {
        this.testServer.shutdownNow().awaitTermination();
    }

    @Test
    public void testPublishByDuration() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setDelayThreshold(Duration.ofSeconds((long)5L)).setElementCountThreshold(Long.valueOf(10L)).build()).build();
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1").addMessageIds("2"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        ApiFuture<String> publishFuture2 = this.sendTestMessage(publisher, "B");
        Assert.assertFalse((boolean)publishFuture1.isDone());
        Assert.assertFalse((boolean)publishFuture2.isDone());
        this.fakeExecutor.advanceTime(Duration.ofSeconds((long)10L));
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((Object)"2", (Object)publishFuture2.get());
        Assert.assertEquals((long)2L, (long)this.testPublisherServiceImpl.getCapturedRequests().get(0).getMessagesCount());
        publisher.shutdown();
    }

    @Test
    public void testPublishByNumBatchedMessages() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(2L)).setDelayThreshold(Duration.ofSeconds((long)100L)).build()).build();
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1").addMessageIds("2")).addPublishResponse(PublishResponse.newBuilder().addMessageIds("3").addMessageIds("4"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        ApiFuture<String> publishFuture2 = this.sendTestMessage(publisher, "B");
        ApiFuture<String> publishFuture3 = this.sendTestMessage(publisher, "C");
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((Object)"2", (Object)publishFuture2.get());
        Assert.assertFalse((boolean)publishFuture3.isDone());
        ApiFuture publishFuture4 = publisher.publish(PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"D")).build());
        Assert.assertEquals((Object)"3", (Object)publishFuture3.get());
        Assert.assertEquals((Object)"4", (Object)publishFuture4.get());
        Assert.assertEquals((long)2L, (long)this.testPublisherServiceImpl.getCapturedRequests().get(0).getMessagesCount());
        Assert.assertEquals((long)2L, (long)this.testPublisherServiceImpl.getCapturedRequests().get(1).getMessagesCount());
        publisher.shutdown();
    }

    @Test
    public void testSinglePublishByNumBytes() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(2L)).setDelayThreshold(Duration.ofSeconds((long)100L)).build()).build();
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1").addMessageIds("2")).addPublishResponse(PublishResponse.newBuilder().addMessageIds("3").addMessageIds("4"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        ApiFuture<String> publishFuture2 = this.sendTestMessage(publisher, "B");
        ApiFuture<String> publishFuture3 = this.sendTestMessage(publisher, "C");
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((Object)"2", (Object)publishFuture2.get());
        Assert.assertFalse((boolean)publishFuture3.isDone());
        ApiFuture<String> publishFuture4 = this.sendTestMessage(publisher, "D");
        Assert.assertEquals((Object)"3", (Object)publishFuture3.get());
        Assert.assertEquals((Object)"4", (Object)publishFuture4.get());
        Assert.assertEquals((long)2L, (long)this.testPublisherServiceImpl.getCapturedRequests().size());
        publisher.shutdown();
    }

    @Test
    public void testPublishMixedSizeAndDuration() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(2L)).setDelayThreshold(Duration.ofSeconds((long)5L)).build()).build();
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1").addMessageIds("2"));
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("3"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        this.fakeExecutor.advanceTime(Duration.ofSeconds((long)2L));
        Assert.assertFalse((boolean)publishFuture1.isDone());
        ApiFuture<String> publishFuture2 = this.sendTestMessage(publisher, "B");
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((Object)"2", (Object)publishFuture2.get());
        ApiFuture<String> publishFuture3 = this.sendTestMessage(publisher, "C");
        Assert.assertFalse((boolean)publishFuture3.isDone());
        this.fakeExecutor.advanceTime(Duration.ofSeconds((long)5L));
        Assert.assertEquals((Object)"3", (Object)publishFuture3.get());
        Assert.assertEquals((long)2L, (long)this.testPublisherServiceImpl.getCapturedRequests().get(0).getMessagesCount());
        Assert.assertEquals((long)1L, (long)this.testPublisherServiceImpl.getCapturedRequests().get(1).getMessagesCount());
        publisher.shutdown();
    }

    private ApiFuture<String> sendTestMessage(Publisher publisher, String data) {
        return publisher.publish(PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)data)).build());
    }

    @Test
    public void testErrorPropagation() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(1L)).setDelayThreshold(Duration.ofSeconds((long)5L)).build()).build();
        this.testPublisherServiceImpl.addPublishError((Throwable)Status.DATA_LOSS.asException());
        try {
            this.sendTestMessage(publisher, "A").get();
            Assert.fail((String)"should throw exception");
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(DataLossException.class);
        }
    }

    @Test
    public void testPublishFailureRetries() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(1L)).setDelayThreshold(Duration.ofSeconds((long)5L)).build()).build();
        this.testPublisherServiceImpl.addPublishError(new Throwable("Transiently failing"));
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((long)2L, (long)this.testPublisherServiceImpl.getCapturedRequests().size());
        publisher.shutdown();
    }

    @Test(expected=ExecutionException.class)
    public void testPublishFailureRetries_retriesDisabled() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setTotalTimeout(Duration.ofSeconds((long)10L)).setMaxAttempts(1).build()).build();
        this.testPublisherServiceImpl.addPublishError(new Throwable("Transiently failing"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        try {
            publishFuture1.get();
        }
        finally {
            Assert.assertSame((Object)this.testPublisherServiceImpl.getCapturedRequests().size(), (Object)1);
            publisher.shutdown();
        }
    }

    @Test
    public void testPublishFailureRetries_maxRetriesSetup() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setTotalTimeout(Duration.ofSeconds((long)10L)).setMaxAttempts(3).build()).build();
        this.testPublisherServiceImpl.addPublishError(new Throwable("Transiently failing"));
        this.testPublisherServiceImpl.addPublishError(new Throwable("Transiently failing"));
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((long)3L, (long)this.testPublisherServiceImpl.getCapturedRequests().size());
        publisher.shutdown();
    }

    @Test
    public void testPublishFailureRetries_maxRetriesSetUnlimited() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setTotalTimeout(Duration.ofSeconds((long)10L)).setMaxAttempts(0).build()).build();
        this.testPublisherServiceImpl.addPublishError(new Throwable("Transiently failing"));
        this.testPublisherServiceImpl.addPublishError(new Throwable("Transiently failing"));
        this.testPublisherServiceImpl.addPublishResponse(PublishResponse.newBuilder().addMessageIds("1"));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        Assert.assertEquals((Object)"1", (Object)publishFuture1.get());
        Assert.assertEquals((long)3L, (long)this.testPublisherServiceImpl.getCapturedRequests().size());
        publisher.shutdown();
    }

    @Test(expected=ExecutionException.class)
    public void testPublishFailureRetries_nonRetryableFailsImmediately() throws Exception {
        Publisher publisher = this.getTestPublisherBuilder().setExecutorProvider(SINGLE_THREAD_EXECUTOR).setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setTotalTimeout(Duration.ofSeconds((long)10L)).build()).setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(1L)).setDelayThreshold(Duration.ofSeconds((long)5L)).build()).build();
        this.testPublisherServiceImpl.addPublishError((Throwable)new StatusException(Status.INVALID_ARGUMENT));
        ApiFuture<String> publishFuture1 = this.sendTestMessage(publisher, "A");
        try {
            publishFuture1.get();
            Assert.assertTrue((this.testPublisherServiceImpl.getCapturedRequests().size() >= 1 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Assert.assertTrue((this.testPublisherServiceImpl.getCapturedRequests().size() >= 1 ? 1 : 0) != 0);
            publisher.shutdown();
            throw throwable;
        }
        publisher.shutdown();
    }

    @Test
    public void testPublisherGetters() throws Exception {
        Publisher.Builder builder = Publisher.newBuilder((TopicName)TEST_TOPIC);
        builder.setChannelProvider(TEST_CHANNEL_PROVIDER);
        builder.setExecutorProvider(SINGLE_THREAD_EXECUTOR);
        builder.setBatchingSettings(BatchingSettings.newBuilder().setRequestByteThreshold(Long.valueOf(10L)).setDelayThreshold(Duration.ofMillis((long)11L)).setElementCountThreshold(Long.valueOf(12L)).build());
        builder.setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create());
        Publisher publisher = builder.build();
        Assert.assertEquals((Object)TEST_TOPIC, (Object)publisher.getTopicName());
        Assert.assertEquals((long)10L, (long)publisher.getBatchingSettings().getRequestByteThreshold());
        Assert.assertEquals((Object)Duration.ofMillis((long)11L), (Object)publisher.getBatchingSettings().getDelayThreshold());
        Assert.assertEquals((long)12L, (long)publisher.getBatchingSettings().getElementCountThreshold());
        publisher.shutdown();
    }

    @Test
    public void testBuilderParametersAndDefaults() {
        Publisher.Builder builder = Publisher.newBuilder((TopicName)TEST_TOPIC);
        Assert.assertEquals((Object)TEST_TOPIC.toString(), (Object)builder.topicName);
        Assert.assertEquals((Object)Publisher.Builder.DEFAULT_EXECUTOR_PROVIDER, (Object)builder.executorProvider);
        Assert.assertEquals((long)1000L, (long)builder.batchingSettings.getRequestByteThreshold());
        Assert.assertEquals((Object)Publisher.Builder.DEFAULT_DELAY_THRESHOLD, (Object)builder.batchingSettings.getDelayThreshold());
        Assert.assertEquals((long)100L, (long)builder.batchingSettings.getElementCountThreshold());
        Assert.assertEquals((Object)Publisher.Builder.DEFAULT_RETRY_SETTINGS, (Object)builder.retrySettings);
    }

    @Test
    public void testBuilderInvalidArguments() {
        Publisher.Builder builder = Publisher.newBuilder((TopicName)TEST_TOPIC);
        try {
            builder.setChannelProvider(null);
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.setExecutorProvider(null);
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setRequestByteThreshold((Long)null).build());
            Assert.fail((String)"Should have thrown an NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setRequestByteThreshold(Long.valueOf(0L)).build());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setRequestByteThreshold(Long.valueOf(-1L)).build());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setDelayThreshold(Duration.ofMillis((long)1L)).build());
        try {
            builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setDelayThreshold(null).build());
            Assert.fail((String)"Should have thrown an NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setDelayThreshold(Duration.ofMillis((long)-1L)).build());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(1L)).build());
        try {
            builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold((Long)null).build());
            Assert.fail((String)"Should have thrown an NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(0L)).build());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            builder.setBatchingSettings(Publisher.Builder.DEFAULT_BATCHING_SETTINGS.toBuilder().setElementCountThreshold(Long.valueOf(-1L)).build());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        builder.setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setInitialRpcTimeout(Publisher.Builder.MIN_RPC_TIMEOUT).build());
        try {
            builder.setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setInitialRpcTimeout(Publisher.Builder.MIN_RPC_TIMEOUT.minusMillis(1L)).build());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        builder.setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setTotalTimeout(Publisher.Builder.MIN_TOTAL_TIMEOUT).build());
        try {
            builder.setRetrySettings(Publisher.Builder.DEFAULT_RETRY_SETTINGS.toBuilder().setTotalTimeout(Publisher.Builder.MIN_TOTAL_TIMEOUT.minusMillis(1L)).build());
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private Publisher.Builder getTestPublisherBuilder() {
        return Publisher.newBuilder((TopicName)TEST_TOPIC).setExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)this.fakeExecutor)).setChannelProvider(TEST_CHANNEL_PROVIDER).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create());
    }

    class FakeException
    extends Exception {
        FakeException() {
        }
    }
}

