/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.cloud.pubsub.v1.MessageDispatcher;
import com.google.cloud.pubsub.v1.StreamingSubscriberConnection;
import com.google.common.truth.Truth;
import com.google.pubsub.v1.StreamingPullRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Test;

public class StreamingSubscriberConnectionTest {
    @Test
    public void testPartitionAckOperations() {
        List requests = StreamingSubscriberConnection.partitionAckOperations(Collections.emptyList(), Collections.emptyList(), (int)3);
        Truth.assertThat((Iterable)requests).isEmpty();
        requests = StreamingSubscriberConnection.partitionAckOperations(Arrays.asList("a", "b", "c"), Collections.emptyList(), (int)3);
        Truth.assertThat((Iterable)requests).containsExactly(new Object[]{StreamingPullRequest.newBuilder().addAckIds("a").addAckIds("b").addAckIds("c").build()}).inOrder();
        requests = StreamingSubscriberConnection.partitionAckOperations(Arrays.asList("a", "b", "c", "d"), Collections.emptyList(), (int)3);
        Truth.assertThat((Iterable)requests).containsExactly(new Object[]{StreamingPullRequest.newBuilder().addAckIds("a").addAckIds("b").addAckIds("c").build(), StreamingPullRequest.newBuilder().addAckIds("d").build()}).inOrder();
        requests = StreamingSubscriberConnection.partitionAckOperations(Arrays.asList("a", "b", "c", "d"), Arrays.asList(new MessageDispatcher.PendingModifyAckDeadline(42, new String[]{"w"})), (int)3);
        Truth.assertThat((Iterable)requests).containsExactly(new Object[]{StreamingPullRequest.newBuilder().addAckIds("a").addAckIds("b").addAckIds("c").addModifyDeadlineAckIds("w").addModifyDeadlineSeconds(42).build(), StreamingPullRequest.newBuilder().addAckIds("d").build()}).inOrder();
        requests = StreamingSubscriberConnection.partitionAckOperations(Arrays.asList("a"), Arrays.asList(new MessageDispatcher.PendingModifyAckDeadline(42, new String[]{"w", "x"})), (int)3);
        Truth.assertThat((Iterable)requests).containsExactly(new Object[]{StreamingPullRequest.newBuilder().addAckIds("a").addModifyDeadlineAckIds("w").addModifyDeadlineSeconds(42).addModifyDeadlineAckIds("x").addModifyDeadlineSeconds(42).build()}).inOrder();
        requests = StreamingSubscriberConnection.partitionAckOperations(Arrays.asList("a"), Arrays.asList(new MessageDispatcher.PendingModifyAckDeadline(42, new String[]{"w", "x"}), new MessageDispatcher.PendingModifyAckDeadline(43, new String[]{"y", "z"})), (int)3);
        Truth.assertThat((Iterable)requests).containsExactly(new Object[]{StreamingPullRequest.newBuilder().addAckIds("a").addModifyDeadlineAckIds("w").addModifyDeadlineSeconds(42).addModifyDeadlineAckIds("x").addModifyDeadlineSeconds(42).addModifyDeadlineAckIds("y").addModifyDeadlineSeconds(43).build(), StreamingPullRequest.newBuilder().addModifyDeadlineAckIds("z").addModifyDeadlineSeconds(43).build()}).inOrder();
    }
}

