/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiService;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.FakeScheduledExecutorService;
import com.google.cloud.pubsub.v1.FakeSubscriberServiceImpl;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.PubsubMessage;
import io.grpc.BindableService;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class SubscriberTest {
    private static final ProjectSubscriptionName TEST_SUBSCRIPTION = ProjectSubscriptionName.of((String)"test-project", (String)"test-subscription");
    private ManagedChannel testChannel;
    private FakeScheduledExecutorService fakeExecutor;
    private FakeSubscriberServiceImpl fakeSubscriberServiceImpl;
    private Server testServer;
    private final MessageReceiver testReceiver = new MessageReceiver(){

        public void receiveMessage(PubsubMessage message, AckReplyConsumer consumer) {
            consumer.ack();
        }
    };
    @Rule
    public TestName testName = new TestName();

    @Before
    public void setUp() throws Exception {
        InProcessServerBuilder serverBuilder = InProcessServerBuilder.forName((String)this.testName.getMethodName());
        this.fakeSubscriberServiceImpl = new FakeSubscriberServiceImpl();
        this.fakeExecutor = new FakeScheduledExecutorService();
        this.testChannel = InProcessChannelBuilder.forName((String)this.testName.getMethodName()).build();
        serverBuilder.addService((BindableService)this.fakeSubscriberServiceImpl);
        this.testServer = serverBuilder.build();
        this.testServer.start();
    }

    @After
    public void tearDown() throws Exception {
        this.testServer.shutdownNow().awaitTermination();
        this.testChannel.shutdown();
    }

    @Test
    public void testOpenedChannels() throws Exception {
        int expectedChannelCount = 1;
        Subscriber subscriber = this.startSubscriber(this.getTestSubscriberBuilder(this.testReceiver));
        Assert.assertEquals((long)expectedChannelCount, (long)this.fakeSubscriberServiceImpl.waitForOpenedStreams(expectedChannelCount));
        subscriber.stopAsync().awaitTerminated();
    }

    @Test
    public void testFailedChannel_recoverableError_channelReopened() throws Exception {
        int expectedChannelCount = 1;
        Subscriber subscriber = this.startSubscriber(this.getTestSubscriberBuilder(this.testReceiver).setSystemExecutorProvider((ExecutorProvider)InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(1).build()));
        this.fakeSubscriberServiceImpl.sendError((Throwable)new StatusException(Status.INTERNAL));
        Assert.assertEquals((long)1L, (long)this.fakeSubscriberServiceImpl.waitForClosedStreams(1));
        Assert.assertEquals((long)expectedChannelCount, (long)this.fakeSubscriberServiceImpl.waitForOpenedStreams(expectedChannelCount));
        subscriber.stopAsync().awaitTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testFailedChannel_fatalError_subscriberFails() throws Exception {
        Subscriber subscriber = this.startSubscriber(this.getTestSubscriberBuilder(this.testReceiver).setSystemExecutorProvider((ExecutorProvider)InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(10).build()));
        this.fakeSubscriberServiceImpl.sendError((Throwable)new StatusException(Status.INVALID_ARGUMENT));
        try {
            subscriber.awaitTerminated();
        }
        finally {
            Assert.assertEquals((Object)ApiService.State.FAILED, (Object)subscriber.state());
            Throwable t = subscriber.failureCause();
            Assert.assertTrue((boolean)(t instanceof ApiException));
            ApiException ex = (ApiException)t;
            Assert.assertTrue((boolean)(ex.getStatusCode() instanceof GrpcStatusCode));
            GrpcStatusCode grpcCode = (GrpcStatusCode)ex.getStatusCode();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)grpcCode.getCode());
        }
    }

    private Subscriber startSubscriber(Subscriber.Builder testSubscriberBuilder) throws Exception {
        Subscriber subscriber = testSubscriberBuilder.build();
        subscriber.startAsync().awaitRunning();
        return subscriber;
    }

    private Subscriber.Builder getTestSubscriberBuilder(MessageReceiver receiver) {
        return Subscriber.newBuilder((ProjectSubscriptionName)TEST_SUBSCRIPTION, (MessageReceiver)receiver).setExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)this.fakeExecutor)).setSystemExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)this.fakeExecutor)).setChannelProvider((TransportChannelProvider)FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)this.testChannel))).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).setClock(this.fakeExecutor.getClock()).setParallelPullCount(1);
    }
}

