/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.MockIAMPolicy;
import com.google.cloud.pubsub.v1.MockPublisher;
import com.google.cloud.pubsub.v1.MockSubscriber;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.GeneratedMessageV3;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.Topic;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TopicAdminClientTest {
    private static MockPublisher mockPublisher;
    private static MockIAMPolicy mockIAMPolicy;
    private static MockSubscriber mockSubscriber;
    private static MockServiceHelper serviceHelper;
    private TopicAdminClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockPublisher = new MockPublisher();
        mockIAMPolicy = new MockIAMPolicy();
        mockSubscriber = new MockSubscriber();
        serviceHelper = new MockServiceHelper("in-process-1", Arrays.asList(mockPublisher, mockIAMPolicy, mockSubscriber));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        TopicAdminSettings settings = ((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = TopicAdminClient.create((TopicAdminSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createTopicTest() {
        ProjectTopicName name2 = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
        Topic expectedResponse = Topic.newBuilder().setName(name2.toString()).build();
        mockPublisher.addResponse((GeneratedMessageV3)expectedResponse);
        ProjectTopicName name = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
        Topic actualResponse = this.client.createTopic(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<GeneratedMessageV3> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Topic actualRequest = (Topic)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)ProjectTopicName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTopicExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            ProjectTopicName name = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
            this.client.createTopic(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void publishTest() {
        String messageIdsElement = "messageIdsElement-744837059";
        List<String> messageIds = Arrays.asList(messageIdsElement);
        PublishResponse expectedResponse = PublishResponse.newBuilder().addAllMessageIds(messageIds).build();
        mockPublisher.addResponse((GeneratedMessageV3)expectedResponse);
        ProjectTopicName topic = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
        ByteString data = ByteString.copyFromUtf8((String)"-86");
        PubsubMessage messagesElement = PubsubMessage.newBuilder().setData(data).build();
        List<PubsubMessage> messages = Arrays.asList(messagesElement);
        PublishResponse actualResponse = this.client.publish(topic, messages);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<GeneratedMessageV3> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PublishRequest actualRequest = (PublishRequest)actualRequests.get(0);
        Assert.assertEquals((Object)topic, (Object)ProjectTopicName.parse((String)actualRequest.getTopic()));
        Assert.assertEquals(messages, (Object)actualRequest.getMessagesList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void publishExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            ProjectTopicName topic = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
            ByteString data = ByteString.copyFromUtf8((String)"-86");
            PubsubMessage messagesElement = PubsubMessage.newBuilder().setData(data).build();
            List<PubsubMessage> messages = Arrays.asList(messagesElement);
            this.client.publish(topic, messages);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTopicTest() {
        ProjectTopicName name = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
        Topic expectedResponse = Topic.newBuilder().setName(name.toString()).build();
        mockPublisher.addResponse((GeneratedMessageV3)expectedResponse);
        ProjectTopicName topic = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
        Topic actualResponse = this.client.getTopic(topic);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<GeneratedMessageV3> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTopicRequest actualRequest = (GetTopicRequest)actualRequests.get(0);
        Assert.assertEquals((Object)topic, (Object)ProjectTopicName.parse((String)actualRequest.getTopic()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTopicExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            ProjectTopicName topic = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
            this.client.getTopic(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicsTest() {
        String nextPageToken = "";
        Topic topicsElement = Topic.newBuilder().build();
        List<Topic> topics = Arrays.asList(topicsElement);
        ListTopicsResponse expectedResponse = ListTopicsResponse.newBuilder().setNextPageToken(nextPageToken).addAllTopics(topics).build();
        mockPublisher.addResponse((GeneratedMessageV3)expectedResponse);
        ProjectName project = ProjectName.of((String)"[PROJECT]");
        TopicAdminClient.ListTopicsPagedResponse pagedListResponse = this.client.listTopics(project);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTopicsList().get(0), resources.get(0));
        List<GeneratedMessageV3> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTopicsRequest actualRequest = (ListTopicsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)project, (Object)ProjectName.parse((String)actualRequest.getProject()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTopicsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            ProjectName project = ProjectName.of((String)"[PROJECT]");
            this.client.listTopics(project);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicSubscriptionsTest() {
        String nextPageToken = "";
        ProjectSubscriptionName subscriptionsElement = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        List<ProjectSubscriptionName> subscriptions = Arrays.asList(subscriptionsElement);
        ListTopicSubscriptionsResponse expectedResponse = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken(nextPageToken).addAllSubscriptions((Iterable)ProjectSubscriptionName.toStringList(subscriptions)).build();
        mockPublisher.addResponse((GeneratedMessageV3)expectedResponse);
        ProjectTopicName topic = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
        TopicAdminClient.ListTopicSubscriptionsPagedResponse pagedListResponse = this.client.listTopicSubscriptions(topic);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getSubscriptionsList().get(0), resources.get(0));
        ArrayList resourceNames = Lists.newArrayList((Iterable)pagedListResponse.iterateAllAsProjectSubscriptionName());
        Assert.assertEquals((long)1L, (long)resourceNames.size());
        Assert.assertEquals((Object)ProjectSubscriptionName.parse((String)((String)expectedResponse.getSubscriptionsList().get(0))), resourceNames.get(0));
        List<GeneratedMessageV3> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTopicSubscriptionsRequest actualRequest = (ListTopicSubscriptionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)topic, (Object)ProjectTopicName.parse((String)actualRequest.getTopic()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTopicSubscriptionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            ProjectTopicName topic = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
            this.client.listTopicSubscriptions(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteTopicTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockPublisher.addResponse((GeneratedMessageV3)expectedResponse);
        ProjectTopicName topic = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
        this.client.deleteTopic(topic);
        List<GeneratedMessageV3> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteTopicRequest actualRequest = (DeleteTopicRequest)actualRequests.get(0);
        Assert.assertEquals((Object)topic, (Object)ProjectTopicName.parse((String)actualRequest.getTopic()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteTopicExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            ProjectTopicName topic = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
            this.client.deleteTopic(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() {
        int version = 351608024;
        ByteString etag = ByteString.copyFromUtf8((String)"21");
        Policy expectedResponse = Policy.newBuilder().setVersion(version).setEtag(etag).build();
        mockIAMPolicy.addResponse((GeneratedMessageV3)expectedResponse);
        String formattedResource = ProjectTopicName.format((String)"[PROJECT]", (String)"[TOPIC]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy(formattedResource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<GeneratedMessageV3> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedResource, (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            String formattedResource = ProjectTopicName.format((String)"[PROJECT]", (String)"[TOPIC]");
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy(formattedResource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() {
        int version = 351608024;
        ByteString etag = ByteString.copyFromUtf8((String)"21");
        Policy expectedResponse = Policy.newBuilder().setVersion(version).setEtag(etag).build();
        mockIAMPolicy.addResponse((GeneratedMessageV3)expectedResponse);
        String formattedResource = ProjectTopicName.format((String)"[PROJECT]", (String)"[TOPIC]");
        Policy actualResponse = this.client.getIamPolicy(formattedResource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<GeneratedMessageV3> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedResource, (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            String formattedResource = ProjectTopicName.format((String)"[PROJECT]", (String)"[TOPIC]");
            this.client.getIamPolicy(formattedResource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().build();
        mockIAMPolicy.addResponse((GeneratedMessageV3)expectedResponse);
        String formattedResource = ProjectTopicName.format((String)"[PROJECT]", (String)"[TOPIC]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(formattedResource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<GeneratedMessageV3> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedResource, (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            String formattedResource = ProjectTopicName.format((String)"[PROJECT]", (String)"[TOPIC]");
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions(formattedResource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

