/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.common.base.Optional;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PublisherGrpc;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

class FakePublisherServiceImpl
extends PublisherGrpc.PublisherImplBase {
    private final LinkedBlockingQueue<PublishRequest> requests = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<Response> publishResponses = new LinkedBlockingQueue();

    FakePublisherServiceImpl() {
    }

    public void publish(PublishRequest request, StreamObserver<PublishResponse> responseObserver) {
        Response response;
        this.requests.add(request);
        try {
            response = this.publishResponses.take();
        }
        catch (InterruptedException e) {
            throw new IllegalArgumentException(e);
        }
        if (response.isError()) {
            responseObserver.onError(response.getError());
        } else {
            responseObserver.onNext((Object)response.getPublishResponse());
            responseObserver.onCompleted();
        }
    }

    public FakePublisherServiceImpl addPublishResponse(PublishResponse publishResponse) {
        this.publishResponses.add(new Response(publishResponse));
        return this;
    }

    public FakePublisherServiceImpl addPublishResponse(PublishResponse.Builder publishResponseBuilder) {
        return this.addPublishResponse(publishResponseBuilder.build());
    }

    public FakePublisherServiceImpl addPublishError(Throwable error) {
        this.publishResponses.add(new Response(error));
        return this;
    }

    public List<PublishRequest> getCapturedRequests() {
        return new ArrayList<PublishRequest>(this.requests);
    }

    private static class Response {
        Optional<PublishResponse> publishResponse;
        Optional<Throwable> error;

        public Response(PublishResponse publishResponse) {
            this.publishResponse = Optional.of((Object)publishResponse);
            this.error = Optional.absent();
        }

        public Response(Throwable exception) {
            this.publishResponse = Optional.absent();
            this.error = Optional.of((Object)exception);
        }

        public PublishResponse getPublishResponse() {
            return (PublishResponse)this.publishResponse.get();
        }

        public Throwable getError() {
            return (Throwable)this.error.get();
        }

        boolean isError() {
            return this.error.isPresent();
        }

        public String toString() {
            if (this.isError()) {
                return ((Throwable)this.error.get()).toString();
            }
            return ((PublishResponse)this.publishResponse.get()).toString();
        }
    }
}

