/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiClock;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.Distribution;
import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.AutoValue_MessageDispatcherTest_ModAckItem;
import com.google.cloud.pubsub.v1.FakeClock;
import com.google.cloud.pubsub.v1.MessageDispatcher;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.ReceivedMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.threeten.bp.Duration;

public class MessageDispatcherTest {
    private static final ReceivedMessage TEST_MESSAGE = ReceivedMessage.newBuilder().setAckId("ackid").setMessage(PubsubMessage.newBuilder().setData(ByteString.EMPTY).build()).build();
    private static final Runnable NOOP_RUNNABLE = new Runnable(){

        @Override
        public void run() {
        }
    };
    private MessageDispatcher dispatcher;
    private LinkedBlockingQueue<AckReplyConsumer> consumers;
    private List<String> sentAcks;
    private List<ModAckItem> sentModAcks;
    private FakeClock clock;
    private FlowController flowController;

    @Before
    public void setUp() {
        this.consumers = new LinkedBlockingQueue();
        this.sentAcks = new ArrayList<String>();
        this.sentModAcks = new ArrayList<ModAckItem>();
        MessageReceiver receiver = new MessageReceiver(){

            public void receiveMessage(PubsubMessage message, AckReplyConsumer consumer) {
                MessageDispatcherTest.this.consumers.add(consumer);
            }
        };
        MessageDispatcher.AckProcessor processor = new MessageDispatcher.AckProcessor(){

            public void sendAckOperations(List<String> acksToSend, List<MessageDispatcher.PendingModifyAckDeadline> ackDeadlineExtensions) {
                MessageDispatcherTest.this.sentAcks.addAll(acksToSend);
                for (MessageDispatcher.PendingModifyAckDeadline modack : ackDeadlineExtensions) {
                    for (String ackId : modack.ackIds) {
                        MessageDispatcherTest.this.sentModAcks.add(ModAckItem.of(ackId, modack.deadlineExtensionSeconds));
                    }
                }
            }
        };
        ScheduledThreadPoolExecutor systemExecutor = new ScheduledThreadPoolExecutor(1);
        systemExecutor.shutdownNow();
        this.clock = new FakeClock();
        this.flowController = new FlowController(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(1L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).build());
        this.dispatcher = new MessageDispatcher(receiver, processor, Duration.ofSeconds((long)5L), Duration.ofMinutes((long)60L), new Distribution(601), this.flowController, MoreExecutors.directExecutor(), (ScheduledExecutorService)systemExecutor, (ApiClock)this.clock);
        this.dispatcher.setMessageDeadlineSeconds(10);
    }

    @Test
    public void testReceipt() throws Exception {
        this.dispatcher.processReceivedMessages(Collections.singletonList(TEST_MESSAGE));
        this.dispatcher.processOutstandingAckOperations();
        Truth.assertThat(this.sentModAcks).contains((Object)ModAckItem.of(TEST_MESSAGE.getAckId(), 10));
    }

    @Test
    public void testAck() throws Exception {
        this.dispatcher.processReceivedMessages(Collections.singletonList(TEST_MESSAGE));
        this.consumers.take().ack();
        this.dispatcher.processOutstandingAckOperations();
        Truth.assertThat(this.sentAcks).contains((Object)TEST_MESSAGE.getAckId());
    }

    @Test
    public void testNack() throws Exception {
        this.dispatcher.processReceivedMessages(Collections.singletonList(TEST_MESSAGE));
        this.consumers.take().nack();
        this.dispatcher.processOutstandingAckOperations();
        Truth.assertThat(this.sentModAcks).contains((Object)ModAckItem.of(TEST_MESSAGE.getAckId(), 0));
    }

    @Test
    public void testExtension() throws Exception {
        this.dispatcher.processReceivedMessages(Collections.singletonList(TEST_MESSAGE));
        this.dispatcher.extendDeadlines();
        Truth.assertThat(this.sentModAcks).contains((Object)ModAckItem.of(TEST_MESSAGE.getAckId(), 10));
        this.sentModAcks.clear();
        this.consumers.take().ack();
        this.dispatcher.extendDeadlines();
        Truth.assertThat(this.sentModAcks).isEmpty();
    }

    @Test
    public void testExtension_Close() throws Exception {
        this.dispatcher.processReceivedMessages(Collections.singletonList(TEST_MESSAGE));
        this.dispatcher.extendDeadlines();
        Truth.assertThat(this.sentModAcks).contains((Object)ModAckItem.of(TEST_MESSAGE.getAckId(), 10));
        this.sentModAcks.clear();
        this.clock.advance(3595L, TimeUnit.SECONDS);
        this.dispatcher.extendDeadlines();
        Truth.assertThat(this.sentModAcks).contains((Object)ModAckItem.of(TEST_MESSAGE.getAckId(), 5));
    }

    @Test
    public void testExtension_GiveUp() throws Exception {
        this.dispatcher.processReceivedMessages(Collections.singletonList(TEST_MESSAGE));
        this.dispatcher.extendDeadlines();
        Truth.assertThat(this.sentModAcks).contains((Object)ModAckItem.of(TEST_MESSAGE.getAckId(), 10));
        this.sentModAcks.clear();
        this.clock.advance(1L, TimeUnit.DAYS);
        this.dispatcher.extendDeadlines();
        Truth.assertThat(this.sentModAcks).isEmpty();
        this.flowController.reserve(1L, 0L);
        this.dispatcher.stop();
    }

    @Test
    public void testDeadlineAdjustment() throws Exception {
        Truth.assertThat((Integer)this.dispatcher.computeDeadlineSeconds()).isEqualTo((Object)10);
        this.dispatcher.processReceivedMessages(Collections.singletonList(TEST_MESSAGE));
        this.clock.advance(42L, TimeUnit.SECONDS);
        this.consumers.take().ack();
        Truth.assertThat((Integer)this.dispatcher.computeDeadlineSeconds()).isEqualTo((Object)42);
    }

    static abstract class ModAckItem {
        ModAckItem() {
        }

        abstract String ackId();

        abstract int seconds();

        static ModAckItem of(String ackId, int seconds) {
            return new AutoValue_MessageDispatcherTest_ModAckItem(ackId, seconds);
        }
    }
}

