/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.grpc.testing.MockStreamObserver;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.MockIAMPolicy;
import com.google.cloud.pubsub.v1.MockPublisher;
import com.google.cloud.pubsub.v1.MockSubscriber;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.CreateSnapshotRequest;
import com.google.pubsub.v1.DeleteSnapshotRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ListSnapshotsRequest;
import com.google.pubsub.v1.ListSnapshotsResponse;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.ProjectSnapshotName;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.ReceivedMessage;
import com.google.pubsub.v1.Snapshot;
import com.google.pubsub.v1.StreamingPullRequest;
import com.google.pubsub.v1.StreamingPullResponse;
import com.google.pubsub.v1.Subscription;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SubscriptionAdminClientTest {
    private static MockPublisher mockPublisher;
    private static MockIAMPolicy mockIAMPolicy;
    private static MockSubscriber mockSubscriber;
    private static MockServiceHelper serviceHelper;
    private SubscriptionAdminClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockPublisher = new MockPublisher();
        mockIAMPolicy = new MockIAMPolicy();
        mockSubscriber = new MockSubscriber();
        serviceHelper = new MockServiceHelper("in-process-1", Arrays.asList(mockPublisher, mockIAMPolicy, mockSubscriber));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        SubscriptionAdminSettings settings = ((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = SubscriptionAdminClient.create((SubscriptionAdminSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createSubscriptionTest() {
        ProjectSubscriptionName name2 = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        ProjectTopicName topic2 = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
        int ackDeadlineSeconds2 = 921632575;
        boolean retainAckedMessages = false;
        boolean enableMessageOrdering = true;
        Subscription expectedResponse = Subscription.newBuilder().setName(name2.toString()).setTopic(topic2.toString()).setAckDeadlineSeconds(ackDeadlineSeconds2).setRetainAckedMessages(retainAckedMessages).setEnableMessageOrdering(enableMessageOrdering).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        ProjectSubscriptionName name = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        ProjectTopicName topic = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
        PushConfig pushConfig = PushConfig.newBuilder().build();
        int ackDeadlineSeconds = 2135351438;
        Subscription actualResponse = this.client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Subscription actualRequest = (Subscription)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)ProjectSubscriptionName.parse((String)actualRequest.getName()));
        Assert.assertEquals((Object)Objects.toString(topic), (Object)actualRequest.getTopic());
        Assert.assertEquals((Object)pushConfig, (Object)actualRequest.getPushConfig());
        Assert.assertEquals((long)ackDeadlineSeconds, (long)actualRequest.getAckDeadlineSeconds());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSubscriptionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            ProjectSubscriptionName name = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            ProjectTopicName topic = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
            PushConfig pushConfig = PushConfig.newBuilder().build();
            int ackDeadlineSeconds = 2135351438;
            this.client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSubscriptionTest() {
        ProjectSubscriptionName name = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        ProjectTopicName topic = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
        int ackDeadlineSeconds = 2135351438;
        boolean retainAckedMessages = false;
        boolean enableMessageOrdering = true;
        Subscription expectedResponse = Subscription.newBuilder().setName(name.toString()).setTopic(topic.toString()).setAckDeadlineSeconds(ackDeadlineSeconds).setRetainAckedMessages(retainAckedMessages).setEnableMessageOrdering(enableMessageOrdering).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        Subscription actualResponse = this.client.getSubscription(subscription);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSubscriptionRequest actualRequest = (GetSubscriptionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription, (Object)ProjectSubscriptionName.parse((String)actualRequest.getSubscription()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSubscriptionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            this.client.getSubscription(subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSubscriptionsTest() {
        String nextPageToken = "";
        Subscription subscriptionsElement = Subscription.newBuilder().build();
        List<Subscription> subscriptions = Arrays.asList(subscriptionsElement);
        ListSubscriptionsResponse expectedResponse = ListSubscriptionsResponse.newBuilder().setNextPageToken(nextPageToken).addAllSubscriptions(subscriptions).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        ProjectName project = ProjectName.of((String)"[PROJECT]");
        SubscriptionAdminClient.ListSubscriptionsPagedResponse pagedListResponse = this.client.listSubscriptions(project);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSubscriptionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSubscriptionsRequest actualRequest = (ListSubscriptionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)project, (Object)ProjectName.parse((String)actualRequest.getProject()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSubscriptionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            ProjectName project = ProjectName.of((String)"[PROJECT]");
            this.client.listSubscriptions(project);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSubscriptionTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        this.client.deleteSubscription(subscription);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSubscriptionRequest actualRequest = (DeleteSubscriptionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription, (Object)ProjectSubscriptionName.parse((String)actualRequest.getSubscription()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSubscriptionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            this.client.deleteSubscription(subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void modifyAckDeadlineTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        ArrayList ackIds = new ArrayList();
        int ackDeadlineSeconds = 2135351438;
        this.client.modifyAckDeadline(subscription, ackIds, ackDeadlineSeconds);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ModifyAckDeadlineRequest actualRequest = (ModifyAckDeadlineRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription, (Object)ProjectSubscriptionName.parse((String)actualRequest.getSubscription()));
        Assert.assertEquals(ackIds, (Object)actualRequest.getAckIdsList());
        Assert.assertEquals((long)ackDeadlineSeconds, (long)actualRequest.getAckDeadlineSeconds());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void modifyAckDeadlineExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            ArrayList ackIds = new ArrayList();
            int ackDeadlineSeconds = 2135351438;
            this.client.modifyAckDeadline(subscription, ackIds, ackDeadlineSeconds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void acknowledgeTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        ArrayList ackIds = new ArrayList();
        this.client.acknowledge(subscription, ackIds);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AcknowledgeRequest actualRequest = (AcknowledgeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription, (Object)ProjectSubscriptionName.parse((String)actualRequest.getSubscription()));
        Assert.assertEquals(ackIds, (Object)actualRequest.getAckIdsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void acknowledgeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            ArrayList ackIds = new ArrayList();
            this.client.acknowledge(subscription, ackIds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void pullTest() {
        PullResponse expectedResponse = PullResponse.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        boolean returnImmediately = false;
        int maxMessages = 496131527;
        PullResponse actualResponse = this.client.pull(subscription, returnImmediately, maxMessages);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PullRequest actualRequest = (PullRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription, (Object)ProjectSubscriptionName.parse((String)actualRequest.getSubscription()));
        Assert.assertEquals((Object)returnImmediately, (Object)actualRequest.getReturnImmediately());
        Assert.assertEquals((long)maxMessages, (long)actualRequest.getMaxMessages());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void pullExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            boolean returnImmediately = false;
            int maxMessages = 496131527;
            this.client.pull(subscription, returnImmediately, maxMessages);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void streamingPullTest() throws Exception {
        ReceivedMessage receivedMessagesElement = ReceivedMessage.newBuilder().build();
        List<ReceivedMessage> receivedMessages = Arrays.asList(receivedMessagesElement);
        StreamingPullResponse expectedResponse = StreamingPullResponse.newBuilder().addAllReceivedMessages(receivedMessages).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        int streamAckDeadlineSeconds = 1875467245;
        StreamingPullRequest request = StreamingPullRequest.newBuilder().setSubscription(subscription.toString()).setStreamAckDeadlineSeconds(streamAckDeadlineSeconds).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.streamingPullCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void streamingPullExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        int streamAckDeadlineSeconds = 1875467245;
        StreamingPullRequest request = StreamingPullRequest.newBuilder().setSubscription(subscription.toString()).setStreamAckDeadlineSeconds(streamAckDeadlineSeconds).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.streamingPullCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void modifyPushConfigTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        PushConfig pushConfig = PushConfig.newBuilder().build();
        this.client.modifyPushConfig(subscription, pushConfig);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ModifyPushConfigRequest actualRequest = (ModifyPushConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription, (Object)ProjectSubscriptionName.parse((String)actualRequest.getSubscription()));
        Assert.assertEquals((Object)pushConfig, (Object)actualRequest.getPushConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void modifyPushConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            PushConfig pushConfig = PushConfig.newBuilder().build();
            this.client.modifyPushConfig(subscription, pushConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSnapshotsTest() {
        String nextPageToken = "";
        Snapshot snapshotsElement = Snapshot.newBuilder().build();
        List<Snapshot> snapshots = Arrays.asList(snapshotsElement);
        ListSnapshotsResponse expectedResponse = ListSnapshotsResponse.newBuilder().setNextPageToken(nextPageToken).addAllSnapshots(snapshots).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        ProjectName project = ProjectName.of((String)"[PROJECT]");
        SubscriptionAdminClient.ListSnapshotsPagedResponse pagedListResponse = this.client.listSnapshots(project);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSnapshotsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSnapshotsRequest actualRequest = (ListSnapshotsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)project, (Object)ProjectName.parse((String)actualRequest.getProject()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSnapshotsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            ProjectName project = ProjectName.of((String)"[PROJECT]");
            this.client.listSnapshots(project);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSnapshotTest() {
        ProjectSnapshotName name2 = ProjectSnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
        ProjectTopicName topic = ProjectTopicName.of((String)"[PROJECT]", (String)"[TOPIC]");
        Snapshot expectedResponse = Snapshot.newBuilder().setName(name2.toString()).setTopic(topic.toString()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        ProjectSnapshotName name = ProjectSnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
        ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        Snapshot actualResponse = this.client.createSnapshot(name, subscription);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSnapshotRequest actualRequest = (CreateSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)ProjectSnapshotName.parse((String)actualRequest.getName()));
        Assert.assertEquals((Object)subscription, (Object)ProjectSubscriptionName.parse((String)actualRequest.getSubscription()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSnapshotExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            ProjectSnapshotName name = ProjectSnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
            ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            this.client.createSnapshot(name, subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSnapshotTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        ProjectSnapshotName snapshot = ProjectSnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
        this.client.deleteSnapshot(snapshot);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSnapshotRequest actualRequest = (DeleteSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)snapshot, (Object)ProjectSnapshotName.parse((String)actualRequest.getSnapshot()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSnapshotExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            ProjectSnapshotName snapshot = ProjectSnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
            this.client.deleteSnapshot(snapshot);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() {
        int version = 351608024;
        ByteString etag = ByteString.copyFromUtf8((String)"21");
        Policy expectedResponse = Policy.newBuilder().setVersion(version).setEtag(etag).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        String formattedResource = ProjectSubscriptionName.format((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy(formattedResource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedResource, (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            String formattedResource = ProjectSubscriptionName.format((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy(formattedResource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() {
        int version = 351608024;
        ByteString etag = ByteString.copyFromUtf8((String)"21");
        Policy expectedResponse = Policy.newBuilder().setVersion(version).setEtag(etag).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        String formattedResource = ProjectSubscriptionName.format((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        Policy actualResponse = this.client.getIamPolicy(formattedResource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedResource, (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            String formattedResource = ProjectSubscriptionName.format((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            this.client.getIamPolicy(formattedResource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        String formattedResource = ProjectSubscriptionName.format((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(formattedResource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedResource, (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            String formattedResource = ProjectSubscriptionName.format((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions(formattedResource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

