/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.CreateSnapshotRequest;
import com.google.pubsub.v1.DeleteSnapshotRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ListSnapshotsRequest;
import com.google.pubsub.v1.ListSnapshotsResponse;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.ProjectSnapshotName;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.SeekRequest;
import com.google.pubsub.v1.SeekResponse;
import com.google.pubsub.v1.Snapshot;
import com.google.pubsub.v1.StreamingPullRequest;
import com.google.pubsub.v1.StreamingPullResponse;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.UpdateSnapshotRequest;
import com.google.pubsub.v1.UpdateSubscriptionRequest;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SubscriptionAdminClient
implements BackgroundResource {
    private final SubscriptionAdminSettings settings;
    private final SubscriberStub stub;

    public static final SubscriptionAdminClient create() throws IOException {
        return SubscriptionAdminClient.create(SubscriptionAdminSettings.newBuilder().build());
    }

    public static final SubscriptionAdminClient create(SubscriptionAdminSettings settings) throws IOException {
        return new SubscriptionAdminClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SubscriptionAdminClient create(SubscriberStub stub) {
        return new SubscriptionAdminClient(stub);
    }

    protected SubscriptionAdminClient(SubscriptionAdminSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SubscriberStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SubscriptionAdminClient(SubscriberStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SubscriptionAdminSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SubscriberStub getStub() {
        return this.stub;
    }

    public final Subscription createSubscription(ProjectSubscriptionName name, ProjectTopicName topic, PushConfig pushConfig, int ackDeadlineSeconds) {
        Subscription request = Subscription.newBuilder().setName(name == null ? null : name.toString()).setTopic(topic == null ? null : topic.toString()).setPushConfig(pushConfig).setAckDeadlineSeconds(ackDeadlineSeconds).build();
        return this.createSubscription(request);
    }

    public final Subscription createSubscription(String name, String topic, PushConfig pushConfig, int ackDeadlineSeconds) {
        Subscription request = Subscription.newBuilder().setName(name).setTopic(topic).setPushConfig(pushConfig).setAckDeadlineSeconds(ackDeadlineSeconds).build();
        return this.createSubscription(request);
    }

    public final Subscription createSubscription(Subscription request) {
        return (Subscription)this.createSubscriptionCallable().call((Object)request);
    }

    public final UnaryCallable<Subscription, Subscription> createSubscriptionCallable() {
        return this.stub.createSubscriptionCallable();
    }

    public final Subscription getSubscription(ProjectSubscriptionName subscription) {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setSubscription(subscription == null ? null : subscription.toString()).build();
        return this.getSubscription(request);
    }

    public final Subscription getSubscription(String subscription) {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setSubscription(subscription).build();
        return this.getSubscription(request);
    }

    public final Subscription getSubscription(GetSubscriptionRequest request) {
        return (Subscription)this.getSubscriptionCallable().call((Object)request);
    }

    public final UnaryCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable() {
        return this.stub.getSubscriptionCallable();
    }

    public final Subscription updateSubscription(UpdateSubscriptionRequest request) {
        return (Subscription)this.updateSubscriptionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSubscriptionRequest, Subscription> updateSubscriptionCallable() {
        return this.stub.updateSubscriptionCallable();
    }

    public final ListSubscriptionsPagedResponse listSubscriptions(ProjectName project) {
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listSubscriptions(request);
    }

    public final ListSubscriptionsPagedResponse listSubscriptions(String project) {
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setProject(project).build();
        return this.listSubscriptions(request);
    }

    public final ListSubscriptionsPagedResponse listSubscriptions(ListSubscriptionsRequest request) {
        return (ListSubscriptionsPagedResponse)((Object)this.listSubscriptionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsPagedResponse> listSubscriptionsPagedCallable() {
        return this.stub.listSubscriptionsPagedCallable();
    }

    public final UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable() {
        return this.stub.listSubscriptionsCallable();
    }

    public final void deleteSubscription(ProjectSubscriptionName subscription) {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setSubscription(subscription == null ? null : subscription.toString()).build();
        this.deleteSubscription(request);
    }

    public final void deleteSubscription(String subscription) {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setSubscription(subscription).build();
        this.deleteSubscription(request);
    }

    public final void deleteSubscription(DeleteSubscriptionRequest request) {
        this.deleteSubscriptionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSubscriptionRequest, Empty> deleteSubscriptionCallable() {
        return this.stub.deleteSubscriptionCallable();
    }

    final void modifyAckDeadline(ProjectSubscriptionName subscription, List<String> ackIds, int ackDeadlineSeconds) {
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setSubscription(subscription == null ? null : subscription.toString()).addAllAckIds(ackIds).setAckDeadlineSeconds(ackDeadlineSeconds).build();
        this.modifyAckDeadline(request);
    }

    final void modifyAckDeadline(String subscription, List<String> ackIds, int ackDeadlineSeconds) {
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setSubscription(subscription).addAllAckIds(ackIds).setAckDeadlineSeconds(ackDeadlineSeconds).build();
        this.modifyAckDeadline(request);
    }

    final void modifyAckDeadline(ModifyAckDeadlineRequest request) {
        this.modifyAckDeadlineCallable().call((Object)request);
    }

    final UnaryCallable<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineCallable() {
        return this.stub.modifyAckDeadlineCallable();
    }

    final void acknowledge(ProjectSubscriptionName subscription, List<String> ackIds) {
        AcknowledgeRequest request = AcknowledgeRequest.newBuilder().setSubscription(subscription == null ? null : subscription.toString()).addAllAckIds(ackIds).build();
        this.acknowledge(request);
    }

    final void acknowledge(String subscription, List<String> ackIds) {
        AcknowledgeRequest request = AcknowledgeRequest.newBuilder().setSubscription(subscription).addAllAckIds(ackIds).build();
        this.acknowledge(request);
    }

    final void acknowledge(AcknowledgeRequest request) {
        this.acknowledgeCallable().call((Object)request);
    }

    final UnaryCallable<AcknowledgeRequest, Empty> acknowledgeCallable() {
        return this.stub.acknowledgeCallable();
    }

    final PullResponse pull(ProjectSubscriptionName subscription, boolean returnImmediately, int maxMessages) {
        PullRequest request = PullRequest.newBuilder().setSubscription(subscription == null ? null : subscription.toString()).setReturnImmediately(returnImmediately).setMaxMessages(maxMessages).build();
        return this.pull(request);
    }

    final PullResponse pull(String subscription, boolean returnImmediately, int maxMessages) {
        PullRequest request = PullRequest.newBuilder().setSubscription(subscription).setReturnImmediately(returnImmediately).setMaxMessages(maxMessages).build();
        return this.pull(request);
    }

    final PullResponse pull(PullRequest request) {
        return (PullResponse)this.pullCallable().call((Object)request);
    }

    final UnaryCallable<PullRequest, PullResponse> pullCallable() {
        return this.stub.pullCallable();
    }

    final BidiStreamingCallable<StreamingPullRequest, StreamingPullResponse> streamingPullCallable() {
        return this.stub.streamingPullCallable();
    }

    public final void modifyPushConfig(ProjectSubscriptionName subscription, PushConfig pushConfig) {
        ModifyPushConfigRequest request = ModifyPushConfigRequest.newBuilder().setSubscription(subscription == null ? null : subscription.toString()).setPushConfig(pushConfig).build();
        this.modifyPushConfig(request);
    }

    public final void modifyPushConfig(String subscription, PushConfig pushConfig) {
        ModifyPushConfigRequest request = ModifyPushConfigRequest.newBuilder().setSubscription(subscription).setPushConfig(pushConfig).build();
        this.modifyPushConfig(request);
    }

    public final void modifyPushConfig(ModifyPushConfigRequest request) {
        this.modifyPushConfigCallable().call((Object)request);
    }

    public final UnaryCallable<ModifyPushConfigRequest, Empty> modifyPushConfigCallable() {
        return this.stub.modifyPushConfigCallable();
    }

    public final ListSnapshotsPagedResponse listSnapshots(ProjectName project) {
        ListSnapshotsRequest request = ListSnapshotsRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listSnapshots(request);
    }

    public final ListSnapshotsPagedResponse listSnapshots(String project) {
        ListSnapshotsRequest request = ListSnapshotsRequest.newBuilder().setProject(project).build();
        return this.listSnapshots(request);
    }

    public final ListSnapshotsPagedResponse listSnapshots(ListSnapshotsRequest request) {
        return (ListSnapshotsPagedResponse)((Object)this.listSnapshotsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSnapshotsRequest, ListSnapshotsPagedResponse> listSnapshotsPagedCallable() {
        return this.stub.listSnapshotsPagedCallable();
    }

    public final UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsCallable() {
        return this.stub.listSnapshotsCallable();
    }

    public final Snapshot createSnapshot(ProjectSnapshotName name, ProjectSubscriptionName subscription) {
        CreateSnapshotRequest request = CreateSnapshotRequest.newBuilder().setName(name == null ? null : name.toString()).setSubscription(subscription == null ? null : subscription.toString()).build();
        return this.createSnapshot(request);
    }

    public final Snapshot createSnapshot(String name, String subscription) {
        CreateSnapshotRequest request = CreateSnapshotRequest.newBuilder().setName(name).setSubscription(subscription).build();
        return this.createSnapshot(request);
    }

    public final Snapshot createSnapshot(CreateSnapshotRequest request) {
        return (Snapshot)this.createSnapshotCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSnapshotRequest, Snapshot> createSnapshotCallable() {
        return this.stub.createSnapshotCallable();
    }

    public final Snapshot updateSnapshot(UpdateSnapshotRequest request) {
        return (Snapshot)this.updateSnapshotCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSnapshotRequest, Snapshot> updateSnapshotCallable() {
        return this.stub.updateSnapshotCallable();
    }

    public final void deleteSnapshot(ProjectSnapshotName snapshot) {
        DeleteSnapshotRequest request = DeleteSnapshotRequest.newBuilder().setSnapshot(snapshot == null ? null : snapshot.toString()).build();
        this.deleteSnapshot(request);
    }

    public final void deleteSnapshot(String snapshot) {
        DeleteSnapshotRequest request = DeleteSnapshotRequest.newBuilder().setSnapshot(snapshot).build();
        this.deleteSnapshot(request);
    }

    public final void deleteSnapshot(DeleteSnapshotRequest request) {
        this.deleteSnapshotCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSnapshotRequest, Empty> deleteSnapshotCallable() {
        return this.stub.deleteSnapshotCallable();
    }

    public final SeekResponse seek(SeekRequest request) {
        return (SeekResponse)this.seekCallable().call((Object)request);
    }

    public final UnaryCallable<SeekRequest, SeekResponse> seekCallable() {
        return this.stub.seekCallable();
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSnapshotsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot, ListSnapshotsPage, ListSnapshotsFixedSizeCollection> {
        private ListSnapshotsFixedSizeCollection(List<ListSnapshotsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSnapshotsFixedSizeCollection createEmptyCollection() {
            return new ListSnapshotsFixedSizeCollection(null, 0);
        }

        protected ListSnapshotsFixedSizeCollection createCollection(List<ListSnapshotsPage> pages, int collectionSize) {
            return new ListSnapshotsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSnapshotsPage
    extends AbstractPage<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot, ListSnapshotsPage> {
        private ListSnapshotsPage(PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> context, ListSnapshotsResponse response) {
            super(context, (Object)response);
        }

        private static ListSnapshotsPage createEmptyPage() {
            return new ListSnapshotsPage(null, null);
        }

        protected ListSnapshotsPage createPage(PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> context, ListSnapshotsResponse response) {
            return new ListSnapshotsPage(context, response);
        }

        public ApiFuture<ListSnapshotsPage> createPageAsync(PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> context, ApiFuture<ListSnapshotsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSnapshotsPagedResponse
    extends AbstractPagedListResponse<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot, ListSnapshotsPage, ListSnapshotsFixedSizeCollection> {
        public static ApiFuture<ListSnapshotsPagedResponse> createAsync(PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> context, ApiFuture<ListSnapshotsResponse> futureResponse) {
            ApiFuture<ListSnapshotsPage> futurePage = ListSnapshotsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListSnapshotsPage, ListSnapshotsPagedResponse>(){

                public ListSnapshotsPagedResponse apply(ListSnapshotsPage input) {
                    return new ListSnapshotsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListSnapshotsPagedResponse(ListSnapshotsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSnapshotsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSubscriptionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription, ListSubscriptionsPage, ListSubscriptionsFixedSizeCollection> {
        private ListSubscriptionsFixedSizeCollection(List<ListSubscriptionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSubscriptionsFixedSizeCollection createEmptyCollection() {
            return new ListSubscriptionsFixedSizeCollection(null, 0);
        }

        protected ListSubscriptionsFixedSizeCollection createCollection(List<ListSubscriptionsPage> pages, int collectionSize) {
            return new ListSubscriptionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSubscriptionsPage
    extends AbstractPage<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription, ListSubscriptionsPage> {
        private ListSubscriptionsPage(PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> context, ListSubscriptionsResponse response) {
            super(context, (Object)response);
        }

        private static ListSubscriptionsPage createEmptyPage() {
            return new ListSubscriptionsPage(null, null);
        }

        protected ListSubscriptionsPage createPage(PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> context, ListSubscriptionsResponse response) {
            return new ListSubscriptionsPage(context, response);
        }

        public ApiFuture<ListSubscriptionsPage> createPageAsync(PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> context, ApiFuture<ListSubscriptionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSubscriptionsPagedResponse
    extends AbstractPagedListResponse<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription, ListSubscriptionsPage, ListSubscriptionsFixedSizeCollection> {
        public static ApiFuture<ListSubscriptionsPagedResponse> createAsync(PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> context, ApiFuture<ListSubscriptionsResponse> futureResponse) {
            ApiFuture<ListSubscriptionsPage> futurePage = ListSubscriptionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListSubscriptionsPage, ListSubscriptionsPagedResponse>(){

                public ListSubscriptionsPagedResponse apply(ListSubscriptionsPage input) {
                    return new ListSubscriptionsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListSubscriptionsPagedResponse(ListSubscriptionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSubscriptionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

