/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.securitycenter.v1.Access;
import com.google.cloud.securitycenter.v1.BigQueryExport;
import com.google.cloud.securitycenter.v1.BigQueryExportName;
import com.google.cloud.securitycenter.v1.BulkMuteFindingsResponse;
import com.google.cloud.securitycenter.v1.CloudDlpDataProfile;
import com.google.cloud.securitycenter.v1.CloudDlpInspection;
import com.google.cloud.securitycenter.v1.CustomConfig;
import com.google.cloud.securitycenter.v1.Database;
import com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule;
import com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModuleName;
import com.google.cloud.securitycenter.v1.Exfiltration;
import com.google.cloud.securitycenter.v1.ExternalSystem;
import com.google.cloud.securitycenter.v1.Finding;
import com.google.cloud.securitycenter.v1.FindingName;
import com.google.cloud.securitycenter.v1.FolderName;
import com.google.cloud.securitycenter.v1.GroupAssetsRequest;
import com.google.cloud.securitycenter.v1.GroupAssetsResponse;
import com.google.cloud.securitycenter.v1.GroupFindingsResponse;
import com.google.cloud.securitycenter.v1.GroupResult;
import com.google.cloud.securitycenter.v1.Indicator;
import com.google.cloud.securitycenter.v1.KernelRootkit;
import com.google.cloud.securitycenter.v1.Kubernetes;
import com.google.cloud.securitycenter.v1.ListAssetsRequest;
import com.google.cloud.securitycenter.v1.ListAssetsResponse;
import com.google.cloud.securitycenter.v1.ListBigQueryExportsResponse;
import com.google.cloud.securitycenter.v1.ListDescendantSecurityHealthAnalyticsCustomModulesResponse;
import com.google.cloud.securitycenter.v1.ListEffectiveSecurityHealthAnalyticsCustomModulesResponse;
import com.google.cloud.securitycenter.v1.ListFindingsRequest;
import com.google.cloud.securitycenter.v1.ListFindingsResponse;
import com.google.cloud.securitycenter.v1.ListMuteConfigsResponse;
import com.google.cloud.securitycenter.v1.ListNotificationConfigsResponse;
import com.google.cloud.securitycenter.v1.ListSecurityHealthAnalyticsCustomModulesResponse;
import com.google.cloud.securitycenter.v1.ListSourcesResponse;
import com.google.cloud.securitycenter.v1.MitreAttack;
import com.google.cloud.securitycenter.v1.MuteConfig;
import com.google.cloud.securitycenter.v1.MuteConfigName;
import com.google.cloud.securitycenter.v1.NotificationConfig;
import com.google.cloud.securitycenter.v1.NotificationConfigName;
import com.google.cloud.securitycenter.v1.OrganizationName;
import com.google.cloud.securitycenter.v1.OrganizationSettings;
import com.google.cloud.securitycenter.v1.OrganizationSettingsName;
import com.google.cloud.securitycenter.v1.ProjectName;
import com.google.cloud.securitycenter.v1.RunAssetDiscoveryResponse;
import com.google.cloud.securitycenter.v1.SecurityCenterClient;
import com.google.cloud.securitycenter.v1.SecurityCenterSettings;
import com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule;
import com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModuleName;
import com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsSettingsName;
import com.google.cloud.securitycenter.v1.SecurityMarks;
import com.google.cloud.securitycenter.v1.Source;
import com.google.cloud.securitycenter.v1.SourceName;
import com.google.cloud.securitycenter.v1.Vulnerability;
import com.google.cloud.securitycenter.v1.stub.HttpJsonSecurityCenterStub;
import com.google.common.collect.Lists;
import com.google.iam.v1.Policy;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SecurityCenterClientHttpJsonTest {
    private static MockHttpService mockService;
    private static SecurityCenterClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonSecurityCenterStub.getMethodDescriptors(), SecurityCenterSettings.getDefaultEndpoint());
        SecurityCenterSettings settings = ((SecurityCenterSettings.Builder)((SecurityCenterSettings.Builder)SecurityCenterSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)SecurityCenterSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = SecurityCenterClient.create((SecurityCenterSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void bulkMuteFindingsTest() throws Exception {
        BulkMuteFindingsResponse expectedResponse = BulkMuteFindingsResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("bulkMuteFindingsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        BulkMuteFindingsResponse actualResponse = (BulkMuteFindingsResponse)client.bulkMuteFindingsAsync((ResourceName)parent).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void bulkMuteFindingsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            client.bulkMuteFindingsAsync((ResourceName)parent).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void bulkMuteFindingsTest2() throws Exception {
        BulkMuteFindingsResponse expectedResponse = BulkMuteFindingsResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("bulkMuteFindingsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "organizations/organization-8287";
        BulkMuteFindingsResponse actualResponse = (BulkMuteFindingsResponse)client.bulkMuteFindingsAsync(parent).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void bulkMuteFindingsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            client.bulkMuteFindingsAsync(parent).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createSecurityHealthAnalyticsCustomModuleTest() throws Exception {
        SecurityHealthAnalyticsCustomModule expectedResponse = SecurityHealthAnalyticsCustomModule.newBuilder().setName(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setDisplayName("displayName1714148973").setUpdateTime(Timestamp.newBuilder().build()).setLastEditor("lastEditor1523898275").setAncestorModule(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setCustomConfig(CustomConfig.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        SecurityHealthAnalyticsSettingsName parent = SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)"[ORGANIZATION]");
        SecurityHealthAnalyticsCustomModule securityHealthAnalyticsCustomModule = SecurityHealthAnalyticsCustomModule.newBuilder().build();
        SecurityHealthAnalyticsCustomModule actualResponse = client.createSecurityHealthAnalyticsCustomModule(parent, securityHealthAnalyticsCustomModule);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSecurityHealthAnalyticsCustomModuleExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SecurityHealthAnalyticsSettingsName parent = SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)"[ORGANIZATION]");
            SecurityHealthAnalyticsCustomModule securityHealthAnalyticsCustomModule = SecurityHealthAnalyticsCustomModule.newBuilder().build();
            client.createSecurityHealthAnalyticsCustomModule(parent, securityHealthAnalyticsCustomModule);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSecurityHealthAnalyticsCustomModuleTest2() throws Exception {
        SecurityHealthAnalyticsCustomModule expectedResponse = SecurityHealthAnalyticsCustomModule.newBuilder().setName(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setDisplayName("displayName1714148973").setUpdateTime(Timestamp.newBuilder().build()).setLastEditor("lastEditor1523898275").setAncestorModule(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setCustomConfig(CustomConfig.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-7807/securityHealthAnalyticsSettings";
        SecurityHealthAnalyticsCustomModule securityHealthAnalyticsCustomModule = SecurityHealthAnalyticsCustomModule.newBuilder().build();
        SecurityHealthAnalyticsCustomModule actualResponse = client.createSecurityHealthAnalyticsCustomModule(parent, securityHealthAnalyticsCustomModule);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSecurityHealthAnalyticsCustomModuleExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-7807/securityHealthAnalyticsSettings";
            SecurityHealthAnalyticsCustomModule securityHealthAnalyticsCustomModule = SecurityHealthAnalyticsCustomModule.newBuilder().build();
            client.createSecurityHealthAnalyticsCustomModule(parent, securityHealthAnalyticsCustomModule);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSourceTest() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        Source source = Source.newBuilder().build();
        Source actualResponse = client.createSource(parent, source);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSourceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            Source source = Source.newBuilder().build();
            client.createSource(parent, source);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSourceTest2() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8287";
        Source source = Source.newBuilder().build();
        Source actualResponse = client.createSource(parent, source);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSourceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            Source source = Source.newBuilder().build();
            client.createSource(parent, source);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createFindingTest() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").setIndicator(Indicator.newBuilder().build()).setVulnerability(Vulnerability.newBuilder().build()).setMuteUpdateTime(Timestamp.newBuilder().build()).putAllExternalSystems(new HashMap()).setMitreAttack(MitreAttack.newBuilder().build()).setAccess(Access.newBuilder().build()).addAllConnections(new ArrayList()).setMuteInitiator("muteInitiator1395645462").addAllProcesses(new ArrayList()).putAllContacts(new HashMap()).addAllCompliances(new ArrayList()).setParentDisplayName("parentDisplayName-1523759261").setDescription("description-1724546052").setExfiltration(Exfiltration.newBuilder().build()).addAllIamBindings(new ArrayList()).setNextSteps("nextSteps1206138868").setModuleName("moduleName-870351081").addAllContainers(new ArrayList()).setKubernetes(Kubernetes.newBuilder().build()).setDatabase(Database.newBuilder().build()).addAllFiles(new ArrayList()).setCloudDlpInspection(CloudDlpInspection.newBuilder().build()).setCloudDlpDataProfile(CloudDlpDataProfile.newBuilder().build()).setKernelRootkit(KernelRootkit.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        SourceName parent = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        String findingId = "findingId439150212";
        Finding finding = Finding.newBuilder().build();
        Finding actualResponse = client.createFinding(parent, findingId, finding);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createFindingExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SourceName parent = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            String findingId = "findingId439150212";
            Finding finding = Finding.newBuilder().build();
            client.createFinding(parent, findingId, finding);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createFindingTest2() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").setIndicator(Indicator.newBuilder().build()).setVulnerability(Vulnerability.newBuilder().build()).setMuteUpdateTime(Timestamp.newBuilder().build()).putAllExternalSystems(new HashMap()).setMitreAttack(MitreAttack.newBuilder().build()).setAccess(Access.newBuilder().build()).addAllConnections(new ArrayList()).setMuteInitiator("muteInitiator1395645462").addAllProcesses(new ArrayList()).putAllContacts(new HashMap()).addAllCompliances(new ArrayList()).setParentDisplayName("parentDisplayName-1523759261").setDescription("description-1724546052").setExfiltration(Exfiltration.newBuilder().build()).addAllIamBindings(new ArrayList()).setNextSteps("nextSteps1206138868").setModuleName("moduleName-870351081").addAllContainers(new ArrayList()).setKubernetes(Kubernetes.newBuilder().build()).setDatabase(Database.newBuilder().build()).addAllFiles(new ArrayList()).setCloudDlpInspection(CloudDlpInspection.newBuilder().build()).setCloudDlpDataProfile(CloudDlpDataProfile.newBuilder().build()).setKernelRootkit(KernelRootkit.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8741/sources/source-8741";
        String findingId = "findingId439150212";
        Finding finding = Finding.newBuilder().build();
        Finding actualResponse = client.createFinding(parent, findingId, finding);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createFindingExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8741/sources/source-8741";
            String findingId = "findingId439150212";
            Finding finding = Finding.newBuilder().build();
            client.createFinding(parent, findingId, finding);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMuteConfigTest() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockService.addResponse((Object)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        MuteConfig actualResponse = client.createMuteConfig(parent, muteConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createMuteConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            client.createMuteConfig(parent, muteConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMuteConfigTest2() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        MuteConfig actualResponse = client.createMuteConfig(parent, muteConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createMuteConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            client.createMuteConfig(parent, muteConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMuteConfigTest3() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        MuteConfig actualResponse = client.createMuteConfig(parent, muteConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createMuteConfigExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            client.createMuteConfig(parent, muteConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMuteConfigTest4() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8287";
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        MuteConfig actualResponse = client.createMuteConfig(parent, muteConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createMuteConfigExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            client.createMuteConfig(parent, muteConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMuteConfigTest5() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockService.addResponse((Object)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        String muteConfigId = "muteConfigId1689669942";
        MuteConfig actualResponse = client.createMuteConfig(parent, muteConfig, muteConfigId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createMuteConfigExceptionTest5() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            String muteConfigId = "muteConfigId1689669942";
            client.createMuteConfig(parent, muteConfig, muteConfigId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMuteConfigTest6() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        String muteConfigId = "muteConfigId1689669942";
        MuteConfig actualResponse = client.createMuteConfig(parent, muteConfig, muteConfigId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createMuteConfigExceptionTest6() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            String muteConfigId = "muteConfigId1689669942";
            client.createMuteConfig(parent, muteConfig, muteConfigId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMuteConfigTest7() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        String muteConfigId = "muteConfigId1689669942";
        MuteConfig actualResponse = client.createMuteConfig(parent, muteConfig, muteConfigId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createMuteConfigExceptionTest7() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            String muteConfigId = "muteConfigId1689669942";
            client.createMuteConfig(parent, muteConfig, muteConfigId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMuteConfigTest8() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8287";
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        String muteConfigId = "muteConfigId1689669942";
        MuteConfig actualResponse = client.createMuteConfig(parent, muteConfig, muteConfigId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createMuteConfigExceptionTest8() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            String muteConfigId = "muteConfigId1689669942";
            client.createMuteConfig(parent, muteConfig, muteConfigId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = client.createNotificationConfig(parent, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createNotificationConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            client.createNotificationConfig(parent, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest2() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = client.createNotificationConfig(parent, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createNotificationConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            client.createNotificationConfig(parent, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest3() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = client.createNotificationConfig(parent, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createNotificationConfigExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            client.createNotificationConfig(parent, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest4() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8287";
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = client.createNotificationConfig(parent, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createNotificationConfigExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            client.createNotificationConfig(parent, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest5() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        String configId = "configId-580140035";
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = client.createNotificationConfig(parent, configId, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createNotificationConfigExceptionTest5() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            String configId = "configId-580140035";
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            client.createNotificationConfig(parent, configId, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest6() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        String configId = "configId-580140035";
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = client.createNotificationConfig(parent, configId, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createNotificationConfigExceptionTest6() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            String configId = "configId-580140035";
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            client.createNotificationConfig(parent, configId, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest7() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        String configId = "configId-580140035";
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = client.createNotificationConfig(parent, configId, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createNotificationConfigExceptionTest7() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            String configId = "configId-580140035";
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            client.createNotificationConfig(parent, configId, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest8() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8287";
        String configId = "configId-580140035";
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = client.createNotificationConfig(parent, configId, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createNotificationConfigExceptionTest8() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            String configId = "configId-580140035";
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            client.createNotificationConfig(parent, configId, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteMuteConfigTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        MuteConfigName name = MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]");
        client.deleteMuteConfig(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteMuteConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            MuteConfigName name = MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]");
            client.deleteMuteConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteMuteConfigTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-3180/muteConfigs/muteConfig-3180";
        client.deleteMuteConfig(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteMuteConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-3180/muteConfigs/muteConfig-3180";
            client.deleteMuteConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteNotificationConfigTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        NotificationConfigName name = NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]");
        client.deleteNotificationConfig(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteNotificationConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            NotificationConfigName name = NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]");
            client.deleteNotificationConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteNotificationConfigTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-7374/notificationConfigs/notificationConfig-7374";
        client.deleteNotificationConfig(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteNotificationConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-7374/notificationConfigs/notificationConfig-7374";
            client.deleteNotificationConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSecurityHealthAnalyticsCustomModuleTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        SecurityHealthAnalyticsCustomModuleName name = SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]");
        client.deleteSecurityHealthAnalyticsCustomModule(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSecurityHealthAnalyticsCustomModuleExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SecurityHealthAnalyticsCustomModuleName name = SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]");
            client.deleteSecurityHealthAnalyticsCustomModule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSecurityHealthAnalyticsCustomModuleTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-3280/securityHealthAnalyticsSettings/customModules/customModule-3280";
        client.deleteSecurityHealthAnalyticsCustomModule(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSecurityHealthAnalyticsCustomModuleExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-3280/securityHealthAnalyticsSettings/customModules/customModule-3280";
            client.deleteSecurityHealthAnalyticsCustomModule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getBigQueryExportTest() throws Exception {
        BigQueryExport expectedResponse = BigQueryExport.newBuilder().setName(BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]").toString()).setDescription("description-1724546052").setFilter("filter-1274492040").setDataset("dataset1443214456").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").setPrincipal("principal-1812041682").build();
        mockService.addResponse((Object)expectedResponse);
        BigQueryExportName name = BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]");
        BigQueryExport actualResponse = client.getBigQueryExport(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getBigQueryExportExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BigQueryExportName name = BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]");
            client.getBigQueryExport(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getBigQueryExportTest2() throws Exception {
        BigQueryExport expectedResponse = BigQueryExport.newBuilder().setName(BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]").toString()).setDescription("description-1724546052").setFilter("filter-1274492040").setDataset("dataset1443214456").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").setPrincipal("principal-1812041682").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-3683/bigQueryExports/bigQueryExport-3683";
        BigQueryExport actualResponse = client.getBigQueryExport(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getBigQueryExportExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-3683/bigQueryExports/bigQueryExport-3683";
            client.getBigQueryExport(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        Policy actualResponse = client.getIamPolicy((ResourceName)resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            client.getIamPolicy((ResourceName)resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        String resource = "organizations/organization-3393/sources/source-3393";
        Policy actualResponse = client.getIamPolicy(resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIamPolicyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String resource = "organizations/organization-3393/sources/source-3393";
            client.getIamPolicy(resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getMuteConfigTest() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockService.addResponse((Object)expectedResponse);
        MuteConfigName name = MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]");
        MuteConfig actualResponse = client.getMuteConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getMuteConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            MuteConfigName name = MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]");
            client.getMuteConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getMuteConfigTest2() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-3180/muteConfigs/muteConfig-3180";
        MuteConfig actualResponse = client.getMuteConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getMuteConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-3180/muteConfigs/muteConfig-3180";
            client.getMuteConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNotificationConfigTest() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        NotificationConfigName name = NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]");
        NotificationConfig actualResponse = client.getNotificationConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getNotificationConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            NotificationConfigName name = NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]");
            client.getNotificationConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNotificationConfigTest2() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-7374/notificationConfigs/notificationConfig-7374";
        NotificationConfig actualResponse = client.getNotificationConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getNotificationConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-7374/notificationConfigs/notificationConfig-7374";
            client.getNotificationConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOrganizationSettingsTest() throws Exception {
        OrganizationSettings expectedResponse = OrganizationSettings.newBuilder().setName(OrganizationSettingsName.of((String)"[ORGANIZATION]").toString()).setEnableAssetDiscovery(true).setAssetDiscoveryConfig(OrganizationSettings.AssetDiscoveryConfig.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationSettingsName name = OrganizationSettingsName.of((String)"[ORGANIZATION]");
        OrganizationSettings actualResponse = client.getOrganizationSettings(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getOrganizationSettingsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationSettingsName name = OrganizationSettingsName.of((String)"[ORGANIZATION]");
            client.getOrganizationSettings(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOrganizationSettingsTest2() throws Exception {
        OrganizationSettings expectedResponse = OrganizationSettings.newBuilder().setName(OrganizationSettingsName.of((String)"[ORGANIZATION]").toString()).setEnableAssetDiscovery(true).setAssetDiscoveryConfig(OrganizationSettings.AssetDiscoveryConfig.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-9995/organizationSettings";
        OrganizationSettings actualResponse = client.getOrganizationSettings(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getOrganizationSettingsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-9995/organizationSettings";
            client.getOrganizationSettings(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getEffectiveSecurityHealthAnalyticsCustomModuleTest() throws Exception {
        EffectiveSecurityHealthAnalyticsCustomModule expectedResponse = EffectiveSecurityHealthAnalyticsCustomModule.newBuilder().setName(EffectiveSecurityHealthAnalyticsCustomModuleName.ofOrganizationEffectiveCustomModuleName((String)"[ORGANIZATION]", (String)"[EFFECTIVE_CUSTOM_MODULE]").toString()).setCustomConfig(CustomConfig.newBuilder().build()).setDisplayName("displayName1714148973").build();
        mockService.addResponse((Object)expectedResponse);
        EffectiveSecurityHealthAnalyticsCustomModuleName name = EffectiveSecurityHealthAnalyticsCustomModuleName.ofOrganizationEffectiveCustomModuleName((String)"[ORGANIZATION]", (String)"[EFFECTIVE_CUSTOM_MODULE]");
        EffectiveSecurityHealthAnalyticsCustomModule actualResponse = client.getEffectiveSecurityHealthAnalyticsCustomModule(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getEffectiveSecurityHealthAnalyticsCustomModuleExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            EffectiveSecurityHealthAnalyticsCustomModuleName name = EffectiveSecurityHealthAnalyticsCustomModuleName.ofOrganizationEffectiveCustomModuleName((String)"[ORGANIZATION]", (String)"[EFFECTIVE_CUSTOM_MODULE]");
            client.getEffectiveSecurityHealthAnalyticsCustomModule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getEffectiveSecurityHealthAnalyticsCustomModuleTest2() throws Exception {
        EffectiveSecurityHealthAnalyticsCustomModule expectedResponse = EffectiveSecurityHealthAnalyticsCustomModule.newBuilder().setName(EffectiveSecurityHealthAnalyticsCustomModuleName.ofOrganizationEffectiveCustomModuleName((String)"[ORGANIZATION]", (String)"[EFFECTIVE_CUSTOM_MODULE]").toString()).setCustomConfig(CustomConfig.newBuilder().build()).setDisplayName("displayName1714148973").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-9493/securityHealthAnalyticsSettings/effectiveCustomModules/effectiveCustomModule-9493";
        EffectiveSecurityHealthAnalyticsCustomModule actualResponse = client.getEffectiveSecurityHealthAnalyticsCustomModule(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getEffectiveSecurityHealthAnalyticsCustomModuleExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-9493/securityHealthAnalyticsSettings/effectiveCustomModules/effectiveCustomModule-9493";
            client.getEffectiveSecurityHealthAnalyticsCustomModule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSecurityHealthAnalyticsCustomModuleTest() throws Exception {
        SecurityHealthAnalyticsCustomModule expectedResponse = SecurityHealthAnalyticsCustomModule.newBuilder().setName(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setDisplayName("displayName1714148973").setUpdateTime(Timestamp.newBuilder().build()).setLastEditor("lastEditor1523898275").setAncestorModule(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setCustomConfig(CustomConfig.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        SecurityHealthAnalyticsCustomModuleName name = SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]");
        SecurityHealthAnalyticsCustomModule actualResponse = client.getSecurityHealthAnalyticsCustomModule(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSecurityHealthAnalyticsCustomModuleExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SecurityHealthAnalyticsCustomModuleName name = SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]");
            client.getSecurityHealthAnalyticsCustomModule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSecurityHealthAnalyticsCustomModuleTest2() throws Exception {
        SecurityHealthAnalyticsCustomModule expectedResponse = SecurityHealthAnalyticsCustomModule.newBuilder().setName(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setDisplayName("displayName1714148973").setUpdateTime(Timestamp.newBuilder().build()).setLastEditor("lastEditor1523898275").setAncestorModule(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setCustomConfig(CustomConfig.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-3280/securityHealthAnalyticsSettings/customModules/customModule-3280";
        SecurityHealthAnalyticsCustomModule actualResponse = client.getSecurityHealthAnalyticsCustomModule(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSecurityHealthAnalyticsCustomModuleExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-3280/securityHealthAnalyticsSettings/customModules/customModule-3280";
            client.getSecurityHealthAnalyticsCustomModule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSourceTest() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        SourceName name = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        Source actualResponse = client.getSource(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSourceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SourceName name = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            client.getSource(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSourceTest2() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-7292/sources/source-7292";
        Source actualResponse = client.getSource(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSourceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-7292/sources/source-7292";
            client.getSource(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void groupAssetsTest() throws Exception {
        GroupResult responsesElement = GroupResult.newBuilder().build();
        GroupAssetsResponse expectedResponse = GroupAssetsResponse.newBuilder().setNextPageToken("").addAllGroupByResults(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        GroupAssetsRequest request = GroupAssetsRequest.newBuilder().setParent(OrganizationName.of((String)"[ORGANIZATION]").toString()).setFilter("filter-1274492040").setGroupBy("groupBy293428022").setCompareDuration(Duration.newBuilder().build()).setReadTime(Timestamp.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
        SecurityCenterClient.GroupAssetsPagedResponse pagedListResponse = client.groupAssets(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGroupByResultsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void groupAssetsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GroupAssetsRequest request = GroupAssetsRequest.newBuilder().setParent(OrganizationName.of((String)"[ORGANIZATION]").toString()).setFilter("filter-1274492040").setGroupBy("groupBy293428022").setCompareDuration(Duration.newBuilder().build()).setReadTime(Timestamp.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
            client.groupAssets(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void groupFindingsTest() throws Exception {
        GroupResult responsesElement = GroupResult.newBuilder().build();
        GroupFindingsResponse expectedResponse = GroupFindingsResponse.newBuilder().setNextPageToken("").addAllGroupByResults(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        SourceName parent = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        String groupBy = "groupBy293428022";
        SecurityCenterClient.GroupFindingsPagedResponse pagedListResponse = client.groupFindings(parent, groupBy);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGroupByResultsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void groupFindingsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SourceName parent = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            String groupBy = "groupBy293428022";
            client.groupFindings(parent, groupBy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void groupFindingsTest2() throws Exception {
        GroupResult responsesElement = GroupResult.newBuilder().build();
        GroupFindingsResponse expectedResponse = GroupFindingsResponse.newBuilder().setNextPageToken("").addAllGroupByResults(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8741/sources/source-8741";
        String groupBy = "groupBy293428022";
        SecurityCenterClient.GroupFindingsPagedResponse pagedListResponse = client.groupFindings(parent, groupBy);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGroupByResultsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void groupFindingsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8741/sources/source-8741";
            String groupBy = "groupBy293428022";
            client.groupFindings(parent, groupBy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAssetsTest() throws Exception {
        ListAssetsResponse.ListAssetsResult responsesElement = ListAssetsResponse.ListAssetsResult.newBuilder().build();
        ListAssetsResponse expectedResponse = ListAssetsResponse.newBuilder().setNextPageToken("").addAllListAssetsResults(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ListAssetsRequest request = ListAssetsRequest.newBuilder().setParent(OrganizationName.of((String)"[ORGANIZATION]").toString()).setFilter("filter-1274492040").setOrderBy("orderBy-1207110587").setReadTime(Timestamp.newBuilder().build()).setCompareDuration(Duration.newBuilder().build()).setFieldMask(FieldMask.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
        SecurityCenterClient.ListAssetsPagedResponse pagedListResponse = client.listAssets(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getListAssetsResultsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listAssetsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ListAssetsRequest request = ListAssetsRequest.newBuilder().setParent(OrganizationName.of((String)"[ORGANIZATION]").toString()).setFilter("filter-1274492040").setOrderBy("orderBy-1207110587").setReadTime(Timestamp.newBuilder().build()).setCompareDuration(Duration.newBuilder().build()).setFieldMask(FieldMask.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
            client.listAssets(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDescendantSecurityHealthAnalyticsCustomModulesTest() throws Exception {
        SecurityHealthAnalyticsCustomModule responsesElement = SecurityHealthAnalyticsCustomModule.newBuilder().build();
        ListDescendantSecurityHealthAnalyticsCustomModulesResponse expectedResponse = ListDescendantSecurityHealthAnalyticsCustomModulesResponse.newBuilder().setNextPageToken("").addAllSecurityHealthAnalyticsCustomModules(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        SecurityHealthAnalyticsSettingsName parent = SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)"[ORGANIZATION]");
        SecurityCenterClient.ListDescendantSecurityHealthAnalyticsCustomModulesPagedResponse pagedListResponse = client.listDescendantSecurityHealthAnalyticsCustomModules(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSecurityHealthAnalyticsCustomModulesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDescendantSecurityHealthAnalyticsCustomModulesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SecurityHealthAnalyticsSettingsName parent = SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)"[ORGANIZATION]");
            client.listDescendantSecurityHealthAnalyticsCustomModules(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDescendantSecurityHealthAnalyticsCustomModulesTest2() throws Exception {
        SecurityHealthAnalyticsCustomModule responsesElement = SecurityHealthAnalyticsCustomModule.newBuilder().build();
        ListDescendantSecurityHealthAnalyticsCustomModulesResponse expectedResponse = ListDescendantSecurityHealthAnalyticsCustomModulesResponse.newBuilder().setNextPageToken("").addAllSecurityHealthAnalyticsCustomModules(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-7807/securityHealthAnalyticsSettings";
        SecurityCenterClient.ListDescendantSecurityHealthAnalyticsCustomModulesPagedResponse pagedListResponse = client.listDescendantSecurityHealthAnalyticsCustomModules(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSecurityHealthAnalyticsCustomModulesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDescendantSecurityHealthAnalyticsCustomModulesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-7807/securityHealthAnalyticsSettings";
            client.listDescendantSecurityHealthAnalyticsCustomModules(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listFindingsTest() throws Exception {
        ListFindingsResponse.ListFindingsResult responsesElement = ListFindingsResponse.ListFindingsResult.newBuilder().build();
        ListFindingsResponse expectedResponse = ListFindingsResponse.newBuilder().setNextPageToken("").addAllListFindingsResults(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ListFindingsRequest request = ListFindingsRequest.newBuilder().setParent(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setFilter("filter-1274492040").setOrderBy("orderBy-1207110587").setReadTime(Timestamp.newBuilder().build()).setCompareDuration(Duration.newBuilder().build()).setFieldMask(FieldMask.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
        SecurityCenterClient.ListFindingsPagedResponse pagedListResponse = client.listFindings(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getListFindingsResultsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listFindingsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ListFindingsRequest request = ListFindingsRequest.newBuilder().setParent(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setFilter("filter-1274492040").setOrderBy("orderBy-1207110587").setReadTime(Timestamp.newBuilder().build()).setCompareDuration(Duration.newBuilder().build()).setFieldMask(FieldMask.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
            client.listFindings(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMuteConfigsTest() throws Exception {
        MuteConfig responsesElement = MuteConfig.newBuilder().build();
        ListMuteConfigsResponse expectedResponse = ListMuteConfigsResponse.newBuilder().setNextPageToken("").addAllMuteConfigs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        SecurityCenterClient.ListMuteConfigsPagedResponse pagedListResponse = client.listMuteConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMuteConfigsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listMuteConfigsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            client.listMuteConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMuteConfigsTest2() throws Exception {
        MuteConfig responsesElement = MuteConfig.newBuilder().build();
        ListMuteConfigsResponse expectedResponse = ListMuteConfigsResponse.newBuilder().setNextPageToken("").addAllMuteConfigs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        SecurityCenterClient.ListMuteConfigsPagedResponse pagedListResponse = client.listMuteConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMuteConfigsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listMuteConfigsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            client.listMuteConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMuteConfigsTest3() throws Exception {
        MuteConfig responsesElement = MuteConfig.newBuilder().build();
        ListMuteConfigsResponse expectedResponse = ListMuteConfigsResponse.newBuilder().setNextPageToken("").addAllMuteConfigs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        SecurityCenterClient.ListMuteConfigsPagedResponse pagedListResponse = client.listMuteConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMuteConfigsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listMuteConfigsExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            client.listMuteConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMuteConfigsTest4() throws Exception {
        MuteConfig responsesElement = MuteConfig.newBuilder().build();
        ListMuteConfigsResponse expectedResponse = ListMuteConfigsResponse.newBuilder().setNextPageToken("").addAllMuteConfigs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8287";
        SecurityCenterClient.ListMuteConfigsPagedResponse pagedListResponse = client.listMuteConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMuteConfigsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listMuteConfigsExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            client.listMuteConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationConfigsTest() throws Exception {
        NotificationConfig responsesElement = NotificationConfig.newBuilder().build();
        ListNotificationConfigsResponse expectedResponse = ListNotificationConfigsResponse.newBuilder().setNextPageToken("").addAllNotificationConfigs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        SecurityCenterClient.ListNotificationConfigsPagedResponse pagedListResponse = client.listNotificationConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNotificationConfigsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listNotificationConfigsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            client.listNotificationConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationConfigsTest2() throws Exception {
        NotificationConfig responsesElement = NotificationConfig.newBuilder().build();
        ListNotificationConfigsResponse expectedResponse = ListNotificationConfigsResponse.newBuilder().setNextPageToken("").addAllNotificationConfigs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        SecurityCenterClient.ListNotificationConfigsPagedResponse pagedListResponse = client.listNotificationConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNotificationConfigsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listNotificationConfigsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            client.listNotificationConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationConfigsTest3() throws Exception {
        NotificationConfig responsesElement = NotificationConfig.newBuilder().build();
        ListNotificationConfigsResponse expectedResponse = ListNotificationConfigsResponse.newBuilder().setNextPageToken("").addAllNotificationConfigs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        SecurityCenterClient.ListNotificationConfigsPagedResponse pagedListResponse = client.listNotificationConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNotificationConfigsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listNotificationConfigsExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            client.listNotificationConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationConfigsTest4() throws Exception {
        NotificationConfig responsesElement = NotificationConfig.newBuilder().build();
        ListNotificationConfigsResponse expectedResponse = ListNotificationConfigsResponse.newBuilder().setNextPageToken("").addAllNotificationConfigs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8287";
        SecurityCenterClient.ListNotificationConfigsPagedResponse pagedListResponse = client.listNotificationConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNotificationConfigsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listNotificationConfigsExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            client.listNotificationConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listEffectiveSecurityHealthAnalyticsCustomModulesTest() throws Exception {
        EffectiveSecurityHealthAnalyticsCustomModule responsesElement = EffectiveSecurityHealthAnalyticsCustomModule.newBuilder().build();
        ListEffectiveSecurityHealthAnalyticsCustomModulesResponse expectedResponse = ListEffectiveSecurityHealthAnalyticsCustomModulesResponse.newBuilder().setNextPageToken("").addAllEffectiveSecurityHealthAnalyticsCustomModules(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        SecurityHealthAnalyticsSettingsName parent = SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)"[ORGANIZATION]");
        SecurityCenterClient.ListEffectiveSecurityHealthAnalyticsCustomModulesPagedResponse pagedListResponse = client.listEffectiveSecurityHealthAnalyticsCustomModules(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getEffectiveSecurityHealthAnalyticsCustomModulesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listEffectiveSecurityHealthAnalyticsCustomModulesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SecurityHealthAnalyticsSettingsName parent = SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)"[ORGANIZATION]");
            client.listEffectiveSecurityHealthAnalyticsCustomModules(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listEffectiveSecurityHealthAnalyticsCustomModulesTest2() throws Exception {
        EffectiveSecurityHealthAnalyticsCustomModule responsesElement = EffectiveSecurityHealthAnalyticsCustomModule.newBuilder().build();
        ListEffectiveSecurityHealthAnalyticsCustomModulesResponse expectedResponse = ListEffectiveSecurityHealthAnalyticsCustomModulesResponse.newBuilder().setNextPageToken("").addAllEffectiveSecurityHealthAnalyticsCustomModules(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-7807/securityHealthAnalyticsSettings";
        SecurityCenterClient.ListEffectiveSecurityHealthAnalyticsCustomModulesPagedResponse pagedListResponse = client.listEffectiveSecurityHealthAnalyticsCustomModules(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getEffectiveSecurityHealthAnalyticsCustomModulesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listEffectiveSecurityHealthAnalyticsCustomModulesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-7807/securityHealthAnalyticsSettings";
            client.listEffectiveSecurityHealthAnalyticsCustomModules(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSecurityHealthAnalyticsCustomModulesTest() throws Exception {
        SecurityHealthAnalyticsCustomModule responsesElement = SecurityHealthAnalyticsCustomModule.newBuilder().build();
        ListSecurityHealthAnalyticsCustomModulesResponse expectedResponse = ListSecurityHealthAnalyticsCustomModulesResponse.newBuilder().setNextPageToken("").addAllSecurityHealthAnalyticsCustomModules(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        SecurityHealthAnalyticsSettingsName parent = SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)"[ORGANIZATION]");
        SecurityCenterClient.ListSecurityHealthAnalyticsCustomModulesPagedResponse pagedListResponse = client.listSecurityHealthAnalyticsCustomModules(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSecurityHealthAnalyticsCustomModulesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSecurityHealthAnalyticsCustomModulesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SecurityHealthAnalyticsSettingsName parent = SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)"[ORGANIZATION]");
            client.listSecurityHealthAnalyticsCustomModules(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSecurityHealthAnalyticsCustomModulesTest2() throws Exception {
        SecurityHealthAnalyticsCustomModule responsesElement = SecurityHealthAnalyticsCustomModule.newBuilder().build();
        ListSecurityHealthAnalyticsCustomModulesResponse expectedResponse = ListSecurityHealthAnalyticsCustomModulesResponse.newBuilder().setNextPageToken("").addAllSecurityHealthAnalyticsCustomModules(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-7807/securityHealthAnalyticsSettings";
        SecurityCenterClient.ListSecurityHealthAnalyticsCustomModulesPagedResponse pagedListResponse = client.listSecurityHealthAnalyticsCustomModules(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSecurityHealthAnalyticsCustomModulesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSecurityHealthAnalyticsCustomModulesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-7807/securityHealthAnalyticsSettings";
            client.listSecurityHealthAnalyticsCustomModules(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSourcesTest() throws Exception {
        Source responsesElement = Source.newBuilder().build();
        ListSourcesResponse expectedResponse = ListSourcesResponse.newBuilder().setNextPageToken("").addAllSources(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        SecurityCenterClient.ListSourcesPagedResponse pagedListResponse = client.listSources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSourcesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSourcesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            client.listSources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSourcesTest2() throws Exception {
        Source responsesElement = Source.newBuilder().build();
        ListSourcesResponse expectedResponse = ListSourcesResponse.newBuilder().setNextPageToken("").addAllSources(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        SecurityCenterClient.ListSourcesPagedResponse pagedListResponse = client.listSources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSourcesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSourcesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            client.listSources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSourcesTest3() throws Exception {
        Source responsesElement = Source.newBuilder().build();
        ListSourcesResponse expectedResponse = ListSourcesResponse.newBuilder().setNextPageToken("").addAllSources(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        SecurityCenterClient.ListSourcesPagedResponse pagedListResponse = client.listSources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSourcesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSourcesExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            client.listSources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSourcesTest4() throws Exception {
        Source responsesElement = Source.newBuilder().build();
        ListSourcesResponse expectedResponse = ListSourcesResponse.newBuilder().setNextPageToken("").addAllSources(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8287";
        SecurityCenterClient.ListSourcesPagedResponse pagedListResponse = client.listSources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSourcesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSourcesExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            client.listSources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void runAssetDiscoveryTest() throws Exception {
        RunAssetDiscoveryResponse expectedResponse = RunAssetDiscoveryResponse.newBuilder().setDuration(Duration.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("runAssetDiscoveryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        RunAssetDiscoveryResponse actualResponse = (RunAssetDiscoveryResponse)client.runAssetDiscoveryAsync(parent).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void runAssetDiscoveryExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            client.runAssetDiscoveryAsync(parent).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void runAssetDiscoveryTest2() throws Exception {
        RunAssetDiscoveryResponse expectedResponse = RunAssetDiscoveryResponse.newBuilder().setDuration(Duration.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("runAssetDiscoveryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "organizations/organization-8287";
        RunAssetDiscoveryResponse actualResponse = (RunAssetDiscoveryResponse)client.runAssetDiscoveryAsync(parent).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void runAssetDiscoveryExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            client.runAssetDiscoveryAsync(parent).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void setFindingStateTest() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").setIndicator(Indicator.newBuilder().build()).setVulnerability(Vulnerability.newBuilder().build()).setMuteUpdateTime(Timestamp.newBuilder().build()).putAllExternalSystems(new HashMap()).setMitreAttack(MitreAttack.newBuilder().build()).setAccess(Access.newBuilder().build()).addAllConnections(new ArrayList()).setMuteInitiator("muteInitiator1395645462").addAllProcesses(new ArrayList()).putAllContacts(new HashMap()).addAllCompliances(new ArrayList()).setParentDisplayName("parentDisplayName-1523759261").setDescription("description-1724546052").setExfiltration(Exfiltration.newBuilder().build()).addAllIamBindings(new ArrayList()).setNextSteps("nextSteps1206138868").setModuleName("moduleName-870351081").addAllContainers(new ArrayList()).setKubernetes(Kubernetes.newBuilder().build()).setDatabase(Database.newBuilder().build()).addAllFiles(new ArrayList()).setCloudDlpInspection(CloudDlpInspection.newBuilder().build()).setCloudDlpDataProfile(CloudDlpDataProfile.newBuilder().build()).setKernelRootkit(KernelRootkit.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        FindingName name = FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]");
        Finding.State state = Finding.State.forNumber((int)0);
        Timestamp startTime = Timestamp.newBuilder().build();
        Finding actualResponse = client.setFindingState(name, state, startTime);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setFindingStateExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FindingName name = FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]");
            Finding.State state = Finding.State.forNumber((int)0);
            Timestamp startTime = Timestamp.newBuilder().build();
            client.setFindingState(name, state, startTime);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setFindingStateTest2() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").setIndicator(Indicator.newBuilder().build()).setVulnerability(Vulnerability.newBuilder().build()).setMuteUpdateTime(Timestamp.newBuilder().build()).putAllExternalSystems(new HashMap()).setMitreAttack(MitreAttack.newBuilder().build()).setAccess(Access.newBuilder().build()).addAllConnections(new ArrayList()).setMuteInitiator("muteInitiator1395645462").addAllProcesses(new ArrayList()).putAllContacts(new HashMap()).addAllCompliances(new ArrayList()).setParentDisplayName("parentDisplayName-1523759261").setDescription("description-1724546052").setExfiltration(Exfiltration.newBuilder().build()).addAllIamBindings(new ArrayList()).setNextSteps("nextSteps1206138868").setModuleName("moduleName-870351081").addAllContainers(new ArrayList()).setKubernetes(Kubernetes.newBuilder().build()).setDatabase(Database.newBuilder().build()).addAllFiles(new ArrayList()).setCloudDlpInspection(CloudDlpInspection.newBuilder().build()).setCloudDlpDataProfile(CloudDlpDataProfile.newBuilder().build()).setKernelRootkit(KernelRootkit.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-9392/sources/source-9392/findings/finding-9392";
        Finding.State state = Finding.State.forNumber((int)0);
        Timestamp startTime = Timestamp.newBuilder().build();
        Finding actualResponse = client.setFindingState(name, state, startTime);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setFindingStateExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-9392/sources/source-9392/findings/finding-9392";
            Finding.State state = Finding.State.forNumber((int)0);
            Timestamp startTime = Timestamp.newBuilder().build();
            client.setFindingState(name, state, startTime);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setMuteTest() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").setIndicator(Indicator.newBuilder().build()).setVulnerability(Vulnerability.newBuilder().build()).setMuteUpdateTime(Timestamp.newBuilder().build()).putAllExternalSystems(new HashMap()).setMitreAttack(MitreAttack.newBuilder().build()).setAccess(Access.newBuilder().build()).addAllConnections(new ArrayList()).setMuteInitiator("muteInitiator1395645462").addAllProcesses(new ArrayList()).putAllContacts(new HashMap()).addAllCompliances(new ArrayList()).setParentDisplayName("parentDisplayName-1523759261").setDescription("description-1724546052").setExfiltration(Exfiltration.newBuilder().build()).addAllIamBindings(new ArrayList()).setNextSteps("nextSteps1206138868").setModuleName("moduleName-870351081").addAllContainers(new ArrayList()).setKubernetes(Kubernetes.newBuilder().build()).setDatabase(Database.newBuilder().build()).addAllFiles(new ArrayList()).setCloudDlpInspection(CloudDlpInspection.newBuilder().build()).setCloudDlpDataProfile(CloudDlpDataProfile.newBuilder().build()).setKernelRootkit(KernelRootkit.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        FindingName name = FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]");
        Finding.Mute mute = Finding.Mute.forNumber((int)0);
        Finding actualResponse = client.setMute(name, mute);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setMuteExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FindingName name = FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]");
            Finding.Mute mute = Finding.Mute.forNumber((int)0);
            client.setMute(name, mute);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setMuteTest2() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").setIndicator(Indicator.newBuilder().build()).setVulnerability(Vulnerability.newBuilder().build()).setMuteUpdateTime(Timestamp.newBuilder().build()).putAllExternalSystems(new HashMap()).setMitreAttack(MitreAttack.newBuilder().build()).setAccess(Access.newBuilder().build()).addAllConnections(new ArrayList()).setMuteInitiator("muteInitiator1395645462").addAllProcesses(new ArrayList()).putAllContacts(new HashMap()).addAllCompliances(new ArrayList()).setParentDisplayName("parentDisplayName-1523759261").setDescription("description-1724546052").setExfiltration(Exfiltration.newBuilder().build()).addAllIamBindings(new ArrayList()).setNextSteps("nextSteps1206138868").setModuleName("moduleName-870351081").addAllContainers(new ArrayList()).setKubernetes(Kubernetes.newBuilder().build()).setDatabase(Database.newBuilder().build()).addAllFiles(new ArrayList()).setCloudDlpInspection(CloudDlpInspection.newBuilder().build()).setCloudDlpDataProfile(CloudDlpDataProfile.newBuilder().build()).setKernelRootkit(KernelRootkit.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-9392/sources/source-9392/findings/finding-9392";
        Finding.Mute mute = Finding.Mute.forNumber((int)0);
        Finding actualResponse = client.setMute(name, mute);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setMuteExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-9392/sources/source-9392/findings/finding-9392";
            Finding.Mute mute = Finding.Mute.forNumber((int)0);
            client.setMute(name, mute);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = client.setIamPolicy((ResourceName)resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            Policy policy = Policy.newBuilder().build();
            client.setIamPolicy((ResourceName)resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        String resource = "organizations/organization-3393/sources/source-3393";
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = client.setIamPolicy(resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setIamPolicyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String resource = "organizations/organization-3393/sources/source-3393";
            Policy policy = Policy.newBuilder().build();
            client.setIamPolicy(resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = client.testIamPermissions((ResourceName)resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            ArrayList permissions = new ArrayList();
            client.testIamPermissions((ResourceName)resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest2() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String resource = "organizations/organization-3393/sources/source-3393";
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = client.testIamPermissions(resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void testIamPermissionsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String resource = "organizations/organization-3393/sources/source-3393";
            ArrayList permissions = new ArrayList();
            client.testIamPermissions(resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateExternalSystemTest() throws Exception {
        ExternalSystem expectedResponse = ExternalSystem.newBuilder().setName("name3373707").addAllAssignees(new ArrayList()).setExternalUid("externalUid-1153085307").setStatus("status-892481550").setExternalSystemUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        ExternalSystem externalSystem = ExternalSystem.newBuilder().setName("organizations/organization-5115/sources/source-5115/findings/finding-5115/externalSystems/externalSystem-5115").addAllAssignees(new ArrayList()).setExternalUid("externalUid-1153085307").setStatus("status-892481550").setExternalSystemUpdateTime(Timestamp.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        ExternalSystem actualResponse = client.updateExternalSystem(externalSystem, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateExternalSystemExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ExternalSystem externalSystem = ExternalSystem.newBuilder().setName("organizations/organization-5115/sources/source-5115/findings/finding-5115/externalSystems/externalSystem-5115").addAllAssignees(new ArrayList()).setExternalUid("externalUid-1153085307").setStatus("status-892481550").setExternalSystemUpdateTime(Timestamp.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateExternalSystem(externalSystem, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateFindingTest() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").setIndicator(Indicator.newBuilder().build()).setVulnerability(Vulnerability.newBuilder().build()).setMuteUpdateTime(Timestamp.newBuilder().build()).putAllExternalSystems(new HashMap()).setMitreAttack(MitreAttack.newBuilder().build()).setAccess(Access.newBuilder().build()).addAllConnections(new ArrayList()).setMuteInitiator("muteInitiator1395645462").addAllProcesses(new ArrayList()).putAllContacts(new HashMap()).addAllCompliances(new ArrayList()).setParentDisplayName("parentDisplayName-1523759261").setDescription("description-1724546052").setExfiltration(Exfiltration.newBuilder().build()).addAllIamBindings(new ArrayList()).setNextSteps("nextSteps1206138868").setModuleName("moduleName-870351081").addAllContainers(new ArrayList()).setKubernetes(Kubernetes.newBuilder().build()).setDatabase(Database.newBuilder().build()).addAllFiles(new ArrayList()).setCloudDlpInspection(CloudDlpInspection.newBuilder().build()).setCloudDlpDataProfile(CloudDlpDataProfile.newBuilder().build()).setKernelRootkit(KernelRootkit.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        Finding finding = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").setIndicator(Indicator.newBuilder().build()).setVulnerability(Vulnerability.newBuilder().build()).setMuteUpdateTime(Timestamp.newBuilder().build()).putAllExternalSystems(new HashMap()).setMitreAttack(MitreAttack.newBuilder().build()).setAccess(Access.newBuilder().build()).addAllConnections(new ArrayList()).setMuteInitiator("muteInitiator1395645462").addAllProcesses(new ArrayList()).putAllContacts(new HashMap()).addAllCompliances(new ArrayList()).setParentDisplayName("parentDisplayName-1523759261").setDescription("description-1724546052").setExfiltration(Exfiltration.newBuilder().build()).addAllIamBindings(new ArrayList()).setNextSteps("nextSteps1206138868").setModuleName("moduleName-870351081").addAllContainers(new ArrayList()).setKubernetes(Kubernetes.newBuilder().build()).setDatabase(Database.newBuilder().build()).addAllFiles(new ArrayList()).setCloudDlpInspection(CloudDlpInspection.newBuilder().build()).setCloudDlpDataProfile(CloudDlpDataProfile.newBuilder().build()).setKernelRootkit(KernelRootkit.newBuilder().build()).build();
        Finding actualResponse = client.updateFinding(finding);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateFindingExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Finding finding = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").setIndicator(Indicator.newBuilder().build()).setVulnerability(Vulnerability.newBuilder().build()).setMuteUpdateTime(Timestamp.newBuilder().build()).putAllExternalSystems(new HashMap()).setMitreAttack(MitreAttack.newBuilder().build()).setAccess(Access.newBuilder().build()).addAllConnections(new ArrayList()).setMuteInitiator("muteInitiator1395645462").addAllProcesses(new ArrayList()).putAllContacts(new HashMap()).addAllCompliances(new ArrayList()).setParentDisplayName("parentDisplayName-1523759261").setDescription("description-1724546052").setExfiltration(Exfiltration.newBuilder().build()).addAllIamBindings(new ArrayList()).setNextSteps("nextSteps1206138868").setModuleName("moduleName-870351081").addAllContainers(new ArrayList()).setKubernetes(Kubernetes.newBuilder().build()).setDatabase(Database.newBuilder().build()).addAllFiles(new ArrayList()).setCloudDlpInspection(CloudDlpInspection.newBuilder().build()).setCloudDlpDataProfile(CloudDlpDataProfile.newBuilder().build()).setKernelRootkit(KernelRootkit.newBuilder().build()).build();
            client.updateFinding(finding);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateMuteConfigTest() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockService.addResponse((Object)expectedResponse);
        MuteConfig muteConfig = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        MuteConfig actualResponse = client.updateMuteConfig(muteConfig, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateMuteConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            MuteConfig muteConfig = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateMuteConfig(muteConfig, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateNotificationConfigTest() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        NotificationConfig actualResponse = client.updateNotificationConfig(notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateNotificationConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
            client.updateNotificationConfig(notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateNotificationConfigTest2() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        NotificationConfig actualResponse = client.updateNotificationConfig(notificationConfig, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateNotificationConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateNotificationConfig(notificationConfig, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateOrganizationSettingsTest() throws Exception {
        OrganizationSettings expectedResponse = OrganizationSettings.newBuilder().setName(OrganizationSettingsName.of((String)"[ORGANIZATION]").toString()).setEnableAssetDiscovery(true).setAssetDiscoveryConfig(OrganizationSettings.AssetDiscoveryConfig.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationSettings organizationSettings = OrganizationSettings.newBuilder().setName(OrganizationSettingsName.of((String)"[ORGANIZATION]").toString()).setEnableAssetDiscovery(true).setAssetDiscoveryConfig(OrganizationSettings.AssetDiscoveryConfig.newBuilder().build()).build();
        OrganizationSettings actualResponse = client.updateOrganizationSettings(organizationSettings);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateOrganizationSettingsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationSettings organizationSettings = OrganizationSettings.newBuilder().setName(OrganizationSettingsName.of((String)"[ORGANIZATION]").toString()).setEnableAssetDiscovery(true).setAssetDiscoveryConfig(OrganizationSettings.AssetDiscoveryConfig.newBuilder().build()).build();
            client.updateOrganizationSettings(organizationSettings);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSecurityHealthAnalyticsCustomModuleTest() throws Exception {
        SecurityHealthAnalyticsCustomModule expectedResponse = SecurityHealthAnalyticsCustomModule.newBuilder().setName(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setDisplayName("displayName1714148973").setUpdateTime(Timestamp.newBuilder().build()).setLastEditor("lastEditor1523898275").setAncestorModule(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setCustomConfig(CustomConfig.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        SecurityHealthAnalyticsCustomModule securityHealthAnalyticsCustomModule = SecurityHealthAnalyticsCustomModule.newBuilder().setName(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setDisplayName("displayName1714148973").setUpdateTime(Timestamp.newBuilder().build()).setLastEditor("lastEditor1523898275").setAncestorModule(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setCustomConfig(CustomConfig.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        SecurityHealthAnalyticsCustomModule actualResponse = client.updateSecurityHealthAnalyticsCustomModule(securityHealthAnalyticsCustomModule, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateSecurityHealthAnalyticsCustomModuleExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SecurityHealthAnalyticsCustomModule securityHealthAnalyticsCustomModule = SecurityHealthAnalyticsCustomModule.newBuilder().setName(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setDisplayName("displayName1714148973").setUpdateTime(Timestamp.newBuilder().build()).setLastEditor("lastEditor1523898275").setAncestorModule(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setCustomConfig(CustomConfig.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateSecurityHealthAnalyticsCustomModule(securityHealthAnalyticsCustomModule, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSourceTest() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        Source source = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        Source actualResponse = client.updateSource(source);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateSourceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Source source = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
            client.updateSource(source);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSecurityMarksTest() throws Exception {
        SecurityMarks expectedResponse = SecurityMarks.newBuilder().setName("name3373707").putAllMarks(new HashMap()).setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        SecurityMarks securityMarks = SecurityMarks.newBuilder().setName("organizations/organization-5924/assets/asset-5924/securityMarks").putAllMarks(new HashMap()).setCanonicalName("canonicalName2122381727").build();
        SecurityMarks actualResponse = client.updateSecurityMarks(securityMarks);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateSecurityMarksExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SecurityMarks securityMarks = SecurityMarks.newBuilder().setName("organizations/organization-5924/assets/asset-5924/securityMarks").putAllMarks(new HashMap()).setCanonicalName("canonicalName2122381727").build();
            client.updateSecurityMarks(securityMarks);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBigQueryExportTest() throws Exception {
        BigQueryExport expectedResponse = BigQueryExport.newBuilder().setName(BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]").toString()).setDescription("description-1724546052").setFilter("filter-1274492040").setDataset("dataset1443214456").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").setPrincipal("principal-1812041682").build();
        mockService.addResponse((Object)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
        String bigQueryExportId = "bigQueryExportId1024198583";
        BigQueryExport actualResponse = client.createBigQueryExport(parent, bigQueryExport, bigQueryExportId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createBigQueryExportExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
            String bigQueryExportId = "bigQueryExportId1024198583";
            client.createBigQueryExport(parent, bigQueryExport, bigQueryExportId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBigQueryExportTest2() throws Exception {
        BigQueryExport expectedResponse = BigQueryExport.newBuilder().setName(BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]").toString()).setDescription("description-1724546052").setFilter("filter-1274492040").setDataset("dataset1443214456").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").setPrincipal("principal-1812041682").build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
        String bigQueryExportId = "bigQueryExportId1024198583";
        BigQueryExport actualResponse = client.createBigQueryExport(parent, bigQueryExport, bigQueryExportId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createBigQueryExportExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
            String bigQueryExportId = "bigQueryExportId1024198583";
            client.createBigQueryExport(parent, bigQueryExport, bigQueryExportId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBigQueryExportTest3() throws Exception {
        BigQueryExport expectedResponse = BigQueryExport.newBuilder().setName(BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]").toString()).setDescription("description-1724546052").setFilter("filter-1274492040").setDataset("dataset1443214456").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").setPrincipal("principal-1812041682").build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
        String bigQueryExportId = "bigQueryExportId1024198583";
        BigQueryExport actualResponse = client.createBigQueryExport(parent, bigQueryExport, bigQueryExportId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createBigQueryExportExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
            String bigQueryExportId = "bigQueryExportId1024198583";
            client.createBigQueryExport(parent, bigQueryExport, bigQueryExportId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBigQueryExportTest4() throws Exception {
        BigQueryExport expectedResponse = BigQueryExport.newBuilder().setName(BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]").toString()).setDescription("description-1724546052").setFilter("filter-1274492040").setDataset("dataset1443214456").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").setPrincipal("principal-1812041682").build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8287";
        BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
        String bigQueryExportId = "bigQueryExportId1024198583";
        BigQueryExport actualResponse = client.createBigQueryExport(parent, bigQueryExport, bigQueryExportId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createBigQueryExportExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
            String bigQueryExportId = "bigQueryExportId1024198583";
            client.createBigQueryExport(parent, bigQueryExport, bigQueryExportId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteBigQueryExportTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        BigQueryExportName name = BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]");
        client.deleteBigQueryExport(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteBigQueryExportExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BigQueryExportName name = BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]");
            client.deleteBigQueryExport(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteBigQueryExportTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-3683/bigQueryExports/bigQueryExport-3683";
        client.deleteBigQueryExport(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteBigQueryExportExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-3683/bigQueryExports/bigQueryExport-3683";
            client.deleteBigQueryExport(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateBigQueryExportTest() throws Exception {
        BigQueryExport expectedResponse = BigQueryExport.newBuilder().setName(BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]").toString()).setDescription("description-1724546052").setFilter("filter-1274492040").setDataset("dataset1443214456").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").setPrincipal("principal-1812041682").build();
        mockService.addResponse((Object)expectedResponse);
        BigQueryExport bigQueryExport = BigQueryExport.newBuilder().setName(BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]").toString()).setDescription("description-1724546052").setFilter("filter-1274492040").setDataset("dataset1443214456").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").setPrincipal("principal-1812041682").build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        BigQueryExport actualResponse = client.updateBigQueryExport(bigQueryExport, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateBigQueryExportExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BigQueryExport bigQueryExport = BigQueryExport.newBuilder().setName(BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]").toString()).setDescription("description-1724546052").setFilter("filter-1274492040").setDataset("dataset1443214456").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").setPrincipal("principal-1812041682").build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateBigQueryExport(bigQueryExport, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBigQueryExportsTest() throws Exception {
        BigQueryExport responsesElement = BigQueryExport.newBuilder().build();
        ListBigQueryExportsResponse expectedResponse = ListBigQueryExportsResponse.newBuilder().setNextPageToken("").addAllBigQueryExports(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        SecurityCenterClient.ListBigQueryExportsPagedResponse pagedListResponse = client.listBigQueryExports(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBigQueryExportsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listBigQueryExportsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            client.listBigQueryExports(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBigQueryExportsTest2() throws Exception {
        BigQueryExport responsesElement = BigQueryExport.newBuilder().build();
        ListBigQueryExportsResponse expectedResponse = ListBigQueryExportsResponse.newBuilder().setNextPageToken("").addAllBigQueryExports(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        SecurityCenterClient.ListBigQueryExportsPagedResponse pagedListResponse = client.listBigQueryExports(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBigQueryExportsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listBigQueryExportsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            client.listBigQueryExports(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBigQueryExportsTest3() throws Exception {
        BigQueryExport responsesElement = BigQueryExport.newBuilder().build();
        ListBigQueryExportsResponse expectedResponse = ListBigQueryExportsResponse.newBuilder().setNextPageToken("").addAllBigQueryExports(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        SecurityCenterClient.ListBigQueryExportsPagedResponse pagedListResponse = client.listBigQueryExports(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBigQueryExportsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listBigQueryExportsExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            client.listBigQueryExports(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBigQueryExportsTest4() throws Exception {
        BigQueryExport responsesElement = BigQueryExport.newBuilder().build();
        ListBigQueryExportsResponse expectedResponse = ListBigQueryExportsResponse.newBuilder().setNextPageToken("").addAllBigQueryExports(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8287";
        SecurityCenterClient.ListBigQueryExportsPagedResponse pagedListResponse = client.listBigQueryExports(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBigQueryExportsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listBigQueryExportsExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            client.listBigQueryExports(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

