/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.securitycenter.v1.Access;
import com.google.cloud.securitycenter.v1.BigQueryExport;
import com.google.cloud.securitycenter.v1.BigQueryExportName;
import com.google.cloud.securitycenter.v1.BulkMuteFindingsRequest;
import com.google.cloud.securitycenter.v1.BulkMuteFindingsResponse;
import com.google.cloud.securitycenter.v1.CloudDlpDataProfile;
import com.google.cloud.securitycenter.v1.CloudDlpInspection;
import com.google.cloud.securitycenter.v1.CreateBigQueryExportRequest;
import com.google.cloud.securitycenter.v1.CreateFindingRequest;
import com.google.cloud.securitycenter.v1.CreateMuteConfigRequest;
import com.google.cloud.securitycenter.v1.CreateNotificationConfigRequest;
import com.google.cloud.securitycenter.v1.CreateSecurityHealthAnalyticsCustomModuleRequest;
import com.google.cloud.securitycenter.v1.CreateSourceRequest;
import com.google.cloud.securitycenter.v1.CustomConfig;
import com.google.cloud.securitycenter.v1.Database;
import com.google.cloud.securitycenter.v1.DeleteBigQueryExportRequest;
import com.google.cloud.securitycenter.v1.DeleteMuteConfigRequest;
import com.google.cloud.securitycenter.v1.DeleteNotificationConfigRequest;
import com.google.cloud.securitycenter.v1.DeleteSecurityHealthAnalyticsCustomModuleRequest;
import com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule;
import com.google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModuleName;
import com.google.cloud.securitycenter.v1.Exfiltration;
import com.google.cloud.securitycenter.v1.ExternalSystem;
import com.google.cloud.securitycenter.v1.Finding;
import com.google.cloud.securitycenter.v1.FindingName;
import com.google.cloud.securitycenter.v1.FolderName;
import com.google.cloud.securitycenter.v1.GetBigQueryExportRequest;
import com.google.cloud.securitycenter.v1.GetEffectiveSecurityHealthAnalyticsCustomModuleRequest;
import com.google.cloud.securitycenter.v1.GetMuteConfigRequest;
import com.google.cloud.securitycenter.v1.GetNotificationConfigRequest;
import com.google.cloud.securitycenter.v1.GetOrganizationSettingsRequest;
import com.google.cloud.securitycenter.v1.GetSecurityHealthAnalyticsCustomModuleRequest;
import com.google.cloud.securitycenter.v1.GetSourceRequest;
import com.google.cloud.securitycenter.v1.GroupAssetsRequest;
import com.google.cloud.securitycenter.v1.GroupAssetsResponse;
import com.google.cloud.securitycenter.v1.GroupFindingsRequest;
import com.google.cloud.securitycenter.v1.GroupFindingsResponse;
import com.google.cloud.securitycenter.v1.GroupResult;
import com.google.cloud.securitycenter.v1.Indicator;
import com.google.cloud.securitycenter.v1.KernelRootkit;
import com.google.cloud.securitycenter.v1.Kubernetes;
import com.google.cloud.securitycenter.v1.ListAssetsRequest;
import com.google.cloud.securitycenter.v1.ListAssetsResponse;
import com.google.cloud.securitycenter.v1.ListBigQueryExportsRequest;
import com.google.cloud.securitycenter.v1.ListBigQueryExportsResponse;
import com.google.cloud.securitycenter.v1.ListDescendantSecurityHealthAnalyticsCustomModulesRequest;
import com.google.cloud.securitycenter.v1.ListDescendantSecurityHealthAnalyticsCustomModulesResponse;
import com.google.cloud.securitycenter.v1.ListEffectiveSecurityHealthAnalyticsCustomModulesRequest;
import com.google.cloud.securitycenter.v1.ListEffectiveSecurityHealthAnalyticsCustomModulesResponse;
import com.google.cloud.securitycenter.v1.ListFindingsRequest;
import com.google.cloud.securitycenter.v1.ListFindingsResponse;
import com.google.cloud.securitycenter.v1.ListMuteConfigsRequest;
import com.google.cloud.securitycenter.v1.ListMuteConfigsResponse;
import com.google.cloud.securitycenter.v1.ListNotificationConfigsRequest;
import com.google.cloud.securitycenter.v1.ListNotificationConfigsResponse;
import com.google.cloud.securitycenter.v1.ListSecurityHealthAnalyticsCustomModulesRequest;
import com.google.cloud.securitycenter.v1.ListSecurityHealthAnalyticsCustomModulesResponse;
import com.google.cloud.securitycenter.v1.ListSourcesRequest;
import com.google.cloud.securitycenter.v1.ListSourcesResponse;
import com.google.cloud.securitycenter.v1.MitreAttack;
import com.google.cloud.securitycenter.v1.MockSecurityCenter;
import com.google.cloud.securitycenter.v1.MuteConfig;
import com.google.cloud.securitycenter.v1.MuteConfigName;
import com.google.cloud.securitycenter.v1.NotificationConfig;
import com.google.cloud.securitycenter.v1.NotificationConfigName;
import com.google.cloud.securitycenter.v1.OrganizationName;
import com.google.cloud.securitycenter.v1.OrganizationSettings;
import com.google.cloud.securitycenter.v1.OrganizationSettingsName;
import com.google.cloud.securitycenter.v1.ProjectName;
import com.google.cloud.securitycenter.v1.RunAssetDiscoveryRequest;
import com.google.cloud.securitycenter.v1.RunAssetDiscoveryResponse;
import com.google.cloud.securitycenter.v1.SecurityCenterClient;
import com.google.cloud.securitycenter.v1.SecurityCenterSettings;
import com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule;
import com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModuleName;
import com.google.cloud.securitycenter.v1.SecurityHealthAnalyticsSettingsName;
import com.google.cloud.securitycenter.v1.SecurityMarks;
import com.google.cloud.securitycenter.v1.SetFindingStateRequest;
import com.google.cloud.securitycenter.v1.SetMuteRequest;
import com.google.cloud.securitycenter.v1.Source;
import com.google.cloud.securitycenter.v1.SourceName;
import com.google.cloud.securitycenter.v1.UpdateBigQueryExportRequest;
import com.google.cloud.securitycenter.v1.UpdateExternalSystemRequest;
import com.google.cloud.securitycenter.v1.UpdateFindingRequest;
import com.google.cloud.securitycenter.v1.UpdateMuteConfigRequest;
import com.google.cloud.securitycenter.v1.UpdateNotificationConfigRequest;
import com.google.cloud.securitycenter.v1.UpdateOrganizationSettingsRequest;
import com.google.cloud.securitycenter.v1.UpdateSecurityHealthAnalyticsCustomModuleRequest;
import com.google.cloud.securitycenter.v1.UpdateSecurityMarksRequest;
import com.google.cloud.securitycenter.v1.UpdateSourceRequest;
import com.google.cloud.securitycenter.v1.Vulnerability;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SecurityCenterClientTest {
    private static MockSecurityCenter mockSecurityCenter;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private SecurityCenterClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockSecurityCenter = new MockSecurityCenter();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockSecurityCenter));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        SecurityCenterSettings settings = ((SecurityCenterSettings.Builder)((SecurityCenterSettings.Builder)SecurityCenterSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = SecurityCenterClient.create((SecurityCenterSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void bulkMuteFindingsTest() throws Exception {
        BulkMuteFindingsResponse expectedResponse = BulkMuteFindingsResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("bulkMuteFindingsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockSecurityCenter.addResponse((AbstractMessage)resultOperation);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        BulkMuteFindingsResponse actualResponse = (BulkMuteFindingsResponse)this.client.bulkMuteFindingsAsync((ResourceName)parent).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BulkMuteFindingsRequest actualRequest = (BulkMuteFindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void bulkMuteFindingsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            this.client.bulkMuteFindingsAsync((ResourceName)parent).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void bulkMuteFindingsTest2() throws Exception {
        BulkMuteFindingsResponse expectedResponse = BulkMuteFindingsResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("bulkMuteFindingsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockSecurityCenter.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        BulkMuteFindingsResponse actualResponse = (BulkMuteFindingsResponse)this.client.bulkMuteFindingsAsync(parent).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BulkMuteFindingsRequest actualRequest = (BulkMuteFindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void bulkMuteFindingsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.bulkMuteFindingsAsync(parent).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createSecurityHealthAnalyticsCustomModuleTest() throws Exception {
        SecurityHealthAnalyticsCustomModule expectedResponse = SecurityHealthAnalyticsCustomModule.newBuilder().setName(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setDisplayName("displayName1714148973").setUpdateTime(Timestamp.newBuilder().build()).setLastEditor("lastEditor1523898275").setAncestorModule(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setCustomConfig(CustomConfig.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SecurityHealthAnalyticsSettingsName parent = SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)"[ORGANIZATION]");
        SecurityHealthAnalyticsCustomModule securityHealthAnalyticsCustomModule = SecurityHealthAnalyticsCustomModule.newBuilder().build();
        SecurityHealthAnalyticsCustomModule actualResponse = this.client.createSecurityHealthAnalyticsCustomModule(parent, securityHealthAnalyticsCustomModule);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSecurityHealthAnalyticsCustomModuleRequest actualRequest = (CreateSecurityHealthAnalyticsCustomModuleRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)securityHealthAnalyticsCustomModule, (Object)actualRequest.getSecurityHealthAnalyticsCustomModule());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSecurityHealthAnalyticsCustomModuleExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SecurityHealthAnalyticsSettingsName parent = SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)"[ORGANIZATION]");
            SecurityHealthAnalyticsCustomModule securityHealthAnalyticsCustomModule = SecurityHealthAnalyticsCustomModule.newBuilder().build();
            this.client.createSecurityHealthAnalyticsCustomModule(parent, securityHealthAnalyticsCustomModule);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSecurityHealthAnalyticsCustomModuleTest2() throws Exception {
        SecurityHealthAnalyticsCustomModule expectedResponse = SecurityHealthAnalyticsCustomModule.newBuilder().setName(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setDisplayName("displayName1714148973").setUpdateTime(Timestamp.newBuilder().build()).setLastEditor("lastEditor1523898275").setAncestorModule(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setCustomConfig(CustomConfig.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        SecurityHealthAnalyticsCustomModule securityHealthAnalyticsCustomModule = SecurityHealthAnalyticsCustomModule.newBuilder().build();
        SecurityHealthAnalyticsCustomModule actualResponse = this.client.createSecurityHealthAnalyticsCustomModule(parent, securityHealthAnalyticsCustomModule);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSecurityHealthAnalyticsCustomModuleRequest actualRequest = (CreateSecurityHealthAnalyticsCustomModuleRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)securityHealthAnalyticsCustomModule, (Object)actualRequest.getSecurityHealthAnalyticsCustomModule());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSecurityHealthAnalyticsCustomModuleExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            SecurityHealthAnalyticsCustomModule securityHealthAnalyticsCustomModule = SecurityHealthAnalyticsCustomModule.newBuilder().build();
            this.client.createSecurityHealthAnalyticsCustomModule(parent, securityHealthAnalyticsCustomModule);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSourceTest() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        Source source = Source.newBuilder().build();
        Source actualResponse = this.client.createSource(parent, source);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSourceRequest actualRequest = (CreateSourceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)source, (Object)actualRequest.getSource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSourceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            Source source = Source.newBuilder().build();
            this.client.createSource(parent, source);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSourceTest2() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Source source = Source.newBuilder().build();
        Source actualResponse = this.client.createSource(parent, source);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSourceRequest actualRequest = (CreateSourceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)source, (Object)actualRequest.getSource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSourceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Source source = Source.newBuilder().build();
            this.client.createSource(parent, source);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createFindingTest() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").setIndicator(Indicator.newBuilder().build()).setVulnerability(Vulnerability.newBuilder().build()).setMuteUpdateTime(Timestamp.newBuilder().build()).putAllExternalSystems(new HashMap()).setMitreAttack(MitreAttack.newBuilder().build()).setAccess(Access.newBuilder().build()).addAllConnections(new ArrayList()).setMuteInitiator("muteInitiator1395645462").addAllProcesses(new ArrayList()).putAllContacts(new HashMap()).addAllCompliances(new ArrayList()).setParentDisplayName("parentDisplayName-1523759261").setDescription("description-1724546052").setExfiltration(Exfiltration.newBuilder().build()).addAllIamBindings(new ArrayList()).setNextSteps("nextSteps1206138868").setModuleName("moduleName-870351081").addAllContainers(new ArrayList()).setKubernetes(Kubernetes.newBuilder().build()).setDatabase(Database.newBuilder().build()).addAllFiles(new ArrayList()).setCloudDlpInspection(CloudDlpInspection.newBuilder().build()).setCloudDlpDataProfile(CloudDlpDataProfile.newBuilder().build()).setKernelRootkit(KernelRootkit.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SourceName parent = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        String findingId = "findingId439150212";
        Finding finding = Finding.newBuilder().build();
        Finding actualResponse = this.client.createFinding(parent, findingId, finding);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateFindingRequest actualRequest = (CreateFindingRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)findingId, (Object)actualRequest.getFindingId());
        Assert.assertEquals((Object)finding, (Object)actualRequest.getFinding());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createFindingExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SourceName parent = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            String findingId = "findingId439150212";
            Finding finding = Finding.newBuilder().build();
            this.client.createFinding(parent, findingId, finding);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createFindingTest2() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").setIndicator(Indicator.newBuilder().build()).setVulnerability(Vulnerability.newBuilder().build()).setMuteUpdateTime(Timestamp.newBuilder().build()).putAllExternalSystems(new HashMap()).setMitreAttack(MitreAttack.newBuilder().build()).setAccess(Access.newBuilder().build()).addAllConnections(new ArrayList()).setMuteInitiator("muteInitiator1395645462").addAllProcesses(new ArrayList()).putAllContacts(new HashMap()).addAllCompliances(new ArrayList()).setParentDisplayName("parentDisplayName-1523759261").setDescription("description-1724546052").setExfiltration(Exfiltration.newBuilder().build()).addAllIamBindings(new ArrayList()).setNextSteps("nextSteps1206138868").setModuleName("moduleName-870351081").addAllContainers(new ArrayList()).setKubernetes(Kubernetes.newBuilder().build()).setDatabase(Database.newBuilder().build()).addAllFiles(new ArrayList()).setCloudDlpInspection(CloudDlpInspection.newBuilder().build()).setCloudDlpDataProfile(CloudDlpDataProfile.newBuilder().build()).setKernelRootkit(KernelRootkit.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String findingId = "findingId439150212";
        Finding finding = Finding.newBuilder().build();
        Finding actualResponse = this.client.createFinding(parent, findingId, finding);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateFindingRequest actualRequest = (CreateFindingRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)findingId, (Object)actualRequest.getFindingId());
        Assert.assertEquals((Object)finding, (Object)actualRequest.getFinding());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createFindingExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String findingId = "findingId439150212";
            Finding finding = Finding.newBuilder().build();
            this.client.createFinding(parent, findingId, finding);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMuteConfigTest() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        MuteConfig actualResponse = this.client.createMuteConfig(parent, muteConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateMuteConfigRequest actualRequest = (CreateMuteConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)muteConfig, (Object)actualRequest.getMuteConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createMuteConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            this.client.createMuteConfig(parent, muteConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMuteConfigTest2() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        MuteConfig actualResponse = this.client.createMuteConfig(parent, muteConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateMuteConfigRequest actualRequest = (CreateMuteConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)muteConfig, (Object)actualRequest.getMuteConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createMuteConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            this.client.createMuteConfig(parent, muteConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMuteConfigTest3() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        MuteConfig actualResponse = this.client.createMuteConfig(parent, muteConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateMuteConfigRequest actualRequest = (CreateMuteConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)muteConfig, (Object)actualRequest.getMuteConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createMuteConfigExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            this.client.createMuteConfig(parent, muteConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMuteConfigTest4() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        MuteConfig actualResponse = this.client.createMuteConfig(parent, muteConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateMuteConfigRequest actualRequest = (CreateMuteConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)muteConfig, (Object)actualRequest.getMuteConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createMuteConfigExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            this.client.createMuteConfig(parent, muteConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMuteConfigTest5() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        String muteConfigId = "muteConfigId1689669942";
        MuteConfig actualResponse = this.client.createMuteConfig(parent, muteConfig, muteConfigId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateMuteConfigRequest actualRequest = (CreateMuteConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)muteConfig, (Object)actualRequest.getMuteConfig());
        Assert.assertEquals((Object)muteConfigId, (Object)actualRequest.getMuteConfigId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createMuteConfigExceptionTest5() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            String muteConfigId = "muteConfigId1689669942";
            this.client.createMuteConfig(parent, muteConfig, muteConfigId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMuteConfigTest6() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        String muteConfigId = "muteConfigId1689669942";
        MuteConfig actualResponse = this.client.createMuteConfig(parent, muteConfig, muteConfigId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateMuteConfigRequest actualRequest = (CreateMuteConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)muteConfig, (Object)actualRequest.getMuteConfig());
        Assert.assertEquals((Object)muteConfigId, (Object)actualRequest.getMuteConfigId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createMuteConfigExceptionTest6() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            String muteConfigId = "muteConfigId1689669942";
            this.client.createMuteConfig(parent, muteConfig, muteConfigId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMuteConfigTest7() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        String muteConfigId = "muteConfigId1689669942";
        MuteConfig actualResponse = this.client.createMuteConfig(parent, muteConfig, muteConfigId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateMuteConfigRequest actualRequest = (CreateMuteConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)muteConfig, (Object)actualRequest.getMuteConfig());
        Assert.assertEquals((Object)muteConfigId, (Object)actualRequest.getMuteConfigId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createMuteConfigExceptionTest7() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            String muteConfigId = "muteConfigId1689669942";
            this.client.createMuteConfig(parent, muteConfig, muteConfigId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMuteConfigTest8() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        String muteConfigId = "muteConfigId1689669942";
        MuteConfig actualResponse = this.client.createMuteConfig(parent, muteConfig, muteConfigId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateMuteConfigRequest actualRequest = (CreateMuteConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)muteConfig, (Object)actualRequest.getMuteConfig());
        Assert.assertEquals((Object)muteConfigId, (Object)actualRequest.getMuteConfigId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createMuteConfigExceptionTest8() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            String muteConfigId = "muteConfigId1689669942";
            this.client.createMuteConfig(parent, muteConfig, muteConfigId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = this.client.createNotificationConfig(parent, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNotificationConfigRequest actualRequest = (CreateNotificationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)notificationConfig, (Object)actualRequest.getNotificationConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNotificationConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            this.client.createNotificationConfig(parent, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest2() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = this.client.createNotificationConfig(parent, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNotificationConfigRequest actualRequest = (CreateNotificationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)notificationConfig, (Object)actualRequest.getNotificationConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNotificationConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            this.client.createNotificationConfig(parent, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest3() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = this.client.createNotificationConfig(parent, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNotificationConfigRequest actualRequest = (CreateNotificationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)notificationConfig, (Object)actualRequest.getNotificationConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNotificationConfigExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            this.client.createNotificationConfig(parent, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest4() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = this.client.createNotificationConfig(parent, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNotificationConfigRequest actualRequest = (CreateNotificationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)notificationConfig, (Object)actualRequest.getNotificationConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNotificationConfigExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            this.client.createNotificationConfig(parent, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest5() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        String configId = "configId-580140035";
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = this.client.createNotificationConfig(parent, configId, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNotificationConfigRequest actualRequest = (CreateNotificationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)configId, (Object)actualRequest.getConfigId());
        Assert.assertEquals((Object)notificationConfig, (Object)actualRequest.getNotificationConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNotificationConfigExceptionTest5() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            String configId = "configId-580140035";
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            this.client.createNotificationConfig(parent, configId, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest6() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        String configId = "configId-580140035";
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = this.client.createNotificationConfig(parent, configId, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNotificationConfigRequest actualRequest = (CreateNotificationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)configId, (Object)actualRequest.getConfigId());
        Assert.assertEquals((Object)notificationConfig, (Object)actualRequest.getNotificationConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNotificationConfigExceptionTest6() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            String configId = "configId-580140035";
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            this.client.createNotificationConfig(parent, configId, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest7() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        String configId = "configId-580140035";
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = this.client.createNotificationConfig(parent, configId, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNotificationConfigRequest actualRequest = (CreateNotificationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)configId, (Object)actualRequest.getConfigId());
        Assert.assertEquals((Object)notificationConfig, (Object)actualRequest.getNotificationConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNotificationConfigExceptionTest7() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            String configId = "configId-580140035";
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            this.client.createNotificationConfig(parent, configId, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest8() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String configId = "configId-580140035";
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = this.client.createNotificationConfig(parent, configId, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNotificationConfigRequest actualRequest = (CreateNotificationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)configId, (Object)actualRequest.getConfigId());
        Assert.assertEquals((Object)notificationConfig, (Object)actualRequest.getNotificationConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNotificationConfigExceptionTest8() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String configId = "configId-580140035";
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            this.client.createNotificationConfig(parent, configId, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteMuteConfigTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        MuteConfigName name = MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]");
        this.client.deleteMuteConfig(name);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteMuteConfigRequest actualRequest = (DeleteMuteConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteMuteConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            MuteConfigName name = MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]");
            this.client.deleteMuteConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteMuteConfigTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteMuteConfig(name);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteMuteConfigRequest actualRequest = (DeleteMuteConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteMuteConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteMuteConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteNotificationConfigTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        NotificationConfigName name = NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]");
        this.client.deleteNotificationConfig(name);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteNotificationConfigRequest actualRequest = (DeleteNotificationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteNotificationConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            NotificationConfigName name = NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]");
            this.client.deleteNotificationConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteNotificationConfigTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteNotificationConfig(name);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteNotificationConfigRequest actualRequest = (DeleteNotificationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteNotificationConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteNotificationConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSecurityHealthAnalyticsCustomModuleTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SecurityHealthAnalyticsCustomModuleName name = SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]");
        this.client.deleteSecurityHealthAnalyticsCustomModule(name);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSecurityHealthAnalyticsCustomModuleRequest actualRequest = (DeleteSecurityHealthAnalyticsCustomModuleRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSecurityHealthAnalyticsCustomModuleExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SecurityHealthAnalyticsCustomModuleName name = SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]");
            this.client.deleteSecurityHealthAnalyticsCustomModule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSecurityHealthAnalyticsCustomModuleTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteSecurityHealthAnalyticsCustomModule(name);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSecurityHealthAnalyticsCustomModuleRequest actualRequest = (DeleteSecurityHealthAnalyticsCustomModuleRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSecurityHealthAnalyticsCustomModuleExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteSecurityHealthAnalyticsCustomModule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getBigQueryExportTest() throws Exception {
        BigQueryExport expectedResponse = BigQueryExport.newBuilder().setName(BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]").toString()).setDescription("description-1724546052").setFilter("filter-1274492040").setDataset("dataset1443214456").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").setPrincipal("principal-1812041682").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        BigQueryExportName name = BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]");
        BigQueryExport actualResponse = this.client.getBigQueryExport(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetBigQueryExportRequest actualRequest = (GetBigQueryExportRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getBigQueryExportExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            BigQueryExportName name = BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]");
            this.client.getBigQueryExport(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getBigQueryExportTest2() throws Exception {
        BigQueryExport expectedResponse = BigQueryExport.newBuilder().setName(BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]").toString()).setDescription("description-1724546052").setFilter("filter-1274492040").setDataset("dataset1443214456").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").setPrincipal("principal-1812041682").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        BigQueryExport actualResponse = this.client.getBigQueryExport(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetBigQueryExportRequest actualRequest = (GetBigQueryExportRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getBigQueryExportExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getBigQueryExport(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        Policy actualResponse = this.client.getIamPolicy((ResourceName)resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            this.client.getIamPolicy((ResourceName)resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        Policy actualResponse = this.client.getIamPolicy(resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            this.client.getIamPolicy(resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getMuteConfigTest() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        MuteConfigName name = MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]");
        MuteConfig actualResponse = this.client.getMuteConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetMuteConfigRequest actualRequest = (GetMuteConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getMuteConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            MuteConfigName name = MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]");
            this.client.getMuteConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getMuteConfigTest2() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        MuteConfig actualResponse = this.client.getMuteConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetMuteConfigRequest actualRequest = (GetMuteConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getMuteConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getMuteConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNotificationConfigTest() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        NotificationConfigName name = NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]");
        NotificationConfig actualResponse = this.client.getNotificationConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetNotificationConfigRequest actualRequest = (GetNotificationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getNotificationConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            NotificationConfigName name = NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]");
            this.client.getNotificationConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNotificationConfigTest2() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        NotificationConfig actualResponse = this.client.getNotificationConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetNotificationConfigRequest actualRequest = (GetNotificationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getNotificationConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getNotificationConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOrganizationSettingsTest() throws Exception {
        OrganizationSettings expectedResponse = OrganizationSettings.newBuilder().setName(OrganizationSettingsName.of((String)"[ORGANIZATION]").toString()).setEnableAssetDiscovery(true).setAssetDiscoveryConfig(OrganizationSettings.AssetDiscoveryConfig.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        OrganizationSettingsName name = OrganizationSettingsName.of((String)"[ORGANIZATION]");
        OrganizationSettings actualResponse = this.client.getOrganizationSettings(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetOrganizationSettingsRequest actualRequest = (GetOrganizationSettingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getOrganizationSettingsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationSettingsName name = OrganizationSettingsName.of((String)"[ORGANIZATION]");
            this.client.getOrganizationSettings(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOrganizationSettingsTest2() throws Exception {
        OrganizationSettings expectedResponse = OrganizationSettings.newBuilder().setName(OrganizationSettingsName.of((String)"[ORGANIZATION]").toString()).setEnableAssetDiscovery(true).setAssetDiscoveryConfig(OrganizationSettings.AssetDiscoveryConfig.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        OrganizationSettings actualResponse = this.client.getOrganizationSettings(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetOrganizationSettingsRequest actualRequest = (GetOrganizationSettingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getOrganizationSettingsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getOrganizationSettings(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getEffectiveSecurityHealthAnalyticsCustomModuleTest() throws Exception {
        EffectiveSecurityHealthAnalyticsCustomModule expectedResponse = EffectiveSecurityHealthAnalyticsCustomModule.newBuilder().setName(EffectiveSecurityHealthAnalyticsCustomModuleName.ofOrganizationEffectiveCustomModuleName((String)"[ORGANIZATION]", (String)"[EFFECTIVE_CUSTOM_MODULE]").toString()).setCustomConfig(CustomConfig.newBuilder().build()).setDisplayName("displayName1714148973").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        EffectiveSecurityHealthAnalyticsCustomModuleName name = EffectiveSecurityHealthAnalyticsCustomModuleName.ofOrganizationEffectiveCustomModuleName((String)"[ORGANIZATION]", (String)"[EFFECTIVE_CUSTOM_MODULE]");
        EffectiveSecurityHealthAnalyticsCustomModule actualResponse = this.client.getEffectiveSecurityHealthAnalyticsCustomModule(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetEffectiveSecurityHealthAnalyticsCustomModuleRequest actualRequest = (GetEffectiveSecurityHealthAnalyticsCustomModuleRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getEffectiveSecurityHealthAnalyticsCustomModuleExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            EffectiveSecurityHealthAnalyticsCustomModuleName name = EffectiveSecurityHealthAnalyticsCustomModuleName.ofOrganizationEffectiveCustomModuleName((String)"[ORGANIZATION]", (String)"[EFFECTIVE_CUSTOM_MODULE]");
            this.client.getEffectiveSecurityHealthAnalyticsCustomModule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getEffectiveSecurityHealthAnalyticsCustomModuleTest2() throws Exception {
        EffectiveSecurityHealthAnalyticsCustomModule expectedResponse = EffectiveSecurityHealthAnalyticsCustomModule.newBuilder().setName(EffectiveSecurityHealthAnalyticsCustomModuleName.ofOrganizationEffectiveCustomModuleName((String)"[ORGANIZATION]", (String)"[EFFECTIVE_CUSTOM_MODULE]").toString()).setCustomConfig(CustomConfig.newBuilder().build()).setDisplayName("displayName1714148973").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        EffectiveSecurityHealthAnalyticsCustomModule actualResponse = this.client.getEffectiveSecurityHealthAnalyticsCustomModule(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetEffectiveSecurityHealthAnalyticsCustomModuleRequest actualRequest = (GetEffectiveSecurityHealthAnalyticsCustomModuleRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getEffectiveSecurityHealthAnalyticsCustomModuleExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getEffectiveSecurityHealthAnalyticsCustomModule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSecurityHealthAnalyticsCustomModuleTest() throws Exception {
        SecurityHealthAnalyticsCustomModule expectedResponse = SecurityHealthAnalyticsCustomModule.newBuilder().setName(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setDisplayName("displayName1714148973").setUpdateTime(Timestamp.newBuilder().build()).setLastEditor("lastEditor1523898275").setAncestorModule(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setCustomConfig(CustomConfig.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SecurityHealthAnalyticsCustomModuleName name = SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]");
        SecurityHealthAnalyticsCustomModule actualResponse = this.client.getSecurityHealthAnalyticsCustomModule(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSecurityHealthAnalyticsCustomModuleRequest actualRequest = (GetSecurityHealthAnalyticsCustomModuleRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSecurityHealthAnalyticsCustomModuleExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SecurityHealthAnalyticsCustomModuleName name = SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]");
            this.client.getSecurityHealthAnalyticsCustomModule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSecurityHealthAnalyticsCustomModuleTest2() throws Exception {
        SecurityHealthAnalyticsCustomModule expectedResponse = SecurityHealthAnalyticsCustomModule.newBuilder().setName(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setDisplayName("displayName1714148973").setUpdateTime(Timestamp.newBuilder().build()).setLastEditor("lastEditor1523898275").setAncestorModule(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setCustomConfig(CustomConfig.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        SecurityHealthAnalyticsCustomModule actualResponse = this.client.getSecurityHealthAnalyticsCustomModule(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSecurityHealthAnalyticsCustomModuleRequest actualRequest = (GetSecurityHealthAnalyticsCustomModuleRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSecurityHealthAnalyticsCustomModuleExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getSecurityHealthAnalyticsCustomModule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSourceTest() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SourceName name = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        Source actualResponse = this.client.getSource(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSourceRequest actualRequest = (GetSourceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSourceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SourceName name = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            this.client.getSource(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSourceTest2() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Source actualResponse = this.client.getSource(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSourceRequest actualRequest = (GetSourceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSourceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getSource(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void groupAssetsTest() throws Exception {
        GroupResult responsesElement = GroupResult.newBuilder().build();
        GroupAssetsResponse expectedResponse = GroupAssetsResponse.newBuilder().setNextPageToken("").addAllGroupByResults(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        GroupAssetsRequest request = GroupAssetsRequest.newBuilder().setParent(OrganizationName.of((String)"[ORGANIZATION]").toString()).setFilter("filter-1274492040").setGroupBy("groupBy293428022").setCompareDuration(Duration.newBuilder().build()).setReadTime(Timestamp.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
        SecurityCenterClient.GroupAssetsPagedResponse pagedListResponse = this.client.groupAssets(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGroupByResultsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GroupAssetsRequest actualRequest = (GroupAssetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getFilter(), (Object)actualRequest.getFilter());
        Assert.assertEquals((Object)request.getGroupBy(), (Object)actualRequest.getGroupBy());
        Assert.assertEquals((Object)request.getCompareDuration(), (Object)actualRequest.getCompareDuration());
        Assert.assertEquals((Object)request.getReadTime(), (Object)actualRequest.getReadTime());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void groupAssetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            GroupAssetsRequest request = GroupAssetsRequest.newBuilder().setParent(OrganizationName.of((String)"[ORGANIZATION]").toString()).setFilter("filter-1274492040").setGroupBy("groupBy293428022").setCompareDuration(Duration.newBuilder().build()).setReadTime(Timestamp.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
            this.client.groupAssets(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void groupFindingsTest() throws Exception {
        GroupResult responsesElement = GroupResult.newBuilder().build();
        GroupFindingsResponse expectedResponse = GroupFindingsResponse.newBuilder().setNextPageToken("").addAllGroupByResults(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SourceName parent = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        String groupBy = "groupBy293428022";
        SecurityCenterClient.GroupFindingsPagedResponse pagedListResponse = this.client.groupFindings(parent, groupBy);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGroupByResultsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GroupFindingsRequest actualRequest = (GroupFindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)groupBy, (Object)actualRequest.getGroupBy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void groupFindingsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SourceName parent = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            String groupBy = "groupBy293428022";
            this.client.groupFindings(parent, groupBy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void groupFindingsTest2() throws Exception {
        GroupResult responsesElement = GroupResult.newBuilder().build();
        GroupFindingsResponse expectedResponse = GroupFindingsResponse.newBuilder().setNextPageToken("").addAllGroupByResults(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String groupBy = "groupBy293428022";
        SecurityCenterClient.GroupFindingsPagedResponse pagedListResponse = this.client.groupFindings(parent, groupBy);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGroupByResultsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GroupFindingsRequest actualRequest = (GroupFindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)groupBy, (Object)actualRequest.getGroupBy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void groupFindingsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String groupBy = "groupBy293428022";
            this.client.groupFindings(parent, groupBy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAssetsTest() throws Exception {
        ListAssetsResponse.ListAssetsResult responsesElement = ListAssetsResponse.ListAssetsResult.newBuilder().build();
        ListAssetsResponse expectedResponse = ListAssetsResponse.newBuilder().setNextPageToken("").addAllListAssetsResults(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        ListAssetsRequest request = ListAssetsRequest.newBuilder().setParent(OrganizationName.of((String)"[ORGANIZATION]").toString()).setFilter("filter-1274492040").setOrderBy("orderBy-1207110587").setReadTime(Timestamp.newBuilder().build()).setCompareDuration(Duration.newBuilder().build()).setFieldMask(FieldMask.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
        SecurityCenterClient.ListAssetsPagedResponse pagedListResponse = this.client.listAssets(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getListAssetsResultsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAssetsRequest actualRequest = (ListAssetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getFilter(), (Object)actualRequest.getFilter());
        Assert.assertEquals((Object)request.getOrderBy(), (Object)actualRequest.getOrderBy());
        Assert.assertEquals((Object)request.getReadTime(), (Object)actualRequest.getReadTime());
        Assert.assertEquals((Object)request.getCompareDuration(), (Object)actualRequest.getCompareDuration());
        Assert.assertEquals((Object)request.getFieldMask(), (Object)actualRequest.getFieldMask());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAssetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            ListAssetsRequest request = ListAssetsRequest.newBuilder().setParent(OrganizationName.of((String)"[ORGANIZATION]").toString()).setFilter("filter-1274492040").setOrderBy("orderBy-1207110587").setReadTime(Timestamp.newBuilder().build()).setCompareDuration(Duration.newBuilder().build()).setFieldMask(FieldMask.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
            this.client.listAssets(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDescendantSecurityHealthAnalyticsCustomModulesTest() throws Exception {
        SecurityHealthAnalyticsCustomModule responsesElement = SecurityHealthAnalyticsCustomModule.newBuilder().build();
        ListDescendantSecurityHealthAnalyticsCustomModulesResponse expectedResponse = ListDescendantSecurityHealthAnalyticsCustomModulesResponse.newBuilder().setNextPageToken("").addAllSecurityHealthAnalyticsCustomModules(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SecurityHealthAnalyticsSettingsName parent = SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)"[ORGANIZATION]");
        SecurityCenterClient.ListDescendantSecurityHealthAnalyticsCustomModulesPagedResponse pagedListResponse = this.client.listDescendantSecurityHealthAnalyticsCustomModules(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSecurityHealthAnalyticsCustomModulesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDescendantSecurityHealthAnalyticsCustomModulesRequest actualRequest = (ListDescendantSecurityHealthAnalyticsCustomModulesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDescendantSecurityHealthAnalyticsCustomModulesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SecurityHealthAnalyticsSettingsName parent = SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)"[ORGANIZATION]");
            this.client.listDescendantSecurityHealthAnalyticsCustomModules(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDescendantSecurityHealthAnalyticsCustomModulesTest2() throws Exception {
        SecurityHealthAnalyticsCustomModule responsesElement = SecurityHealthAnalyticsCustomModule.newBuilder().build();
        ListDescendantSecurityHealthAnalyticsCustomModulesResponse expectedResponse = ListDescendantSecurityHealthAnalyticsCustomModulesResponse.newBuilder().setNextPageToken("").addAllSecurityHealthAnalyticsCustomModules(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        SecurityCenterClient.ListDescendantSecurityHealthAnalyticsCustomModulesPagedResponse pagedListResponse = this.client.listDescendantSecurityHealthAnalyticsCustomModules(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSecurityHealthAnalyticsCustomModulesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDescendantSecurityHealthAnalyticsCustomModulesRequest actualRequest = (ListDescendantSecurityHealthAnalyticsCustomModulesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDescendantSecurityHealthAnalyticsCustomModulesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listDescendantSecurityHealthAnalyticsCustomModules(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listFindingsTest() throws Exception {
        ListFindingsResponse.ListFindingsResult responsesElement = ListFindingsResponse.ListFindingsResult.newBuilder().build();
        ListFindingsResponse expectedResponse = ListFindingsResponse.newBuilder().setNextPageToken("").addAllListFindingsResults(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        ListFindingsRequest request = ListFindingsRequest.newBuilder().setParent(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setFilter("filter-1274492040").setOrderBy("orderBy-1207110587").setReadTime(Timestamp.newBuilder().build()).setCompareDuration(Duration.newBuilder().build()).setFieldMask(FieldMask.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
        SecurityCenterClient.ListFindingsPagedResponse pagedListResponse = this.client.listFindings(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getListFindingsResultsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListFindingsRequest actualRequest = (ListFindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getFilter(), (Object)actualRequest.getFilter());
        Assert.assertEquals((Object)request.getOrderBy(), (Object)actualRequest.getOrderBy());
        Assert.assertEquals((Object)request.getReadTime(), (Object)actualRequest.getReadTime());
        Assert.assertEquals((Object)request.getCompareDuration(), (Object)actualRequest.getCompareDuration());
        Assert.assertEquals((Object)request.getFieldMask(), (Object)actualRequest.getFieldMask());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listFindingsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            ListFindingsRequest request = ListFindingsRequest.newBuilder().setParent(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setFilter("filter-1274492040").setOrderBy("orderBy-1207110587").setReadTime(Timestamp.newBuilder().build()).setCompareDuration(Duration.newBuilder().build()).setFieldMask(FieldMask.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
            this.client.listFindings(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMuteConfigsTest() throws Exception {
        MuteConfig responsesElement = MuteConfig.newBuilder().build();
        ListMuteConfigsResponse expectedResponse = ListMuteConfigsResponse.newBuilder().setNextPageToken("").addAllMuteConfigs(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        SecurityCenterClient.ListMuteConfigsPagedResponse pagedListResponse = this.client.listMuteConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMuteConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMuteConfigsRequest actualRequest = (ListMuteConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMuteConfigsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            this.client.listMuteConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMuteConfigsTest2() throws Exception {
        MuteConfig responsesElement = MuteConfig.newBuilder().build();
        ListMuteConfigsResponse expectedResponse = ListMuteConfigsResponse.newBuilder().setNextPageToken("").addAllMuteConfigs(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        SecurityCenterClient.ListMuteConfigsPagedResponse pagedListResponse = this.client.listMuteConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMuteConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMuteConfigsRequest actualRequest = (ListMuteConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMuteConfigsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            this.client.listMuteConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMuteConfigsTest3() throws Exception {
        MuteConfig responsesElement = MuteConfig.newBuilder().build();
        ListMuteConfigsResponse expectedResponse = ListMuteConfigsResponse.newBuilder().setNextPageToken("").addAllMuteConfigs(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        SecurityCenterClient.ListMuteConfigsPagedResponse pagedListResponse = this.client.listMuteConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMuteConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMuteConfigsRequest actualRequest = (ListMuteConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMuteConfigsExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listMuteConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMuteConfigsTest4() throws Exception {
        MuteConfig responsesElement = MuteConfig.newBuilder().build();
        ListMuteConfigsResponse expectedResponse = ListMuteConfigsResponse.newBuilder().setNextPageToken("").addAllMuteConfigs(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        SecurityCenterClient.ListMuteConfigsPagedResponse pagedListResponse = this.client.listMuteConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMuteConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMuteConfigsRequest actualRequest = (ListMuteConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMuteConfigsExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listMuteConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationConfigsTest() throws Exception {
        NotificationConfig responsesElement = NotificationConfig.newBuilder().build();
        ListNotificationConfigsResponse expectedResponse = ListNotificationConfigsResponse.newBuilder().setNextPageToken("").addAllNotificationConfigs(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        SecurityCenterClient.ListNotificationConfigsPagedResponse pagedListResponse = this.client.listNotificationConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNotificationConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNotificationConfigsRequest actualRequest = (ListNotificationConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNotificationConfigsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            this.client.listNotificationConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationConfigsTest2() throws Exception {
        NotificationConfig responsesElement = NotificationConfig.newBuilder().build();
        ListNotificationConfigsResponse expectedResponse = ListNotificationConfigsResponse.newBuilder().setNextPageToken("").addAllNotificationConfigs(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        SecurityCenterClient.ListNotificationConfigsPagedResponse pagedListResponse = this.client.listNotificationConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNotificationConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNotificationConfigsRequest actualRequest = (ListNotificationConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNotificationConfigsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            this.client.listNotificationConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationConfigsTest3() throws Exception {
        NotificationConfig responsesElement = NotificationConfig.newBuilder().build();
        ListNotificationConfigsResponse expectedResponse = ListNotificationConfigsResponse.newBuilder().setNextPageToken("").addAllNotificationConfigs(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        SecurityCenterClient.ListNotificationConfigsPagedResponse pagedListResponse = this.client.listNotificationConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNotificationConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNotificationConfigsRequest actualRequest = (ListNotificationConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNotificationConfigsExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listNotificationConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationConfigsTest4() throws Exception {
        NotificationConfig responsesElement = NotificationConfig.newBuilder().build();
        ListNotificationConfigsResponse expectedResponse = ListNotificationConfigsResponse.newBuilder().setNextPageToken("").addAllNotificationConfigs(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        SecurityCenterClient.ListNotificationConfigsPagedResponse pagedListResponse = this.client.listNotificationConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNotificationConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNotificationConfigsRequest actualRequest = (ListNotificationConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNotificationConfigsExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listNotificationConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listEffectiveSecurityHealthAnalyticsCustomModulesTest() throws Exception {
        EffectiveSecurityHealthAnalyticsCustomModule responsesElement = EffectiveSecurityHealthAnalyticsCustomModule.newBuilder().build();
        ListEffectiveSecurityHealthAnalyticsCustomModulesResponse expectedResponse = ListEffectiveSecurityHealthAnalyticsCustomModulesResponse.newBuilder().setNextPageToken("").addAllEffectiveSecurityHealthAnalyticsCustomModules(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SecurityHealthAnalyticsSettingsName parent = SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)"[ORGANIZATION]");
        SecurityCenterClient.ListEffectiveSecurityHealthAnalyticsCustomModulesPagedResponse pagedListResponse = this.client.listEffectiveSecurityHealthAnalyticsCustomModules(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getEffectiveSecurityHealthAnalyticsCustomModulesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListEffectiveSecurityHealthAnalyticsCustomModulesRequest actualRequest = (ListEffectiveSecurityHealthAnalyticsCustomModulesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listEffectiveSecurityHealthAnalyticsCustomModulesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SecurityHealthAnalyticsSettingsName parent = SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)"[ORGANIZATION]");
            this.client.listEffectiveSecurityHealthAnalyticsCustomModules(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listEffectiveSecurityHealthAnalyticsCustomModulesTest2() throws Exception {
        EffectiveSecurityHealthAnalyticsCustomModule responsesElement = EffectiveSecurityHealthAnalyticsCustomModule.newBuilder().build();
        ListEffectiveSecurityHealthAnalyticsCustomModulesResponse expectedResponse = ListEffectiveSecurityHealthAnalyticsCustomModulesResponse.newBuilder().setNextPageToken("").addAllEffectiveSecurityHealthAnalyticsCustomModules(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        SecurityCenterClient.ListEffectiveSecurityHealthAnalyticsCustomModulesPagedResponse pagedListResponse = this.client.listEffectiveSecurityHealthAnalyticsCustomModules(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getEffectiveSecurityHealthAnalyticsCustomModulesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListEffectiveSecurityHealthAnalyticsCustomModulesRequest actualRequest = (ListEffectiveSecurityHealthAnalyticsCustomModulesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listEffectiveSecurityHealthAnalyticsCustomModulesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listEffectiveSecurityHealthAnalyticsCustomModules(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSecurityHealthAnalyticsCustomModulesTest() throws Exception {
        SecurityHealthAnalyticsCustomModule responsesElement = SecurityHealthAnalyticsCustomModule.newBuilder().build();
        ListSecurityHealthAnalyticsCustomModulesResponse expectedResponse = ListSecurityHealthAnalyticsCustomModulesResponse.newBuilder().setNextPageToken("").addAllSecurityHealthAnalyticsCustomModules(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SecurityHealthAnalyticsSettingsName parent = SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)"[ORGANIZATION]");
        SecurityCenterClient.ListSecurityHealthAnalyticsCustomModulesPagedResponse pagedListResponse = this.client.listSecurityHealthAnalyticsCustomModules(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSecurityHealthAnalyticsCustomModulesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSecurityHealthAnalyticsCustomModulesRequest actualRequest = (ListSecurityHealthAnalyticsCustomModulesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSecurityHealthAnalyticsCustomModulesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SecurityHealthAnalyticsSettingsName parent = SecurityHealthAnalyticsSettingsName.ofOrganizationName((String)"[ORGANIZATION]");
            this.client.listSecurityHealthAnalyticsCustomModules(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSecurityHealthAnalyticsCustomModulesTest2() throws Exception {
        SecurityHealthAnalyticsCustomModule responsesElement = SecurityHealthAnalyticsCustomModule.newBuilder().build();
        ListSecurityHealthAnalyticsCustomModulesResponse expectedResponse = ListSecurityHealthAnalyticsCustomModulesResponse.newBuilder().setNextPageToken("").addAllSecurityHealthAnalyticsCustomModules(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        SecurityCenterClient.ListSecurityHealthAnalyticsCustomModulesPagedResponse pagedListResponse = this.client.listSecurityHealthAnalyticsCustomModules(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSecurityHealthAnalyticsCustomModulesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSecurityHealthAnalyticsCustomModulesRequest actualRequest = (ListSecurityHealthAnalyticsCustomModulesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSecurityHealthAnalyticsCustomModulesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listSecurityHealthAnalyticsCustomModules(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSourcesTest() throws Exception {
        Source responsesElement = Source.newBuilder().build();
        ListSourcesResponse expectedResponse = ListSourcesResponse.newBuilder().setNextPageToken("").addAllSources(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        SecurityCenterClient.ListSourcesPagedResponse pagedListResponse = this.client.listSources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSourcesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSourcesRequest actualRequest = (ListSourcesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSourcesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            this.client.listSources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSourcesTest2() throws Exception {
        Source responsesElement = Source.newBuilder().build();
        ListSourcesResponse expectedResponse = ListSourcesResponse.newBuilder().setNextPageToken("").addAllSources(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        SecurityCenterClient.ListSourcesPagedResponse pagedListResponse = this.client.listSources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSourcesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSourcesRequest actualRequest = (ListSourcesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSourcesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            this.client.listSources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSourcesTest3() throws Exception {
        Source responsesElement = Source.newBuilder().build();
        ListSourcesResponse expectedResponse = ListSourcesResponse.newBuilder().setNextPageToken("").addAllSources(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        SecurityCenterClient.ListSourcesPagedResponse pagedListResponse = this.client.listSources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSourcesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSourcesRequest actualRequest = (ListSourcesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSourcesExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listSources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSourcesTest4() throws Exception {
        Source responsesElement = Source.newBuilder().build();
        ListSourcesResponse expectedResponse = ListSourcesResponse.newBuilder().setNextPageToken("").addAllSources(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        SecurityCenterClient.ListSourcesPagedResponse pagedListResponse = this.client.listSources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSourcesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSourcesRequest actualRequest = (ListSourcesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSourcesExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listSources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void runAssetDiscoveryTest() throws Exception {
        RunAssetDiscoveryResponse expectedResponse = RunAssetDiscoveryResponse.newBuilder().setDuration(Duration.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("runAssetDiscoveryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockSecurityCenter.addResponse((AbstractMessage)resultOperation);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        RunAssetDiscoveryResponse actualResponse = (RunAssetDiscoveryResponse)this.client.runAssetDiscoveryAsync(parent).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RunAssetDiscoveryRequest actualRequest = (RunAssetDiscoveryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void runAssetDiscoveryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            this.client.runAssetDiscoveryAsync(parent).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void runAssetDiscoveryTest2() throws Exception {
        RunAssetDiscoveryResponse expectedResponse = RunAssetDiscoveryResponse.newBuilder().setDuration(Duration.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("runAssetDiscoveryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockSecurityCenter.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        RunAssetDiscoveryResponse actualResponse = (RunAssetDiscoveryResponse)this.client.runAssetDiscoveryAsync(parent).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RunAssetDiscoveryRequest actualRequest = (RunAssetDiscoveryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void runAssetDiscoveryExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.runAssetDiscoveryAsync(parent).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void setFindingStateTest() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").setIndicator(Indicator.newBuilder().build()).setVulnerability(Vulnerability.newBuilder().build()).setMuteUpdateTime(Timestamp.newBuilder().build()).putAllExternalSystems(new HashMap()).setMitreAttack(MitreAttack.newBuilder().build()).setAccess(Access.newBuilder().build()).addAllConnections(new ArrayList()).setMuteInitiator("muteInitiator1395645462").addAllProcesses(new ArrayList()).putAllContacts(new HashMap()).addAllCompliances(new ArrayList()).setParentDisplayName("parentDisplayName-1523759261").setDescription("description-1724546052").setExfiltration(Exfiltration.newBuilder().build()).addAllIamBindings(new ArrayList()).setNextSteps("nextSteps1206138868").setModuleName("moduleName-870351081").addAllContainers(new ArrayList()).setKubernetes(Kubernetes.newBuilder().build()).setDatabase(Database.newBuilder().build()).addAllFiles(new ArrayList()).setCloudDlpInspection(CloudDlpInspection.newBuilder().build()).setCloudDlpDataProfile(CloudDlpDataProfile.newBuilder().build()).setKernelRootkit(KernelRootkit.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        FindingName name = FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]");
        Finding.State state = Finding.State.forNumber((int)0);
        Timestamp startTime = Timestamp.newBuilder().build();
        Finding actualResponse = this.client.setFindingState(name, state, startTime);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetFindingStateRequest actualRequest = (SetFindingStateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)state, (Object)actualRequest.getState());
        Assert.assertEquals((Object)startTime, (Object)actualRequest.getStartTime());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setFindingStateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            FindingName name = FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]");
            Finding.State state = Finding.State.forNumber((int)0);
            Timestamp startTime = Timestamp.newBuilder().build();
            this.client.setFindingState(name, state, startTime);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setFindingStateTest2() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").setIndicator(Indicator.newBuilder().build()).setVulnerability(Vulnerability.newBuilder().build()).setMuteUpdateTime(Timestamp.newBuilder().build()).putAllExternalSystems(new HashMap()).setMitreAttack(MitreAttack.newBuilder().build()).setAccess(Access.newBuilder().build()).addAllConnections(new ArrayList()).setMuteInitiator("muteInitiator1395645462").addAllProcesses(new ArrayList()).putAllContacts(new HashMap()).addAllCompliances(new ArrayList()).setParentDisplayName("parentDisplayName-1523759261").setDescription("description-1724546052").setExfiltration(Exfiltration.newBuilder().build()).addAllIamBindings(new ArrayList()).setNextSteps("nextSteps1206138868").setModuleName("moduleName-870351081").addAllContainers(new ArrayList()).setKubernetes(Kubernetes.newBuilder().build()).setDatabase(Database.newBuilder().build()).addAllFiles(new ArrayList()).setCloudDlpInspection(CloudDlpInspection.newBuilder().build()).setCloudDlpDataProfile(CloudDlpDataProfile.newBuilder().build()).setKernelRootkit(KernelRootkit.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Finding.State state = Finding.State.forNumber((int)0);
        Timestamp startTime = Timestamp.newBuilder().build();
        Finding actualResponse = this.client.setFindingState(name, state, startTime);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetFindingStateRequest actualRequest = (SetFindingStateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)state, (Object)actualRequest.getState());
        Assert.assertEquals((Object)startTime, (Object)actualRequest.getStartTime());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setFindingStateExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String name = "name3373707";
            Finding.State state = Finding.State.forNumber((int)0);
            Timestamp startTime = Timestamp.newBuilder().build();
            this.client.setFindingState(name, state, startTime);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setMuteTest() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").setIndicator(Indicator.newBuilder().build()).setVulnerability(Vulnerability.newBuilder().build()).setMuteUpdateTime(Timestamp.newBuilder().build()).putAllExternalSystems(new HashMap()).setMitreAttack(MitreAttack.newBuilder().build()).setAccess(Access.newBuilder().build()).addAllConnections(new ArrayList()).setMuteInitiator("muteInitiator1395645462").addAllProcesses(new ArrayList()).putAllContacts(new HashMap()).addAllCompliances(new ArrayList()).setParentDisplayName("parentDisplayName-1523759261").setDescription("description-1724546052").setExfiltration(Exfiltration.newBuilder().build()).addAllIamBindings(new ArrayList()).setNextSteps("nextSteps1206138868").setModuleName("moduleName-870351081").addAllContainers(new ArrayList()).setKubernetes(Kubernetes.newBuilder().build()).setDatabase(Database.newBuilder().build()).addAllFiles(new ArrayList()).setCloudDlpInspection(CloudDlpInspection.newBuilder().build()).setCloudDlpDataProfile(CloudDlpDataProfile.newBuilder().build()).setKernelRootkit(KernelRootkit.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        FindingName name = FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]");
        Finding.Mute mute = Finding.Mute.forNumber((int)0);
        Finding actualResponse = this.client.setMute(name, mute);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetMuteRequest actualRequest = (SetMuteRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)mute, (Object)actualRequest.getMute());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setMuteExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            FindingName name = FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]");
            Finding.Mute mute = Finding.Mute.forNumber((int)0);
            this.client.setMute(name, mute);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setMuteTest2() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").setIndicator(Indicator.newBuilder().build()).setVulnerability(Vulnerability.newBuilder().build()).setMuteUpdateTime(Timestamp.newBuilder().build()).putAllExternalSystems(new HashMap()).setMitreAttack(MitreAttack.newBuilder().build()).setAccess(Access.newBuilder().build()).addAllConnections(new ArrayList()).setMuteInitiator("muteInitiator1395645462").addAllProcesses(new ArrayList()).putAllContacts(new HashMap()).addAllCompliances(new ArrayList()).setParentDisplayName("parentDisplayName-1523759261").setDescription("description-1724546052").setExfiltration(Exfiltration.newBuilder().build()).addAllIamBindings(new ArrayList()).setNextSteps("nextSteps1206138868").setModuleName("moduleName-870351081").addAllContainers(new ArrayList()).setKubernetes(Kubernetes.newBuilder().build()).setDatabase(Database.newBuilder().build()).addAllFiles(new ArrayList()).setCloudDlpInspection(CloudDlpInspection.newBuilder().build()).setCloudDlpDataProfile(CloudDlpDataProfile.newBuilder().build()).setKernelRootkit(KernelRootkit.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Finding.Mute mute = Finding.Mute.forNumber((int)0);
        Finding actualResponse = this.client.setMute(name, mute);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetMuteRequest actualRequest = (SetMuteRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)mute, (Object)actualRequest.getMute());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setMuteExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String name = "name3373707";
            Finding.Mute mute = Finding.Mute.forNumber((int)0);
            this.client.setMute(name, mute);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy((ResourceName)resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy((ResourceName)resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy(resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy(resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions((ResourceName)resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions((ResourceName)resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest2() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions(resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateExternalSystemTest() throws Exception {
        ExternalSystem expectedResponse = ExternalSystem.newBuilder().setName("name3373707").addAllAssignees(new ArrayList()).setExternalUid("externalUid-1153085307").setStatus("status-892481550").setExternalSystemUpdateTime(Timestamp.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        ExternalSystem externalSystem = ExternalSystem.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        ExternalSystem actualResponse = this.client.updateExternalSystem(externalSystem, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateExternalSystemRequest actualRequest = (UpdateExternalSystemRequest)actualRequests.get(0);
        Assert.assertEquals((Object)externalSystem, (Object)actualRequest.getExternalSystem());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateExternalSystemExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            ExternalSystem externalSystem = ExternalSystem.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateExternalSystem(externalSystem, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateFindingTest() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").setIndicator(Indicator.newBuilder().build()).setVulnerability(Vulnerability.newBuilder().build()).setMuteUpdateTime(Timestamp.newBuilder().build()).putAllExternalSystems(new HashMap()).setMitreAttack(MitreAttack.newBuilder().build()).setAccess(Access.newBuilder().build()).addAllConnections(new ArrayList()).setMuteInitiator("muteInitiator1395645462").addAllProcesses(new ArrayList()).putAllContacts(new HashMap()).addAllCompliances(new ArrayList()).setParentDisplayName("parentDisplayName-1523759261").setDescription("description-1724546052").setExfiltration(Exfiltration.newBuilder().build()).addAllIamBindings(new ArrayList()).setNextSteps("nextSteps1206138868").setModuleName("moduleName-870351081").addAllContainers(new ArrayList()).setKubernetes(Kubernetes.newBuilder().build()).setDatabase(Database.newBuilder().build()).addAllFiles(new ArrayList()).setCloudDlpInspection(CloudDlpInspection.newBuilder().build()).setCloudDlpDataProfile(CloudDlpDataProfile.newBuilder().build()).setKernelRootkit(KernelRootkit.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        Finding finding = Finding.newBuilder().build();
        Finding actualResponse = this.client.updateFinding(finding);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateFindingRequest actualRequest = (UpdateFindingRequest)actualRequests.get(0);
        Assert.assertEquals((Object)finding, (Object)actualRequest.getFinding());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateFindingExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            Finding finding = Finding.newBuilder().build();
            this.client.updateFinding(finding);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateMuteConfigTest() throws Exception {
        MuteConfig expectedResponse = MuteConfig.newBuilder().setName(MuteConfigName.ofOrganizationMuteConfigName((String)"[ORGANIZATION]", (String)"[MUTE_CONFIG]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setFilter("filter-1274492040").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        MuteConfig muteConfig = MuteConfig.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        MuteConfig actualResponse = this.client.updateMuteConfig(muteConfig, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateMuteConfigRequest actualRequest = (UpdateMuteConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)muteConfig, (Object)actualRequest.getMuteConfig());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateMuteConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            MuteConfig muteConfig = MuteConfig.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateMuteConfig(muteConfig, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateNotificationConfigTest() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = this.client.updateNotificationConfig(notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateNotificationConfigRequest actualRequest = (UpdateNotificationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)notificationConfig, (Object)actualRequest.getNotificationConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateNotificationConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            this.client.updateNotificationConfig(notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateNotificationConfigTest2() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.ofOrganizationNotificationConfigName((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        NotificationConfig actualResponse = this.client.updateNotificationConfig(notificationConfig, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateNotificationConfigRequest actualRequest = (UpdateNotificationConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)notificationConfig, (Object)actualRequest.getNotificationConfig());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateNotificationConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateNotificationConfig(notificationConfig, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateOrganizationSettingsTest() throws Exception {
        OrganizationSettings expectedResponse = OrganizationSettings.newBuilder().setName(OrganizationSettingsName.of((String)"[ORGANIZATION]").toString()).setEnableAssetDiscovery(true).setAssetDiscoveryConfig(OrganizationSettings.AssetDiscoveryConfig.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        OrganizationSettings organizationSettings = OrganizationSettings.newBuilder().build();
        OrganizationSettings actualResponse = this.client.updateOrganizationSettings(organizationSettings);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateOrganizationSettingsRequest actualRequest = (UpdateOrganizationSettingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)organizationSettings, (Object)actualRequest.getOrganizationSettings());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateOrganizationSettingsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationSettings organizationSettings = OrganizationSettings.newBuilder().build();
            this.client.updateOrganizationSettings(organizationSettings);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSecurityHealthAnalyticsCustomModuleTest() throws Exception {
        SecurityHealthAnalyticsCustomModule expectedResponse = SecurityHealthAnalyticsCustomModule.newBuilder().setName(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setDisplayName("displayName1714148973").setUpdateTime(Timestamp.newBuilder().build()).setLastEditor("lastEditor1523898275").setAncestorModule(SecurityHealthAnalyticsCustomModuleName.ofOrganizationCustomModuleName((String)"[ORGANIZATION]", (String)"[CUSTOM_MODULE]").toString()).setCustomConfig(CustomConfig.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SecurityHealthAnalyticsCustomModule securityHealthAnalyticsCustomModule = SecurityHealthAnalyticsCustomModule.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        SecurityHealthAnalyticsCustomModule actualResponse = this.client.updateSecurityHealthAnalyticsCustomModule(securityHealthAnalyticsCustomModule, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateSecurityHealthAnalyticsCustomModuleRequest actualRequest = (UpdateSecurityHealthAnalyticsCustomModuleRequest)actualRequests.get(0);
        Assert.assertEquals((Object)securityHealthAnalyticsCustomModule, (Object)actualRequest.getSecurityHealthAnalyticsCustomModule());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateSecurityHealthAnalyticsCustomModuleExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SecurityHealthAnalyticsCustomModule securityHealthAnalyticsCustomModule = SecurityHealthAnalyticsCustomModule.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateSecurityHealthAnalyticsCustomModule(securityHealthAnalyticsCustomModule, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSourceTest() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        Source source = Source.newBuilder().build();
        Source actualResponse = this.client.updateSource(source);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateSourceRequest actualRequest = (UpdateSourceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)source, (Object)actualRequest.getSource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateSourceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            Source source = Source.newBuilder().build();
            this.client.updateSource(source);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSecurityMarksTest() throws Exception {
        SecurityMarks expectedResponse = SecurityMarks.newBuilder().setName("name3373707").putAllMarks(new HashMap()).setCanonicalName("canonicalName2122381727").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SecurityMarks securityMarks = SecurityMarks.newBuilder().build();
        SecurityMarks actualResponse = this.client.updateSecurityMarks(securityMarks);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateSecurityMarksRequest actualRequest = (UpdateSecurityMarksRequest)actualRequests.get(0);
        Assert.assertEquals((Object)securityMarks, (Object)actualRequest.getSecurityMarks());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateSecurityMarksExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SecurityMarks securityMarks = SecurityMarks.newBuilder().build();
            this.client.updateSecurityMarks(securityMarks);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBigQueryExportTest() throws Exception {
        BigQueryExport expectedResponse = BigQueryExport.newBuilder().setName(BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]").toString()).setDescription("description-1724546052").setFilter("filter-1274492040").setDataset("dataset1443214456").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").setPrincipal("principal-1812041682").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
        String bigQueryExportId = "bigQueryExportId1024198583";
        BigQueryExport actualResponse = this.client.createBigQueryExport(parent, bigQueryExport, bigQueryExportId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateBigQueryExportRequest actualRequest = (CreateBigQueryExportRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)bigQueryExport, (Object)actualRequest.getBigQueryExport());
        Assert.assertEquals((Object)bigQueryExportId, (Object)actualRequest.getBigQueryExportId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createBigQueryExportExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
            String bigQueryExportId = "bigQueryExportId1024198583";
            this.client.createBigQueryExport(parent, bigQueryExport, bigQueryExportId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBigQueryExportTest2() throws Exception {
        BigQueryExport expectedResponse = BigQueryExport.newBuilder().setName(BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]").toString()).setDescription("description-1724546052").setFilter("filter-1274492040").setDataset("dataset1443214456").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").setPrincipal("principal-1812041682").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
        String bigQueryExportId = "bigQueryExportId1024198583";
        BigQueryExport actualResponse = this.client.createBigQueryExport(parent, bigQueryExport, bigQueryExportId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateBigQueryExportRequest actualRequest = (CreateBigQueryExportRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)bigQueryExport, (Object)actualRequest.getBigQueryExport());
        Assert.assertEquals((Object)bigQueryExportId, (Object)actualRequest.getBigQueryExportId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createBigQueryExportExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
            String bigQueryExportId = "bigQueryExportId1024198583";
            this.client.createBigQueryExport(parent, bigQueryExport, bigQueryExportId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBigQueryExportTest3() throws Exception {
        BigQueryExport expectedResponse = BigQueryExport.newBuilder().setName(BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]").toString()).setDescription("description-1724546052").setFilter("filter-1274492040").setDataset("dataset1443214456").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").setPrincipal("principal-1812041682").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
        String bigQueryExportId = "bigQueryExportId1024198583";
        BigQueryExport actualResponse = this.client.createBigQueryExport(parent, bigQueryExport, bigQueryExportId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateBigQueryExportRequest actualRequest = (CreateBigQueryExportRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)bigQueryExport, (Object)actualRequest.getBigQueryExport());
        Assert.assertEquals((Object)bigQueryExportId, (Object)actualRequest.getBigQueryExportId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createBigQueryExportExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
            String bigQueryExportId = "bigQueryExportId1024198583";
            this.client.createBigQueryExport(parent, bigQueryExport, bigQueryExportId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBigQueryExportTest4() throws Exception {
        BigQueryExport expectedResponse = BigQueryExport.newBuilder().setName(BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]").toString()).setDescription("description-1724546052").setFilter("filter-1274492040").setDataset("dataset1443214456").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").setPrincipal("principal-1812041682").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
        String bigQueryExportId = "bigQueryExportId1024198583";
        BigQueryExport actualResponse = this.client.createBigQueryExport(parent, bigQueryExport, bigQueryExportId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateBigQueryExportRequest actualRequest = (CreateBigQueryExportRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)bigQueryExport, (Object)actualRequest.getBigQueryExport());
        Assert.assertEquals((Object)bigQueryExportId, (Object)actualRequest.getBigQueryExportId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createBigQueryExportExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
            String bigQueryExportId = "bigQueryExportId1024198583";
            this.client.createBigQueryExport(parent, bigQueryExport, bigQueryExportId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteBigQueryExportTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        BigQueryExportName name = BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]");
        this.client.deleteBigQueryExport(name);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteBigQueryExportRequest actualRequest = (DeleteBigQueryExportRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteBigQueryExportExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            BigQueryExportName name = BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]");
            this.client.deleteBigQueryExport(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteBigQueryExportTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteBigQueryExport(name);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteBigQueryExportRequest actualRequest = (DeleteBigQueryExportRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteBigQueryExportExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteBigQueryExport(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateBigQueryExportTest() throws Exception {
        BigQueryExport expectedResponse = BigQueryExport.newBuilder().setName(BigQueryExportName.ofOrganizationExportName((String)"[ORGANIZATION]", (String)"[EXPORT]").toString()).setDescription("description-1724546052").setFilter("filter-1274492040").setDataset("dataset1443214456").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setMostRecentEditor("mostRecentEditor-833861941").setPrincipal("principal-1812041682").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        BigQueryExport actualResponse = this.client.updateBigQueryExport(bigQueryExport, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateBigQueryExportRequest actualRequest = (UpdateBigQueryExportRequest)actualRequests.get(0);
        Assert.assertEquals((Object)bigQueryExport, (Object)actualRequest.getBigQueryExport());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateBigQueryExportExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            BigQueryExport bigQueryExport = BigQueryExport.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateBigQueryExport(bigQueryExport, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBigQueryExportsTest() throws Exception {
        BigQueryExport responsesElement = BigQueryExport.newBuilder().build();
        ListBigQueryExportsResponse expectedResponse = ListBigQueryExportsResponse.newBuilder().setNextPageToken("").addAllBigQueryExports(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        SecurityCenterClient.ListBigQueryExportsPagedResponse pagedListResponse = this.client.listBigQueryExports(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBigQueryExportsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListBigQueryExportsRequest actualRequest = (ListBigQueryExportsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listBigQueryExportsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            this.client.listBigQueryExports(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBigQueryExportsTest2() throws Exception {
        BigQueryExport responsesElement = BigQueryExport.newBuilder().build();
        ListBigQueryExportsResponse expectedResponse = ListBigQueryExportsResponse.newBuilder().setNextPageToken("").addAllBigQueryExports(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        SecurityCenterClient.ListBigQueryExportsPagedResponse pagedListResponse = this.client.listBigQueryExports(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBigQueryExportsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListBigQueryExportsRequest actualRequest = (ListBigQueryExportsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listBigQueryExportsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            this.client.listBigQueryExports(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBigQueryExportsTest3() throws Exception {
        BigQueryExport responsesElement = BigQueryExport.newBuilder().build();
        ListBigQueryExportsResponse expectedResponse = ListBigQueryExportsResponse.newBuilder().setNextPageToken("").addAllBigQueryExports(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        SecurityCenterClient.ListBigQueryExportsPagedResponse pagedListResponse = this.client.listBigQueryExports(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBigQueryExportsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListBigQueryExportsRequest actualRequest = (ListBigQueryExportsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listBigQueryExportsExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listBigQueryExports(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBigQueryExportsTest4() throws Exception {
        BigQueryExport responsesElement = BigQueryExport.newBuilder().build();
        ListBigQueryExportsResponse expectedResponse = ListBigQueryExportsResponse.newBuilder().setNextPageToken("").addAllBigQueryExports(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        SecurityCenterClient.ListBigQueryExportsPagedResponse pagedListResponse = this.client.listBigQueryExports(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBigQueryExportsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListBigQueryExportsRequest actualRequest = (ListBigQueryExportsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listBigQueryExportsExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listBigQueryExports(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

