/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.securitycenter.v1beta1.CreateFindingRequest;
import com.google.cloud.securitycenter.v1beta1.CreateSourceRequest;
import com.google.cloud.securitycenter.v1beta1.Finding;
import com.google.cloud.securitycenter.v1beta1.FindingName;
import com.google.cloud.securitycenter.v1beta1.GetOrganizationSettingsRequest;
import com.google.cloud.securitycenter.v1beta1.GetSourceRequest;
import com.google.cloud.securitycenter.v1beta1.GroupAssetsRequest;
import com.google.cloud.securitycenter.v1beta1.GroupAssetsResponse;
import com.google.cloud.securitycenter.v1beta1.GroupFindingsRequest;
import com.google.cloud.securitycenter.v1beta1.GroupFindingsResponse;
import com.google.cloud.securitycenter.v1beta1.GroupResult;
import com.google.cloud.securitycenter.v1beta1.ListAssetsRequest;
import com.google.cloud.securitycenter.v1beta1.ListAssetsResponse;
import com.google.cloud.securitycenter.v1beta1.ListFindingsRequest;
import com.google.cloud.securitycenter.v1beta1.ListFindingsResponse;
import com.google.cloud.securitycenter.v1beta1.ListSourcesRequest;
import com.google.cloud.securitycenter.v1beta1.ListSourcesResponse;
import com.google.cloud.securitycenter.v1beta1.MockSecurityCenter;
import com.google.cloud.securitycenter.v1beta1.OrganizationName;
import com.google.cloud.securitycenter.v1beta1.OrganizationSettings;
import com.google.cloud.securitycenter.v1beta1.OrganizationSettingsName;
import com.google.cloud.securitycenter.v1beta1.RunAssetDiscoveryRequest;
import com.google.cloud.securitycenter.v1beta1.SecurityCenterClient;
import com.google.cloud.securitycenter.v1beta1.SecurityCenterSettings;
import com.google.cloud.securitycenter.v1beta1.SecurityMarks;
import com.google.cloud.securitycenter.v1beta1.SetFindingStateRequest;
import com.google.cloud.securitycenter.v1beta1.Source;
import com.google.cloud.securitycenter.v1beta1.SourceName;
import com.google.cloud.securitycenter.v1beta1.UpdateFindingRequest;
import com.google.cloud.securitycenter.v1beta1.UpdateOrganizationSettingsRequest;
import com.google.cloud.securitycenter.v1beta1.UpdateSecurityMarksRequest;
import com.google.cloud.securitycenter.v1beta1.UpdateSourceRequest;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SecurityCenterClientTest {
    private static MockSecurityCenter mockSecurityCenter;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private SecurityCenterClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockSecurityCenter = new MockSecurityCenter();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockSecurityCenter));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        SecurityCenterSettings settings = ((SecurityCenterSettings.Builder)((SecurityCenterSettings.Builder)SecurityCenterSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = SecurityCenterClient.create((SecurityCenterSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createSourceTest() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        Source source = Source.newBuilder().build();
        Source actualResponse = this.client.createSource(parent, source);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSourceRequest actualRequest = (CreateSourceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)source, (Object)actualRequest.getSource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSourceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            Source source = Source.newBuilder().build();
            this.client.createSource(parent, source);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSourceTest2() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Source source = Source.newBuilder().build();
        Source actualResponse = this.client.createSource(parent, source);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSourceRequest actualRequest = (CreateSourceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)source, (Object)actualRequest.getSource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSourceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Source source = Source.newBuilder().build();
            this.client.createSource(parent, source);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createFindingTest() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.of((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SourceName parent = SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]");
        String findingId = "findingId439150212";
        Finding finding = Finding.newBuilder().build();
        Finding actualResponse = this.client.createFinding(parent, findingId, finding);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateFindingRequest actualRequest = (CreateFindingRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)findingId, (Object)actualRequest.getFindingId());
        Assert.assertEquals((Object)finding, (Object)actualRequest.getFinding());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createFindingExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SourceName parent = SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]");
            String findingId = "findingId439150212";
            Finding finding = Finding.newBuilder().build();
            this.client.createFinding(parent, findingId, finding);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createFindingTest2() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.of((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String findingId = "findingId439150212";
        Finding finding = Finding.newBuilder().build();
        Finding actualResponse = this.client.createFinding(parent, findingId, finding);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateFindingRequest actualRequest = (CreateFindingRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)findingId, (Object)actualRequest.getFindingId());
        Assert.assertEquals((Object)finding, (Object)actualRequest.getFinding());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createFindingExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String findingId = "findingId439150212";
            Finding finding = Finding.newBuilder().build();
            this.client.createFinding(parent, findingId, finding);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SourceName resource = SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]");
        Policy actualResponse = this.client.getIamPolicy((ResourceName)resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SourceName resource = SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]");
            this.client.getIamPolicy((ResourceName)resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        Policy actualResponse = this.client.getIamPolicy(resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            this.client.getIamPolicy(resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOrganizationSettingsTest() throws Exception {
        OrganizationSettings expectedResponse = OrganizationSettings.newBuilder().setName(OrganizationSettingsName.of((String)"[ORGANIZATION]").toString()).setEnableAssetDiscovery(true).setAssetDiscoveryConfig(OrganizationSettings.AssetDiscoveryConfig.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        OrganizationSettingsName name = OrganizationSettingsName.of((String)"[ORGANIZATION]");
        OrganizationSettings actualResponse = this.client.getOrganizationSettings(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetOrganizationSettingsRequest actualRequest = (GetOrganizationSettingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getOrganizationSettingsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationSettingsName name = OrganizationSettingsName.of((String)"[ORGANIZATION]");
            this.client.getOrganizationSettings(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOrganizationSettingsTest2() throws Exception {
        OrganizationSettings expectedResponse = OrganizationSettings.newBuilder().setName(OrganizationSettingsName.of((String)"[ORGANIZATION]").toString()).setEnableAssetDiscovery(true).setAssetDiscoveryConfig(OrganizationSettings.AssetDiscoveryConfig.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        OrganizationSettings actualResponse = this.client.getOrganizationSettings(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetOrganizationSettingsRequest actualRequest = (GetOrganizationSettingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getOrganizationSettingsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getOrganizationSettings(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSourceTest() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SourceName name = SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]");
        Source actualResponse = this.client.getSource(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSourceRequest actualRequest = (GetSourceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSourceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SourceName name = SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]");
            this.client.getSource(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSourceTest2() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Source actualResponse = this.client.getSource(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSourceRequest actualRequest = (GetSourceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSourceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getSource(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void groupAssetsTest() throws Exception {
        GroupResult responsesElement = GroupResult.newBuilder().build();
        GroupAssetsResponse expectedResponse = GroupAssetsResponse.newBuilder().setNextPageToken("").addAllGroupByResults(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        GroupAssetsRequest request = GroupAssetsRequest.newBuilder().setParent(OrganizationName.of((String)"[ORGANIZATION]").toString()).setFilter("filter-1274492040").setGroupBy("groupBy293428022").setCompareDuration(Duration.newBuilder().build()).setReadTime(Timestamp.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
        SecurityCenterClient.GroupAssetsPagedResponse pagedListResponse = this.client.groupAssets(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGroupByResultsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GroupAssetsRequest actualRequest = (GroupAssetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getFilter(), (Object)actualRequest.getFilter());
        Assert.assertEquals((Object)request.getGroupBy(), (Object)actualRequest.getGroupBy());
        Assert.assertEquals((Object)request.getCompareDuration(), (Object)actualRequest.getCompareDuration());
        Assert.assertEquals((Object)request.getReadTime(), (Object)actualRequest.getReadTime());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void groupAssetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            GroupAssetsRequest request = GroupAssetsRequest.newBuilder().setParent(OrganizationName.of((String)"[ORGANIZATION]").toString()).setFilter("filter-1274492040").setGroupBy("groupBy293428022").setCompareDuration(Duration.newBuilder().build()).setReadTime(Timestamp.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
            this.client.groupAssets(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void groupFindingsTest() throws Exception {
        GroupResult responsesElement = GroupResult.newBuilder().build();
        GroupFindingsResponse expectedResponse = GroupFindingsResponse.newBuilder().setNextPageToken("").addAllGroupByResults(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SourceName parent = SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]");
        String groupBy = "groupBy293428022";
        SecurityCenterClient.GroupFindingsPagedResponse pagedListResponse = this.client.groupFindings(parent, groupBy);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGroupByResultsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GroupFindingsRequest actualRequest = (GroupFindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)groupBy, (Object)actualRequest.getGroupBy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void groupFindingsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SourceName parent = SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]");
            String groupBy = "groupBy293428022";
            this.client.groupFindings(parent, groupBy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void groupFindingsTest2() throws Exception {
        GroupResult responsesElement = GroupResult.newBuilder().build();
        GroupFindingsResponse expectedResponse = GroupFindingsResponse.newBuilder().setNextPageToken("").addAllGroupByResults(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        String groupBy = "groupBy293428022";
        SecurityCenterClient.GroupFindingsPagedResponse pagedListResponse = this.client.groupFindings(parent, groupBy);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGroupByResultsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GroupFindingsRequest actualRequest = (GroupFindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)groupBy, (Object)actualRequest.getGroupBy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void groupFindingsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String groupBy = "groupBy293428022";
            this.client.groupFindings(parent, groupBy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAssetsTest() throws Exception {
        ListAssetsResponse.ListAssetsResult responsesElement = ListAssetsResponse.ListAssetsResult.newBuilder().build();
        ListAssetsResponse expectedResponse = ListAssetsResponse.newBuilder().setNextPageToken("").addAllListAssetsResults(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        ListAssetsRequest request = ListAssetsRequest.newBuilder().setParent(OrganizationName.of((String)"[ORGANIZATION]").toString()).setFilter("filter-1274492040").setOrderBy("orderBy-1207110587").setReadTime(Timestamp.newBuilder().build()).setCompareDuration(Duration.newBuilder().build()).setFieldMask(FieldMask.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
        SecurityCenterClient.ListAssetsPagedResponse pagedListResponse = this.client.listAssets(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getListAssetsResultsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAssetsRequest actualRequest = (ListAssetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getFilter(), (Object)actualRequest.getFilter());
        Assert.assertEquals((Object)request.getOrderBy(), (Object)actualRequest.getOrderBy());
        Assert.assertEquals((Object)request.getReadTime(), (Object)actualRequest.getReadTime());
        Assert.assertEquals((Object)request.getCompareDuration(), (Object)actualRequest.getCompareDuration());
        Assert.assertEquals((Object)request.getFieldMask(), (Object)actualRequest.getFieldMask());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAssetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            ListAssetsRequest request = ListAssetsRequest.newBuilder().setParent(OrganizationName.of((String)"[ORGANIZATION]").toString()).setFilter("filter-1274492040").setOrderBy("orderBy-1207110587").setReadTime(Timestamp.newBuilder().build()).setCompareDuration(Duration.newBuilder().build()).setFieldMask(FieldMask.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
            this.client.listAssets(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listFindingsTest() throws Exception {
        Finding responsesElement = Finding.newBuilder().build();
        ListFindingsResponse expectedResponse = ListFindingsResponse.newBuilder().setNextPageToken("").addAllFindings(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        ListFindingsRequest request = ListFindingsRequest.newBuilder().setParent(SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setFilter("filter-1274492040").setOrderBy("orderBy-1207110587").setReadTime(Timestamp.newBuilder().build()).setFieldMask(FieldMask.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
        SecurityCenterClient.ListFindingsPagedResponse pagedListResponse = this.client.listFindings(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getFindingsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListFindingsRequest actualRequest = (ListFindingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getFilter(), (Object)actualRequest.getFilter());
        Assert.assertEquals((Object)request.getOrderBy(), (Object)actualRequest.getOrderBy());
        Assert.assertEquals((Object)request.getReadTime(), (Object)actualRequest.getReadTime());
        Assert.assertEquals((Object)request.getFieldMask(), (Object)actualRequest.getFieldMask());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listFindingsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            ListFindingsRequest request = ListFindingsRequest.newBuilder().setParent(SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setFilter("filter-1274492040").setOrderBy("orderBy-1207110587").setReadTime(Timestamp.newBuilder().build()).setFieldMask(FieldMask.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
            this.client.listFindings(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSourcesTest() throws Exception {
        Source responsesElement = Source.newBuilder().build();
        ListSourcesResponse expectedResponse = ListSourcesResponse.newBuilder().setNextPageToken("").addAllSources(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        SecurityCenterClient.ListSourcesPagedResponse pagedListResponse = this.client.listSources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSourcesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSourcesRequest actualRequest = (ListSourcesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSourcesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            this.client.listSources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSourcesTest2() throws Exception {
        Source responsesElement = Source.newBuilder().build();
        ListSourcesResponse expectedResponse = ListSourcesResponse.newBuilder().setNextPageToken("").addAllSources(Arrays.asList(responsesElement)).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        SecurityCenterClient.ListSourcesPagedResponse pagedListResponse = this.client.listSources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSourcesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSourcesRequest actualRequest = (ListSourcesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSourcesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listSources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void runAssetDiscoveryTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("runAssetDiscoveryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockSecurityCenter.addResponse((AbstractMessage)resultOperation);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        this.client.runAssetDiscoveryAsync(parent).get();
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RunAssetDiscoveryRequest actualRequest = (RunAssetDiscoveryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void runAssetDiscoveryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            this.client.runAssetDiscoveryAsync(parent).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void runAssetDiscoveryTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("runAssetDiscoveryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockSecurityCenter.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        this.client.runAssetDiscoveryAsync(parent).get();
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RunAssetDiscoveryRequest actualRequest = (RunAssetDiscoveryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void runAssetDiscoveryExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.runAssetDiscoveryAsync(parent).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void setFindingStateTest() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.of((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        FindingName name = FindingName.of((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]");
        Finding.State state = Finding.State.forNumber((int)0);
        Timestamp startTime = Timestamp.newBuilder().build();
        Finding actualResponse = this.client.setFindingState(name, state, startTime);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetFindingStateRequest actualRequest = (SetFindingStateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)state, (Object)actualRequest.getState());
        Assert.assertEquals((Object)startTime, (Object)actualRequest.getStartTime());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setFindingStateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            FindingName name = FindingName.of((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]");
            Finding.State state = Finding.State.forNumber((int)0);
            Timestamp startTime = Timestamp.newBuilder().build();
            this.client.setFindingState(name, state, startTime);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setFindingStateTest2() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.of((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Finding.State state = Finding.State.forNumber((int)0);
        Timestamp startTime = Timestamp.newBuilder().build();
        Finding actualResponse = this.client.setFindingState(name, state, startTime);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetFindingStateRequest actualRequest = (SetFindingStateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)state, (Object)actualRequest.getState());
        Assert.assertEquals((Object)startTime, (Object)actualRequest.getStartTime());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setFindingStateExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String name = "name3373707";
            Finding.State state = Finding.State.forNumber((int)0);
            Timestamp startTime = Timestamp.newBuilder().build();
            this.client.setFindingState(name, state, startTime);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SourceName resource = SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy((ResourceName)resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SourceName resource = SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]");
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy((ResourceName)resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy(resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy(resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SourceName resource = SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions((ResourceName)resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SourceName resource = SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]");
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions((ResourceName)resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest2() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions(resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateFindingTest() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.of((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        Finding finding = Finding.newBuilder().build();
        Finding actualResponse = this.client.updateFinding(finding);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateFindingRequest actualRequest = (UpdateFindingRequest)actualRequests.get(0);
        Assert.assertEquals((Object)finding, (Object)actualRequest.getFinding());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateFindingExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            Finding finding = Finding.newBuilder().build();
            this.client.updateFinding(finding);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateOrganizationSettingsTest() throws Exception {
        OrganizationSettings expectedResponse = OrganizationSettings.newBuilder().setName(OrganizationSettingsName.of((String)"[ORGANIZATION]").toString()).setEnableAssetDiscovery(true).setAssetDiscoveryConfig(OrganizationSettings.AssetDiscoveryConfig.newBuilder().build()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        OrganizationSettings organizationSettings = OrganizationSettings.newBuilder().build();
        OrganizationSettings actualResponse = this.client.updateOrganizationSettings(organizationSettings);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateOrganizationSettingsRequest actualRequest = (UpdateOrganizationSettingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)organizationSettings, (Object)actualRequest.getOrganizationSettings());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateOrganizationSettingsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            OrganizationSettings organizationSettings = OrganizationSettings.newBuilder().build();
            this.client.updateOrganizationSettings(organizationSettings);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSourceTest() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.of((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        Source source = Source.newBuilder().build();
        Source actualResponse = this.client.updateSource(source);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateSourceRequest actualRequest = (UpdateSourceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)source, (Object)actualRequest.getSource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateSourceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            Source source = Source.newBuilder().build();
            this.client.updateSource(source);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSecurityMarksTest() throws Exception {
        SecurityMarks expectedResponse = SecurityMarks.newBuilder().setName("name3373707").putAllMarks(new HashMap()).build();
        mockSecurityCenter.addResponse((AbstractMessage)expectedResponse);
        SecurityMarks securityMarks = SecurityMarks.newBuilder().build();
        SecurityMarks actualResponse = this.client.updateSecurityMarks(securityMarks);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSecurityCenter.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateSecurityMarksRequest actualRequest = (UpdateSecurityMarksRequest)actualRequests.get(0);
        Assert.assertEquals((Object)securityMarks, (Object)actualRequest.getSecurityMarks());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateSecurityMarksExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSecurityCenter.addException((Exception)exception);
        try {
            SecurityMarks securityMarks = SecurityMarks.newBuilder().build();
            this.client.updateSecurityMarks(securityMarks);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

