/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1p1beta1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.securitycenter.v1p1beta1.Finding;
import com.google.cloud.securitycenter.v1p1beta1.FindingName;
import com.google.cloud.securitycenter.v1p1beta1.FolderName;
import com.google.cloud.securitycenter.v1p1beta1.GroupAssetsRequest;
import com.google.cloud.securitycenter.v1p1beta1.GroupAssetsResponse;
import com.google.cloud.securitycenter.v1p1beta1.GroupFindingsResponse;
import com.google.cloud.securitycenter.v1p1beta1.GroupResult;
import com.google.cloud.securitycenter.v1p1beta1.ListAssetsResponse;
import com.google.cloud.securitycenter.v1p1beta1.ListFindingsResponse;
import com.google.cloud.securitycenter.v1p1beta1.ListNotificationConfigsResponse;
import com.google.cloud.securitycenter.v1p1beta1.ListSourcesResponse;
import com.google.cloud.securitycenter.v1p1beta1.NotificationConfig;
import com.google.cloud.securitycenter.v1p1beta1.NotificationConfigName;
import com.google.cloud.securitycenter.v1p1beta1.OrganizationName;
import com.google.cloud.securitycenter.v1p1beta1.OrganizationSettings;
import com.google.cloud.securitycenter.v1p1beta1.OrganizationSettingsName;
import com.google.cloud.securitycenter.v1p1beta1.ProjectName;
import com.google.cloud.securitycenter.v1p1beta1.RunAssetDiscoveryResponse;
import com.google.cloud.securitycenter.v1p1beta1.SecurityCenterClient;
import com.google.cloud.securitycenter.v1p1beta1.SecurityCenterSettings;
import com.google.cloud.securitycenter.v1p1beta1.SecurityMarks;
import com.google.cloud.securitycenter.v1p1beta1.Source;
import com.google.cloud.securitycenter.v1p1beta1.SourceName;
import com.google.cloud.securitycenter.v1p1beta1.stub.HttpJsonSecurityCenterStub;
import com.google.common.collect.Lists;
import com.google.iam.v1.Policy;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SecurityCenterClientHttpJsonTest {
    private static MockHttpService mockService;
    private static SecurityCenterClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonSecurityCenterStub.getMethodDescriptors(), SecurityCenterSettings.getDefaultEndpoint());
        SecurityCenterSettings settings = ((SecurityCenterSettings.Builder)((SecurityCenterSettings.Builder)SecurityCenterSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)SecurityCenterSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = SecurityCenterClient.create((SecurityCenterSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void createSourceTest() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        Source source = Source.newBuilder().build();
        Source actualResponse = client.createSource(parent, source);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSourceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            Source source = Source.newBuilder().build();
            client.createSource(parent, source);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSourceTest2() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8287";
        Source source = Source.newBuilder().build();
        Source actualResponse = client.createSource(parent, source);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSourceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            Source source = Source.newBuilder().build();
            client.createSource(parent, source);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createFindingTest() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        SourceName parent = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        Finding finding = Finding.newBuilder().build();
        String findingId = "findingId439150212";
        Finding actualResponse = client.createFinding(parent, finding, findingId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createFindingExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SourceName parent = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            Finding finding = Finding.newBuilder().build();
            String findingId = "findingId439150212";
            client.createFinding(parent, finding, findingId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createFindingTest2() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        SourceName parent = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        String findingId = "findingId439150212";
        Finding finding = Finding.newBuilder().build();
        Finding actualResponse = client.createFinding(parent, findingId, finding);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createFindingExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SourceName parent = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            String findingId = "findingId439150212";
            Finding finding = Finding.newBuilder().build();
            client.createFinding(parent, findingId, finding);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createFindingTest3() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8741/sources/source-8741";
        Finding finding = Finding.newBuilder().build();
        String findingId = "findingId439150212";
        Finding actualResponse = client.createFinding(parent, finding, findingId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createFindingExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8741/sources/source-8741";
            Finding finding = Finding.newBuilder().build();
            String findingId = "findingId439150212";
            client.createFinding(parent, finding, findingId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createFindingTest4() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8741/sources/source-8741";
        String findingId = "findingId439150212";
        Finding finding = Finding.newBuilder().build();
        Finding actualResponse = client.createFinding(parent, findingId, finding);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createFindingExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8741/sources/source-8741";
            String findingId = "findingId439150212";
            Finding finding = Finding.newBuilder().build();
            client.createFinding(parent, findingId, finding);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.of((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = client.createNotificationConfig(parent, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createNotificationConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            client.createNotificationConfig(parent, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest2() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.of((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8287";
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = client.createNotificationConfig(parent, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createNotificationConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            client.createNotificationConfig(parent, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest3() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.of((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        String configId = "configId-580140035";
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = client.createNotificationConfig(parent, configId, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createNotificationConfigExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            String configId = "configId-580140035";
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            client.createNotificationConfig(parent, configId, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationConfigTest4() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.of((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8287";
        String configId = "configId-580140035";
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
        NotificationConfig actualResponse = client.createNotificationConfig(parent, configId, notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createNotificationConfigExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            String configId = "configId-580140035";
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().build();
            client.createNotificationConfig(parent, configId, notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteNotificationConfigTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        NotificationConfigName name = NotificationConfigName.of((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]");
        client.deleteNotificationConfig(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteNotificationConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            NotificationConfigName name = NotificationConfigName.of((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]");
            client.deleteNotificationConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteNotificationConfigTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-7374/notificationConfigs/notificationConfig-7374";
        client.deleteNotificationConfig(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteNotificationConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-7374/notificationConfigs/notificationConfig-7374";
            client.deleteNotificationConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        Policy actualResponse = client.getIamPolicy((ResourceName)resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            client.getIamPolicy((ResourceName)resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        String resource = "organizations/organization-3393/sources/source-3393";
        Policy actualResponse = client.getIamPolicy(resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIamPolicyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String resource = "organizations/organization-3393/sources/source-3393";
            client.getIamPolicy(resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNotificationConfigTest() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.of((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        NotificationConfigName name = NotificationConfigName.of((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]");
        NotificationConfig actualResponse = client.getNotificationConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getNotificationConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            NotificationConfigName name = NotificationConfigName.of((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]");
            client.getNotificationConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNotificationConfigTest2() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.of((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-7374/notificationConfigs/notificationConfig-7374";
        NotificationConfig actualResponse = client.getNotificationConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getNotificationConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-7374/notificationConfigs/notificationConfig-7374";
            client.getNotificationConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOrganizationSettingsTest() throws Exception {
        OrganizationSettings expectedResponse = OrganizationSettings.newBuilder().setName(OrganizationSettingsName.of((String)"[ORGANIZATION]").toString()).setEnableAssetDiscovery(true).setAssetDiscoveryConfig(OrganizationSettings.AssetDiscoveryConfig.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationSettingsName name = OrganizationSettingsName.of((String)"[ORGANIZATION]");
        OrganizationSettings actualResponse = client.getOrganizationSettings(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getOrganizationSettingsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationSettingsName name = OrganizationSettingsName.of((String)"[ORGANIZATION]");
            client.getOrganizationSettings(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOrganizationSettingsTest2() throws Exception {
        OrganizationSettings expectedResponse = OrganizationSettings.newBuilder().setName(OrganizationSettingsName.of((String)"[ORGANIZATION]").toString()).setEnableAssetDiscovery(true).setAssetDiscoveryConfig(OrganizationSettings.AssetDiscoveryConfig.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-9995/organizationSettings";
        OrganizationSettings actualResponse = client.getOrganizationSettings(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getOrganizationSettingsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-9995/organizationSettings";
            client.getOrganizationSettings(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSourceTest() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        SourceName name = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        Source actualResponse = client.getSource(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSourceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SourceName name = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            client.getSource(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSourceTest2() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-7292/sources/source-7292";
        Source actualResponse = client.getSource(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSourceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-7292/sources/source-7292";
            client.getSource(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void groupAssetsTest() throws Exception {
        GroupResult responsesElement = GroupResult.newBuilder().build();
        GroupAssetsResponse expectedResponse = GroupAssetsResponse.newBuilder().setNextPageToken("").addAllGroupByResults(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        GroupAssetsRequest request = GroupAssetsRequest.newBuilder().setParent(OrganizationName.of((String)"[ORGANIZATION]").toString()).setFilter("filter-1274492040").setGroupBy("groupBy293428022").setCompareDuration(Duration.newBuilder().build()).setReadTime(Timestamp.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
        SecurityCenterClient.GroupAssetsPagedResponse pagedListResponse = client.groupAssets(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGroupByResultsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void groupAssetsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GroupAssetsRequest request = GroupAssetsRequest.newBuilder().setParent(OrganizationName.of((String)"[ORGANIZATION]").toString()).setFilter("filter-1274492040").setGroupBy("groupBy293428022").setCompareDuration(Duration.newBuilder().build()).setReadTime(Timestamp.newBuilder().build()).setPageToken("pageToken873572522").setPageSize(883849137).build();
            client.groupAssets(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void groupFindingsTest() throws Exception {
        GroupResult responsesElement = GroupResult.newBuilder().build();
        GroupFindingsResponse expectedResponse = GroupFindingsResponse.newBuilder().setNextPageToken("").addAllGroupByResults(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        SourceName parent = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        String groupBy = "groupBy293428022";
        SecurityCenterClient.GroupFindingsPagedResponse pagedListResponse = client.groupFindings(parent, groupBy);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGroupByResultsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void groupFindingsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SourceName parent = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            String groupBy = "groupBy293428022";
            client.groupFindings(parent, groupBy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void groupFindingsTest2() throws Exception {
        GroupResult responsesElement = GroupResult.newBuilder().build();
        GroupFindingsResponse expectedResponse = GroupFindingsResponse.newBuilder().setNextPageToken("").addAllGroupByResults(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8741/sources/source-8741";
        String groupBy = "groupBy293428022";
        SecurityCenterClient.GroupFindingsPagedResponse pagedListResponse = client.groupFindings(parent, groupBy);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGroupByResultsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void groupFindingsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8741/sources/source-8741";
            String groupBy = "groupBy293428022";
            client.groupFindings(parent, groupBy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAssetsTest() throws Exception {
        ListAssetsResponse.ListAssetsResult responsesElement = ListAssetsResponse.ListAssetsResult.newBuilder().build();
        ListAssetsResponse expectedResponse = ListAssetsResponse.newBuilder().setNextPageToken("").addAllListAssetsResults(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        SecurityCenterClient.ListAssetsPagedResponse pagedListResponse = client.listAssets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getListAssetsResultsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listAssetsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            client.listAssets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAssetsTest2() throws Exception {
        ListAssetsResponse.ListAssetsResult responsesElement = ListAssetsResponse.ListAssetsResult.newBuilder().build();
        ListAssetsResponse expectedResponse = ListAssetsResponse.newBuilder().setNextPageToken("").addAllListAssetsResults(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        SecurityCenterClient.ListAssetsPagedResponse pagedListResponse = client.listAssets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getListAssetsResultsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listAssetsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            client.listAssets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAssetsTest3() throws Exception {
        ListAssetsResponse.ListAssetsResult responsesElement = ListAssetsResponse.ListAssetsResult.newBuilder().build();
        ListAssetsResponse expectedResponse = ListAssetsResponse.newBuilder().setNextPageToken("").addAllListAssetsResults(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        SecurityCenterClient.ListAssetsPagedResponse pagedListResponse = client.listAssets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getListAssetsResultsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listAssetsExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            client.listAssets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAssetsTest4() throws Exception {
        ListAssetsResponse.ListAssetsResult responsesElement = ListAssetsResponse.ListAssetsResult.newBuilder().build();
        ListAssetsResponse expectedResponse = ListAssetsResponse.newBuilder().setNextPageToken("").addAllListAssetsResults(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8287";
        SecurityCenterClient.ListAssetsPagedResponse pagedListResponse = client.listAssets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getListAssetsResultsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listAssetsExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            client.listAssets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listFindingsTest() throws Exception {
        ListFindingsResponse.ListFindingsResult responsesElement = ListFindingsResponse.ListFindingsResult.newBuilder().build();
        ListFindingsResponse expectedResponse = ListFindingsResponse.newBuilder().setNextPageToken("").addAllListFindingsResults(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        SourceName parent = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        SecurityCenterClient.ListFindingsPagedResponse pagedListResponse = client.listFindings(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getListFindingsResultsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listFindingsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SourceName parent = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            client.listFindings(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listFindingsTest2() throws Exception {
        ListFindingsResponse.ListFindingsResult responsesElement = ListFindingsResponse.ListFindingsResult.newBuilder().build();
        ListFindingsResponse expectedResponse = ListFindingsResponse.newBuilder().setNextPageToken("").addAllListFindingsResults(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8741/sources/source-8741";
        SecurityCenterClient.ListFindingsPagedResponse pagedListResponse = client.listFindings(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getListFindingsResultsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listFindingsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8741/sources/source-8741";
            client.listFindings(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationConfigsTest() throws Exception {
        NotificationConfig responsesElement = NotificationConfig.newBuilder().build();
        ListNotificationConfigsResponse expectedResponse = ListNotificationConfigsResponse.newBuilder().setNextPageToken("").addAllNotificationConfigs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        SecurityCenterClient.ListNotificationConfigsPagedResponse pagedListResponse = client.listNotificationConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNotificationConfigsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listNotificationConfigsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            client.listNotificationConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationConfigsTest2() throws Exception {
        NotificationConfig responsesElement = NotificationConfig.newBuilder().build();
        ListNotificationConfigsResponse expectedResponse = ListNotificationConfigsResponse.newBuilder().setNextPageToken("").addAllNotificationConfigs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8287";
        SecurityCenterClient.ListNotificationConfigsPagedResponse pagedListResponse = client.listNotificationConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNotificationConfigsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listNotificationConfigsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            client.listNotificationConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSourcesTest() throws Exception {
        Source responsesElement = Source.newBuilder().build();
        ListSourcesResponse expectedResponse = ListSourcesResponse.newBuilder().setNextPageToken("").addAllSources(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        SecurityCenterClient.ListSourcesPagedResponse pagedListResponse = client.listSources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSourcesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSourcesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            client.listSources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSourcesTest2() throws Exception {
        Source responsesElement = Source.newBuilder().build();
        ListSourcesResponse expectedResponse = ListSourcesResponse.newBuilder().setNextPageToken("").addAllSources(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        SecurityCenterClient.ListSourcesPagedResponse pagedListResponse = client.listSources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSourcesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSourcesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            client.listSources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSourcesTest3() throws Exception {
        Source responsesElement = Source.newBuilder().build();
        ListSourcesResponse expectedResponse = ListSourcesResponse.newBuilder().setNextPageToken("").addAllSources(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        SecurityCenterClient.ListSourcesPagedResponse pagedListResponse = client.listSources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSourcesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSourcesExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            client.listSources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSourcesTest4() throws Exception {
        Source responsesElement = Source.newBuilder().build();
        ListSourcesResponse expectedResponse = ListSourcesResponse.newBuilder().setNextPageToken("").addAllSources(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-8287";
        SecurityCenterClient.ListSourcesPagedResponse pagedListResponse = client.listSources(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSourcesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSourcesExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            client.listSources(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void runAssetDiscoveryTest() throws Exception {
        RunAssetDiscoveryResponse expectedResponse = RunAssetDiscoveryResponse.newBuilder().setDuration(Duration.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("runAssetDiscoveryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        RunAssetDiscoveryResponse actualResponse = (RunAssetDiscoveryResponse)client.runAssetDiscoveryAsync(parent).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void runAssetDiscoveryExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            client.runAssetDiscoveryAsync(parent).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void runAssetDiscoveryTest2() throws Exception {
        RunAssetDiscoveryResponse expectedResponse = RunAssetDiscoveryResponse.newBuilder().setDuration(Duration.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("runAssetDiscoveryTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "organizations/organization-8287";
        RunAssetDiscoveryResponse actualResponse = (RunAssetDiscoveryResponse)client.runAssetDiscoveryAsync(parent).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void runAssetDiscoveryExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-8287";
            client.runAssetDiscoveryAsync(parent).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void setFindingStateTest() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        FindingName name = FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]");
        Finding.State state = Finding.State.forNumber((int)0);
        Timestamp startTime = Timestamp.newBuilder().build();
        Finding actualResponse = client.setFindingState(name, state, startTime);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setFindingStateExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            FindingName name = FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]");
            Finding.State state = Finding.State.forNumber((int)0);
            Timestamp startTime = Timestamp.newBuilder().build();
            client.setFindingState(name, state, startTime);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setFindingStateTest2() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-9392/sources/source-9392/findings/finding-9392";
        Finding.State state = Finding.State.forNumber((int)0);
        Timestamp startTime = Timestamp.newBuilder().build();
        Finding actualResponse = client.setFindingState(name, state, startTime);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setFindingStateExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-9392/sources/source-9392/findings/finding-9392";
            Finding.State state = Finding.State.forNumber((int)0);
            Timestamp startTime = Timestamp.newBuilder().build();
            client.setFindingState(name, state, startTime);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = client.setIamPolicy((ResourceName)resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            Policy policy = Policy.newBuilder().build();
            client.setIamPolicy((ResourceName)resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        String resource = "organizations/organization-3393/sources/source-3393";
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = client.setIamPolicy(resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setIamPolicyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String resource = "organizations/organization-3393/sources/source-3393";
            Policy policy = Policy.newBuilder().build();
            client.setIamPolicy(resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = client.testIamPermissions((ResourceName)resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SourceName resource = SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]");
            ArrayList permissions = new ArrayList();
            client.testIamPermissions((ResourceName)resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest2() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String resource = "organizations/organization-3393/sources/source-3393";
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = client.testIamPermissions(resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void testIamPermissionsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String resource = "organizations/organization-3393/sources/source-3393";
            ArrayList permissions = new ArrayList();
            client.testIamPermissions(resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateFindingTest() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        Finding finding = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").build();
        Finding actualResponse = client.updateFinding(finding);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateFindingExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Finding finding = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").build();
            client.updateFinding(finding);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateFindingTest2() throws Exception {
        Finding expectedResponse = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        Finding finding = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Finding actualResponse = client.updateFinding(finding, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateFindingExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Finding finding = Finding.newBuilder().setName(FindingName.ofOrganizationSourceFindingName((String)"[ORGANIZATION]", (String)"[SOURCE]", (String)"[FINDING]").toString()).setParent("parent-995424086").setResourceName("resourceName-384566343").setCategory("category50511102").setExternalUri("externalUri-1153085023").putAllSourceProperties(new HashMap()).setSecurityMarks(SecurityMarks.newBuilder().build()).setEventTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setCanonicalName("canonicalName2122381727").build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateFinding(finding, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateNotificationConfigTest() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.of((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().setName(NotificationConfigName.of((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        NotificationConfig actualResponse = client.updateNotificationConfig(notificationConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateNotificationConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().setName(NotificationConfigName.of((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
            client.updateNotificationConfig(notificationConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateNotificationConfigTest2() throws Exception {
        NotificationConfig expectedResponse = NotificationConfig.newBuilder().setName(NotificationConfigName.of((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        mockService.addResponse((Object)expectedResponse);
        NotificationConfig notificationConfig = NotificationConfig.newBuilder().setName(NotificationConfigName.of((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        NotificationConfig actualResponse = client.updateNotificationConfig(notificationConfig, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateNotificationConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            NotificationConfig notificationConfig = NotificationConfig.newBuilder().setName(NotificationConfigName.of((String)"[ORGANIZATION]", (String)"[NOTIFICATION_CONFIG]").toString()).setDescription("description-1724546052").setPubsubTopic("pubsubTopic255880396").setServiceAccount("serviceAccount1079137720").build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateNotificationConfig(notificationConfig, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateOrganizationSettingsTest() throws Exception {
        OrganizationSettings expectedResponse = OrganizationSettings.newBuilder().setName(OrganizationSettingsName.of((String)"[ORGANIZATION]").toString()).setEnableAssetDiscovery(true).setAssetDiscoveryConfig(OrganizationSettings.AssetDiscoveryConfig.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationSettings organizationSettings = OrganizationSettings.newBuilder().setName(OrganizationSettingsName.of((String)"[ORGANIZATION]").toString()).setEnableAssetDiscovery(true).setAssetDiscoveryConfig(OrganizationSettings.AssetDiscoveryConfig.newBuilder().build()).build();
        OrganizationSettings actualResponse = client.updateOrganizationSettings(organizationSettings);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateOrganizationSettingsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationSettings organizationSettings = OrganizationSettings.newBuilder().setName(OrganizationSettingsName.of((String)"[ORGANIZATION]").toString()).setEnableAssetDiscovery(true).setAssetDiscoveryConfig(OrganizationSettings.AssetDiscoveryConfig.newBuilder().build()).build();
            client.updateOrganizationSettings(organizationSettings);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSourceTest() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        Source source = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        Source actualResponse = client.updateSource(source);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateSourceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Source source = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
            client.updateSource(source);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSourceTest2() throws Exception {
        Source expectedResponse = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        Source source = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Source actualResponse = client.updateSource(source, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateSourceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Source source = Source.newBuilder().setName(SourceName.ofOrganizationSourceName((String)"[ORGANIZATION]", (String)"[SOURCE]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setCanonicalName("canonicalName2122381727").build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateSource(source, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSecurityMarksTest() throws Exception {
        SecurityMarks expectedResponse = SecurityMarks.newBuilder().setName("name3373707").putAllMarks(new HashMap()).setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        SecurityMarks securityMarks = SecurityMarks.newBuilder().setName("organizations/organization-5924/assets/asset-5924/securityMarks").putAllMarks(new HashMap()).setCanonicalName("canonicalName2122381727").build();
        SecurityMarks actualResponse = client.updateSecurityMarks(securityMarks);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateSecurityMarksExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SecurityMarks securityMarks = SecurityMarks.newBuilder().setName("organizations/organization-5924/assets/asset-5924/securityMarks").putAllMarks(new HashMap()).setCanonicalName("canonicalName2122381727").build();
            client.updateSecurityMarks(securityMarks);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSecurityMarksTest2() throws Exception {
        SecurityMarks expectedResponse = SecurityMarks.newBuilder().setName("name3373707").putAllMarks(new HashMap()).setCanonicalName("canonicalName2122381727").build();
        mockService.addResponse((Object)expectedResponse);
        SecurityMarks securityMarks = SecurityMarks.newBuilder().setName("organizations/organization-5924/assets/asset-5924/securityMarks").putAllMarks(new HashMap()).setCanonicalName("canonicalName2122381727").build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        SecurityMarks actualResponse = client.updateSecurityMarks(securityMarks, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateSecurityMarksExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SecurityMarks securityMarks = SecurityMarks.newBuilder().setName("organizations/organization-5924/assets/asset-5924/securityMarks").putAllMarks(new HashMap()).setCanonicalName("canonicalName2122381727").build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateSecurityMarks(securityMarks, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

