/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicedirectory.v1beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.servicedirectory.v1beta1.LookupServiceClient;
import com.google.cloud.servicedirectory.v1beta1.LookupServiceSettings;
import com.google.cloud.servicedirectory.v1beta1.MockLookupService;
import com.google.cloud.servicedirectory.v1beta1.ResolveServiceRequest;
import com.google.cloud.servicedirectory.v1beta1.ResolveServiceResponse;
import com.google.cloud.servicedirectory.v1beta1.Service;
import com.google.cloud.servicedirectory.v1beta1.ServiceName;
import com.google.protobuf.AbstractMessage;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class LookupServiceClientTest {
    private static MockServiceHelper mockServiceHelper;
    private LookupServiceClient client;
    private static MockLookupService mockLookupService;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockLookupService = new MockLookupService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockLookupService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        LookupServiceSettings settings = ((LookupServiceSettings.Builder)((LookupServiceSettings.Builder)LookupServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = LookupServiceClient.create((LookupServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void resolveServiceTest() throws Exception {
        ResolveServiceResponse expectedResponse = ResolveServiceResponse.newBuilder().setService(Service.newBuilder().build()).build();
        mockLookupService.addResponse((AbstractMessage)expectedResponse);
        ResolveServiceRequest request = ResolveServiceRequest.newBuilder().setName(ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]").toString()).setMaxEndpoints(2074789987).setEndpointFilter("endpointFilter-1834249875").build();
        ResolveServiceResponse actualResponse = this.client.resolveService(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLookupService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ResolveServiceRequest actualRequest = (ResolveServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((long)request.getMaxEndpoints(), (long)actualRequest.getMaxEndpoints());
        Assert.assertEquals((Object)request.getEndpointFilter(), (Object)actualRequest.getEndpointFilter());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void resolveServiceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLookupService.addException((Exception)exception);
        try {
            ResolveServiceRequest request = ResolveServiceRequest.newBuilder().setName(ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]").toString()).setMaxEndpoints(2074789987).setEndpointFilter("endpointFilter-1834249875").build();
            this.client.resolveService(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

