/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicedirectory.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.servicedirectory.v1.LookupServiceClient;
import com.google.cloud.servicedirectory.v1.LookupServiceSettings;
import com.google.cloud.servicedirectory.v1.ResolveServiceRequest;
import com.google.cloud.servicedirectory.v1.ResolveServiceResponse;
import com.google.cloud.servicedirectory.v1.Service;
import com.google.cloud.servicedirectory.v1.ServiceName;
import com.google.cloud.servicedirectory.v1.stub.HttpJsonLookupServiceStub;
import java.io.IOException;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class LookupServiceClientHttpJsonTest {
    private static MockHttpService mockService;
    private static LookupServiceClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonLookupServiceStub.getMethodDescriptors(), LookupServiceSettings.getDefaultEndpoint());
        LookupServiceSettings settings = ((LookupServiceSettings.Builder)((LookupServiceSettings.Builder)LookupServiceSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)LookupServiceSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = LookupServiceClient.create((LookupServiceSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void resolveServiceTest() throws Exception {
        ResolveServiceResponse expectedResponse = ResolveServiceResponse.newBuilder().setService(Service.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        ResolveServiceRequest request = ResolveServiceRequest.newBuilder().setName(ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]").toString()).setMaxEndpoints(2074789987).setEndpointFilter("endpointFilter-1834249875").build();
        ResolveServiceResponse actualResponse = client.resolveService(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void resolveServiceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ResolveServiceRequest request = ResolveServiceRequest.newBuilder().setName(ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]").toString()).setMaxEndpoints(2074789987).setEndpointFilter("endpointFilter-1834249875").build();
            client.resolveService(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

