/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicedirectory.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.servicedirectory.v1.CreateEndpointRequest;
import com.google.cloud.servicedirectory.v1.CreateNamespaceRequest;
import com.google.cloud.servicedirectory.v1.CreateServiceRequest;
import com.google.cloud.servicedirectory.v1.DeleteEndpointRequest;
import com.google.cloud.servicedirectory.v1.DeleteNamespaceRequest;
import com.google.cloud.servicedirectory.v1.DeleteServiceRequest;
import com.google.cloud.servicedirectory.v1.Endpoint;
import com.google.cloud.servicedirectory.v1.EndpointName;
import com.google.cloud.servicedirectory.v1.GetEndpointRequest;
import com.google.cloud.servicedirectory.v1.GetNamespaceRequest;
import com.google.cloud.servicedirectory.v1.GetServiceRequest;
import com.google.cloud.servicedirectory.v1.ListEndpointsRequest;
import com.google.cloud.servicedirectory.v1.ListEndpointsResponse;
import com.google.cloud.servicedirectory.v1.ListNamespacesRequest;
import com.google.cloud.servicedirectory.v1.ListNamespacesResponse;
import com.google.cloud.servicedirectory.v1.ListServicesRequest;
import com.google.cloud.servicedirectory.v1.ListServicesResponse;
import com.google.cloud.servicedirectory.v1.LocationName;
import com.google.cloud.servicedirectory.v1.MockRegistrationService;
import com.google.cloud.servicedirectory.v1.Namespace;
import com.google.cloud.servicedirectory.v1.NamespaceName;
import com.google.cloud.servicedirectory.v1.RegistrationServiceClient;
import com.google.cloud.servicedirectory.v1.RegistrationServiceSettings;
import com.google.cloud.servicedirectory.v1.Service;
import com.google.cloud.servicedirectory.v1.ServiceName;
import com.google.cloud.servicedirectory.v1.UpdateEndpointRequest;
import com.google.cloud.servicedirectory.v1.UpdateNamespaceRequest;
import com.google.cloud.servicedirectory.v1.UpdateServiceRequest;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.GetPolicyOptions;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RegistrationServiceClientTest {
    private static MockRegistrationService mockRegistrationService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private RegistrationServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockRegistrationService = new MockRegistrationService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockRegistrationService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        RegistrationServiceSettings settings = ((RegistrationServiceSettings.Builder)((RegistrationServiceSettings.Builder)RegistrationServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = RegistrationServiceClient.create((RegistrationServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createNamespaceTest() throws Exception {
        Namespace expectedResponse = Namespace.newBuilder().setName(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).putAllLabels(new HashMap()).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Namespace namespace = Namespace.newBuilder().build();
        String namespaceId = "namespaceId790852566";
        Namespace actualResponse = this.client.createNamespace(parent, namespace, namespaceId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNamespaceRequest actualRequest = (CreateNamespaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)namespace, (Object)actualRequest.getNamespace());
        Assert.assertEquals((Object)namespaceId, (Object)actualRequest.getNamespaceId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNamespaceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Namespace namespace = Namespace.newBuilder().build();
            String namespaceId = "namespaceId790852566";
            this.client.createNamespace(parent, namespace, namespaceId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNamespaceTest2() throws Exception {
        Namespace expectedResponse = Namespace.newBuilder().setName(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).putAllLabels(new HashMap()).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Namespace namespace = Namespace.newBuilder().build();
        String namespaceId = "namespaceId790852566";
        Namespace actualResponse = this.client.createNamespace(parent, namespace, namespaceId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNamespaceRequest actualRequest = (CreateNamespaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)namespace, (Object)actualRequest.getNamespace());
        Assert.assertEquals((Object)namespaceId, (Object)actualRequest.getNamespaceId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNamespaceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Namespace namespace = Namespace.newBuilder().build();
            String namespaceId = "namespaceId790852566";
            this.client.createNamespace(parent, namespace, namespaceId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNamespacesTest() throws Exception {
        Namespace responsesElement = Namespace.newBuilder().build();
        ListNamespacesResponse expectedResponse = ListNamespacesResponse.newBuilder().setNextPageToken("").addAllNamespaces(Arrays.asList(responsesElement)).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        RegistrationServiceClient.ListNamespacesPagedResponse pagedListResponse = this.client.listNamespaces(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNamespacesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNamespacesRequest actualRequest = (ListNamespacesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNamespacesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listNamespaces(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNamespacesTest2() throws Exception {
        Namespace responsesElement = Namespace.newBuilder().build();
        ListNamespacesResponse expectedResponse = ListNamespacesResponse.newBuilder().setNextPageToken("").addAllNamespaces(Arrays.asList(responsesElement)).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        RegistrationServiceClient.ListNamespacesPagedResponse pagedListResponse = this.client.listNamespaces(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNamespacesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNamespacesRequest actualRequest = (ListNamespacesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNamespacesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listNamespaces(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNamespaceTest() throws Exception {
        Namespace expectedResponse = Namespace.newBuilder().setName(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).putAllLabels(new HashMap()).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        NamespaceName name = NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]");
        Namespace actualResponse = this.client.getNamespace(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetNamespaceRequest actualRequest = (GetNamespaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getNamespaceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            NamespaceName name = NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]");
            this.client.getNamespace(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNamespaceTest2() throws Exception {
        Namespace expectedResponse = Namespace.newBuilder().setName(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).putAllLabels(new HashMap()).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Namespace actualResponse = this.client.getNamespace(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetNamespaceRequest actualRequest = (GetNamespaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getNamespaceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getNamespace(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateNamespaceTest() throws Exception {
        Namespace expectedResponse = Namespace.newBuilder().setName(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).putAllLabels(new HashMap()).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        Namespace namespace = Namespace.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Namespace actualResponse = this.client.updateNamespace(namespace, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateNamespaceRequest actualRequest = (UpdateNamespaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)namespace, (Object)actualRequest.getNamespace());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateNamespaceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            Namespace namespace = Namespace.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateNamespace(namespace, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteNamespaceTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        NamespaceName name = NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]");
        this.client.deleteNamespace(name);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteNamespaceRequest actualRequest = (DeleteNamespaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteNamespaceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            NamespaceName name = NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]");
            this.client.deleteNamespace(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteNamespaceTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteNamespace(name);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteNamespaceRequest actualRequest = (DeleteNamespaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteNamespaceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteNamespace(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createServiceTest() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]").toString()).putAllAnnotations(new HashMap()).addAllEndpoints(new ArrayList()).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        NamespaceName parent = NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]");
        Service service = Service.newBuilder().build();
        String serviceId = "serviceId-194185552";
        Service actualResponse = this.client.createService(parent, service, serviceId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateServiceRequest actualRequest = (CreateServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)service, (Object)actualRequest.getService());
        Assert.assertEquals((Object)serviceId, (Object)actualRequest.getServiceId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createServiceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            NamespaceName parent = NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]");
            Service service = Service.newBuilder().build();
            String serviceId = "serviceId-194185552";
            this.client.createService(parent, service, serviceId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createServiceTest2() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]").toString()).putAllAnnotations(new HashMap()).addAllEndpoints(new ArrayList()).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Service service = Service.newBuilder().build();
        String serviceId = "serviceId-194185552";
        Service actualResponse = this.client.createService(parent, service, serviceId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateServiceRequest actualRequest = (CreateServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)service, (Object)actualRequest.getService());
        Assert.assertEquals((Object)serviceId, (Object)actualRequest.getServiceId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createServiceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Service service = Service.newBuilder().build();
            String serviceId = "serviceId-194185552";
            this.client.createService(parent, service, serviceId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listServicesTest() throws Exception {
        Service responsesElement = Service.newBuilder().build();
        ListServicesResponse expectedResponse = ListServicesResponse.newBuilder().setNextPageToken("").addAllServices(Arrays.asList(responsesElement)).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        NamespaceName parent = NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]");
        RegistrationServiceClient.ListServicesPagedResponse pagedListResponse = this.client.listServices(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getServicesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListServicesRequest actualRequest = (ListServicesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listServicesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            NamespaceName parent = NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]");
            this.client.listServices(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listServicesTest2() throws Exception {
        Service responsesElement = Service.newBuilder().build();
        ListServicesResponse expectedResponse = ListServicesResponse.newBuilder().setNextPageToken("").addAllServices(Arrays.asList(responsesElement)).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        RegistrationServiceClient.ListServicesPagedResponse pagedListResponse = this.client.listServices(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getServicesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListServicesRequest actualRequest = (ListServicesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listServicesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listServices(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getServiceTest() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]").toString()).putAllAnnotations(new HashMap()).addAllEndpoints(new ArrayList()).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        ServiceName name = ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]");
        Service actualResponse = this.client.getService(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetServiceRequest actualRequest = (GetServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getServiceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            ServiceName name = ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]");
            this.client.getService(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getServiceTest2() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]").toString()).putAllAnnotations(new HashMap()).addAllEndpoints(new ArrayList()).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Service actualResponse = this.client.getService(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetServiceRequest actualRequest = (GetServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getServiceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getService(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateServiceTest() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]").toString()).putAllAnnotations(new HashMap()).addAllEndpoints(new ArrayList()).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        Service service = Service.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Service actualResponse = this.client.updateService(service, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateServiceRequest actualRequest = (UpdateServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)service, (Object)actualRequest.getService());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateServiceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            Service service = Service.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateService(service, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteServiceTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        ServiceName name = ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]");
        this.client.deleteService(name);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteServiceRequest actualRequest = (DeleteServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteServiceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            ServiceName name = ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]");
            this.client.deleteService(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteServiceTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteService(name);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteServiceRequest actualRequest = (DeleteServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteServiceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteService(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createEndpointTest() throws Exception {
        Endpoint expectedResponse = Endpoint.newBuilder().setName(EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]").toString()).setAddress("address-1147692044").setPort(3446913).putAllAnnotations(new HashMap()).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        ServiceName parent = ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]");
        Endpoint endpoint = Endpoint.newBuilder().build();
        String endpointId = "endpointId-1837754992";
        Endpoint actualResponse = this.client.createEndpoint(parent, endpoint, endpointId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateEndpointRequest actualRequest = (CreateEndpointRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)endpoint, (Object)actualRequest.getEndpoint());
        Assert.assertEquals((Object)endpointId, (Object)actualRequest.getEndpointId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createEndpointExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            ServiceName parent = ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]");
            Endpoint endpoint = Endpoint.newBuilder().build();
            String endpointId = "endpointId-1837754992";
            this.client.createEndpoint(parent, endpoint, endpointId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createEndpointTest2() throws Exception {
        Endpoint expectedResponse = Endpoint.newBuilder().setName(EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]").toString()).setAddress("address-1147692044").setPort(3446913).putAllAnnotations(new HashMap()).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Endpoint endpoint = Endpoint.newBuilder().build();
        String endpointId = "endpointId-1837754992";
        Endpoint actualResponse = this.client.createEndpoint(parent, endpoint, endpointId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateEndpointRequest actualRequest = (CreateEndpointRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)endpoint, (Object)actualRequest.getEndpoint());
        Assert.assertEquals((Object)endpointId, (Object)actualRequest.getEndpointId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createEndpointExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Endpoint endpoint = Endpoint.newBuilder().build();
            String endpointId = "endpointId-1837754992";
            this.client.createEndpoint(parent, endpoint, endpointId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listEndpointsTest() throws Exception {
        Endpoint responsesElement = Endpoint.newBuilder().build();
        ListEndpointsResponse expectedResponse = ListEndpointsResponse.newBuilder().setNextPageToken("").addAllEndpoints(Arrays.asList(responsesElement)).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        ServiceName parent = ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]");
        RegistrationServiceClient.ListEndpointsPagedResponse pagedListResponse = this.client.listEndpoints(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getEndpointsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListEndpointsRequest actualRequest = (ListEndpointsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listEndpointsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            ServiceName parent = ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]");
            this.client.listEndpoints(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listEndpointsTest2() throws Exception {
        Endpoint responsesElement = Endpoint.newBuilder().build();
        ListEndpointsResponse expectedResponse = ListEndpointsResponse.newBuilder().setNextPageToken("").addAllEndpoints(Arrays.asList(responsesElement)).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        RegistrationServiceClient.ListEndpointsPagedResponse pagedListResponse = this.client.listEndpoints(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getEndpointsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListEndpointsRequest actualRequest = (ListEndpointsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listEndpointsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listEndpoints(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getEndpointTest() throws Exception {
        Endpoint expectedResponse = Endpoint.newBuilder().setName(EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]").toString()).setAddress("address-1147692044").setPort(3446913).putAllAnnotations(new HashMap()).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        EndpointName name = EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]");
        Endpoint actualResponse = this.client.getEndpoint(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetEndpointRequest actualRequest = (GetEndpointRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getEndpointExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            EndpointName name = EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]");
            this.client.getEndpoint(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getEndpointTest2() throws Exception {
        Endpoint expectedResponse = Endpoint.newBuilder().setName(EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]").toString()).setAddress("address-1147692044").setPort(3446913).putAllAnnotations(new HashMap()).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Endpoint actualResponse = this.client.getEndpoint(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetEndpointRequest actualRequest = (GetEndpointRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getEndpointExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getEndpoint(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateEndpointTest() throws Exception {
        Endpoint expectedResponse = Endpoint.newBuilder().setName(EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]").toString()).setAddress("address-1147692044").setPort(3446913).putAllAnnotations(new HashMap()).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        Endpoint endpoint = Endpoint.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Endpoint actualResponse = this.client.updateEndpoint(endpoint, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateEndpointRequest actualRequest = (UpdateEndpointRequest)actualRequests.get(0);
        Assert.assertEquals((Object)endpoint, (Object)actualRequest.getEndpoint());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateEndpointExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            Endpoint endpoint = Endpoint.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateEndpoint(endpoint, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteEndpointTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        EndpointName name = EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]");
        this.client.deleteEndpoint(name);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteEndpointRequest actualRequest = (DeleteEndpointRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteEndpointExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            EndpointName name = EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]");
            this.client.deleteEndpoint(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteEndpointTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteEndpoint(name);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteEndpointRequest actualRequest = (DeleteEndpointRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteEndpointExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteEndpoint(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
        Policy actualResponse = this.client.getIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getOptions(), (Object)actualRequest.getOptions());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
            this.client.getIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
        Policy actualResponse = this.client.setIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getPolicy(), (Object)actualRequest.getPolicy());
        Assert.assertEquals((Object)request.getUpdateMask(), (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
            this.client.setIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockRegistrationService.addResponse((AbstractMessage)expectedResponse);
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).addAllPermissions(new ArrayList()).build();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRegistrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getPermissionsList(), (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRegistrationService.addException((Exception)exception);
        try {
            TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).addAllPermissions(new ArrayList()).build();
            this.client.testIamPermissions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

