/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicedirectory.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.servicedirectory.v1.Endpoint;
import com.google.cloud.servicedirectory.v1.EndpointName;
import com.google.cloud.servicedirectory.v1.ListEndpointsResponse;
import com.google.cloud.servicedirectory.v1.ListNamespacesResponse;
import com.google.cloud.servicedirectory.v1.ListServicesResponse;
import com.google.cloud.servicedirectory.v1.LocationName;
import com.google.cloud.servicedirectory.v1.Namespace;
import com.google.cloud.servicedirectory.v1.NamespaceName;
import com.google.cloud.servicedirectory.v1.RegistrationServiceClient;
import com.google.cloud.servicedirectory.v1.RegistrationServiceSettings;
import com.google.cloud.servicedirectory.v1.Service;
import com.google.cloud.servicedirectory.v1.ServiceName;
import com.google.cloud.servicedirectory.v1.stub.HttpJsonRegistrationServiceStub;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.GetPolicyOptions;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RegistrationServiceClientHttpJsonTest {
    private static MockHttpService mockService;
    private static RegistrationServiceClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonRegistrationServiceStub.getMethodDescriptors(), RegistrationServiceSettings.getDefaultEndpoint());
        RegistrationServiceSettings settings = ((RegistrationServiceSettings.Builder)((RegistrationServiceSettings.Builder)RegistrationServiceSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)RegistrationServiceSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = RegistrationServiceClient.create((RegistrationServiceSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void createNamespaceTest() throws Exception {
        Namespace expectedResponse = Namespace.newBuilder().setName(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).putAllLabels(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Namespace namespace = Namespace.newBuilder().build();
        String namespaceId = "namespaceId790852566";
        Namespace actualResponse = client.createNamespace(parent, namespace, namespaceId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createNamespaceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Namespace namespace = Namespace.newBuilder().build();
            String namespaceId = "namespaceId790852566";
            client.createNamespace(parent, namespace, namespaceId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNamespaceTest2() throws Exception {
        Namespace expectedResponse = Namespace.newBuilder().setName(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).putAllLabels(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        Namespace namespace = Namespace.newBuilder().build();
        String namespaceId = "namespaceId790852566";
        Namespace actualResponse = client.createNamespace(parent, namespace, namespaceId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createNamespaceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Namespace namespace = Namespace.newBuilder().build();
            String namespaceId = "namespaceId790852566";
            client.createNamespace(parent, namespace, namespaceId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNamespacesTest() throws Exception {
        Namespace responsesElement = Namespace.newBuilder().build();
        ListNamespacesResponse expectedResponse = ListNamespacesResponse.newBuilder().setNextPageToken("").addAllNamespaces(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        RegistrationServiceClient.ListNamespacesPagedResponse pagedListResponse = client.listNamespaces(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNamespacesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listNamespacesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listNamespaces(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNamespacesTest2() throws Exception {
        Namespace responsesElement = Namespace.newBuilder().build();
        ListNamespacesResponse expectedResponse = ListNamespacesResponse.newBuilder().setNextPageToken("").addAllNamespaces(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        RegistrationServiceClient.ListNamespacesPagedResponse pagedListResponse = client.listNamespaces(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNamespacesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listNamespacesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listNamespaces(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNamespaceTest() throws Exception {
        Namespace expectedResponse = Namespace.newBuilder().setName(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).putAllLabels(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        NamespaceName name = NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]");
        Namespace actualResponse = client.getNamespace(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getNamespaceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            NamespaceName name = NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]");
            client.getNamespace(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNamespaceTest2() throws Exception {
        Namespace expectedResponse = Namespace.newBuilder().setName(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).putAllLabels(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-9720/locations/location-9720/namespaces/namespace-9720";
        Namespace actualResponse = client.getNamespace(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getNamespaceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-9720/locations/location-9720/namespaces/namespace-9720";
            client.getNamespace(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateNamespaceTest() throws Exception {
        Namespace expectedResponse = Namespace.newBuilder().setName(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).putAllLabels(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        Namespace namespace = Namespace.newBuilder().setName(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).putAllLabels(new HashMap()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Namespace actualResponse = client.updateNamespace(namespace, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateNamespaceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Namespace namespace = Namespace.newBuilder().setName(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).putAllLabels(new HashMap()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateNamespace(namespace, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteNamespaceTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        NamespaceName name = NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]");
        client.deleteNamespace(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteNamespaceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            NamespaceName name = NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]");
            client.deleteNamespace(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteNamespaceTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-9720/locations/location-9720/namespaces/namespace-9720";
        client.deleteNamespace(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteNamespaceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-9720/locations/location-9720/namespaces/namespace-9720";
            client.deleteNamespace(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createServiceTest() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]").toString()).putAllAnnotations(new HashMap()).addAllEndpoints(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        NamespaceName parent = NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]");
        Service service = Service.newBuilder().build();
        String serviceId = "serviceId-194185552";
        Service actualResponse = client.createService(parent, service, serviceId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createServiceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            NamespaceName parent = NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]");
            Service service = Service.newBuilder().build();
            String serviceId = "serviceId-194185552";
            client.createService(parent, service, serviceId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createServiceTest2() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]").toString()).putAllAnnotations(new HashMap()).addAllEndpoints(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-1689/locations/location-1689/namespaces/namespace-1689";
        Service service = Service.newBuilder().build();
        String serviceId = "serviceId-194185552";
        Service actualResponse = client.createService(parent, service, serviceId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createServiceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-1689/locations/location-1689/namespaces/namespace-1689";
            Service service = Service.newBuilder().build();
            String serviceId = "serviceId-194185552";
            client.createService(parent, service, serviceId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listServicesTest() throws Exception {
        Service responsesElement = Service.newBuilder().build();
        ListServicesResponse expectedResponse = ListServicesResponse.newBuilder().setNextPageToken("").addAllServices(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        NamespaceName parent = NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]");
        RegistrationServiceClient.ListServicesPagedResponse pagedListResponse = client.listServices(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getServicesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listServicesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            NamespaceName parent = NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]");
            client.listServices(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listServicesTest2() throws Exception {
        Service responsesElement = Service.newBuilder().build();
        ListServicesResponse expectedResponse = ListServicesResponse.newBuilder().setNextPageToken("").addAllServices(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-1689/locations/location-1689/namespaces/namespace-1689";
        RegistrationServiceClient.ListServicesPagedResponse pagedListResponse = client.listServices(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getServicesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listServicesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-1689/locations/location-1689/namespaces/namespace-1689";
            client.listServices(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getServiceTest() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]").toString()).putAllAnnotations(new HashMap()).addAllEndpoints(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        ServiceName name = ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]");
        Service actualResponse = client.getService(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getServiceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ServiceName name = ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]");
            client.getService(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getServiceTest2() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]").toString()).putAllAnnotations(new HashMap()).addAllEndpoints(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-160/locations/location-160/namespaces/namespace-160/services/service-160";
        Service actualResponse = client.getService(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getServiceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-160/locations/location-160/namespaces/namespace-160/services/service-160";
            client.getService(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateServiceTest() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]").toString()).putAllAnnotations(new HashMap()).addAllEndpoints(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        Service service = Service.newBuilder().setName(ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]").toString()).putAllAnnotations(new HashMap()).addAllEndpoints(new ArrayList()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Service actualResponse = client.updateService(service, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateServiceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Service service = Service.newBuilder().setName(ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]").toString()).putAllAnnotations(new HashMap()).addAllEndpoints(new ArrayList()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateService(service, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteServiceTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        ServiceName name = ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]");
        client.deleteService(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteServiceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ServiceName name = ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]");
            client.deleteService(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteServiceTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-160/locations/location-160/namespaces/namespace-160/services/service-160";
        client.deleteService(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteServiceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-160/locations/location-160/namespaces/namespace-160/services/service-160";
            client.deleteService(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createEndpointTest() throws Exception {
        Endpoint expectedResponse = Endpoint.newBuilder().setName(EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]").toString()).setAddress("address-1147692044").setPort(3446913).putAllAnnotations(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        ServiceName parent = ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]");
        Endpoint endpoint = Endpoint.newBuilder().build();
        String endpointId = "endpointId-1837754992";
        Endpoint actualResponse = client.createEndpoint(parent, endpoint, endpointId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createEndpointExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ServiceName parent = ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]");
            Endpoint endpoint = Endpoint.newBuilder().build();
            String endpointId = "endpointId-1837754992";
            client.createEndpoint(parent, endpoint, endpointId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createEndpointTest2() throws Exception {
        Endpoint expectedResponse = Endpoint.newBuilder().setName(EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]").toString()).setAddress("address-1147692044").setPort(3446913).putAllAnnotations(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-4575/locations/location-4575/namespaces/namespace-4575/services/service-4575";
        Endpoint endpoint = Endpoint.newBuilder().build();
        String endpointId = "endpointId-1837754992";
        Endpoint actualResponse = client.createEndpoint(parent, endpoint, endpointId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createEndpointExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-4575/locations/location-4575/namespaces/namespace-4575/services/service-4575";
            Endpoint endpoint = Endpoint.newBuilder().build();
            String endpointId = "endpointId-1837754992";
            client.createEndpoint(parent, endpoint, endpointId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listEndpointsTest() throws Exception {
        Endpoint responsesElement = Endpoint.newBuilder().build();
        ListEndpointsResponse expectedResponse = ListEndpointsResponse.newBuilder().setNextPageToken("").addAllEndpoints(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ServiceName parent = ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]");
        RegistrationServiceClient.ListEndpointsPagedResponse pagedListResponse = client.listEndpoints(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getEndpointsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listEndpointsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ServiceName parent = ServiceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]");
            client.listEndpoints(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listEndpointsTest2() throws Exception {
        Endpoint responsesElement = Endpoint.newBuilder().build();
        ListEndpointsResponse expectedResponse = ListEndpointsResponse.newBuilder().setNextPageToken("").addAllEndpoints(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-4575/locations/location-4575/namespaces/namespace-4575/services/service-4575";
        RegistrationServiceClient.ListEndpointsPagedResponse pagedListResponse = client.listEndpoints(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getEndpointsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listEndpointsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-4575/locations/location-4575/namespaces/namespace-4575/services/service-4575";
            client.listEndpoints(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getEndpointTest() throws Exception {
        Endpoint expectedResponse = Endpoint.newBuilder().setName(EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]").toString()).setAddress("address-1147692044").setPort(3446913).putAllAnnotations(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        EndpointName name = EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]");
        Endpoint actualResponse = client.getEndpoint(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getEndpointExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            EndpointName name = EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]");
            client.getEndpoint(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getEndpointTest2() throws Exception {
        Endpoint expectedResponse = Endpoint.newBuilder().setName(EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]").toString()).setAddress("address-1147692044").setPort(3446913).putAllAnnotations(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-9594/locations/location-9594/namespaces/namespace-9594/services/service-9594/endpoints/endpoint-9594";
        Endpoint actualResponse = client.getEndpoint(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getEndpointExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-9594/locations/location-9594/namespaces/namespace-9594/services/service-9594/endpoints/endpoint-9594";
            client.getEndpoint(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateEndpointTest() throws Exception {
        Endpoint expectedResponse = Endpoint.newBuilder().setName(EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]").toString()).setAddress("address-1147692044").setPort(3446913).putAllAnnotations(new HashMap()).build();
        mockService.addResponse((Object)expectedResponse);
        Endpoint endpoint = Endpoint.newBuilder().setName(EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]").toString()).setAddress("address-1147692044").setPort(3446913).putAllAnnotations(new HashMap()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Endpoint actualResponse = client.updateEndpoint(endpoint, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateEndpointExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Endpoint endpoint = Endpoint.newBuilder().setName(EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]").toString()).setAddress("address-1147692044").setPort(3446913).putAllAnnotations(new HashMap()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateEndpoint(endpoint, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteEndpointTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        EndpointName name = EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]");
        client.deleteEndpoint(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteEndpointExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            EndpointName name = EndpointName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]", (String)"[SERVICE]", (String)"[ENDPOINT]");
            client.deleteEndpoint(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteEndpointTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-9594/locations/location-9594/namespaces/namespace-9594/services/service-9594/endpoints/endpoint-9594";
        client.deleteEndpoint(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteEndpointExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-9594/locations/location-9594/namespaces/namespace-9594/services/service-9594/endpoints/endpoint-9594";
            client.deleteEndpoint(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
        Policy actualResponse = client.getIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
            client.getIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
        Policy actualResponse = client.setIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
            client.setIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).addAllPermissions(new ArrayList()).build();
        TestIamPermissionsResponse actualResponse = client.testIamPermissions(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(NamespaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NAMESPACE]").toString()).addAllPermissions(new ArrayList()).build();
            client.testIamPermissions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

