/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicehealth.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.servicehealth.v1.Event;
import com.google.cloud.servicehealth.v1.GetEventRequest;
import com.google.cloud.servicehealth.v1.GetOrganizationEventRequest;
import com.google.cloud.servicehealth.v1.GetOrganizationImpactRequest;
import com.google.cloud.servicehealth.v1.ListEventsRequest;
import com.google.cloud.servicehealth.v1.ListEventsResponse;
import com.google.cloud.servicehealth.v1.ListOrganizationEventsRequest;
import com.google.cloud.servicehealth.v1.ListOrganizationEventsResponse;
import com.google.cloud.servicehealth.v1.ListOrganizationImpactsRequest;
import com.google.cloud.servicehealth.v1.ListOrganizationImpactsResponse;
import com.google.cloud.servicehealth.v1.OrganizationEvent;
import com.google.cloud.servicehealth.v1.OrganizationImpact;
import com.google.cloud.servicehealth.v1.ServiceHealthClient;
import com.google.cloud.servicehealth.v1.stub.GrpcServiceHealthStub;
import com.google.cloud.servicehealth.v1.stub.HttpJsonServiceHealthStub;
import com.google.cloud.servicehealth.v1.stub.ServiceHealthStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ServiceHealthStubSettings
extends StubSettings<ServiceHealthStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListEventsRequest, ListEventsResponse, ServiceHealthClient.ListEventsPagedResponse> listEventsSettings;
    private final UnaryCallSettings<GetEventRequest, Event> getEventSettings;
    private final PagedCallSettings<ListOrganizationEventsRequest, ListOrganizationEventsResponse, ServiceHealthClient.ListOrganizationEventsPagedResponse> listOrganizationEventsSettings;
    private final UnaryCallSettings<GetOrganizationEventRequest, OrganizationEvent> getOrganizationEventSettings;
    private final PagedCallSettings<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse, ServiceHealthClient.ListOrganizationImpactsPagedResponse> listOrganizationImpactsSettings;
    private final UnaryCallSettings<GetOrganizationImpactRequest, OrganizationImpact> getOrganizationImpactSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ServiceHealthClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListEventsRequest, ListEventsResponse, Event> LIST_EVENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEventsRequest, ListEventsResponse, Event>(){

        public String emptyToken() {
            return "";
        }

        public ListEventsRequest injectToken(ListEventsRequest payload, String token) {
            return ListEventsRequest.newBuilder((ListEventsRequest)payload).setPageToken(token).build();
        }

        public ListEventsRequest injectPageSize(ListEventsRequest payload, int pageSize) {
            return ListEventsRequest.newBuilder((ListEventsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEventsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEventsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Event> extractResources(ListEventsResponse payload) {
            return payload.getEventsList();
        }
    };
    private static final PagedListDescriptor<ListOrganizationEventsRequest, ListOrganizationEventsResponse, OrganizationEvent> LIST_ORGANIZATION_EVENTS_PAGE_STR_DESC = new PagedListDescriptor<ListOrganizationEventsRequest, ListOrganizationEventsResponse, OrganizationEvent>(){

        public String emptyToken() {
            return "";
        }

        public ListOrganizationEventsRequest injectToken(ListOrganizationEventsRequest payload, String token) {
            return ListOrganizationEventsRequest.newBuilder((ListOrganizationEventsRequest)payload).setPageToken(token).build();
        }

        public ListOrganizationEventsRequest injectPageSize(ListOrganizationEventsRequest payload, int pageSize) {
            return ListOrganizationEventsRequest.newBuilder((ListOrganizationEventsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListOrganizationEventsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListOrganizationEventsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<OrganizationEvent> extractResources(ListOrganizationEventsResponse payload) {
            return payload.getOrganizationEventsList();
        }
    };
    private static final PagedListDescriptor<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse, OrganizationImpact> LIST_ORGANIZATION_IMPACTS_PAGE_STR_DESC = new PagedListDescriptor<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse, OrganizationImpact>(){

        public String emptyToken() {
            return "";
        }

        public ListOrganizationImpactsRequest injectToken(ListOrganizationImpactsRequest payload, String token) {
            return ListOrganizationImpactsRequest.newBuilder((ListOrganizationImpactsRequest)payload).setPageToken(token).build();
        }

        public ListOrganizationImpactsRequest injectPageSize(ListOrganizationImpactsRequest payload, int pageSize) {
            return ListOrganizationImpactsRequest.newBuilder((ListOrganizationImpactsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListOrganizationImpactsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListOrganizationImpactsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<OrganizationImpact> extractResources(ListOrganizationImpactsResponse payload) {
            return payload.getOrganizationImpactsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListEventsRequest, ListEventsResponse, ServiceHealthClient.ListEventsPagedResponse> LIST_EVENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEventsRequest, ListEventsResponse, ServiceHealthClient.ListEventsPagedResponse>(){

        public ApiFuture<ServiceHealthClient.ListEventsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEventsRequest, ListEventsResponse> callable, ListEventsRequest request, ApiCallContext context, ApiFuture<ListEventsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EVENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ServiceHealthClient.ListEventsPagedResponse.createAsync((PageContext<ListEventsRequest, ListEventsResponse, Event>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListOrganizationEventsRequest, ListOrganizationEventsResponse, ServiceHealthClient.ListOrganizationEventsPagedResponse> LIST_ORGANIZATION_EVENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListOrganizationEventsRequest, ListOrganizationEventsResponse, ServiceHealthClient.ListOrganizationEventsPagedResponse>(){

        public ApiFuture<ServiceHealthClient.ListOrganizationEventsPagedResponse> getFuturePagedResponse(UnaryCallable<ListOrganizationEventsRequest, ListOrganizationEventsResponse> callable, ListOrganizationEventsRequest request, ApiCallContext context, ApiFuture<ListOrganizationEventsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ORGANIZATION_EVENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ServiceHealthClient.ListOrganizationEventsPagedResponse.createAsync((PageContext<ListOrganizationEventsRequest, ListOrganizationEventsResponse, OrganizationEvent>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse, ServiceHealthClient.ListOrganizationImpactsPagedResponse> LIST_ORGANIZATION_IMPACTS_PAGE_STR_FACT = new PagedListResponseFactory<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse, ServiceHealthClient.ListOrganizationImpactsPagedResponse>(){

        public ApiFuture<ServiceHealthClient.ListOrganizationImpactsPagedResponse> getFuturePagedResponse(UnaryCallable<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse> callable, ListOrganizationImpactsRequest request, ApiCallContext context, ApiFuture<ListOrganizationImpactsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ORGANIZATION_IMPACTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ServiceHealthClient.ListOrganizationImpactsPagedResponse.createAsync((PageContext<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse, OrganizationImpact>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ServiceHealthClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ServiceHealthClient.ListLocationsPagedResponse>(){

        public ApiFuture<ServiceHealthClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ServiceHealthClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListEventsRequest, ListEventsResponse, ServiceHealthClient.ListEventsPagedResponse> listEventsSettings() {
        return this.listEventsSettings;
    }

    public UnaryCallSettings<GetEventRequest, Event> getEventSettings() {
        return this.getEventSettings;
    }

    public PagedCallSettings<ListOrganizationEventsRequest, ListOrganizationEventsResponse, ServiceHealthClient.ListOrganizationEventsPagedResponse> listOrganizationEventsSettings() {
        return this.listOrganizationEventsSettings;
    }

    public UnaryCallSettings<GetOrganizationEventRequest, OrganizationEvent> getOrganizationEventSettings() {
        return this.getOrganizationEventSettings;
    }

    public PagedCallSettings<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse, ServiceHealthClient.ListOrganizationImpactsPagedResponse> listOrganizationImpactsSettings() {
        return this.listOrganizationImpactsSettings;
    }

    public UnaryCallSettings<GetOrganizationImpactRequest, OrganizationImpact> getOrganizationImpactSettings() {
        return this.getOrganizationImpactSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ServiceHealthClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public ServiceHealthStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcServiceHealthStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonServiceHealthStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "servicehealth";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "servicehealth.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "servicehealth.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ServiceHealthStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ServiceHealthStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ServiceHealthStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ServiceHealthStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ServiceHealthStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listEventsSettings = settingsBuilder.listEventsSettings().build();
        this.getEventSettings = settingsBuilder.getEventSettings().build();
        this.listOrganizationEventsSettings = settingsBuilder.listOrganizationEventsSettings().build();
        this.getOrganizationEventSettings = settingsBuilder.getOrganizationEventSettings().build();
        this.listOrganizationImpactsSettings = settingsBuilder.listOrganizationImpactsSettings().build();
        this.getOrganizationImpactSettings = settingsBuilder.getOrganizationImpactSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ServiceHealthStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListEventsRequest, ListEventsResponse, ServiceHealthClient.ListEventsPagedResponse> listEventsSettings;
        private final UnaryCallSettings.Builder<GetEventRequest, Event> getEventSettings;
        private final PagedCallSettings.Builder<ListOrganizationEventsRequest, ListOrganizationEventsResponse, ServiceHealthClient.ListOrganizationEventsPagedResponse> listOrganizationEventsSettings;
        private final UnaryCallSettings.Builder<GetOrganizationEventRequest, OrganizationEvent> getOrganizationEventSettings;
        private final PagedCallSettings.Builder<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse, ServiceHealthClient.ListOrganizationImpactsPagedResponse> listOrganizationImpactsSettings;
        private final UnaryCallSettings.Builder<GetOrganizationImpactRequest, OrganizationImpact> getOrganizationImpactSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ServiceHealthClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listEventsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EVENTS_PAGE_STR_FACT);
            this.getEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listOrganizationEventsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ORGANIZATION_EVENTS_PAGE_STR_FACT);
            this.getOrganizationEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listOrganizationImpactsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ORGANIZATION_IMPACTS_PAGE_STR_FACT);
            this.getOrganizationImpactSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listEventsSettings, this.getEventSettings, this.listOrganizationEventsSettings, this.getOrganizationEventSettings, this.listOrganizationImpactsSettings, this.getOrganizationImpactSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ServiceHealthStubSettings settings) {
            super((StubSettings)settings);
            this.listEventsSettings = settings.listEventsSettings.toBuilder();
            this.getEventSettings = settings.getEventSettings.toBuilder();
            this.listOrganizationEventsSettings = settings.listOrganizationEventsSettings.toBuilder();
            this.getOrganizationEventSettings = settings.getOrganizationEventSettings.toBuilder();
            this.listOrganizationImpactsSettings = settings.listOrganizationImpactsSettings.toBuilder();
            this.getOrganizationImpactSettings = settings.getOrganizationImpactSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listEventsSettings, this.getEventSettings, this.listOrganizationEventsSettings, this.getOrganizationEventSettings, this.listOrganizationImpactsSettings, this.getOrganizationImpactSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ServiceHealthStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ServiceHealthStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ServiceHealthStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ServiceHealthStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ServiceHealthStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ServiceHealthStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ServiceHealthStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ServiceHealthStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listOrganizationEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getOrganizationEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listOrganizationImpactsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getOrganizationImpactSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListEventsRequest, ListEventsResponse, ServiceHealthClient.ListEventsPagedResponse> listEventsSettings() {
            return this.listEventsSettings;
        }

        public UnaryCallSettings.Builder<GetEventRequest, Event> getEventSettings() {
            return this.getEventSettings;
        }

        public PagedCallSettings.Builder<ListOrganizationEventsRequest, ListOrganizationEventsResponse, ServiceHealthClient.ListOrganizationEventsPagedResponse> listOrganizationEventsSettings() {
            return this.listOrganizationEventsSettings;
        }

        public UnaryCallSettings.Builder<GetOrganizationEventRequest, OrganizationEvent> getOrganizationEventSettings() {
            return this.getOrganizationEventSettings;
        }

        public PagedCallSettings.Builder<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse, ServiceHealthClient.ListOrganizationImpactsPagedResponse> listOrganizationImpactsSettings() {
            return this.listOrganizationImpactsSettings;
        }

        public UnaryCallSettings.Builder<GetOrganizationImpactRequest, OrganizationImpact> getOrganizationImpactSettings() {
            return this.getOrganizationImpactSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ServiceHealthClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public ServiceHealthStubSettings build() throws IOException {
            return new ServiceHealthStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

