/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicehealth.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.servicehealth.v1.Asset;
import com.google.cloud.servicehealth.v1.Event;
import com.google.cloud.servicehealth.v1.EventName;
import com.google.cloud.servicehealth.v1.ListEventsResponse;
import com.google.cloud.servicehealth.v1.ListOrganizationEventsResponse;
import com.google.cloud.servicehealth.v1.ListOrganizationImpactsResponse;
import com.google.cloud.servicehealth.v1.LocationName;
import com.google.cloud.servicehealth.v1.OrganizationEvent;
import com.google.cloud.servicehealth.v1.OrganizationEventName;
import com.google.cloud.servicehealth.v1.OrganizationImpact;
import com.google.cloud.servicehealth.v1.OrganizationImpactName;
import com.google.cloud.servicehealth.v1.OrganizationLocationName;
import com.google.cloud.servicehealth.v1.ServiceHealthClient;
import com.google.cloud.servicehealth.v1.ServiceHealthSettings;
import com.google.cloud.servicehealth.v1.stub.HttpJsonServiceHealthStub;
import com.google.common.collect.Lists;
import com.google.protobuf.Any;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ServiceHealthClientHttpJsonTest {
    private static MockHttpService mockService;
    private static ServiceHealthClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonServiceHealthStub.getMethodDescriptors(), ServiceHealthSettings.getDefaultEndpoint());
        ServiceHealthSettings settings = ((ServiceHealthSettings.Builder)((ServiceHealthSettings.Builder)ServiceHealthSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)ServiceHealthSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = ServiceHealthClient.create((ServiceHealthSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void listEventsTest() throws Exception {
        Event responsesElement = Event.newBuilder().build();
        ListEventsResponse expectedResponse = ListEventsResponse.newBuilder().setNextPageToken("").addAllEvents(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ServiceHealthClient.ListEventsPagedResponse pagedListResponse = client.listEvents(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getEventsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listEventsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listEvents(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listEventsTest2() throws Exception {
        Event responsesElement = Event.newBuilder().build();
        ListEventsResponse expectedResponse = ListEventsResponse.newBuilder().setNextPageToken("").addAllEvents(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        ServiceHealthClient.ListEventsPagedResponse pagedListResponse = client.listEvents(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getEventsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listEventsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listEvents(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getEventTest() throws Exception {
        Event expectedResponse = Event.newBuilder().setName(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[EVENT]").toString()).setTitle("title110371416").setDescription("description-1724546052").addAllEventImpacts(new ArrayList()).addAllUpdates(new ArrayList()).setParentEvent("parentEvent991253520").setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setNextUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        EventName name = EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[EVENT]");
        Event actualResponse = client.getEvent(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getEventExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            EventName name = EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[EVENT]");
            client.getEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getEventTest2() throws Exception {
        Event expectedResponse = Event.newBuilder().setName(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[EVENT]").toString()).setTitle("title110371416").setDescription("description-1724546052").addAllEventImpacts(new ArrayList()).addAllUpdates(new ArrayList()).setParentEvent("parentEvent991253520").setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setNextUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4441/locations/location-4441/events/event-4441";
        Event actualResponse = client.getEvent(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getEventExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4441/locations/location-4441/events/event-4441";
            client.getEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listOrganizationEventsTest() throws Exception {
        OrganizationEvent responsesElement = OrganizationEvent.newBuilder().build();
        ListOrganizationEventsResponse expectedResponse = ListOrganizationEventsResponse.newBuilder().setNextPageToken("").addAllOrganizationEvents(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        ServiceHealthClient.ListOrganizationEventsPagedResponse pagedListResponse = client.listOrganizationEvents(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOrganizationEventsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listOrganizationEventsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            client.listOrganizationEvents(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listOrganizationEventsTest2() throws Exception {
        OrganizationEvent responsesElement = OrganizationEvent.newBuilder().build();
        ListOrganizationEventsResponse expectedResponse = ListOrganizationEventsResponse.newBuilder().setNextPageToken("").addAllOrganizationEvents(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-9365/locations/location-9365";
        ServiceHealthClient.ListOrganizationEventsPagedResponse pagedListResponse = client.listOrganizationEvents(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOrganizationEventsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listOrganizationEventsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-9365/locations/location-9365";
            client.listOrganizationEvents(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOrganizationEventTest() throws Exception {
        OrganizationEvent expectedResponse = OrganizationEvent.newBuilder().setName(OrganizationEventName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[EVENT]").toString()).setTitle("title110371416").setDescription("description-1724546052").addAllEventImpacts(new ArrayList()).addAllUpdates(new ArrayList()).setParentEvent("parentEvent991253520").setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setNextUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationEventName name = OrganizationEventName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[EVENT]");
        OrganizationEvent actualResponse = client.getOrganizationEvent(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getOrganizationEventExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationEventName name = OrganizationEventName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[EVENT]");
            client.getOrganizationEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOrganizationEventTest2() throws Exception {
        OrganizationEvent expectedResponse = OrganizationEvent.newBuilder().setName(OrganizationEventName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[EVENT]").toString()).setTitle("title110371416").setDescription("description-1724546052").addAllEventImpacts(new ArrayList()).addAllUpdates(new ArrayList()).setParentEvent("parentEvent991253520").setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setNextUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-4436/locations/location-4436/organizationEvents/organizationEvent-4436";
        OrganizationEvent actualResponse = client.getOrganizationEvent(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getOrganizationEventExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-4436/locations/location-4436/organizationEvents/organizationEvent-4436";
            client.getOrganizationEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listOrganizationImpactsTest() throws Exception {
        OrganizationImpact responsesElement = OrganizationImpact.newBuilder().build();
        ListOrganizationImpactsResponse expectedResponse = ListOrganizationImpactsResponse.newBuilder().setNextPageToken("").addAllOrganizationImpacts(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        ServiceHealthClient.ListOrganizationImpactsPagedResponse pagedListResponse = client.listOrganizationImpacts(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOrganizationImpactsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listOrganizationImpactsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            client.listOrganizationImpacts(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listOrganizationImpactsTest2() throws Exception {
        OrganizationImpact responsesElement = OrganizationImpact.newBuilder().build();
        ListOrganizationImpactsResponse expectedResponse = ListOrganizationImpactsResponse.newBuilder().setNextPageToken("").addAllOrganizationImpacts(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "organizations/organization-9365/locations/location-9365";
        ServiceHealthClient.ListOrganizationImpactsPagedResponse pagedListResponse = client.listOrganizationImpacts(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOrganizationImpactsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listOrganizationImpactsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "organizations/organization-9365/locations/location-9365";
            client.listOrganizationImpacts(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOrganizationImpactTest() throws Exception {
        OrganizationImpact expectedResponse = OrganizationImpact.newBuilder().setName(OrganizationImpactName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[ORGANIZATION_IMPACT]").toString()).addAllEvents(new ArrayList()).setAsset(Asset.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        OrganizationImpactName name = OrganizationImpactName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[ORGANIZATION_IMPACT]");
        OrganizationImpact actualResponse = client.getOrganizationImpact(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getOrganizationImpactExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            OrganizationImpactName name = OrganizationImpactName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[ORGANIZATION_IMPACT]");
            client.getOrganizationImpact(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOrganizationImpactTest2() throws Exception {
        OrganizationImpact expectedResponse = OrganizationImpact.newBuilder().setName(OrganizationImpactName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[ORGANIZATION_IMPACT]").toString()).addAllEvents(new ArrayList()).setAsset(Asset.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "organizations/organization-5360/locations/location-5360/organizationImpacts/organizationImpact-5360";
        OrganizationImpact actualResponse = client.getOrganizationImpact(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getOrganizationImpactExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "organizations/organization-5360/locations/location-5360/organizationImpacts/organizationImpact-5360";
            client.getOrganizationImpact(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listLocationsTest() throws Exception {
        Location responsesElement = Location.newBuilder().build();
        ListLocationsResponse expectedResponse = ListLocationsResponse.newBuilder().setNextPageToken("").addAllLocations(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("projects/project-3664").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
        ServiceHealthClient.ListLocationsPagedResponse pagedListResponse = client.listLocations(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLocationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listLocationsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("projects/project-3664").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
            client.listLocations(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getLocationTest() throws Exception {
        Location expectedResponse = Location.newBuilder().setName("name3373707").setLocationId("locationId1541836720").setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setMetadata(Any.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        GetLocationRequest request = GetLocationRequest.newBuilder().setName("projects/project-9062/locations/location-9062").build();
        Location actualResponse = client.getLocation(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getLocationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GetLocationRequest request = GetLocationRequest.newBuilder().setName("projects/project-9062/locations/location-9062").build();
            client.getLocation(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

