/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicehealth.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.servicehealth.v1.Event;
import com.google.cloud.servicehealth.v1.GetEventRequest;
import com.google.cloud.servicehealth.v1.GetOrganizationEventRequest;
import com.google.cloud.servicehealth.v1.GetOrganizationImpactRequest;
import com.google.cloud.servicehealth.v1.ListEventsRequest;
import com.google.cloud.servicehealth.v1.ListEventsResponse;
import com.google.cloud.servicehealth.v1.ListOrganizationEventsRequest;
import com.google.cloud.servicehealth.v1.ListOrganizationEventsResponse;
import com.google.cloud.servicehealth.v1.ListOrganizationImpactsRequest;
import com.google.cloud.servicehealth.v1.ListOrganizationImpactsResponse;
import com.google.cloud.servicehealth.v1.OrganizationEvent;
import com.google.cloud.servicehealth.v1.OrganizationImpact;
import com.google.cloud.servicehealth.v1.ServiceHealthClient;
import com.google.cloud.servicehealth.v1.stub.GrpcServiceHealthCallableFactory;
import com.google.cloud.servicehealth.v1.stub.ServiceHealthStub;
import com.google.cloud.servicehealth.v1.stub.ServiceHealthStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcServiceHealthStub
extends ServiceHealthStub {
    private static final MethodDescriptor<ListEventsRequest, ListEventsResponse> listEventsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicehealth.v1.ServiceHealth/ListEvents").setRequestMarshaller(ProtoUtils.marshaller((Message)ListEventsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListEventsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetEventRequest, Event> getEventMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicehealth.v1.ServiceHealth/GetEvent").setRequestMarshaller(ProtoUtils.marshaller((Message)GetEventRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Event.getDefaultInstance())).build();
    private static final MethodDescriptor<ListOrganizationEventsRequest, ListOrganizationEventsResponse> listOrganizationEventsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicehealth.v1.ServiceHealth/ListOrganizationEvents").setRequestMarshaller(ProtoUtils.marshaller((Message)ListOrganizationEventsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListOrganizationEventsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetOrganizationEventRequest, OrganizationEvent> getOrganizationEventMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicehealth.v1.ServiceHealth/GetOrganizationEvent").setRequestMarshaller(ProtoUtils.marshaller((Message)GetOrganizationEventRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)OrganizationEvent.getDefaultInstance())).build();
    private static final MethodDescriptor<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse> listOrganizationImpactsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicehealth.v1.ServiceHealth/ListOrganizationImpacts").setRequestMarshaller(ProtoUtils.marshaller((Message)ListOrganizationImpactsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListOrganizationImpactsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetOrganizationImpactRequest, OrganizationImpact> getOrganizationImpactMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicehealth.v1.ServiceHealth/GetOrganizationImpact").setRequestMarshaller(ProtoUtils.marshaller((Message)GetOrganizationImpactRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)OrganizationImpact.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable;
    private final UnaryCallable<ListEventsRequest, ServiceHealthClient.ListEventsPagedResponse> listEventsPagedCallable;
    private final UnaryCallable<GetEventRequest, Event> getEventCallable;
    private final UnaryCallable<ListOrganizationEventsRequest, ListOrganizationEventsResponse> listOrganizationEventsCallable;
    private final UnaryCallable<ListOrganizationEventsRequest, ServiceHealthClient.ListOrganizationEventsPagedResponse> listOrganizationEventsPagedCallable;
    private final UnaryCallable<GetOrganizationEventRequest, OrganizationEvent> getOrganizationEventCallable;
    private final UnaryCallable<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse> listOrganizationImpactsCallable;
    private final UnaryCallable<ListOrganizationImpactsRequest, ServiceHealthClient.ListOrganizationImpactsPagedResponse> listOrganizationImpactsPagedCallable;
    private final UnaryCallable<GetOrganizationImpactRequest, OrganizationImpact> getOrganizationImpactCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ServiceHealthClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcServiceHealthStub create(ServiceHealthStubSettings settings) throws IOException {
        return new GrpcServiceHealthStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcServiceHealthStub create(ClientContext clientContext) throws IOException {
        return new GrpcServiceHealthStub(ServiceHealthStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcServiceHealthStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcServiceHealthStub(ServiceHealthStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcServiceHealthStub(ServiceHealthStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcServiceHealthCallableFactory());
    }

    protected GrpcServiceHealthStub(ServiceHealthStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listEventsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listEventsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getEventTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getEventMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listOrganizationEventsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listOrganizationEventsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getOrganizationEventTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getOrganizationEventMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listOrganizationImpactsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listOrganizationImpactsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getOrganizationImpactTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getOrganizationImpactMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listEventsCallable = callableFactory.createUnaryCallable(listEventsTransportSettings, settings.listEventsSettings(), clientContext);
        this.listEventsPagedCallable = callableFactory.createPagedCallable(listEventsTransportSettings, settings.listEventsSettings(), clientContext);
        this.getEventCallable = callableFactory.createUnaryCallable(getEventTransportSettings, settings.getEventSettings(), clientContext);
        this.listOrganizationEventsCallable = callableFactory.createUnaryCallable(listOrganizationEventsTransportSettings, settings.listOrganizationEventsSettings(), clientContext);
        this.listOrganizationEventsPagedCallable = callableFactory.createPagedCallable(listOrganizationEventsTransportSettings, settings.listOrganizationEventsSettings(), clientContext);
        this.getOrganizationEventCallable = callableFactory.createUnaryCallable(getOrganizationEventTransportSettings, settings.getOrganizationEventSettings(), clientContext);
        this.listOrganizationImpactsCallable = callableFactory.createUnaryCallable(listOrganizationImpactsTransportSettings, settings.listOrganizationImpactsSettings(), clientContext);
        this.listOrganizationImpactsPagedCallable = callableFactory.createPagedCallable(listOrganizationImpactsTransportSettings, settings.listOrganizationImpactsSettings(), clientContext);
        this.getOrganizationImpactCallable = callableFactory.createUnaryCallable(getOrganizationImpactTransportSettings, settings.getOrganizationImpactSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable() {
        return this.listEventsCallable;
    }

    @Override
    public UnaryCallable<ListEventsRequest, ServiceHealthClient.ListEventsPagedResponse> listEventsPagedCallable() {
        return this.listEventsPagedCallable;
    }

    @Override
    public UnaryCallable<GetEventRequest, Event> getEventCallable() {
        return this.getEventCallable;
    }

    @Override
    public UnaryCallable<ListOrganizationEventsRequest, ListOrganizationEventsResponse> listOrganizationEventsCallable() {
        return this.listOrganizationEventsCallable;
    }

    @Override
    public UnaryCallable<ListOrganizationEventsRequest, ServiceHealthClient.ListOrganizationEventsPagedResponse> listOrganizationEventsPagedCallable() {
        return this.listOrganizationEventsPagedCallable;
    }

    @Override
    public UnaryCallable<GetOrganizationEventRequest, OrganizationEvent> getOrganizationEventCallable() {
        return this.getOrganizationEventCallable;
    }

    @Override
    public UnaryCallable<ListOrganizationImpactsRequest, ListOrganizationImpactsResponse> listOrganizationImpactsCallable() {
        return this.listOrganizationImpactsCallable;
    }

    @Override
    public UnaryCallable<ListOrganizationImpactsRequest, ServiceHealthClient.ListOrganizationImpactsPagedResponse> listOrganizationImpactsPagedCallable() {
        return this.listOrganizationImpactsPagedCallable;
    }

    @Override
    public UnaryCallable<GetOrganizationImpactRequest, OrganizationImpact> getOrganizationImpactCallable() {
        return this.getOrganizationImpactCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ServiceHealthClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

