/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicehealth.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.servicehealth.v1.Asset;
import com.google.cloud.servicehealth.v1.Event;
import com.google.cloud.servicehealth.v1.EventName;
import com.google.cloud.servicehealth.v1.GetEventRequest;
import com.google.cloud.servicehealth.v1.GetOrganizationEventRequest;
import com.google.cloud.servicehealth.v1.GetOrganizationImpactRequest;
import com.google.cloud.servicehealth.v1.ListEventsRequest;
import com.google.cloud.servicehealth.v1.ListEventsResponse;
import com.google.cloud.servicehealth.v1.ListOrganizationEventsRequest;
import com.google.cloud.servicehealth.v1.ListOrganizationEventsResponse;
import com.google.cloud.servicehealth.v1.ListOrganizationImpactsRequest;
import com.google.cloud.servicehealth.v1.ListOrganizationImpactsResponse;
import com.google.cloud.servicehealth.v1.LocationName;
import com.google.cloud.servicehealth.v1.MockLocations;
import com.google.cloud.servicehealth.v1.MockServiceHealth;
import com.google.cloud.servicehealth.v1.OrganizationEvent;
import com.google.cloud.servicehealth.v1.OrganizationEventName;
import com.google.cloud.servicehealth.v1.OrganizationImpact;
import com.google.cloud.servicehealth.v1.OrganizationImpactName;
import com.google.cloud.servicehealth.v1.OrganizationLocationName;
import com.google.cloud.servicehealth.v1.ServiceHealthClient;
import com.google.cloud.servicehealth.v1.ServiceHealthSettings;
import com.google.common.collect.Lists;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ServiceHealthClientTest {
    private static MockLocations mockLocations;
    private static MockServiceHealth mockServiceHealth;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private ServiceHealthClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockServiceHealth = new MockServiceHealth();
        mockLocations = new MockLocations();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockServiceHealth, mockLocations));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        ServiceHealthSettings settings = ((ServiceHealthSettings.Builder)((ServiceHealthSettings.Builder)ServiceHealthSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = ServiceHealthClient.create((ServiceHealthSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listEventsTest() throws Exception {
        Event responsesElement = Event.newBuilder().build();
        ListEventsResponse expectedResponse = ListEventsResponse.newBuilder().setNextPageToken("").addAllEvents(Arrays.asList(responsesElement)).build();
        mockServiceHealth.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ServiceHealthClient.ListEventsPagedResponse pagedListResponse = this.client.listEvents(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getEventsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockServiceHealth.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListEventsRequest actualRequest = (ListEventsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listEventsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceHealth.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listEvents(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listEventsTest2() throws Exception {
        Event responsesElement = Event.newBuilder().build();
        ListEventsResponse expectedResponse = ListEventsResponse.newBuilder().setNextPageToken("").addAllEvents(Arrays.asList(responsesElement)).build();
        mockServiceHealth.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ServiceHealthClient.ListEventsPagedResponse pagedListResponse = this.client.listEvents(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getEventsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockServiceHealth.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListEventsRequest actualRequest = (ListEventsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listEventsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceHealth.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listEvents(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getEventTest() throws Exception {
        Event expectedResponse = Event.newBuilder().setName(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[EVENT]").toString()).setTitle("title110371416").setDescription("description-1724546052").addAllEventImpacts(new ArrayList()).addAllUpdates(new ArrayList()).setParentEvent("parentEvent991253520").setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setNextUpdateTime(Timestamp.newBuilder().build()).build();
        mockServiceHealth.addResponse((AbstractMessage)expectedResponse);
        EventName name = EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[EVENT]");
        Event actualResponse = this.client.getEvent(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceHealth.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetEventRequest actualRequest = (GetEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getEventExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceHealth.addException((Exception)exception);
        try {
            EventName name = EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[EVENT]");
            this.client.getEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getEventTest2() throws Exception {
        Event expectedResponse = Event.newBuilder().setName(EventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[EVENT]").toString()).setTitle("title110371416").setDescription("description-1724546052").addAllEventImpacts(new ArrayList()).addAllUpdates(new ArrayList()).setParentEvent("parentEvent991253520").setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setNextUpdateTime(Timestamp.newBuilder().build()).build();
        mockServiceHealth.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Event actualResponse = this.client.getEvent(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceHealth.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetEventRequest actualRequest = (GetEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getEventExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceHealth.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listOrganizationEventsTest() throws Exception {
        OrganizationEvent responsesElement = OrganizationEvent.newBuilder().build();
        ListOrganizationEventsResponse expectedResponse = ListOrganizationEventsResponse.newBuilder().setNextPageToken("").addAllOrganizationEvents(Arrays.asList(responsesElement)).build();
        mockServiceHealth.addResponse((AbstractMessage)expectedResponse);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        ServiceHealthClient.ListOrganizationEventsPagedResponse pagedListResponse = this.client.listOrganizationEvents(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOrganizationEventsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockServiceHealth.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListOrganizationEventsRequest actualRequest = (ListOrganizationEventsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listOrganizationEventsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceHealth.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            this.client.listOrganizationEvents(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listOrganizationEventsTest2() throws Exception {
        OrganizationEvent responsesElement = OrganizationEvent.newBuilder().build();
        ListOrganizationEventsResponse expectedResponse = ListOrganizationEventsResponse.newBuilder().setNextPageToken("").addAllOrganizationEvents(Arrays.asList(responsesElement)).build();
        mockServiceHealth.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ServiceHealthClient.ListOrganizationEventsPagedResponse pagedListResponse = this.client.listOrganizationEvents(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOrganizationEventsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockServiceHealth.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListOrganizationEventsRequest actualRequest = (ListOrganizationEventsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listOrganizationEventsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceHealth.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listOrganizationEvents(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOrganizationEventTest() throws Exception {
        OrganizationEvent expectedResponse = OrganizationEvent.newBuilder().setName(OrganizationEventName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[EVENT]").toString()).setTitle("title110371416").setDescription("description-1724546052").addAllEventImpacts(new ArrayList()).addAllUpdates(new ArrayList()).setParentEvent("parentEvent991253520").setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setNextUpdateTime(Timestamp.newBuilder().build()).build();
        mockServiceHealth.addResponse((AbstractMessage)expectedResponse);
        OrganizationEventName name = OrganizationEventName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[EVENT]");
        OrganizationEvent actualResponse = this.client.getOrganizationEvent(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceHealth.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetOrganizationEventRequest actualRequest = (GetOrganizationEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getOrganizationEventExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceHealth.addException((Exception)exception);
        try {
            OrganizationEventName name = OrganizationEventName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[EVENT]");
            this.client.getOrganizationEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOrganizationEventTest2() throws Exception {
        OrganizationEvent expectedResponse = OrganizationEvent.newBuilder().setName(OrganizationEventName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[EVENT]").toString()).setTitle("title110371416").setDescription("description-1724546052").addAllEventImpacts(new ArrayList()).addAllUpdates(new ArrayList()).setParentEvent("parentEvent991253520").setUpdateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setNextUpdateTime(Timestamp.newBuilder().build()).build();
        mockServiceHealth.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        OrganizationEvent actualResponse = this.client.getOrganizationEvent(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceHealth.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetOrganizationEventRequest actualRequest = (GetOrganizationEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getOrganizationEventExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceHealth.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getOrganizationEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listOrganizationImpactsTest() throws Exception {
        OrganizationImpact responsesElement = OrganizationImpact.newBuilder().build();
        ListOrganizationImpactsResponse expectedResponse = ListOrganizationImpactsResponse.newBuilder().setNextPageToken("").addAllOrganizationImpacts(Arrays.asList(responsesElement)).build();
        mockServiceHealth.addResponse((AbstractMessage)expectedResponse);
        OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
        ServiceHealthClient.ListOrganizationImpactsPagedResponse pagedListResponse = this.client.listOrganizationImpacts(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOrganizationImpactsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockServiceHealth.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListOrganizationImpactsRequest actualRequest = (ListOrganizationImpactsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listOrganizationImpactsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceHealth.addException((Exception)exception);
        try {
            OrganizationLocationName parent = OrganizationLocationName.of((String)"[ORGANIZATION]", (String)"[LOCATION]");
            this.client.listOrganizationImpacts(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listOrganizationImpactsTest2() throws Exception {
        OrganizationImpact responsesElement = OrganizationImpact.newBuilder().build();
        ListOrganizationImpactsResponse expectedResponse = ListOrganizationImpactsResponse.newBuilder().setNextPageToken("").addAllOrganizationImpacts(Arrays.asList(responsesElement)).build();
        mockServiceHealth.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ServiceHealthClient.ListOrganizationImpactsPagedResponse pagedListResponse = this.client.listOrganizationImpacts(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOrganizationImpactsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockServiceHealth.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListOrganizationImpactsRequest actualRequest = (ListOrganizationImpactsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listOrganizationImpactsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceHealth.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listOrganizationImpacts(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOrganizationImpactTest() throws Exception {
        OrganizationImpact expectedResponse = OrganizationImpact.newBuilder().setName(OrganizationImpactName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[ORGANIZATION_IMPACT]").toString()).addAllEvents(new ArrayList()).setAsset(Asset.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockServiceHealth.addResponse((AbstractMessage)expectedResponse);
        OrganizationImpactName name = OrganizationImpactName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[ORGANIZATION_IMPACT]");
        OrganizationImpact actualResponse = this.client.getOrganizationImpact(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceHealth.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetOrganizationImpactRequest actualRequest = (GetOrganizationImpactRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getOrganizationImpactExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceHealth.addException((Exception)exception);
        try {
            OrganizationImpactName name = OrganizationImpactName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[ORGANIZATION_IMPACT]");
            this.client.getOrganizationImpact(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getOrganizationImpactTest2() throws Exception {
        OrganizationImpact expectedResponse = OrganizationImpact.newBuilder().setName(OrganizationImpactName.of((String)"[ORGANIZATION]", (String)"[LOCATION]", (String)"[ORGANIZATION_IMPACT]").toString()).addAllEvents(new ArrayList()).setAsset(Asset.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockServiceHealth.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        OrganizationImpact actualResponse = this.client.getOrganizationImpact(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceHealth.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetOrganizationImpactRequest actualRequest = (GetOrganizationImpactRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getOrganizationImpactExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceHealth.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getOrganizationImpact(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listLocationsTest() throws Exception {
        Location responsesElement = Location.newBuilder().build();
        ListLocationsResponse expectedResponse = ListLocationsResponse.newBuilder().setNextPageToken("").addAllLocations(Arrays.asList(responsesElement)).build();
        mockLocations.addResponse((AbstractMessage)expectedResponse);
        ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("name3373707").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
        ServiceHealthClient.ListLocationsPagedResponse pagedListResponse = this.client.listLocations(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLocationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLocations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListLocationsRequest actualRequest = (ListLocationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getFilter(), (Object)actualRequest.getFilter());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listLocationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLocations.addException((Exception)exception);
        try {
            ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("name3373707").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
            this.client.listLocations(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getLocationTest() throws Exception {
        Location expectedResponse = Location.newBuilder().setName("name3373707").setLocationId("locationId1541836720").setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setMetadata(Any.newBuilder().build()).build();
        mockLocations.addResponse((AbstractMessage)expectedResponse);
        GetLocationRequest request = GetLocationRequest.newBuilder().setName("name3373707").build();
        Location actualResponse = this.client.getLocation(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLocations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetLocationRequest actualRequest = (GetLocationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getLocationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLocations.addException((Exception)exception);
        try {
            GetLocationRequest request = GetLocationRequest.newBuilder().setName("name3373707").build();
            this.client.getLocation(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

