/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.talent.v4beta1.ClientEvent;
import com.google.cloud.talent.v4beta1.CreateClientEventRequest;
import com.google.cloud.talent.v4beta1.EventServiceClient;
import com.google.cloud.talent.v4beta1.EventServiceSettings;
import com.google.cloud.talent.v4beta1.MockApplicationService;
import com.google.cloud.talent.v4beta1.MockCompanyService;
import com.google.cloud.talent.v4beta1.MockCompletion;
import com.google.cloud.talent.v4beta1.MockEventService;
import com.google.cloud.talent.v4beta1.MockJobService;
import com.google.cloud.talent.v4beta1.MockProfileService;
import com.google.cloud.talent.v4beta1.MockTenantService;
import com.google.cloud.talent.v4beta1.TenantName;
import com.google.protobuf.AbstractMessage;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class EventServiceClientTest {
    private static MockApplicationService mockApplicationService;
    private static MockCompanyService mockCompanyService;
    private static MockCompletion mockCompletion;
    private static MockEventService mockEventService;
    private static MockJobService mockJobService;
    private static MockProfileService mockProfileService;
    private static MockTenantService mockTenantService;
    private static MockServiceHelper serviceHelper;
    private EventServiceClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockApplicationService = new MockApplicationService();
        mockCompanyService = new MockCompanyService();
        mockCompletion = new MockCompletion();
        mockEventService = new MockEventService();
        mockJobService = new MockJobService();
        mockProfileService = new MockProfileService();
        mockTenantService = new MockTenantService();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockApplicationService, mockCompanyService, mockCompletion, mockEventService, mockJobService, mockProfileService, mockTenantService));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        EventServiceSettings settings = ((EventServiceSettings.Builder)((EventServiceSettings.Builder)EventServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = EventServiceClient.create((EventServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createClientEventTest() {
        String requestId = "requestId37109963";
        String eventId = "eventId278118624";
        String eventNotes = "eventNotes445073628";
        ClientEvent expectedResponse = ClientEvent.newBuilder().setRequestId(requestId).setEventId(eventId).setEventNotes(eventNotes).build();
        mockEventService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        ClientEvent clientEvent = ClientEvent.newBuilder().build();
        ClientEvent actualResponse = this.client.createClientEvent(parent, clientEvent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEventService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateClientEventRequest actualRequest = (CreateClientEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)TenantName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)clientEvent, (Object)actualRequest.getClientEvent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createClientEventExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEventService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            ClientEvent clientEvent = ClientEvent.newBuilder().build();
            this.client.createClientEvent(parent, clientEvent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

