/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.talent.v4beta1.BatchCreateJobsRequest;
import com.google.cloud.talent.v4beta1.BatchDeleteJobsRequest;
import com.google.cloud.talent.v4beta1.BatchUpdateJobsRequest;
import com.google.cloud.talent.v4beta1.CompanyName;
import com.google.cloud.talent.v4beta1.CreateJobRequest;
import com.google.cloud.talent.v4beta1.DeleteJobRequest;
import com.google.cloud.talent.v4beta1.GetJobRequest;
import com.google.cloud.talent.v4beta1.Job;
import com.google.cloud.talent.v4beta1.JobName;
import com.google.cloud.talent.v4beta1.JobOperationResult;
import com.google.cloud.talent.v4beta1.JobServiceClient;
import com.google.cloud.talent.v4beta1.JobServiceSettings;
import com.google.cloud.talent.v4beta1.ListJobsRequest;
import com.google.cloud.talent.v4beta1.ListJobsResponse;
import com.google.cloud.talent.v4beta1.MockApplicationService;
import com.google.cloud.talent.v4beta1.MockCompanyService;
import com.google.cloud.talent.v4beta1.MockCompletion;
import com.google.cloud.talent.v4beta1.MockEventService;
import com.google.cloud.talent.v4beta1.MockJobService;
import com.google.cloud.talent.v4beta1.MockProfileService;
import com.google.cloud.talent.v4beta1.MockTenantService;
import com.google.cloud.talent.v4beta1.RequestMetadata;
import com.google.cloud.talent.v4beta1.SearchJobsRequest;
import com.google.cloud.talent.v4beta1.SearchJobsResponse;
import com.google.cloud.talent.v4beta1.TenantName;
import com.google.cloud.talent.v4beta1.UpdateJobRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JobServiceClientTest {
    private static MockApplicationService mockApplicationService;
    private static MockCompanyService mockCompanyService;
    private static MockCompletion mockCompletion;
    private static MockEventService mockEventService;
    private static MockJobService mockJobService;
    private static MockProfileService mockProfileService;
    private static MockTenantService mockTenantService;
    private static MockServiceHelper serviceHelper;
    private JobServiceClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockApplicationService = new MockApplicationService();
        mockCompanyService = new MockCompanyService();
        mockCompletion = new MockCompletion();
        mockEventService = new MockEventService();
        mockJobService = new MockJobService();
        mockProfileService = new MockProfileService();
        mockTenantService = new MockTenantService();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockApplicationService, mockCompanyService, mockCompletion, mockEventService, mockJobService, mockProfileService, mockTenantService));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        JobServiceSettings settings = ((JobServiceSettings.Builder)((JobServiceSettings.Builder)JobServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = JobServiceClient.create((JobServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createJobTest() {
        JobName name = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
        CompanyName company = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
        String requisitionId = "requisitionId980224926";
        String title = "title110371416";
        String description = "description-1724546052";
        String department = "department848184146";
        String incentives = "incentives-1262874520";
        String languageCode = "languageCode-412800396";
        int promotionValue = 353413845;
        String qualifications = "qualifications1903501412";
        String responsibilities = "responsibilities-926952660";
        String companyDisplayName = "companyDisplayName1982424170";
        Job expectedResponse = Job.newBuilder().setName(name.toString()).setCompany(company.toString()).setRequisitionId(requisitionId).setTitle(title).setDescription(description).setDepartment(department).setIncentives(incentives).setLanguageCode(languageCode).setPromotionValue(promotionValue).setQualifications(qualifications).setResponsibilities(responsibilities).setCompanyDisplayName(companyDisplayName).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        Job job = Job.newBuilder().build();
        Job actualResponse = this.client.createJob(parent, job);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateJobRequest actualRequest = (CreateJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)TenantName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)job, (Object)actualRequest.getJob());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            Job job = Job.newBuilder().build();
            this.client.createJob(parent, job);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchCreateJobsTest() throws Exception {
        JobOperationResult expectedResponse = JobOperationResult.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("batchCreateJobsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockJobService.addResponse((AbstractMessage)resultOperation);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        ArrayList jobs = new ArrayList();
        JobOperationResult actualResponse = (JobOperationResult)this.client.batchCreateJobsAsync(parent, jobs).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchCreateJobsRequest actualRequest = (BatchCreateJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)TenantName.parse((String)actualRequest.getParent()));
        Assert.assertEquals(jobs, (Object)actualRequest.getJobsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchCreateJobsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            ArrayList jobs = new ArrayList();
            this.client.batchCreateJobsAsync(parent, jobs).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getJobTest() {
        JobName name2 = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
        CompanyName company = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
        String requisitionId = "requisitionId980224926";
        String title = "title110371416";
        String description = "description-1724546052";
        String department = "department848184146";
        String incentives = "incentives-1262874520";
        String languageCode = "languageCode-412800396";
        int promotionValue = 353413845;
        String qualifications = "qualifications1903501412";
        String responsibilities = "responsibilities-926952660";
        String companyDisplayName = "companyDisplayName1982424170";
        Job expectedResponse = Job.newBuilder().setName(name2.toString()).setCompany(company.toString()).setRequisitionId(requisitionId).setTitle(title).setDescription(description).setDepartment(department).setIncentives(incentives).setLanguageCode(languageCode).setPromotionValue(promotionValue).setQualifications(qualifications).setResponsibilities(responsibilities).setCompanyDisplayName(companyDisplayName).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        JobName name = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
        Job actualResponse = this.client.getJob(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetJobRequest actualRequest = (GetJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)JobName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            JobName name = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
            this.client.getJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateJobTest() {
        JobName name = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
        CompanyName company = CompanyName.ofProjectTenantCompanyName((String)"[PROJECT]", (String)"[TENANT]", (String)"[COMPANY]");
        String requisitionId = "requisitionId980224926";
        String title = "title110371416";
        String description = "description-1724546052";
        String department = "department848184146";
        String incentives = "incentives-1262874520";
        String languageCode = "languageCode-412800396";
        int promotionValue = 353413845;
        String qualifications = "qualifications1903501412";
        String responsibilities = "responsibilities-926952660";
        String companyDisplayName = "companyDisplayName1982424170";
        Job expectedResponse = Job.newBuilder().setName(name.toString()).setCompany(company.toString()).setRequisitionId(requisitionId).setTitle(title).setDescription(description).setDepartment(department).setIncentives(incentives).setLanguageCode(languageCode).setPromotionValue(promotionValue).setQualifications(qualifications).setResponsibilities(responsibilities).setCompanyDisplayName(companyDisplayName).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        Job job = Job.newBuilder().build();
        Job actualResponse = this.client.updateJob(job);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateJobRequest actualRequest = (UpdateJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)job, (Object)actualRequest.getJob());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            Job job = Job.newBuilder().build();
            this.client.updateJob(job);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchUpdateJobsTest() throws Exception {
        JobOperationResult expectedResponse = JobOperationResult.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("batchUpdateJobsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockJobService.addResponse((AbstractMessage)resultOperation);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        ArrayList jobs = new ArrayList();
        JobOperationResult actualResponse = (JobOperationResult)this.client.batchUpdateJobsAsync(parent, jobs).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchUpdateJobsRequest actualRequest = (BatchUpdateJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)TenantName.parse((String)actualRequest.getParent()));
        Assert.assertEquals(jobs, (Object)actualRequest.getJobsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchUpdateJobsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            ArrayList jobs = new ArrayList();
            this.client.batchUpdateJobsAsync(parent, jobs).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteJobTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        JobName name = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
        this.client.deleteJob(name);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteJobRequest actualRequest = (DeleteJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)JobName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            JobName name = JobName.ofProjectTenantJobName((String)"[PROJECT]", (String)"[TENANT]", (String)"[JOB]");
            this.client.deleteJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchDeleteJobsTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        String filter = "filter-1274492040";
        this.client.batchDeleteJobs(parent, filter);
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchDeleteJobsRequest actualRequest = (BatchDeleteJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)TenantName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)filter, (Object)actualRequest.getFilter());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchDeleteJobsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            String filter = "filter-1274492040";
            this.client.batchDeleteJobs(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listJobsTest() {
        String nextPageToken = "";
        Job jobsElement = Job.newBuilder().build();
        List<Job> jobs = Arrays.asList(jobsElement);
        ListJobsResponse expectedResponse = ListJobsResponse.newBuilder().setNextPageToken(nextPageToken).addAllJobs(jobs).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        String filter = "filter-1274492040";
        JobServiceClient.ListJobsPagedResponse pagedListResponse = this.client.listJobs(parent, filter);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getJobsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListJobsRequest actualRequest = (ListJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)TenantName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)filter, (Object)actualRequest.getFilter());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listJobsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            String filter = "filter-1274492040";
            this.client.listJobs(parent, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchJobsTest() {
        String nextPageToken = "";
        int estimatedTotalSize = 1882144769;
        int totalSize = 705419236;
        int broadenedQueryJobsCount = 1432104658;
        SearchJobsResponse.MatchingJob matchingJobsElement = SearchJobsResponse.MatchingJob.newBuilder().build();
        List<SearchJobsResponse.MatchingJob> matchingJobs = Arrays.asList(matchingJobsElement);
        SearchJobsResponse expectedResponse = SearchJobsResponse.newBuilder().setNextPageToken(nextPageToken).setEstimatedTotalSize(estimatedTotalSize).setTotalSize(totalSize).setBroadenedQueryJobsCount(broadenedQueryJobsCount).addAllMatchingJobs(matchingJobs).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        RequestMetadata requestMetadata = RequestMetadata.newBuilder().build();
        SearchJobsRequest request = SearchJobsRequest.newBuilder().setParent(parent.toString()).setRequestMetadata(requestMetadata).build();
        JobServiceClient.SearchJobsPagedResponse pagedListResponse = this.client.searchJobs(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMatchingJobsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchJobsRequest actualRequest = (SearchJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)TenantName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)requestMetadata, (Object)actualRequest.getRequestMetadata());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchJobsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            RequestMetadata requestMetadata = RequestMetadata.newBuilder().build();
            SearchJobsRequest request = SearchJobsRequest.newBuilder().setParent(parent.toString()).setRequestMetadata(requestMetadata).build();
            this.client.searchJobs(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchJobsForAlertTest() {
        String nextPageToken = "";
        int estimatedTotalSize = 1882144769;
        int totalSize = 705419236;
        int broadenedQueryJobsCount = 1432104658;
        SearchJobsResponse.MatchingJob matchingJobsElement = SearchJobsResponse.MatchingJob.newBuilder().build();
        List<SearchJobsResponse.MatchingJob> matchingJobs = Arrays.asList(matchingJobsElement);
        SearchJobsResponse expectedResponse = SearchJobsResponse.newBuilder().setNextPageToken(nextPageToken).setEstimatedTotalSize(estimatedTotalSize).setTotalSize(totalSize).setBroadenedQueryJobsCount(broadenedQueryJobsCount).addAllMatchingJobs(matchingJobs).build();
        mockJobService.addResponse((AbstractMessage)expectedResponse);
        TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
        RequestMetadata requestMetadata = RequestMetadata.newBuilder().build();
        SearchJobsRequest request = SearchJobsRequest.newBuilder().setParent(parent.toString()).setRequestMetadata(requestMetadata).build();
        JobServiceClient.SearchJobsForAlertPagedResponse pagedListResponse = this.client.searchJobsForAlert(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMatchingJobsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockJobService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchJobsRequest actualRequest = (SearchJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)TenantName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)requestMetadata, (Object)actualRequest.getRequestMetadata());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchJobsForAlertExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockJobService.addException((Exception)exception);
        try {
            TenantName parent = TenantName.of((String)"[PROJECT]", (String)"[TENANT]");
            RequestMetadata requestMetadata = RequestMetadata.newBuilder().build();
            SearchJobsRequest request = SearchJobsRequest.newBuilder().setParent(parent.toString()).setRequestMetadata(requestMetadata).build();
            this.client.searchJobsForAlert(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

